/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.osgl.$;
import org.osgl.cache.CacheService;
import org.osgl.cache.CacheServiceProvider;
import org.osgl.util.C;
import org.osgl.util.Charsets;
import org.osgl.util.Crypto;
import org.osgl.util.S;

public class Token
implements Serializable {
    private static volatile CacheService cache;
    private String id;
    private long due;
    private List<String> payload = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CacheService cache() {
        if (null != cache) {
            return cache;
        }
        Class<Token> clazz = Token.class;
        synchronized (Token.class) {
            if (null == cache) {
                String cacheName = System.getProperty("aaa.cache.name");
                cache = S.notBlank((String)cacheName) ? CacheServiceProvider.Impl.Auto.get(cacheName) : CacheServiceProvider.Impl.Auto.get();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return cache;
        }
    }

    public String id() {
        return this.id;
    }

    public List<String> payload() {
        return C.list(this.payload);
    }

    public String firstPayload() {
        return this.payload.isEmpty() ? null : this.payload.get(0);
    }

    public String payload(int index) {
        return this.payload.size() > index ? this.payload.get(index) : null;
    }

    public boolean isExpired() {
        return this.expired();
    }

    public boolean expired() {
        return this.due > 0L && this.due <= $.ms();
    }

    public boolean empty() {
        return this.isEmpty();
    }

    public boolean isEmpty() {
        return S.isBlank((String)this.id);
    }

    public boolean isConsumed() {
        return this.consumed();
    }

    public boolean consumed() {
        return Token.cache().get("auth-tk-consumed-" + this.id + this.due) != null;
    }

    public void consume() {
        Token.cache().put("auth-tk-consumed-" + this.id + this.due, (Object)"true", (int)(this.due + 1000L - System.currentTimeMillis()) / 1000);
    }

    public boolean valid() {
        return this.isValid();
    }

    public boolean isValid() {
        return !this.isEmpty() && !this.expired() && !this.consumed();
    }

    public boolean notValid() {
        return !this.isValid();
    }

    public int hashCode() {
        return $.hc((Object)this.id, (Object)this.due, this.payload);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Token) {
            Token that = (Token)obj;
            return S.eq((String)that.id, (String)this.id) && that.due == this.due && $.eq(that.payload, this.payload);
        }
        return false;
    }

    public String toString() {
        return S.fmt((String)"{id: %s, expired: %s, due: %s, payload: %s", (Object[])new Object[]{this.id, this.expired(), this.due, this.payload});
    }

    @Deprecated
    public static String generateToken(String secret, String oid, String ... payload) {
        return Token.generateToken(secret, Life.SHORT, oid, payload);
    }

    public static String generateToken(byte[] secret, String oid, String ... payload) {
        return Token.generateToken(secret, Life.SHORT, oid, payload);
    }

    @Deprecated
    public static String generateToken(String secret, Life tl, String oid, String ... payload) {
        return Token.generateToken(secret, tl.seconds, oid, payload);
    }

    public static String generateToken(byte[] secret, Life tl, String oid, String ... payload) {
        return Token.generateToken(secret, tl.seconds, oid, payload);
    }

    @Deprecated
    public static String generateToken(String secret, long seconds, String oid, String ... payload) {
        return Token.generateToken(secret.getBytes(Charsets.UTF_8), seconds, oid, payload);
    }

    public static String generateToken(byte[] secret, long seconds, String oid, String ... payload) {
        long due = Life.due(seconds);
        ArrayList<String> l = new ArrayList<String>(2 + payload.length);
        l.add(oid);
        l.add(String.valueOf(due));
        l.addAll((Collection<String>)C.listOf((Object[])payload));
        String s = S.join((String)"|", l);
        return Crypto.encryptAES((String)s, (byte[])secret);
    }

    @Deprecated
    public static Token parseToken(String secret, String token) {
        return Token.parseToken(secret.getBytes(Charsets.UTF_8), token);
    }

    public static Token parseToken(byte[] secret, String token) {
        Token tk = new Token();
        if (S.blank((String)token)) {
            return tk;
        }
        String s = "";
        try {
            s = Crypto.decryptAES((String)token, (byte[])secret);
        }
        catch (Exception e) {
            return tk;
        }
        Object[] sa = s.split("\\|");
        if (sa.length < 2) {
            return tk;
        }
        tk.id = sa[0];
        try {
            tk.due = Long.parseLong(sa[1]);
            if (tk.expired()) {
                return tk;
            }
        }
        catch (Exception e) {
            tk.due = $.ms() - 86400000L;
            return tk;
        }
        if (sa.length > 2) {
            sa = Arrays.copyOfRange(sa, 2, sa.length);
            tk.payload.addAll((Collection<String>)C.listOf((Object[])sa));
        }
        return tk;
    }

    @Deprecated
    public static boolean isTokenValid(String secret, String oid, String token) {
        return Token.isTokenValid(secret.getBytes(Charsets.UTF_8), oid, token);
    }

    public static boolean isTokenValid(byte[] secret, String oid, String token) {
        if (S.anyBlank((String[])new String[]{oid, token})) {
            return false;
        }
        String s = Crypto.decryptAES((String)token, (byte[])secret);
        String[] sa = s.split("\\|");
        if (sa.length < 2) {
            return false;
        }
        if (!S.isEqual((String)oid, (String)sa[0])) {
            return false;
        }
        try {
            long due = Long.parseLong(sa[1]);
            return due < 1L || due > System.currentTimeMillis();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static enum Life {
        ONE_MIN(60L),
        SHORT(3600L),
        ONE_HOUR(3600L),
        NORMAL(86400L),
        ONE_DAY(86400L),
        ONE_WEEK(604800L),
        THIRTY_DAYS(2592000L),
        LONG(7776000L),
        NINETY_DAYS(7776000L),
        FOREVER(-1L);

        private long seconds;

        private Life(long seconds) {
            this.seconds = seconds;
        }

        public long due() {
            return Life.due(this.seconds);
        }

        static long due(long seconds) {
            if (seconds <= 0L) {
                return -1L;
            }
            long now = System.currentTimeMillis();
            long period = seconds * 1000L;
            return now + period;
        }
    }
}

