/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.ListIterator;
import org.osgl.util.C;
import org.osgl.util.CompositeListIterator;
import org.osgl.util.ListBase;

public class CompositeList<T>
extends ListBase<T>
implements C.List<T>,
Serializable {
    private final C.List<T> left;
    private final C.List<T> right;

    CompositeList(C.List<T> left, C.List<T> right) {
        this.left = left;
        this.right = right;
    }

    static <T1> CompositeList<T1> of(C.List<T1> left, C.List<T1> right) {
        return new CompositeList<T1>(left, right);
    }

    protected UnsupportedOperationException noMutableOperation() {
        throw new UnsupportedOperationException("mutable operation not allowed in this read only structure");
    }

    @Override
    protected EnumSet<C.Feature> initFeatures() {
        EnumSet<C.Feature> fs = EnumSet.of(C.Feature.READONLY, C.Feature.ORDERED);
        C.Feature[] fa = new C.Feature[]{C.Feature.IMMUTABLE, C.Feature.RANDOM_ACCESS, C.Feature.LAZY, C.Feature.PARALLEL};
        C.List<T> l = this.left;
        C.List<T> r = this.right;
        for (C.Feature f2 : fa) {
            if (!l.is(f2) || !r.is(f2)) continue;
            fs.add(f2);
        }
        return fs;
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        ListIterator r;
        ListIterator l;
        int sz = this.left.size();
        if (index < sz) {
            l = this.left.listIterator(index);
            r = this.right.listIterator();
        } else {
            l = this.left.listIterator();
            r = this.right.listIterator(index - sz);
        }
        return new CompositeListIterator(l, r);
    }

    @Override
    public T get(int index) {
        int rs;
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        C.List<T> l = this.left;
        C.List<T> r = this.right;
        int ls = l.size();
        if (index >= ls + (rs = r.size())) {
            throw new IllegalArgumentException();
        }
        if (index < ls) {
            return (T)l.get(index);
        }
        return (T)r.get(index - ls);
    }

    @Override
    public int size() {
        return this.left.size() + this.right.size();
    }
}

