/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.EnumSet;
import java.util.Iterator;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.Iterators;
import org.osgl.util.ReversibleSeqBase;

class CompositeRSeq<T>
extends ReversibleSeqBase<T> {
    private final C.ReversibleSequence<T> left;
    private final C.ReversibleSequence<T> right;
    private EnumSet<C.Feature> features;

    CompositeRSeq(C.ReversibleSequence<T> left, C.ReversibleSequence<T> right) {
        E.NPE(left, right);
        if (left.isEmpty() || right.isEmpty()) {
            throw new IllegalArgumentException("left or right cannot be empty");
        }
        this.left = left;
        this.right = right;
        this.features = left.features();
        this.features.retainAll(right.features());
        this.features.add(C.Feature.READONLY);
    }

    static <T> C.ReversibleSequence<T> of(C.ReversibleSequence<T> left, C.ReversibleSequence<T> right) {
        return new CompositeRSeq<T>(left, right);
    }

    protected C.ReversibleSequence<T> left() {
        return this.left;
    }

    protected C.ReversibleSequence<T> right() {
        return this.right;
    }

    @Override
    protected EnumSet<C.Feature> initFeatures() {
        EnumSet<C.Feature> features = this.left.features();
        features.retainAll(this.right.features());
        features.add(C.Feature.READONLY);
        features.add(C.Feature.LAZY);
        return features;
    }

    @Override
    public final int size() throws UnsupportedOperationException {
        return this.left.size() + this.right.size();
    }

    @Override
    public final Iterator<T> iterator() {
        return Iterators.composite(this.left.iterator(), this.right.iterator());
    }

    @Override
    public Iterator<T> reverseIterator() {
        return Iterators.composite(this.right.reverseIterator(), this.left.reverseIterator());
    }

    @Override
    public final boolean isEmpty() {
        return this.left.isEmpty() && this.right.isEmpty();
    }
}

