/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.EnumSet;
import java.util.Iterator;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.Iterators;
import org.osgl.util.SequenceBase;

class CompositeSeq<T>
extends SequenceBase<T> {
    private final C.Sequence<? extends T> left;
    private final C.Sequence<? extends T> right;
    private EnumSet<C.Feature> features;

    CompositeSeq(C.Sequence<? extends T> left, C.Sequence<? extends T> right) {
        E.NPE(left, right);
        if (left.isEmpty() || right.isEmpty()) {
            throw new IllegalArgumentException("left or right cannot be empty");
        }
        this.left = left;
        this.right = right;
        this.features = left.features();
        this.features.retainAll(right.features());
        this.features.add(C.Feature.READONLY);
    }

    static <T> C.Sequence<T> of(C.Sequence<? extends T> left, C.Sequence<? extends T> right) {
        return new CompositeSeq<T>(left, right);
    }

    protected C.Sequence<? extends T> left() {
        return this.left;
    }

    protected C.Sequence<? extends T> right() {
        return this.right;
    }

    @Override
    protected EnumSet<C.Feature> initFeatures() {
        EnumSet<C.Feature> features = this.left.features();
        features.retainAll(this.right.features());
        features.add(C.Feature.READONLY);
        features.add(C.Feature.LAZY);
        return features;
    }

    @Override
    public final int size() throws UnsupportedOperationException {
        return this.left.size() + this.right.size();
    }

    @Override
    public final Iterator<T> iterator() {
        return Iterators.composite(this.left.iterator(), this.right.iterator());
    }

    @Override
    public final boolean isEmpty() {
        return this.left.isEmpty() && this.right.isEmpty();
    }
}

