/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.RandomAccess;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.Charsets;
import org.osgl.util.E;
import org.osgl.util.S;
import org.osgl.util.StrBase;
import org.osgl.util.Unsafe;

public class FastStr
extends StrBase<FastStr>
implements RandomAccess,
CharSequence,
Serializable,
Comparable<FastStr> {
    public static final FastStr EMPTY_STR = new FastStr(){

        @Override
        public String toString() {
            return "";
        }
    };
    private final char[] buf;
    private final int begin;
    private final int end;
    private int hash;

    @Override
    protected Class<FastStr> _impl() {
        return FastStr.class;
    }

    @Override
    protected FastStr _empty() {
        return EMPTY_STR;
    }

    private FastStr() {
        this.buf = new char[0];
        this.begin = 0;
        this.end = 0;
    }

    private FastStr(char[] buf) {
        this(buf, 0, buf.length);
    }

    private FastStr(char[] buf, int start, int end) {
        this.buf = buf;
        this.begin = start;
        this.end = end;
    }

    @Override
    public int length() {
        return this.end - this.begin;
    }

    @Override
    public boolean isEmpty() {
        return EMPTY_STR == this || this.buf.length == 0 || this.end <= this.begin;
    }

    @Override
    public boolean isBlank() {
        if (this.isEmpty()) {
            return true;
        }
        for (int i = this.begin; i < this.end; ++i) {
            char c = this.buf[i];
            if (c <= ' ') continue;
            return false;
        }
        return true;
    }

    @Override
    public FastStr subList(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new StringIndexOutOfBoundsException(fromIndex);
        }
        int len = this.size();
        if (toIndex > len) {
            throw new StringIndexOutOfBoundsException(toIndex);
        }
        int subLen = toIndex - fromIndex;
        if (subLen < 0) {
            throw new StringIndexOutOfBoundsException(subLen);
        }
        if (fromIndex == toIndex) {
            return EMPTY_STR;
        }
        int newFrom = this.toInternalId(fromIndex);
        int newTo = this.toInternalId(toIndex);
        return new FastStr(this.buf, newFrom, newTo);
    }

    @Override
    public FastStr takeWhile(Lang.Function<? super Character, Boolean> predicate) {
        if (this.isEmpty()) {
            return EMPTY_STR;
        }
        int sz = this.size();
        int b = this.toInternalId(0);
        int e = -1;
        for (int i = 0; i < sz; ++i) {
            char c = this.charAt(i);
            e = this.toInternalId(i);
            if (!predicate.apply(Character.valueOf(c)).booleanValue()) break;
        }
        return FastStr.unsafeOf(this.buf, b, e);
    }

    @Override
    public FastStr dropWhile(Lang.Function<? super Character, Boolean> predicate) {
        int sz = this.size();
        if (sz == 0) {
            return EMPTY_STR;
        }
        int b = -1;
        int e = this.toInternalId(sz);
        for (int i = 0; i < sz; ++i) {
            char c = this.charAt(i);
            b = this.toInternalId(i);
            if (!predicate.apply(Character.valueOf(c)).booleanValue()) break;
        }
        return FastStr.unsafeOf(this.buf, b, e);
    }

    @Override
    public FastStr remove(Lang.Function<? super Character, Boolean> predicate) {
        int sz = this.size();
        if (sz == 0) {
            return EMPTY_STR;
        }
        char[] newBuf = null;
        boolean removed = false;
        int curNew = 0;
        for (int i = 0; i < sz; ++i) {
            char c = this.charAt(i);
            if (predicate.apply(Character.valueOf(c)).booleanValue()) {
                if (null != newBuf) continue;
                removed = true;
                newBuf = new char[sz];
                System.arraycopy(this.buf, 0, newBuf, 0, i);
                continue;
            }
            if (null != newBuf) {
                newBuf[curNew] = c;
            }
            ++curNew;
        }
        if (!removed) {
            return this;
        }
        return FastStr.unsafeOf(newBuf, 0, curNew);
    }

    @Override
    public FastStr insert(int index, char character) throws StringIndexOutOfBoundsException {
        E.NPE(Character.valueOf(character));
        int len = this.size();
        if (len < Math.abs(index)) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (index < 0) {
            index = len + index;
        }
        char[] newBuf = new char[len + 1];
        if (index > 0) {
            System.arraycopy(this.buf, this.begin, newBuf, 0, index);
        }
        if (index < len) {
            System.arraycopy(this.buf, this.begin + index, newBuf, index + 1, len - index);
        }
        newBuf[index] = character;
        return FastStr.unsafeOf(newBuf, 0, len + 1);
    }

    @Override
    public FastStr insert(int index, Character character) throws StringIndexOutOfBoundsException {
        E.NPE(character);
        int len = this.size();
        if (len < Math.abs(index)) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (index < 0) {
            index = len + index;
        }
        char[] newBuf = new char[len + 1];
        if (index > 0) {
            System.arraycopy(this.buf, this.begin, newBuf, 0, index);
        }
        if (index < len) {
            System.arraycopy(this.buf, this.begin + index, newBuf, index + 1, len - index);
        }
        newBuf[index] = character.charValue();
        return FastStr.unsafeOf(newBuf, 0, len + 1);
    }

    @Override
    public FastStr insert(int index, StrBase<?> str) throws StringIndexOutOfBoundsException {
        return this.insert(index, str.toCharArray());
    }

    @Override
    public FastStr insert(int index, Character ... ca) throws StringIndexOutOfBoundsException {
        return this.insert(0, $.asPrimitive(ca));
    }

    @Override
    public FastStr insert(int index, char ... ca) throws StringIndexOutOfBoundsException {
        int delta = ca.length;
        if (delta == 0) {
            return this;
        }
        int len = this.size();
        if (len < Math.abs(index)) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (index < 0) {
            index = len + index;
        }
        char[] newBuf = new char[len + delta];
        if (index > 0) {
            System.arraycopy(this.buf, this.begin, newBuf, 0, index);
        }
        System.arraycopy(ca, 0, newBuf, index, delta);
        if (index < len) {
            System.arraycopy(this.buf, this.begin + index, newBuf, index + delta, len - index);
        }
        return FastStr.unsafeOf(newBuf, 0, len + delta);
    }

    @Override
    public FastStr insert(int index, String s) throws StringIndexOutOfBoundsException {
        return this.insert(index, s.toCharArray());
    }

    @Override
    public FastStr reverse() {
        int sz = this.size();
        char[] newBuf = new char[sz];
        int i = 0;
        int j = sz - 1;
        while (i < sz) {
            newBuf[j--] = this.buf[this.toInternalId(i++)];
        }
        return new FastStr(newBuf, 0, sz);
    }

    @Override
    public FastStr append(Collection<? extends Character> collection) {
        int sz = this.size();
        int sz2 = collection.size();
        if (0 == sz2) {
            return this;
        }
        if (0 == sz) {
            return FastStr.of(collection);
        }
        char[] newBuf = new char[sz + sz2];
        this.copyTo(newBuf, 0);
        int i = sz;
        for (char c : collection) {
            newBuf[i++] = c;
        }
        return new FastStr(newBuf, 0, sz + sz2);
    }

    @Override
    public FastStr append(C.List<Character> list) {
        int sz = this.size();
        int sz2 = list.size();
        if (0 == sz2) {
            return this;
        }
        if (0 == sz) {
            return FastStr.of(list);
        }
        char[] newBuf = new char[sz + sz2];
        this.copyTo(newBuf, 0);
        for (int i = 0; i < sz2; ++i) {
            newBuf[sz + i] = ((Character)list.get(i)).charValue();
        }
        return new FastStr(newBuf, 0, sz + sz2);
    }

    @Override
    public FastStr parallel() {
        return (FastStr)super.parallel();
    }

    @Override
    public FastStr append(char ... array) {
        int sz = this.size();
        int sz2 = array.length;
        if (0 == sz2) {
            return this;
        }
        if (0 == sz) {
            return FastStr.of(array);
        }
        char[] newBuf = new char[sz + sz2];
        this.copyTo(newBuf, 0);
        for (int i = 0; i < sz2; ++i) {
            newBuf[sz + i] = array[i];
        }
        return new FastStr(newBuf, 0, sz + sz2);
    }

    @Override
    public FastStr append(Character character) {
        int sz = this.size();
        char[] newBuf = new char[sz + 1];
        this.copyTo(newBuf, 0);
        newBuf[sz] = character.charValue();
        return new FastStr(newBuf, 0, sz + 1);
    }

    @Override
    public FastStr append(FastStr s) {
        int sz = this.size();
        int sz2 = s.size();
        if (sz == 0) {
            return s;
        }
        if (sz2 == 0) {
            return this;
        }
        int newSz = sz + sz2;
        char[] newBuf = new char[newSz];
        this.copyTo(newBuf, 0);
        s.copyTo(newBuf, sz);
        return new FastStr(newBuf, 0, newSz);
    }

    @Override
    public FastStr append(String s) {
        int sz = this.size();
        int sz2 = s.length();
        if (0 == sz) {
            return FastStr.of(s);
        }
        if (0 == sz2) {
            return this;
        }
        int newSz = sz + sz2;
        char[] newBuf = new char[newSz];
        this.copyTo(newBuf, 0);
        boolean done = false;
        if (sz2 > 512) {
            try {
                char[] sBuf = Unsafe.bufOf(s);
                System.arraycopy(sBuf, 0, newBuf, sz, sz2);
                done = true;
            }
            catch (RuntimeException sBuf) {
                // empty catch block
            }
        }
        if (!done) {
            for (int i = 0; i < sz2; ++i) {
                newBuf[sz + i] = s.charAt(i);
            }
        }
        return new FastStr(newBuf, 0, newSz);
    }

    @Override
    public FastStr prepend(Collection<? extends Character> collection) {
        int sz = this.size();
        int sz2 = collection.size();
        if (0 == sz2) {
            return this;
        }
        if (0 == sz) {
            return FastStr.of(collection);
        }
        int newSz = sz + sz2;
        int i = 0;
        char[] newBuf = new char[newSz];
        Iterator<Character> itr = collection.iterator();
        while (itr.hasNext()) {
            newBuf[i++] = itr.next().charValue();
        }
        this.copyTo(newBuf, sz2);
        return new FastStr(newBuf, 0, newSz);
    }

    @Override
    public FastStr prepend(C.List<Character> list) {
        int sz = this.size();
        if (0 == sz) {
            return FastStr.of(list);
        }
        int sz2 = list.size();
        if (0 == sz2) {
            return this;
        }
        if (1 == sz2) {
            return this.prepend((Character)list.get(0));
        }
        int newSz = sz + sz2;
        char[] newBuf = new char[newSz];
        for (int i = 0; i < sz2; ++i) {
            newBuf[i] = ((Character)list.get(i)).charValue();
        }
        this.copyTo(newBuf, sz2);
        return new FastStr(newBuf, 0, newSz);
    }

    @Override
    public FastStr prepend(char ... chars) {
        int sz = this.size();
        if (0 == sz) {
            return FastStr.of(chars);
        }
        int sz2 = chars.length;
        if (0 == sz2) {
            return this;
        }
        if (1 == sz2) {
            return this.prepend(Character.valueOf(chars[0]));
        }
        int newSz = sz + sz2;
        char[] newBuf = new char[newSz];
        for (int i = 0; i < sz2; ++i) {
            newBuf[i] = chars[i];
        }
        this.copyTo(newBuf, sz2);
        return new FastStr(newBuf, 0, newSz);
    }

    @Override
    public FastStr prepend(Character character) {
        if (this.begin > 0 && this.buf[this.begin - 1] == character.charValue()) {
            return FastStr.unsafeOf(this.buf, this.begin - 1, this.end);
        }
        int sz = this.size();
        char[] newBuf = new char[++sz];
        newBuf[0] = character.charValue();
        this.copyTo(newBuf, 1);
        return new FastStr(newBuf, 0, sz);
    }

    @Override
    public FastStr prepend(FastStr s) {
        return s.append(this);
    }

    @Override
    public FastStr prepend(String s) {
        int sz = this.size();
        if (0 == sz) {
            return FastStr.of(s);
        }
        int sz2 = s.length();
        if (0 == sz2) {
            return this;
        }
        if (sz2 == 1) {
            return this.prepend(Character.valueOf(s.charAt(0)));
        }
        int newSz = sz + sz2;
        char[] newBuf = new char[newSz];
        boolean done = false;
        if (sz2 > 512) {
            try {
                char[] sBuf = Unsafe.bufOf(s);
                System.arraycopy(sBuf, 0, newBuf, 0, sz2);
                done = true;
            }
            catch (RuntimeException sBuf) {
                // empty catch block
            }
        }
        if (!done) {
            for (int i = 0; i < sz2; ++i) {
                newBuf[i] = s.charAt(i);
            }
        }
        this.copyTo(newBuf, sz2);
        return new FastStr(newBuf, 0, newSz);
    }

    @Override
    public FastStr padLeft(char c, int times) {
        char[] ca = new char[times];
        $.fill(c, ca);
        return this.prepend(ca);
    }

    @Override
    public FastStr lpad(char c, int times) {
        return this.padLeft(c, times);
    }

    @Override
    public FastStr padLeft(int times) {
        return this.padLeft(' ', times);
    }

    @Override
    public FastStr lpad(int times) {
        return this.padLeft(times);
    }

    @Override
    public FastStr padRight(char c, int times) {
        char[] ca = new char[times];
        $.fill(c, ca);
        return this.append(ca);
    }

    @Override
    public FastStr rpad(char c, int times) {
        return this.padRight(c, times);
    }

    @Override
    public FastStr padRight(int times) {
        return this.padRight(' ', times);
    }

    @Override
    public FastStr rpad(int times) {
        return this.padRight(times);
    }

    @Override
    public char charAt(int index) {
        return this.buf[this.toInternalId(index)];
    }

    @Override
    public FastStr subSequence(int start, int end) {
        return this.subList(start, end);
    }

    @Override
    public FastStr copy() {
        if (EMPTY_STR == this) {
            return this;
        }
        return FastStr.unsafeOf(this.charArray(), 0, this.size());
    }

    @Override
    public FastStr times(int n) {
        E.illegalArgumentIf(n < 0, "n cannot be negative");
        if (0 == n) {
            return EMPTY_STR;
        }
        if (1 == n) {
            return this;
        }
        int sz = this.size();
        if (0 == sz) {
            return this;
        }
        int newSz = sz * n;
        char[] newBuf = new char[newSz];
        for (int i = 0; i < n; ++i) {
            this.copyTo(newBuf, i * sz);
        }
        return new FastStr(newBuf, 0, newSz);
    }

    public FastStr canonical() {
        if (EMPTY_STR == this) {
            return this;
        }
        if (this.begin == 0) {
            return this;
        }
        return FastStr.unsafeOf(this.unsafeChars(), 0, this.size());
    }

    @Override
    public int compareTo(FastStr o) {
        int len1 = this.size();
        int len2 = o.size();
        int lim = Math.min(len1, len2);
        char[] v1 = this.buf;
        char[] v2 = o.buf;
        for (int k = 0; k < lim; ++k) {
            char c2;
            char c1 = v1[this.toInternalId(k)];
            if (c1 == (c2 = v2[o.toInternalId(k)])) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    @Override
    public String toString() {
        char[] newBuf = this.charArray();
        try {
            return Unsafe.stringOf(newBuf);
        }
        catch (Exception e) {
            return new String(newBuf);
        }
    }

    @Override
    public FastStr toFastStr() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FastStr) {
            FastStr that = (FastStr)o;
            return this.contentEquals(that);
        }
        if (o instanceof StrBase) {
            StrBase that = (StrBase)o;
            return that.contentEquals(this);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        int h = this.hash;
        if (h == 0) {
            for (int i = this.begin; i < this.end; ++i) {
                h = 31 * h + this.buf[i];
            }
            this.hash = h;
        }
        return h;
    }

    @Override
    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException(srcEnd - srcBegin);
        }
        int sz = this.size();
        if (srcEnd > sz) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        System.arraycopy(this.buf, this.toInternalId(srcBegin), dst, dstBegin, srcEnd - srcBegin);
    }

    @Override
    public byte[] getBytes() {
        String s = this.toString();
        return s.getBytes();
    }

    @Override
    public byte[] getBytes(String charsetName) {
        String s = this.toString();
        if (null == charsetName) {
            return s.getBytes();
        }
        try {
            return s.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw E.encodingException(e);
        }
    }

    @Override
    public byte[] getBytes(Charset charset) {
        String s = this.toString();
        if (null == charset) {
            return s.getBytes();
        }
        return s.getBytes(charset);
    }

    @Override
    public byte[] getBytesAscII() {
        int sz = this.size();
        if (sz == 0) {
            return new byte[0];
        }
        try {
            char[] chars;
            if (sz == this.buf.length && this.begin == 0) {
                chars = this.buf;
            } else {
                chars = new char[sz];
                System.arraycopy(this.buf, this.begin, chars, 0, sz);
            }
            return Unsafe.stringOf(chars).getBytes(Charsets.US_ASCII);
        }
        catch (Exception e) {
            return this.toString().getBytes(Charsets.US_ASCII);
        }
    }

    @Override
    public byte[] getBytesUTF8() {
        int sz = this.size();
        if (sz == 0) {
            return new byte[0];
        }
        try {
            char[] chars;
            if (sz == this.buf.length && this.begin == 0) {
                chars = this.buf;
            } else {
                chars = new char[sz];
                System.arraycopy(this.buf, this.begin, chars, 0, sz);
            }
            return Unsafe.stringOf(chars).getBytes(Charsets.UTF_8);
        }
        catch (Exception e) {
            return this.toString().getBytes(Charsets.UTF_8);
        }
    }

    @Override
    public boolean contentEquals(CharSequence x) {
        int sz2;
        if (x == this) {
            return true;
        }
        if (this.isEmpty()) {
            return x.length() == 0;
        }
        int sz = this.size();
        if (sz != (sz2 = x.length())) {
            return false;
        }
        for (int i = 0; i < sz; ++i) {
            char c1;
            char c = this.buf[this.toInternalId(i)];
            if (c == (c1 = x.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contentEquals(FastStr x) {
        int sz2;
        if (x == this) {
            return true;
        }
        if (null == x) {
            return false;
        }
        int sz = this.size();
        if (sz != (sz2 = x.size())) {
            return false;
        }
        int i = this.begin;
        int j = x.begin;
        while (i < this.end) {
            if (this.buf[i++] == x.buf[j++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsIgnoreCase(CharSequence x) {
        if (x == this) {
            return true;
        }
        if (null == x || this.size() != x.length()) {
            return false;
        }
        if (this.isEmpty() && x.length() == 0) {
            return true;
        }
        return this.regionMatches(true, 0, x, 0, this.size());
    }

    public boolean equalsIgnoreCase(FastStr x) {
        if (x == this) {
            return true;
        }
        if (null == x || this.size() != x.size()) {
            return false;
        }
        return this.regionMatches(true, 0, x.buf, 0, this.size());
    }

    @Override
    public int compareTo(CharSequence x) {
        int len1 = this.size();
        int len2 = x.length();
        int lim = Math.min(len1, len2);
        char[] v1 = this.buf;
        try {
            char[] v2 = Unsafe.bufOf(x);
            for (int k = 0; k < lim; ++k) {
                char c2;
                char c1 = v1[this.toInternalId(k)];
                if (c1 == (c2 = v2[k])) continue;
                return c1 - c2;
            }
        }
        catch (RuntimeException e) {
            for (int k = 0; k < lim; ++k) {
                char c2;
                char c1 = v1[this.toInternalId(k)];
                if (c1 == (c2 = x.charAt(k))) continue;
                return c1 - c2;
            }
        }
        return len1 - len2;
    }

    @Override
    public int compareToIgnoreCase(FastStr o) {
        int len1 = this.size();
        int len2 = o.size();
        int lim = Math.min(len1, len2);
        char[] v1 = this.buf;
        char[] v2 = o.buf;
        for (int k = 0; k < lim; ++k) {
            char c2;
            char c1 = v1[this.toInternalId(k)];
            if (c1 == (c2 = v2[o.toInternalId(k)]) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    @Override
    public int compareToIgnoreCase(CharSequence o) {
        int k;
        int len1 = this.size();
        int len2 = o.length();
        int lim = Math.min(len1, len2);
        char[] v1 = this.buf;
        try {
            char[] v2 = Unsafe.bufOf(o);
            for (k = 0; k < lim; ++k) {
                char c2;
                char c1 = v1[this.toInternalId(k)];
                if (c1 == (c2 = v2[k]) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
                return c1 - c2;
            }
        }
        catch (RuntimeException e) {
            while (k < lim) {
                char c2;
                char c1 = v1[this.toInternalId(k)];
                if (c1 != (c2 = o.charAt(k)) && (c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && (c1 = Character.toLowerCase(c1)) != (c2 = Character.toLowerCase(c2))) {
                    return c1 - c2;
                }
                ++k;
            }
        }
        return len1 - len2;
    }

    @Override
    public boolean regionMatches(boolean ignoreCase, int toffset, FastStr other, int ooffset, int len) {
        return this.regionMatches(ignoreCase, toffset, other.unsafeChars(), ooffset, len);
    }

    @Override
    private boolean regionMatches(boolean ignoreCase, int toffset, char[] other, int ooffset, int len) {
        char[] ta = this.buf;
        int to = this.toInternalId(toffset);
        char[] pa = other;
        int po = ooffset;
        if (ooffset < 0 || to < 0 || (long)toffset > (long)this.length() - (long)len || (long)ooffset > (long)other.length - (long)len) {
            return false;
        }
        while (len-- > 0) {
            char u2;
            char u1;
            char c2;
            char c1;
            if ((c1 = ta[to++]) == (c2 = pa[po++]) || ignoreCase && ((u1 = Character.toUpperCase(c1)) == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean regionMatches(boolean ignoreCase, int toffset, CharSequence other, int ooffset, int len) {
        char[] otherBuf = FastStr.bufOf(other);
        return this.regionMatches(ignoreCase, toffset, otherBuf, ooffset, len);
    }

    @Override
    public boolean startsWith(FastStr prefix, int toffset) {
        if (prefix.isEmpty()) {
            return true;
        }
        int sz2 = prefix.size();
        int sz = this.size();
        if (toffset < 0 || toffset > sz - sz2) {
            return false;
        }
        int po = 0;
        int pc = sz2;
        int to = toffset;
        char[] buf1 = this.buf;
        char[] buf2 = prefix.buf;
        while (--pc >= 0) {
            if (buf1[this.toInternalId(to++)] == buf2[prefix.toInternalId(po++)]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean startsWith(CharSequence suffix, int toffset) {
        if (suffix.length() == 0) {
            return true;
        }
        int sz2 = suffix.length();
        int sz = this.size();
        if (toffset < 0 || toffset > sz - sz2) {
            return false;
        }
        int po = 0;
        int pc = sz2;
        int to = toffset;
        char[] buf1 = this.buf;
        try {
            char[] buf2 = Unsafe.bufOf(suffix);
            while (--pc >= 0) {
                if (buf1[this.toInternalId(to++)] == buf2[po++]) continue;
                return false;
            }
            return true;
        }
        catch (RuntimeException e) {
            while (--pc >= 0) {
                if (buf1[this.toInternalId(to++)] == suffix.charAt(po++)) continue;
                return false;
            }
            return true;
        }
    }

    @Override
    public boolean endsWith(CharSequence suffix, int toffset) {
        int prefixSz = suffix.length();
        if (0 == prefixSz) {
            return true;
        }
        int matchStart = this.length() - toffset;
        if (matchStart < prefixSz) {
            return false;
        }
        int i = this.toInternalId(matchStart - 1);
        for (int j = prefixSz - 1; j >= 0; --j) {
            char c0 = this.buf[i];
            char c1 = suffix.charAt(j);
            if (c0 != c1) {
                return false;
            }
            --i;
        }
        return true;
    }

    @Override
    public boolean endsWith(FastStr prefix, int toffset) {
        int prefixSz = prefix.length();
        if (0 == prefixSz) {
            return true;
        }
        int matchStart = this.length() - toffset;
        if (matchStart < prefixSz) {
            return false;
        }
        char[] prefixBuf = prefix.buf;
        int i = this.toInternalId(matchStart - 1);
        for (int j = prefix.toInternalId(prefixSz - 1); j >= prefix.begin; --j) {
            char c0 = this.buf[i];
            char c1 = prefixBuf[j];
            if (c0 != c1) {
                return false;
            }
            --i;
        }
        return true;
    }

    @Override
    public int indexOf(int ch, int fromIndex) {
        int max = this.size();
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex > max) {
            return -1;
        }
        fromIndex = this.toInternalId(fromIndex);
        if (ch < 65536) {
            char[] buf = this.buf;
            for (int i = fromIndex; i < this.end; ++i) {
                if (buf[i] != ch) continue;
                return this.toExternalId(i);
            }
            return -1;
        }
        return this.toExternalId(this.indexOfSupplementary(ch, fromIndex));
    }

    @Override
    public int lastIndexOf(int ch, int fromIndex) {
        fromIndex = this.toInternalId(fromIndex);
        if (ch < 65536) {
            char[] value = this.buf;
            for (int i = Math.min(fromIndex, this.length() - 1 + this.begin); i >= this.begin; --i) {
                if (value[i] != ch) continue;
                return this.toExternalId(i);
            }
            return -1;
        }
        return this.toExternalId(this.lastIndexOfSupplementary(ch, fromIndex));
    }

    @Override
    public int indexOf(CharSequence str, int fromIndex) {
        char[] strBuf = FastStr.bufOf(str);
        return S.indexOf(this.buf, this.begin, this.size(), strBuf, 0, strBuf.length, fromIndex);
    }

    @Override
    public int indexOf(FastStr str, int fromIndex) {
        char[] buf = str.buf;
        return S.indexOf(this.buf, this.begin, this.size(), buf, str.begin, str.size(), fromIndex);
    }

    @Override
    public int lastIndexOf(CharSequence str, int fromIndex) {
        char[] strBuf = FastStr.bufOf(str);
        int sz = this.size();
        return S.lastIndexOf(this.buf, this.begin, sz, strBuf, 0, strBuf.length, fromIndex);
    }

    @Override
    public int lastIndexOf(FastStr str, int fromIndex) {
        int sz = this.size();
        return S.lastIndexOf(this.buf, this.begin, sz, str.buf, str.begin, str.size(), fromIndex);
    }

    @Override
    public String substring(int beginIndex) {
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        int subLen = this.size() - beginIndex;
        if (subLen < 0) {
            throw new StringIndexOutOfBoundsException(subLen);
        }
        return beginIndex == 0 ? this.toString() : new String(this.buf, this.toInternalId(beginIndex), subLen);
    }

    @Override
    public String substring(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        char[] buf = this.buf;
        int sz = buf.length;
        if (endIndex > sz) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        int subLen = endIndex - beginIndex;
        if (subLen < 0) {
            throw new StringIndexOutOfBoundsException(subLen);
        }
        return beginIndex == 0 && endIndex == sz ? this.toString() : new String(buf, this.toInternalId(beginIndex), subLen);
    }

    @Override
    public FastStr replace(char oldChar, char newChar) {
        if (oldChar != newChar) {
            char[] val = this.buf;
            int len = this.length();
            int i = this.begin - 1;
            while (++i < this.end && val[i] != oldChar) {
            }
            if (i < this.end) {
                char[] buf = new char[len];
                for (int j = this.begin; j < i; ++j) {
                    buf[j - this.begin] = val[j];
                }
                while (i < this.end) {
                    char c = val[i];
                    buf[i - this.begin] = c == oldChar ? newChar : c;
                    ++i;
                }
                return new FastStr(buf, 0, len);
            }
        }
        return this;
    }

    @Override
    public boolean matches(String regex) {
        return Pattern.matches(regex, this);
    }

    @Override
    public boolean contains(CharSequence s) {
        if (s instanceof FastStr) {
            return this.indexOf((FastStr)s) > -1;
        }
        return this.indexOf(s.toString()) > -1;
    }

    @Override
    public FastStr replaceFirst(String regex, String replacement) {
        return FastStr.unsafeOf(Pattern.compile(regex).matcher(this).replaceFirst(replacement));
    }

    @Override
    public FastStr replaceAll(String regex, String replacement) {
        return FastStr.unsafeOf(Pattern.compile(regex).matcher(this).replaceAll(replacement));
    }

    @Override
    public FastStr replace(CharSequence target, CharSequence replacement) {
        return FastStr.unsafeOf(Pattern.compile(target.toString(), 16).matcher(this).replaceAll(Matcher.quoteReplacement(replacement.toString())));
    }

    @Override
    public C.List<FastStr> split(String regex, int limit) {
        char ch;
        if ((regex.length() == 1 && ".$|()[{^?*+\\".indexOf(ch = regex.charAt(0)) == -1 || regex.length() == 2 && regex.charAt(0) == '\\' && ((ch = regex.charAt(1)) - 48 | 57 - ch) < 0 && (ch - 97 | 122 - ch) < 0 && (ch - 65 | 90 - ch) < 0) && (ch < '\ud800' || ch > '\udfff')) {
            int resultSize;
            int off = 0;
            int next = 0;
            boolean limited = limit > 0;
            C.List list = C.newList();
            while ((next = this.indexOf(ch, off)) != -1) {
                if (!limited || list.size() < limit - 1) {
                    list.add(this.substr(off, next));
                    off = next + 1;
                    continue;
                }
                list.add(this.substr(off, this.buf.length));
                off = this.buf.length;
                break;
            }
            if (off == 0) {
                return C.listOf(this);
            }
            if (!limited || list.size() < limit) {
                list.add(this.substr(off, this.buf.length));
            }
            if (limit == 0) {
                for (resultSize = list.size(); resultSize > 0 && ((FastStr)list.get(resultSize - 1)).length() == 0; --resultSize) {
                }
            }
            return list.subList(0, resultSize);
        }
        String[] sa = Pattern.compile(regex).split(this, limit);
        int len = sa.length;
        FastStr[] ssa = new FastStr[len];
        for (int i = 0; i < len; ++i) {
            ssa[i] = FastStr.unsafeOf(sa[i]);
        }
        return C.listOf(ssa);
    }

    @Override
    public FastStr toLowerCase(Locale locale) {
        String s = this.toString();
        return FastStr.unsafeOf(s.toLowerCase(locale));
    }

    @Override
    public FastStr toUpperCase(Locale locale) {
        String s = this.toString();
        return FastStr.unsafeOf(s.toUpperCase(locale));
    }

    @Override
    public FastStr trim() {
        int st;
        char[] value = this.buf;
        int len = this.end;
        char[] val = value;
        for (st = this.begin; st < len && val[st] <= ' '; ++st) {
        }
        while (st < len && val[len - 1] <= ' ') {
            --len;
        }
        return st > this.begin || len < this.size() ? new FastStr(value, st, len) : this;
    }

    @Override
    public char[] charArray() {
        char[] newBuf = new char[this.size()];
        this.copyTo(newBuf, 0);
        return newBuf;
    }

    public char[] unsafeChars() {
        if (this.begin == 0) {
            return this.buf;
        }
        char[] newBuf = new char[this.size()];
        this.copyTo(newBuf, 0);
        return newBuf;
    }

    @Override
    public String intern() {
        return this.toString().intern();
    }

    @Override
    public FastStr afterFirst(String s) {
        return this.afterFirst(FastStr.unsafeOf(s));
    }

    @Override
    public FastStr afterLast(String s) {
        return this.afterLast(FastStr.unsafeOf(s));
    }

    @Override
    public FastStr afterFirst(FastStr s) {
        int pos = this.indexOf(s);
        if (pos < 0) {
            return EMPTY_STR;
        }
        return (FastStr)this.substr(pos + s.size());
    }

    @Override
    public FastStr afterLast(FastStr s) {
        int pos = this.lastIndexOf(s);
        if (pos < 0) {
            return EMPTY_STR;
        }
        return (FastStr)this.substr(pos + s.size());
    }

    @Override
    public FastStr afterFirst(char c) {
        int pos = this.indexOf(c);
        if (pos < 0) {
            return EMPTY_STR;
        }
        return (FastStr)this.substr(pos + 1);
    }

    @Override
    public FastStr afterLast(char c) {
        int pos = this.lastIndexOf(c);
        if (pos < 0) {
            return EMPTY_STR;
        }
        return (FastStr)this.substr(pos + 1);
    }

    @Override
    public FastStr beforeFirst(String s) {
        return this.beforeFirst(FastStr.unsafeOf(s));
    }

    @Override
    public FastStr beforeLast(String s) {
        return this.beforeLast(FastStr.unsafeOf(s));
    }

    @Override
    public FastStr beforeFirst(FastStr s) {
        int pos = this.indexOf(s);
        if (pos < 0) {
            return EMPTY_STR;
        }
        return (FastStr)this.substr(0, pos);
    }

    @Override
    public FastStr beforeLast(FastStr s) {
        int pos = this.lastIndexOf(s);
        if (pos < 0) {
            return EMPTY_STR;
        }
        return (FastStr)this.substr(0, pos);
    }

    @Override
    public FastStr beforeFirst(char c) {
        int pos = this.indexOf(c);
        if (pos < 0) {
            return EMPTY_STR;
        }
        return (FastStr)this.substr(0, pos);
    }

    @Override
    public FastStr beforeLast(char c) {
        int pos = this.lastIndexOf(c);
        if (pos < 0) {
            return EMPTY_STR;
        }
        return (FastStr)this.substr(0, pos);
    }

    @Override
    public FastStr strip(String prefix, String suffix) {
        FastStr s = this;
        if (this.startsWith(prefix)) {
            s = (FastStr)s.substr(prefix.length());
        }
        if (s.endsWith(suffix)) {
            s = (FastStr)s.substr(0, s.size() - suffix.length());
        }
        return s;
    }

    public FastStr strip(FastStr prefix, FastStr suffix) {
        FastStr s = this;
        if (this.startsWith(prefix)) {
            s = (FastStr)s.substr(prefix.size());
        }
        if (s.endsWith(suffix)) {
            s = (FastStr)s.substr(0, s.size() - suffix.size());
        }
        return s;
    }

    @Override
    public FastStr urlEncode() {
        String s;
        try {
            s = Unsafe.stringOf(this.buf);
        }
        catch (Exception e) {
            s = this.toString();
        }
        return FastStr.unsafeOf(S.urlEncode(s));
    }

    @Override
    public FastStr decodeBASE64() {
        String s;
        try {
            s = Unsafe.stringOf(this.buf);
        }
        catch (Exception e) {
            s = this.toString();
        }
        return FastStr.unsafeOf(S.decodeBASE64(s));
    }

    @Override
    public FastStr encodeBASE64() {
        String s;
        try {
            s = Unsafe.stringOf(this.buf);
        }
        catch (Exception e) {
            s = this.toString();
        }
        return FastStr.unsafeOf(S.encodeBASE64(s));
    }

    @Override
    public FastStr capFirst() {
        if (this.isEmpty()) {
            return this;
        }
        char[] buf = this.buf;
        int sz = this.size();
        char[] newBuf = S.unsafeCapFirst(buf, this.begin, sz);
        if (buf == newBuf) {
            return this;
        }
        return FastStr.unsafeOf(newBuf, 0, sz);
    }

    @Override
    public int count(String search, boolean overlap) {
        char[] searchBuf = FastStr.bufOf(search);
        return this.count(searchBuf, 0, searchBuf.length, overlap);
    }

    @Override
    public int count(FastStr search, boolean overlap) {
        return this.count(search.buf, search.begin, search.size(), overlap);
    }

    private int toInternalId(int index) {
        return this.begin + index;
    }

    private int toExternalId(int index) {
        return index - this.begin;
    }

    private void copyTo(char[] buf, int begin) {
        System.arraycopy(this.buf, this.begin, buf, begin, this.size());
    }

    private int indexOfSupplementary(int ch, int fromIndex) {
        if (Character.isValidCodePoint(ch)) {
            char[] buf = this.buf;
            char hi = FastStr.highSurrogate(ch);
            char lo = FastStr.lowSurrogate(ch);
            int max = this.size() - 1;
            for (int i = fromIndex; i < max; ++i) {
                if (buf[this.toInternalId(i)] != hi || buf[this.toInternalId(i + 1)] != lo) continue;
                return i;
            }
        }
        return -1;
    }

    private int lastIndexOfSupplementary(int ch, int fromIndex) {
        if (Character.isValidCodePoint(ch)) {
            char[] buf = this.buf;
            char hi = FastStr.highSurrogate(ch);
            char lo = FastStr.lowSurrogate(ch);
            for (int i = Math.min(fromIndex, buf.length - 2); i >= 0; --i) {
                if (buf[this.toInternalId(i)] != hi || buf[this.toInternalId(i + 1)] != lo) continue;
                return i;
            }
        }
        return -1;
    }

    private int count(char[] search, int searchOffset, int searchCount, boolean overlap) {
        if (this.isEmpty()) {
            return 0;
        }
        return S.count(this.buf, this.begin, this.size(), search, searchOffset, searchCount, overlap);
    }

    public static FastStr of(char[] ca) {
        if (ca.length == 0) {
            return EMPTY_STR;
        }
        char[] newArray = new char[ca.length];
        System.arraycopy(ca, 0, newArray, 0, ca.length);
        return new FastStr(ca);
    }

    public static FastStr of(CharSequence cs) {
        if (cs instanceof FastStr) {
            return (FastStr)cs;
        }
        return FastStr.of(cs.toString());
    }

    public static FastStr of(String s) {
        int sz = s.length();
        if (sz == 0) {
            return EMPTY_STR;
        }
        char[] buf = s.toCharArray();
        return new FastStr(buf, 0, sz);
    }

    public static FastStr of(StringBuilder sb) {
        int sz = sb.length();
        if (0 == sz) {
            return EMPTY_STR;
        }
        char[] buf = new char[sz];
        for (int i = 0; i < sz; ++i) {
            buf[i] = sb.charAt(i);
        }
        return new FastStr(buf, 0, sz);
    }

    public static FastStr of(StringBuffer sb) {
        int sz = sb.length();
        if (0 == sz) {
            return EMPTY_STR;
        }
        char[] buf = new char[sz];
        for (int i = 0; i < sz; ++i) {
            buf[i] = sb.charAt(i);
        }
        return new FastStr(buf, 0, sz);
    }

    public static FastStr of(Iterable<Character> itr) {
        StringBuilder sb = new StringBuilder();
        for (Character c : itr) {
            sb.append(c);
        }
        return FastStr.of(sb);
    }

    public static FastStr of(Collection<Character> col) {
        int sz = col.size();
        if (0 == sz) {
            return EMPTY_STR;
        }
        char[] buf = new char[sz];
        Iterator<Character> itr = col.iterator();
        int i = 0;
        while (itr.hasNext()) {
            buf[i++] = itr.next().charValue();
        }
        return new FastStr(buf, 0, sz);
    }

    public static FastStr of(Iterator<Character> itr) {
        StringBuilder sb = new StringBuilder();
        while (itr.hasNext()) {
            sb.append(itr.next());
        }
        return FastStr.of(sb);
    }

    public static FastStr of(byte[] bytes, String encoding) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        CharBuffer charBuffer = Charset.forName(encoding).decode(byteBuffer);
        char[] chars = Arrays.copyOfRange(charBuffer.array(), charBuffer.position(), charBuffer.limit());
        Arrays.fill(charBuffer.array(), '\u0000');
        Arrays.fill(byteBuffer.array(), (byte)0);
        return FastStr.of(chars);
    }

    public static FastStr unsafeOf(String s) {
        int sz = s.length();
        if (sz == 0) {
            return EMPTY_STR;
        }
        char[] buf = FastStr.bufOf(s);
        return new FastStr(buf, 0, sz);
    }

    public static FastStr unsafeOf(char[] buf) {
        E.NPE(buf);
        return new FastStr(buf, 0, buf.length);
    }

    public static FastStr unsafeOf(char[] buf, int start, int end) {
        E.NPE(buf);
        E.illegalArgumentIf(start < 0 || end > buf.length);
        if (end < start) {
            return EMPTY_STR;
        }
        return new FastStr(buf, start, end);
    }

    public static char[] bufOf(CharSequence chars) {
        return FastStr.of(chars).charArray();
    }

    private static char highSurrogate(int codePoint) {
        return (char)((codePoint >>> 10) + 55232);
    }

    private static char lowSurrogate(int codePoint) {
        return (char)((codePoint & 0x3FF) + 56320);
    }
}

