/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.Iterator;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.FilteredIterator;
import org.osgl.util.IterableSeq;

class FilteredSeq<T>
extends IterableSeq<T>
implements C.Sequence<T> {
    private Lang.Function<? super T, Boolean> filter;
    private FilteredIterator.Type type;

    FilteredSeq(Iterable<? extends T> iterable, Lang.Function<? super T, Boolean> predicate) {
        this(iterable, predicate, FilteredIterator.Type.ALL);
    }

    FilteredSeq(Iterable<? extends T> iterable, Lang.Function<? super T, Boolean> predicate, FilteredIterator.Type type) {
        super(iterable);
        E.NPE(predicate, (Object)type);
        this.filter = predicate;
        this.type = type;
    }

    @Override
    public Iterator<T> iterator() {
        Iterator itr = super.iterator();
        return this.type.filter(itr, this.filter);
    }

    public static <T> FilteredSeq<T> of(Iterable<? extends T> iterable, Lang.Function<? super T, Boolean> predicate) {
        return new FilteredSeq<T>(iterable, predicate);
    }

    public static <T> FilteredSeq<T> of(Iterable<? extends T> iterable, Lang.Function<? super T, Boolean> predicate, FilteredIterator.Type type) {
        return new FilteredSeq<T>(iterable, predicate, type);
    }
}

