/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgl.$;
import org.osgl.exception.UnexpectedException;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class Generics {
    public static <T> Class<T> classOf(Type type) {
        if (type instanceof Class) {
            return (Class)$.cast(type);
        }
        if (type instanceof ParameterizedType) {
            return (Class)$.cast(((ParameterizedType)type).getRawType());
        }
        throw new IllegalArgumentException("Cannot find class from type: " + type);
    }

    public static List<Type> typeParamImplementations(Class theClass, Class rootClass) {
        if (rootClass.getTypeParameters().length == 0) {
            return C.list();
        }
        try {
            return Generics.typeParamImplementations(theClass, rootClass, new ArrayList<Type>());
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(S.fmt("Cannot infer type parameter implementation on %s against %s", theClass.getName(), rootClass.getName()), e);
        }
    }

    public static Map<String, Class> buildTypeParamImplLookup(Class theClass) {
        HashMap<String, Class> lookup = new HashMap<String, Class>();
        Generics.buildTypeParamImplLookup(theClass, lookup);
        return lookup;
    }

    public static void buildTypeParamImplLookup(Class theClass, Map<String, Class> lookup) {
        if (null == theClass || Object.class == theClass) {
            return;
        }
        Type superType = theClass.getGenericSuperclass();
        if (superType instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)$.cast(superType);
            Type[] typeParams = ptype.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeArgs = theClass.getSuperclass().getTypeParameters();
            int len = typeParams.length;
            for (int i = 0; i < len; ++i) {
                Type bound;
                Type typeParam = typeParams[i];
                if (typeParam instanceof Class) {
                    TypeVariable typeVar = typeArgs[i];
                    lookup.put(typeVar.getName(), (Class)typeParam);
                    continue;
                }
                if (!(typeParam instanceof TypeVariable)) continue;
                TypeVariable var = (TypeVariable)$.cast(typeParam);
                String name = var.getName();
                Class impl = lookup.get(name);
                TypeVariable typeVar = typeArgs[i];
                if (null != impl) {
                    lookup.put(typeVar.getName(), impl);
                    continue;
                }
                Type[] ta = var.getBounds();
                if (null == ta || ta.length != 1 || !((bound = ta[0]) instanceof Class)) continue;
                lookup.put(typeVar.getName(), (Class)bound);
            }
        }
        Generics.buildTypeParamImplLookup(theClass.getSuperclass(), lookup);
    }

    private static List<Type> typeParamImplementations(Class theClass, Class rootClass, List<Type> subClassTypeParams) {
        Type[] interfaces;
        Type superType = null;
        for (Type intf : interfaces = theClass.getGenericInterfaces()) {
            Type rawType;
            if (!(intf instanceof ParameterizedType) || !$.eq(rawType = ((ParameterizedType)intf).getRawType(), rootClass)) continue;
            superType = intf;
        }
        if (null == superType) {
            superType = theClass.getGenericSuperclass();
        }
        Class superClass = null;
        boolean theClassIsInterface = theClass.isInterface();
        while (!(superType instanceof ParameterizedType) && Object.class != superType) {
            if (theClassIsInterface) {
                try {
                    if (null == superClass) {
                        superClass = theClass;
                    }
                    Type[] types = superClass.getGenericInterfaces();
                    superType = types[0];
                    Class<?>[] intfs = theClass.getInterfaces();
                    superClass = intfs[0];
                    continue;
                }
                catch (RuntimeException e) {
                    throw new UnexpectedException("Cannot find type implementation for %s", theClass);
                }
            }
            if (null == superClass) {
                superClass = theClass.getSuperclass();
            }
            superType = superClass.getGenericSuperclass();
            superClass = superClass.getSuperclass();
        }
        if (superType instanceof ParameterizedType) {
            TypeVariable<Class<T>>[] declaredTypeVariables = theClass.getTypeParameters();
            ParameterizedType pSuperType = (ParameterizedType)$.cast(superType);
            Type[] superTypeParams = pSuperType.getActualTypeArguments();
            ArrayList<Type> nextList = new ArrayList<Type>();
            for (Type stp : superTypeParams) {
                if (stp instanceof Class || stp instanceof ParameterizedType) {
                    nextList.add(stp);
                    continue;
                }
                if (!(stp instanceof TypeVariable)) continue;
                boolean found = false;
                for (int i = 0; i < declaredTypeVariables.length; ++i) {
                    TypeVariable declared = declaredTypeVariables[i];
                    if (!$.eq(declared, stp)) continue;
                    nextList.add(subClassTypeParams.get(i));
                    found = true;
                }
                E.illegalStateIf(!found, "Cannot find type implementation for %s", theClass);
            }
            superClass = (Class)pSuperType.getRawType();
            if ($.eq(superClass, rootClass)) {
                return nextList;
            }
            return Generics.typeParamImplementations(superClass, rootClass, nextList);
        }
        throw E.unexpected("Cannot find type param implementation: super type %s of %s is not a parameterized type", superType, theClass);
    }

    public static void main(String[] args) {
        Class<Serializable> c = Serializable.class;
        System.out.println(c.getGenericSuperclass());
        System.out.println($.toString2(c.getGenericInterfaces()));
    }
}

