/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.C;
import org.osgl.util.CompositeList;
import org.osgl.util.CompositeSeq;
import org.osgl.util.E;
import org.osgl.util.ListBase;
import org.osgl.util.ListBuilder;
import org.osgl.util.MappedList;
import org.osgl.util.Nil;
import org.osgl.util.ReverseList;
import org.osgl.util.algo.Algorithms;

class ImmutableList<T>
extends ListBase<T>
implements C.List<T>,
RandomAccess,
Serializable {
    private final T[] data_;

    protected ImmutableList(T[] data) {
        E.NPE(data);
        this.data_ = data;
    }

    @Override
    protected EnumSet<C.Feature> initFeatures() {
        return EnumSet.of(C.Feature.READONLY, new C.Feature[]{C.Feature.LIMITED, C.Feature.ORDERED, C.Feature.IMMUTABLE, C.Feature.LAZY, C.Feature.PARALLEL, C.Feature.RANDOM_ACCESS});
    }

    @Override
    public int size() throws UnsupportedOperationException {
        return this.data_.length;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) > -1;
    }

    @Override
    public Object[] toArray() {
        T[] da = this.data_;
        int sz = da.length;
        Object[] ret = new Object[sz];
        System.arraycopy(da, 0, ret, 0, sz);
        return ret;
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        int sza = a.length;
        T[] da = this.data_;
        int sz = da.length;
        if (sza < sz) {
            return Arrays.copyOf(da, sz, a.getClass());
        }
        System.arraycopy(da, 0, a, 0, sz);
        if (sza > sz) {
            a[sz] = null;
        }
        return a;
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T get(int index) {
        return this.data_[index];
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        T[] da = this.data_;
        int sz = da.length;
        if (o == null) {
            for (int i = 0; i < sz; ++i) {
                if (da[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < sz; ++i) {
                if (!o.equals(da[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        T[] da = this.data_;
        int sz = da.length;
        if (o == null) {
            for (int i = sz - 1; i >= 0; --i) {
                if (da[i] != null) continue;
                return i;
            }
        } else {
            for (int i = sz - 1; i >= 0; --i) {
                if (!o.equals(da[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr();
    }

    @Override
    public ListIterator<T> listIterator() {
        return new LstItr();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new LstItr(index);
    }

    @Override
    public <R> C.List<R> map(Lang.Function<? super T, ? extends R> mapper) {
        if (this.isLazy()) {
            return MappedList.of(this, mapper);
        }
        int sz = this.size();
        ListBuilder lb = new ListBuilder(sz);
        this.forEach((Lang.Visitor)$.visitor($.f1(mapper).andThen(C.F.addTo(lb))));
        return lb.toList();
    }

    @Override
    public <R> C.List<R> flatMap(Lang.Function<? super T, ? extends Iterable<? extends R>> mapper) {
        int sz = this.size();
        ListBuilder lb = new ListBuilder(sz * 3);
        this.forEach((Lang.Visitor)$.visitor($.f1(mapper).andThen(C.F.addAllTo(lb))));
        return lb.toList();
    }

    @Override
    public C.Sequence<T> append(Iterable<? extends T> iterable) {
        return super.append(iterable);
    }

    private C.List<T> unLazyAppend(Collection<? extends T> collection) {
        int szB = collection.size();
        if (szB == 0) {
            return this;
        }
        int szA = this.size();
        T[] dataA = this.data_;
        Object[] dataB = collection.toArray();
        T[] data = $.newArray(dataA, szA + szB);
        System.arraycopy(dataA, 0, data, 0, szA);
        System.arraycopy(dataB, 0, data, szA, szB);
        return ImmutableList.of(data);
    }

    @Override
    public C.List<T> append(Collection<? extends T> collection) {
        if (collection instanceof C.List) {
            return this.appendList((C.List)collection);
        }
        return this.unLazyAppend(collection);
    }

    @Override
    public C.ReversibleSequence<T> append(C.ReversibleSequence<T> seq) {
        if (seq instanceof C.List) {
            return this.appendList((C.List)seq);
        }
        return super.appendReversibleSeq(seq);
    }

    @Override
    public C.Sequence<T> append(C.Sequence<? extends T> seq) {
        if (seq instanceof C.List) {
            return this.appendList((C.List)seq);
        }
        if (this.isLazy()) {
            return CompositeSeq.of(this, seq);
        }
        ListBuilder lb = new ListBuilder(this.size() * 2);
        lb.append(this).append(seq);
        return lb.toList();
    }

    @Override
    public C.Sequence<T> append(Iterator<? extends T> iterator) {
        if (this.isLazy()) {
            return CompositeSeq.of(this, C.seq(iterator));
        }
        ListBuilder lb = new ListBuilder(this.size() * 2);
        lb.append(this).append(iterator);
        return lb.toList();
    }

    @Override
    public C.Sequence<T> append(Enumeration<? extends T> enumeration) {
        if (this.isLazy()) {
            return CompositeSeq.of(this, C.seq(enumeration));
        }
        ListBuilder lb = new ListBuilder(this.size() * 2);
        lb.append(this).append(enumeration);
        return lb.toList();
    }

    @Override
    protected C.List<T> appendList(C.List<T> l) {
        if (this.isLazy()) {
            return CompositeList.of(this, l);
        }
        if (l instanceof ImmutableList) {
            return this.appendImmutableList((ImmutableList)l);
        }
        return this.unLazyAppend(l);
    }

    @Override
    public C.List<T> append(C.List<T> l) {
        return this.appendList(l);
    }

    private C.List<T> appendImmutableList(ImmutableList<T> l) {
        int szA = this.size();
        int szB = l.size();
        T[] dataA = this.data_;
        T[] data = $.newArray(dataA, szA + szB);
        System.arraycopy(dataA, 0, data, 0, szA);
        System.arraycopy(l.data_, 0, data, szA, szB);
        return ImmutableList.of(data);
    }

    @Override
    public C.List<T> append(ImmutableList<T> l) {
        return this.appendImmutableList(l);
    }

    private C.List<T> unLazyPrepend(Collection<? extends T> collection) {
        int szB = collection.size();
        if (szB == 0) {
            return this;
        }
        int szA = this.size();
        T[] dataA = this.data_;
        Object[] dataB = collection.toArray();
        T[] data = $.newArray(dataA, szA + szB);
        System.arraycopy(dataB, 0, data, 0, szB);
        System.arraycopy(dataA, 0, data, szB, szA);
        return ImmutableList.of(data);
    }

    @Override
    public C.List<T> prepend(Collection<? extends T> collection) {
        if (collection instanceof C.List) {
            return this.prependList((C.List)collection);
        }
        return this.unLazyPrepend(collection);
    }

    @Override
    public C.ReversibleSequence<T> prepend(C.ReversibleSequence<T> seq) {
        return super.prependReversibleSeq(seq);
    }

    @Override
    public C.Sequence<T> prepend(C.Sequence<? extends T> seq) {
        if (seq instanceof C.List) {
            return this.prependList((C.List)seq);
        }
        if (this.isLazy()) {
            return CompositeSeq.of(seq, this);
        }
        ListBuilder<? extends T> lb = new ListBuilder<T>(this.size() * 2);
        lb.append(seq).append(this);
        return lb.toList();
    }

    @Override
    public C.List<T> prepend(C.List<T> l) {
        if (this.isLazy()) {
            return CompositeList.of(l, this);
        }
        if (l instanceof ImmutableList) {
            return this.prependList((ImmutableList)l);
        }
        return this.unLazyPrepend(l);
    }

    @Override
    public C.List<T> prepend(ImmutableList<T> l) {
        if (this.isLazy()) {
            return CompositeList.of(l, this);
        }
        int szA = this.size();
        int szB = l.size();
        T[] myData = this.data_;
        T[] data = $.newArray(myData, szA + szB);
        System.arraycopy(l.data_, 0, data, 0, szB);
        System.arraycopy(myData, 0, data, szB, szA);
        return ImmutableList.of(data);
    }

    @Override
    public Iterator<T> reverseIterator() {
        return new ReverseItr();
    }

    @Override
    public Lang.Option<T> findLast(Lang.Function<? super T, Boolean> predicate) {
        T[] ta = this.data_;
        for (int i = ta.length - 1; i >= 0; --i) {
            T t = ta[i];
            if (!predicate.apply(t).booleanValue()) continue;
            return $.some(t);
        }
        return $.none();
    }

    @Override
    public C.List<T> takeWhile(Lang.Function<? super T, Boolean> predicate) {
        int sz = this.size();
        ListBuilder<T> lb = new ListBuilder<T>(sz);
        for (T t : this) {
            if (!predicate.apply(t).booleanValue()) break;
            lb.add(t);
        }
        return lb.toList();
    }

    @Override
    public C.List<T> without(Collection<? super T> col) {
        int sz = this.size();
        T[] data = this.data_;
        ListBuilder<T> lb = new ListBuilder<T>(sz);
        for (int i = 0; i < sz; ++i) {
            T t = data[i];
            if (col.contains(t)) continue;
            lb.add(t);
        }
        return lb.toList();
    }

    @Override
    public C.List<T> without(T element) {
        int sz = this.size();
        T[] data = this.data_;
        ListBuilder<T> lb = new ListBuilder<T>(sz);
        for (int i = 0; i < sz; ++i) {
            T t = data[i];
            if (!$.ne(t, element)) continue;
            lb.add(t);
        }
        return lb.toList();
    }

    @Override
    public C.List<T> without(T element, T ... elements) {
        int len = elements.length;
        if (len == 0) {
            return this.without(element);
        }
        int sz = this.size();
        T[] data = this.data_;
        ListBuilder<T> lb = new ListBuilder<T>(sz);
        T t0 = elements[0];
        boolean c = false;
        if (len < 8 && t0 instanceof Comparable) {
            Arrays.sort(elements);
            c = true;
        }
        if (c) {
            for (int i = 0; i < sz; ++i) {
                int id;
                T t = data[i];
                if ($.eq(t, element) || (id = Arrays.binarySearch(elements, t)) > -1) continue;
                lb.add(t);
            }
        } else {
            for (int i = 0; i < sz; ++i) {
                T t = data[i];
                if ($.eq(t, element)) continue;
                boolean found = false;
                for (int j = 0; j < len; ++j) {
                    if (!$.eq(elements[j], t)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                lb.add(t);
            }
        }
        return lb.toList();
    }

    @Override
    public C.List<T> reverse() {
        if (this.isLazy()) {
            return ReverseList.wrap(this);
        }
        T[] data = Algorithms.ARRAY_REVERSE.apply(this.data_, 0, this.data_.length);
        return ImmutableList.of(data);
    }

    @Override
    public C.List<T> prepend(T t) {
        int sz = this.size();
        T[] myData = this.data_;
        T[] data = $.newArray(myData, sz + 1);
        data[0] = t;
        System.arraycopy(myData, 0, data, 1, sz);
        return ImmutableList.of(data);
    }

    @Override
    public C.List<T> append(T t) {
        int sz = this.size();
        T[] myData = this.data_;
        T[] data = $.newArray(myData, sz + 1);
        data[sz] = t;
        System.arraycopy(myData, 0, data, 0, sz);
        return ImmutableList.of(data);
    }

    @Override
    public C.List<T> insert(int index, T t) throws IndexOutOfBoundsException {
        T[] myData = this.data_;
        int sz = this.data_.length;
        if (sz < Math.abs(index)) {
            throw new IndexOutOfBoundsException();
        }
        if (index < 0) {
            index = sz + index;
        }
        T[] data = $.newArray(myData, sz + 1);
        System.arraycopy(myData, 0, data, 0, index);
        data[index] = t;
        System.arraycopy(myData, index, data, index + 1, sz - index);
        return ImmutableList.of(data);
    }

    @Override
    public C.List<T> insert(int index, T ... ta) throws IndexOutOfBoundsException {
        if (ta.length == 0) {
            return this;
        }
        T[] myData = this.data_;
        int sz = this.data_.length;
        if (sz < Math.abs(index)) {
            throw new IndexOutOfBoundsException();
        }
        if (index < 0) {
            index = sz + index;
        }
        int delta = ta.length;
        T[] data = $.newArray(myData, sz + delta);
        if (index > 0) {
            System.arraycopy(myData, 0, data, 0, index);
        }
        System.arraycopy(ta, 0, data, index, delta);
        if (index < sz) {
            System.arraycopy(myData, index, data, index + delta, sz - index);
        }
        return ImmutableList.of(data);
    }

    @Override
    public C.List<T> insert(int index, List<T> subList) throws IndexOutOfBoundsException {
        if (subList.isEmpty()) {
            return this;
        }
        T[] myData = this.data_;
        int sz = this.data_.length;
        if (sz < Math.abs(index)) {
            throw new IndexOutOfBoundsException();
        }
        if (index < 0) {
            index = sz + index;
        }
        int delta = subList.size();
        T[] data = $.newArray(myData, sz + delta);
        if (index > 0) {
            System.arraycopy(myData, 0, data, 0, index);
        }
        for (int i = 0; i < delta; ++i) {
            data[index + i] = subList.get(i);
        }
        if (index < sz) {
            System.arraycopy(myData, index, data, index + delta, sz - index);
        }
        return ImmutableList.of(data);
    }

    @Override
    public C.List.Cursor<T> locateLast(Lang.Function<T, Boolean> predicate) {
        int sz = this.size();
        T[] data = this.data_;
        for (int i = sz - 1; i >= 0; --i) {
            T t = data[i];
            if (!predicate.apply(t).booleanValue()) continue;
            return new Csr(i);
        }
        return new Csr(-1);
    }

    @Override
    public C.List.Cursor<T> locate(Lang.Function<T, Boolean> predicate) {
        return this.locateFirst(predicate);
    }

    @Override
    public C.List.Cursor<T> locateFirst(Lang.Function<T, Boolean> predicate) {
        int sz = this.size();
        T[] data = this.data_;
        for (int i = 0; i < sz; ++i) {
            T t = data[i];
            if (!predicate.apply(t).booleanValue()) continue;
            return new Csr(i);
        }
        return new Csr(sz);
    }

    @Override
    public C.List<T> filter(Lang.Function<? super T, Boolean> predicate) {
        int sz = this.size();
        if (0 == sz) {
            return Nil.list();
        }
        T[] data = $.newArray(this.data_);
        int cursor = 0;
        for (int i = 0; i < sz; ++i) {
            T t = this.data_[i];
            if (!predicate.apply(t).booleanValue()) continue;
            data[cursor++] = t;
        }
        if (0 == cursor) {
            return Nil.list();
        }
        data = Arrays.copyOf(data, cursor);
        return ImmutableList.of(data);
    }

    @Override
    public C.List<T> dropWhile(Lang.Function<? super T, Boolean> predicate) {
        int sz = this.size();
        Lang.Predicate<? super T> f2 = Lang.F.negate(predicate);
        C.List.Cursor<T> cursor = this.locateFirst(f2);
        if (!cursor.isDefined()) {
            return Nil.list();
        }
        int id = cursor.index();
        return this.subList(id, this.size());
    }

    @Override
    public C.List<T> drop(int n) throws IndexOutOfBoundsException {
        int size = this.size();
        if (n < 0) {
            if ((n = -n) >= size) {
                return C.list();
            }
            return this.take(size - n);
        }
        if (0 == n) {
            return this;
        }
        if (n >= size) {
            return Nil.list();
        }
        return this.subList(n, this.size());
    }

    @Override
    public C.List<T> tail(int n) {
        if (n < 0) {
            return this.head(-n);
        }
        int sz = this.size();
        if (n >= sz) {
            return this;
        }
        return this.subList(sz - n, sz);
    }

    @Override
    public C.List<T> tail() {
        int sz = this.size();
        if (sz == 0) {
            throw new UnsupportedOperationException();
        }
        return this.subList(1, sz);
    }

    @Override
    public C.List<T> take(int n) {
        if (n < 0) {
            return this.tail(-n);
        }
        int sz = this.size();
        if (n >= sz) {
            return this;
        }
        return this.subList(0, n);
    }

    @Override
    protected void forEachLeft(Lang.Visitor<? super T> visitor) throws Lang.Break {
        int sz = this.size();
        T[] data = this.data_;
        for (int i = 0; i < sz; ++i) {
            T t = data[i];
            try {
                visitor.apply((Object)t);
                continue;
            }
            catch (NotAppliedException notAppliedException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void forEachRight(Lang.Visitor<? super T> visitor) throws Lang.Break {
        int sz = this.size();
        T[] data = this.data_;
        for (int i = sz - 1; i >= 0; --i) {
            T t = data[i];
            try {
                visitor.apply((Object)t);
                continue;
            }
            catch (NotAppliedException notAppliedException) {
                // empty catch block
            }
        }
    }

    @Override
    public Lang.Option<T> findOne(Lang.Function<? super T, Boolean> predicate) {
        int sz = this.size();
        T[] data = this.data_;
        for (int i = 0; i < sz; ++i) {
            T t = data[i];
            if (!predicate.apply(t).booleanValue()) continue;
            return $.some(t);
        }
        return $.none();
    }

    @Override
    public T head() throws NoSuchElementException {
        return this.data_[0];
    }

    @Override
    public T last() throws NoSuchElementException {
        return this.data_[this.size() - 1];
    }

    @Override
    public <R> R reduce(R identity, Lang.Func2<R, T, R> accumulator) {
        return this.reduceLeft(identity, accumulator);
    }

    @Override
    public <R> R reduceLeft(R identity, Lang.Func2<R, T, R> accumulator) {
        int sz = this.size();
        R ret = identity;
        T[] data = this.data_;
        for (int i = 0; i < sz; ++i) {
            ret = accumulator.apply(ret, data[i]);
        }
        return ret;
    }

    @Override
    public <R> R reduceRight(R identity, Lang.Func2<R, T, R> accumulator) {
        int sz = this.size();
        R ret = identity;
        T[] data = this.data_;
        for (int i = sz - 1; i >= 0; --i) {
            ret = accumulator.apply(ret, data[i]);
        }
        return ret;
    }

    @Override
    public Lang.Option<T> reduce(Lang.Func2<T, T, T> accumulator) {
        return this.reduceLeft(accumulator);
    }

    @Override
    public Lang.Option<T> reduceLeft(Lang.Func2<T, T, T> accumulator) {
        int sz = this.size();
        T[] data = this.data_;
        T ret = data[0];
        for (int i = 1; i < sz; ++i) {
            ret = accumulator.apply(ret, data[i]);
        }
        return $.some(ret);
    }

    @Override
    public Lang.Option<T> reduceRight(Lang.Func2<T, T, T> accumulator) {
        int sz = this.size();
        T[] data = this.data_;
        T ret = data[sz - 1];
        for (int i = sz - 2; i >= 0; --i) {
            ret = accumulator.apply(ret, data[i]);
        }
        return $.some(ret);
    }

    @Override
    int modCount() {
        return 0;
    }

    @Override
    void removeRange2(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    static <T> C.List<T> of(T[] data) {
        E.NPE(data);
        int len = data.length;
        if (len == 0) {
            return Nil.list();
        }
        if (len == 1) {
            return $.val(data[0]);
        }
        return new ImmutableList<T>(data);
    }

    static <T> C.List<T> copyOf(T[] data) {
        int sz = data.length;
        if (sz == 0) {
            return Nil.list();
        }
        T[] a = Arrays.copyOf(data, sz);
        return new ImmutableList<T>(a);
    }

    private class Csr
    implements C.List.Cursor<T> {
        private int id_;

        Csr() {
            this(-1);
        }

        Csr(int index) {
            if (index < -1) {
                index = -1;
            } else if (index > ImmutableList.this.size()) {
                index = ImmutableList.this.size();
            }
            this.id_ = index;
        }

        @Override
        public boolean isDefined() {
            int id = this.id_;
            return id > -1 && id < ImmutableList.this.size();
        }

        @Override
        public int index() {
            return this.id_;
        }

        @Override
        public T get() throws NoSuchElementException {
            if (!this.isDefined()) {
                throw new NoSuchElementException();
            }
            return ImmutableList.this.data_[this.id_];
        }

        @Override
        public boolean hasNext() {
            return this.id_ < ImmutableList.this.size() - 1;
        }

        @Override
        public boolean hasPrevious() {
            return this.id_ > 0;
        }

        @Override
        public C.List.Cursor<T> parkLeft() {
            this.id_ = -1;
            return this;
        }

        @Override
        public C.List.Cursor<T> parkRight() {
            this.id_ = ImmutableList.this.size();
            return this;
        }

        @Override
        public C.List.Cursor<T> forward() {
            if (this.id_ >= ImmutableList.this.size()) {
                this.id_ = ImmutableList.this.size();
                throw new UnsupportedOperationException();
            }
            ++this.id_;
            return this;
        }

        @Override
        public C.List.Cursor<T> backward() throws UnsupportedOperationException {
            if (this.id_ <= -1) {
                this.id_ = -1;
                throw new UnsupportedOperationException();
            }
            --this.id_;
            return this;
        }

        @Override
        public C.List.Cursor<T> set(T t) throws IndexOutOfBoundsException, NullPointerException {
            throw new UnsupportedOperationException();
        }

        @Override
        public C.List.Cursor<T> drop() throws NoSuchElementException {
            throw new UnsupportedOperationException();
        }

        @Override
        public C.List.Cursor<T> prepend(T t) throws IndexOutOfBoundsException {
            throw new UnsupportedOperationException();
        }

        @Override
        public C.List.Cursor<T> append(T t) {
            throw new UnsupportedOperationException();
        }
    }

    private class ReverseItr
    implements Iterator<T> {
        private LstItr itr;

        ReverseItr() {
            this.itr = new LstItr(ImmutableList.this.size());
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasPrevious();
        }

        @Override
        public T next() {
            return this.itr.previous();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class LstItr
    extends Itr
    implements ListIterator<T> {
        LstItr() {
            this(0);
        }

        LstItr(int index) {
            if (index < 0 || index > ImmutableList.this.data_.length) {
                throw new IndexOutOfBoundsException();
            }
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public T previous() {
            if (this.cursor < 0) {
                throw new NoSuchElementException();
            }
            --this.cursor;
            return ImmutableList.this.data_[this.cursor];
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(T t) {
            throw new UnsupportedOperationException();
        }
    }

    private class Itr
    implements Iterator<T> {
        protected int cursor = 0;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ImmutableList.this.data_.length;
        }

        @Override
        public T next() {
            Object[] da = ImmutableList.this.data_;
            if (this.cursor >= da.length) {
                throw new NoSuchElementException();
            }
            int i = this.cursor++;
            return da[i];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

