/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.DelegatingIterator;
import org.osgl.util.E;
import org.osgl.util.EnumerationIterator;
import org.osgl.util.Iterators;
import org.osgl.util.N;
import org.osgl.util.Nil;
import org.osgl.util.SequenceBase;

class IteratorSeq<T>
extends SequenceBase<T> {
    private final Iterator<? extends T> itr_;

    IteratorSeq(Iterator<? extends T> itr) {
        E.NPE(itr);
        this.itr_ = itr;
    }

    @Override
    protected EnumSet<C.Feature> initFeatures() {
        return EnumSet.of(C.Feature.READONLY);
    }

    @Override
    public Iterator<T> iterator() {
        return new DelegatingIterator<T>(this.itr_, true);
    }

    @Override
    public C.Sequence<T> head(int n) {
        if (n < 0) {
            throw new UnsupportedOperationException();
        }
        if (n == 0) {
            return Nil.seq();
        }
        return IteratorSeq.of(Iterators.filterIndex(this.itr_, N.F.lt(n)));
    }

    @Override
    public C.Sequence<T> tail() throws UnsupportedOperationException {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        return IteratorSeq.of(Iterators.filterIndex(this.itr_, N.F.gt(0)));
    }

    @Override
    public C.Sequence<T> takeWhile(Lang.Function<? super T, Boolean> predicate) {
        return IteratorSeq.of(Iterators.filterWhile(this.itr_, predicate));
    }

    @Override
    public C.Sequence<T> drop(int n) {
        return IteratorSeq.of(Iterators.filterIndex(this.itr_, N.F.gte(n)));
    }

    @Override
    public C.Sequence<T> dropWhile(Lang.Function<? super T, Boolean> predicate) {
        return IteratorSeq.of(Iterators.filterUntil(this.itr_, Lang.F.negate(predicate)));
    }

    @Override
    public C.Sequence<T> append(C.Sequence<? extends T> seq) {
        return IteratorSeq.of(Iterators.composite(this.itr_, seq.iterator()));
    }

    @Override
    public C.Sequence<T> append(Iterator<? extends T> iterator) {
        return IteratorSeq.of(Iterators.composite(this.itr_, iterator));
    }

    @Override
    public C.Sequence<T> append(Enumeration<? extends T> enumeration) {
        return IteratorSeq.of(Iterators.composite(this.itr_, new EnumerationIterator<T>(enumeration)));
    }

    @Override
    public C.Sequence<T> append(T t) {
        return IteratorSeq.of(Iterators.composite(this.itr_, Iterators.of(t)));
    }

    @Override
    public C.Sequence<T> prepend(C.Sequence<? extends T> seq) {
        return IteratorSeq.of(Iterators.composite(seq.iterator(), this.itr_));
    }

    @Override
    public C.Sequence<T> prepend(T t) {
        return IteratorSeq.of(Iterators.composite(Iterators.of(t), this.itr_));
    }

    @Override
    public C.Sequence<T> filter(Lang.Function<? super T, Boolean> predicate) {
        return IteratorSeq.of(Iterators.filter(this.itr_, predicate));
    }

    @Override
    public int size() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R> C.Sequence<R> map(Lang.Function<? super T, ? extends R> mapper) {
        return new IteratorSeq<R>(Iterators.map(this.itr_, mapper));
    }

    @Override
    public <R> C.Sequence<R> flatMap(Lang.Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return new IteratorSeq(Iterators.flatMap(this.itr_, mapper));
    }

    static <T> IteratorSeq<T> of(Iterator<? extends T> itr) {
        return new IteratorSeq<T>(itr);
    }
}

