/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.Iterator;
import org.osgl.Lang;
import org.osgl.util.CompositeIterator;
import org.osgl.util.FilteredIterator;
import org.osgl.util.FlatMappedIterator;
import org.osgl.util.IndexFilteredIterator;
import org.osgl.util.MappedIterator;
import org.osgl.util.SingletonIterator;

public enum Iterators {


    public static <T> Iterator<T> filterIndex(Iterator<? extends T> itr, Lang.Function<Integer, Boolean> predicate) {
        return new IndexFilteredIterator<T>(itr, predicate);
    }

    public static <T> Iterator<T> filter(Iterator<? extends T> itr, Lang.Function<? super T, Boolean> predicate) {
        return new FilteredIterator<T>(itr, predicate);
    }

    public static <T> Iterator<T> filterWhile(Iterator<? extends T> itr, Lang.Function<? super T, Boolean> predicate) {
        return new FilteredIterator<T>(itr, predicate, FilteredIterator.Type.WHILE);
    }

    public static <T> Iterator<T> filterUntil(Iterator<? extends T> itr, Lang.Function<? super T, Boolean> predicate) {
        return new FilteredIterator<T>(itr, predicate, FilteredIterator.Type.UNTIL);
    }

    public static <T> Iterator<T> composite(Iterator<? extends T> i1, Iterator<? extends T> i2) {
        return new CompositeIterator<T>(i1, i2);
    }

    public static <T> Iterator<T> of(T t) {
        return new SingletonIterator<T>(t);
    }

    public static <T, R> Iterator<R> map(Iterator<? extends T> itr, Lang.Function<? super T, ? extends R> mapper) {
        return new MappedIterator<T, R>(itr, mapper);
    }

    public static <T, R> Iterator<R> flatMap(Iterator<? extends T> itr, Lang.Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return new FlatMappedIterator(itr, mapper);
    }
}

