/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.RandomAccess;
import org.osgl.$;
import org.osgl.util.C;
import org.osgl.util.ImmutableList;
import org.osgl.util.ImmutableSet;
import org.osgl.util.Nil;

public class ListBuilder<T>
extends AbstractList<T>
implements RandomAccess,
Serializable {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    Object[] buf;
    int size;

    ListBuilder() {
        this(10);
    }

    private ListBuilder(Collection<? extends T> collection) {
        int len = collection.size();
        if (len == 0) {
            this.buf = new Object[10];
        } else {
            Object[] a0 = collection.toArray();
            this.buf = new Object[len];
            System.arraycopy(a0, 0, this.buf, 0, len);
            this.size = len;
        }
    }

    public ListBuilder(int initialCapacity) {
        if (initialCapacity < 0 || initialCapacity > 0x7FFFFFF7) {
            throw new IllegalArgumentException();
        }
        this.buf = new Object[initialCapacity];
    }

    protected void checkState() {
        if (null == this.buf) {
            throw new IllegalStateException("ListBuilder is consumed");
        }
    }

    protected void trimToSize() {
        ++this.modCount;
        int oldCapacity = this.buf.length;
        if (this.size < oldCapacity) {
            this.buf = Arrays.copyOf(this.buf, this.size);
        }
    }

    private void ensureCapacity(int capacity) {
        if (capacity > 0x7FFFFFF7) {
            throw new OutOfMemoryError();
        }
        int oldCapacity = this.buf.length;
        if (capacity > oldCapacity) {
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity < capacity) {
                newCapacity = capacity;
            }
            this.buf = Arrays.copyOf(this.buf, newCapacity);
        }
    }

    @Override
    public int size() {
        this.checkState();
        return this.size;
    }

    @Override
    public T get(int index) {
        this.checkState();
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return (T)this.buf[index];
    }

    @Override
    public boolean add(T t) {
        this.checkState();
        int sz = this.size++;
        this.ensureCapacity(sz + 1);
        this.buf[sz] = t;
        return true;
    }

    @Override
    public void add(int index, T element) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.checkState();
        int sz = this.size++;
        this.ensureCapacity(sz + 1);
        if (index == sz) {
            this.buf[sz] = element;
        } else {
            System.arraycopy(this.buf, index, this.buf, index + 1, sz - index);
            this.buf[index] = element;
        }
    }

    @Override
    public Object[] toArray() {
        this.checkState();
        return Arrays.copyOf(this.buf, this.size);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.checkState();
        int sz = this.size;
        int len = a.length;
        if (len < sz) {
            return Arrays.copyOf(this.buf, sz, a.getClass());
        }
        System.arraycopy(this.buf, 0, a, 0, sz);
        if (len > sz) {
            a[sz] = null;
        }
        return a;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.checkState();
        int cSz = c.size();
        int oldSz = this.size;
        if (cSz < 1) {
            return false;
        }
        this.size += cSz;
        this.ensureCapacity(this.size);
        Object[] newData = c.toArray();
        System.arraycopy(newData, 0, this.buf, oldSz, cSz);
        return true;
    }

    @Override
    public boolean addAll(ListBuilder<? extends T> c) {
        return this.addAll(this.size, c);
    }

    @Override
    public boolean addAll(int index, ListBuilder<? extends T> c) {
        this.checkState();
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (null == c.buf) {
            return false;
        }
        int cSz = c.size();
        int oldSz = this.size;
        if (cSz == 0) {
            return false;
        }
        this.size += cSz;
        this.ensureCapacity(this.size);
        Object[] data = this.buf;
        if (index < oldSz) {
            System.arraycopy(data, index, data, index + cSz, oldSz - index);
        }
        ListBuilder<T> that = c;
        Object[] newData = that.buf;
        System.arraycopy(newData, 0, data, index, cSz);
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.checkState();
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        int cSz = c.size();
        int oldSz = this.size;
        if (cSz == 0) {
            return false;
        }
        this.size += cSz;
        this.ensureCapacity(this.size);
        Object[] data = this.buf;
        if (index < oldSz) {
            System.arraycopy(data, index, data, index + cSz, oldSz - index);
        }
        Object[] newData = c.toArray();
        System.arraycopy(newData, 0, data, index, cSz);
        return true;
    }

    @Override
    public void clear() {
        this.buf = new Object[10];
        this.size = 0;
    }

    public ListBuilder<T> append(T t) {
        this.add(t);
        return this;
    }

    public ListBuilder<T> append(Object[] ta) {
        this.checkState();
        int len = ta.length;
        int oldSz = this.size;
        this.size += len;
        this.ensureCapacity(this.size);
        Object[] data = this.buf;
        System.arraycopy(ta, 0, data, oldSz, len);
        return this;
    }

    public ListBuilder<T> append(Object[] ta1, Object[] ta2) {
        this.checkState();
        int l1 = ta1.length;
        int l2 = ta2.length;
        int oldSz = this.size;
        this.size += l1 + l2;
        this.ensureCapacity(this.size);
        Object[] data = this.buf;
        System.arraycopy(ta1, 0, data, oldSz, l1);
        System.arraycopy(ta2, 0, data, oldSz + l1, l2);
        return this;
    }

    public ListBuilder<T> append(Object[] ta1, Object[] ta2, Object[] ... taa) {
        this.checkState();
        int l1 = ta1.length;
        int l2 = ta2.length;
        int oldSz = this.size;
        int len = l1 + l2;
        for (Object[] ta : taa) {
            len += ta.length;
        }
        this.size += len;
        this.ensureCapacity(this.size);
        Object[] data = this.buf;
        System.arraycopy(ta1, 0, data, oldSz, l1);
        System.arraycopy(ta2, 0, data, oldSz += l1, l2);
        oldSz += l2;
        for (Object[] ta : taa) {
            int l = ta.length;
            System.arraycopy(ta, 0, data, oldSz, l);
            oldSz += l;
        }
        return this;
    }

    public ListBuilder<T> append(T t1, T t2) {
        this.checkState();
        this.size += 2;
        int sz = this.size;
        this.ensureCapacity(sz);
        Object[] data = this.buf;
        data[sz - 1] = t2;
        data[sz - 2] = t1;
        return this;
    }

    public ListBuilder<T> append(T t1, T t2, T t3) {
        this.checkState();
        this.size += 3;
        int sz = this.size;
        this.ensureCapacity(sz);
        Object[] data = this.buf;
        data[sz - 1] = t3;
        data[sz - 2] = t2;
        data[sz - 3] = t1;
        return this;
    }

    public ListBuilder<T> append(T t1, T t2, T t3, T t4) {
        this.checkState();
        this.size += 4;
        int sz = this.size;
        this.ensureCapacity(sz);
        Object[] data = this.buf;
        data[sz - 1] = t4;
        data[sz - 2] = t3;
        data[sz - 3] = t2;
        data[sz - 4] = t1;
        return this;
    }

    public ListBuilder<T> append(T t1, T t2, T t3, T t4, T t5) {
        this.checkState();
        this.size += 5;
        int sz = this.size;
        this.ensureCapacity(sz);
        Object[] data = this.buf;
        data[sz - 1] = t5;
        data[sz - 2] = t4;
        data[sz - 3] = t3;
        data[sz - 4] = t2;
        data[sz - 5] = t1;
        return this;
    }

    public ListBuilder<T> append(T t1, T t2, T t3, T t4, T t5, T ... ta) {
        this.checkState();
        int len = ta.length;
        int oldSz = this.size;
        this.size += len + 5;
        this.ensureCapacity(this.size);
        Object[] data = this.buf;
        System.arraycopy(ta, 0, data, oldSz + 5, len);
        data[oldSz + 4] = t5;
        data[oldSz + 3] = t4;
        data[oldSz + 2] = t3;
        data[oldSz + 1] = t2;
        data[oldSz] = t1;
        return this;
    }

    public ListBuilder<T> append(Collection<? extends T> col) {
        this.addAll(col);
        return this;
    }

    public ListBuilder<T> append(Collection<? extends T> c1, Collection<? extends T> c2) {
        this.checkState();
        int l1 = c1.size();
        int l2 = c2.size();
        int oldSz = this.size;
        this.size += l1 + l2;
        int sz = this.size;
        this.ensureCapacity(sz);
        Object[] data = this.buf;
        Object[] newData = c1.toArray();
        System.arraycopy(newData, 0, data, oldSz, l1);
        newData = c2.toArray();
        System.arraycopy(newData, 0, data, oldSz += l1, l2);
        return this;
    }

    public ListBuilder<T> append(Collection<? extends T> c1, Collection<? extends T> c2, Collection<? extends T> ... ca) {
        this.checkState();
        int l1 = c1.size();
        int l2 = c2.size();
        int oldSz = this.size;
        int len = l1 + l2;
        for (Collection<T> collection : ca) {
            len += collection.size();
        }
        this.size += len;
        int sz = this.size;
        this.ensureCapacity(sz);
        Object[] data = this.buf;
        Object[] newData = c1.toArray();
        System.arraycopy(newData, 0, data, oldSz, l1);
        newData = c2.toArray();
        System.arraycopy(newData, 0, data, oldSz += l1, l2);
        oldSz += l2;
        for (Collection<T> collection : ca) {
            newData = collection.toArray();
            int l = newData.length;
            System.arraycopy(newData, 0, data, oldSz, l);
            oldSz += l;
        }
        return this;
    }

    public ListBuilder<T> append(Iterable<? extends T> iterable) {
        this.checkState();
        if (iterable instanceof Collection) {
            this.append((Collection)iterable);
        }
        Iterator<T> e = iterable.iterator();
        while (e.hasNext()) {
            this.append(e.next());
        }
        return this;
    }

    public ListBuilder<T> append(Iterator<? extends T> iterator) {
        this.checkState();
        while (iterator.hasNext()) {
            this.append(iterator.next());
        }
        return this;
    }

    public ListBuilder<T> append(Enumeration<? extends T> enumeration) {
        this.checkState();
        while (enumeration.hasMoreElements()) {
            this.append(enumeration.nextElement());
        }
        return this;
    }

    public C.List<T> toList() {
        this.checkState();
        this.trimToSize();
        Object[] data = this.buf;
        this.buf = null;
        return ImmutableList.of(data);
    }

    public C.Set<T> toSet() {
        this.checkState();
        this.trimToSize();
        Object[] data = this.buf;
        this.buf = null;
        return ImmutableSet.of(data);
    }

    public static <T> C.List<T> toList(Iterable<? extends T> iterable) {
        if (iterable instanceof Collection) {
            return ListBuilder.toList((Collection)iterable);
        }
        ListBuilder<T> lb = new ListBuilder<T>(10);
        for (T t : iterable) {
            lb.add(t);
        }
        return lb.toList();
    }

    public static <T> C.List<T> toList(Iterator<? extends T> iterator) {
        ListBuilder<? extends T> lb = new ListBuilder<T>(10);
        lb.append(iterator);
        return lb.toList();
    }

    public static <T> C.List<T> toList(Enumeration<? extends T> enumeration) {
        ListBuilder<? extends T> lb = new ListBuilder<T>(10);
        lb.append(enumeration);
        return lb.toList();
    }

    public static <T> C.List<T> toList(Collection<? extends T> col) {
        C.List list;
        if (col.size() == 0) {
            return Nil.list();
        }
        if (col instanceof C.List && (list = (C.List)$.cast(col)).is(C.Feature.IMMUTABLE)) {
            return list;
        }
        return new ListBuilder<T>(col).toList();
    }

    public static <T> ListBuilder<T> create() {
        return new ListBuilder<T>();
    }

    public static <T> ListBuilder<T> create(int initialCapacity) {
        return new ListBuilder<T>(initialCapacity);
    }
}

