/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.EnumSet;
import java.util.ListIterator;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.MappedListIterator;
import org.osgl.util.ReadOnlyListBase;

class MappedList<T, R>
extends ReadOnlyListBase<R>
implements C.List<R> {
    private final C.List<? extends T> l_;
    private final Lang.Function<? super T, ? extends R> m_;

    MappedList(C.List<? extends T> list, Lang.Function<? super T, ? extends R> mapper) {
        E.NPE(list, mapper);
        this.l_ = list;
        this.m_ = mapper;
    }

    @Override
    protected EnumSet<C.Feature> internalInitFeatures() {
        return this.l_.features();
    }

    @Override
    public ListIterator<R> listIterator(int index) {
        return new MappedListIterator<T, R>(this.l_.listIterator(index), this.m_);
    }

    @Override
    public int size() {
        return this.l_.size();
    }

    @Override
    public R get(int index) {
        Object t = this.l_.get(index);
        return this.m_.apply(t);
    }

    public static <T, R> MappedList<T, R> of(C.List<? extends T> data, Lang.Function<? super T, ? extends R> mapper) {
        return new MappedList<T, R>(data, mapper);
    }
}

