/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

public enum OS {
    WINDOWS,
    MAC_OS_X,
    LINUX,
    OS2,
    HP_UX,
    AIX,
    IRIX,
    SOLARIS,
    SUN_OS,
    MPE_IX,
    OS_390,
    FREEBSD,
    DIGITAL_UNIX,
    OSF1,
    UNKNOWN;

    private static OS os;
    private String lineSeparator = System.getProperty("line.separator");
    private String pathSeparator = System.getProperty("path.separator");
    private String fileSeparator = System.getProperty("file.separator");

    public boolean isWindows() {
        return WINDOWS == this;
    }

    public boolean isMacOsX() {
        return MAC_OS_X == this;
    }

    public boolean isLinux() {
        return LINUX == this;
    }

    public boolean isUnix() {
        return UNKNOWN != this && WINDOWS != this;
    }

    public String lineSeparator() {
        return this.lineSeparator;
    }

    public String pathSeparator() {
        return this.pathSeparator;
    }

    public String fileSeparator() {
        return this.fileSeparator;
    }

    public static OS get() {
        return os;
    }

    static {
        os = null;
        String s = System.getProperty("os.name").toUpperCase();
        for (OS x : OS.values()) {
            if (!s.startsWith(x.name())) continue;
            os = x;
            break;
        }
        if (null == os) {
            os = s.startsWith("OS/2") ? OS2 : (s.startsWith("OS/390") ? OS_390 : (s.startsWith("DIGITAL UNIX") ? DIGITAL_UNIX : UNKNOWN));
        }
    }
}

