/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.EnumSet;
import java.util.Iterator;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.FeaturedBase;
import org.osgl.util.FilteredTrav;
import org.osgl.util.FlatMappedTrav;
import org.osgl.util.MappedTrav;

public abstract class TraversableBase<T>
extends FeaturedBase
implements C.Traversable<T> {
    private volatile int hc_;

    @Override
    protected EnumSet<C.Feature> initFeatures() {
        return EnumSet.of(C.Feature.LAZY, C.Feature.READONLY);
    }

    @Override
    public TraversableBase<T> forEach(Lang.Visitor<? super T> visitor) {
        C.forEach(this, visitor);
        return this;
    }

    protected int generateHashCode() {
        return $.iterableHashCode(this);
    }

    public int hashCode() {
        if (!this.is(C.Feature.LIMITED)) {
            return super.hashCode();
        }
        if (this.is(C.Feature.IMMUTABLE)) {
            if (0 == this.hc_) {
                this.hc_ = this.generateHashCode();
            }
            return this.hc_;
        }
        return this.generateHashCode();
    }

    @Override
    public C.Traversable<T> lazy() {
        this.setFeature(C.Feature.LAZY);
        return this;
    }

    @Override
    public C.Traversable<T> eager() {
        this.unsetFeature(C.Feature.LAZY);
        return this;
    }

    @Override
    public C.Traversable<T> parallel() {
        this.setFeature(C.Feature.PARALLEL);
        return this;
    }

    @Override
    public C.Traversable<T> sequential() {
        this.unsetFeature(C.Feature.PARALLEL);
        return this;
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public <R> R reduce(R identity, Lang.Func2<R, T, R> accumulator) {
        R ret = identity;
        for (Object t : this) {
            ret = accumulator.apply(ret, t);
        }
        return ret;
    }

    @Override
    public Lang.Option<T> reduce(Lang.Func2<T, T, T> accumulator) {
        Iterator itr = this.iterator();
        if (!itr.hasNext()) {
            return $.none();
        }
        Object ret = itr.next();
        while (itr.hasNext()) {
            ret = accumulator.apply(ret, itr.next());
        }
        return $.some(ret);
    }

    @Override
    public Lang.Option<T> findOne(Lang.Function<? super T, Boolean> predicate) {
        for (Object t : this) {
            if (!predicate.apply(t).booleanValue()) continue;
            return $.some(t);
        }
        return $.none();
    }

    @Override
    public boolean anyMatch(Lang.Function<? super T, Boolean> predicate) {
        return this.findOne(predicate).isDefined();
    }

    @Override
    public boolean noneMatch(Lang.Function<? super T, Boolean> predicate) {
        return !this.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Lang.Function<? super T, Boolean> predicate) {
        return this.noneMatch(Lang.F.negate(predicate));
    }

    @Override
    public C.Traversable<T> accept(Lang.Visitor<? super T> visitor) {
        return this.forEach((Lang.Visitor)visitor);
    }

    @Override
    public C.Traversable<T> each(Lang.Visitor<? super T> visitor) {
        return this.forEach((Lang.Visitor)visitor);
    }

    @Override
    public <R> C.Traversable<R> map(Lang.Function<? super T, ? extends R> mapper) {
        return MappedTrav.of(this, mapper);
    }

    @Override
    public <R> C.Traversable<R> flatMap(Lang.Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return FlatMappedTrav.of(this, mapper);
    }

    @Override
    public C.Traversable<T> filter(Lang.Function<? super T, Boolean> predicate) {
        return FilteredTrav.of(this, predicate);
    }
}

