/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util.algo;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.algo.ArrayMergeSortInplace;
import org.osgl.util.algo.ArraySimpleInsertionSortInplace;
import org.osgl.util.algo.ArraySort;
import org.osgl.util.algo.ArraySortInplaceBase;

public class ArrayInsertionSortInplace<T>
extends ArraySortInplaceBase<T>
implements ArraySort<T> {
    private static ArrayInsertionSortInplace<Integer> s = new ArrayInsertionSortInplace();
    private static ArraySimpleInsertionSortInplace<Integer> x = new ArraySimpleInsertionSortInplace();
    private static ArrayMergeSortInplace<Integer> m = new ArrayMergeSortInplace();

    @Override
    protected T[] sort0(T[] ts, int from, int to, Comparator<T> comp) {
        int size = from + 1;
        for (int i = from + 1; i < to; ++i) {
            T t = ts[i];
            int loc = Arrays.binarySearch(ts, from, size, t, comp);
            if (loc < 0) {
                loc ^= 0xFFFFFFFF;
            }
            System.arraycopy(ts, loc, ts, loc + 1, size - loc);
            ts[loc] = t;
            ++size;
        }
        return ts;
    }

    public static void test() {
        Integer[] ia = new Integer[]{5, 4, 3, 1, 3, 2, 1, 2};
        ArrayInsertionSortInplace<Integer> s = new ArrayInsertionSortInplace<Integer>();
        Object[] a = s.apply((T[])ia, 1, 7, Lang.F.NATURAL_ORDER);
        System.out.println(Arrays.toString(a));
    }

    private static long osgl(Integer[] a) {
        long l = System.nanoTime();
        m.sort((Integer[])a, 0, a.length, Lang.F.NATURAL_ORDER);
        return System.nanoTime() - l;
    }

    private static long jdk(Integer[] a) {
        long l = System.nanoTime();
        Arrays.sort(a, Lang.F.NATURAL_ORDER);
        return System.nanoTime() - l;
    }

    public static void benchmark() {
        int ARRAY_LEN = 5000;
        int FACT = 5000;
        int TIMES = 2560;
        Lang.Var<Long> osgl = $.var(0L);
        Lang.Var<Long> jdk = $.var(0L);
        for (int i = 0; i < 2560; ++i) {
            Random r = new Random();
            Integer[] a = new Integer[5000];
            for (int j = 0; j < 5000; ++j) {
                a[j] = r.nextInt(Integer.MAX_VALUE);
            }
            Object[] a1 = (Integer[])a.clone();
            Object[] a2 = (Integer[])a.clone();
            long o = ArrayInsertionSortInplace.osgl((Integer[])a1);
            long j = ArrayInsertionSortInplace.jdk((Integer[])a2);
            if (!Arrays.equals(a1, a2)) {
                System.err.print("Error:");
                System.out.println(Arrays.toString(a1));
                System.out.println(Arrays.toString(a2));
                break;
            }
            if (i <= 1280) continue;
            osgl.set(o + osgl.get());
            jdk.set(j + jdk.get());
        }
        System.out.println(String.format("osgl: %s, jdk: %s", osgl.get() / 2560L / 5000L, jdk.get() / 2560L / 5000L));
    }

    public static void main(String[] args) {
        ArrayInsertionSortInplace.benchmark();
    }
}

