/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util.algo;

import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.E;
import org.osgl.util.algo.ArrayAlgorithm;

public class ArrayReverseInplace<T>
implements ArrayAlgorithm,
Lang.Func3<T[], Integer, Integer, T[]> {
    @Override
    public T[] apply(T[] ts, Integer from, Integer to) throws NotAppliedException, Lang.Break {
        return this.reverse(ts, from, to);
    }

    public T[] reverse(T[] ts, int from, int to) {
        int len;
        E.NPE(ts);
        ArrayAlgorithm.Util.checkIndex(ts, from, to);
        if (to < from) {
            int t = to;
            to = from;
            from = t;
        }
        if (0 == (len = to - from)) {
            return ts;
        }
        int steps = len / 2;
        int max = to - 1;
        for (int i = from; i < from + steps; ++i) {
            T t = ts[i];
            ts[i] = ts[max - i];
            ts[max - i] = t;
        }
        return ts;
    }
}

