/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util.converter;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.N;
import org.osgl.util.S;

public class TypeConverterRegistry {
    private static final Map<Class, Object> NULL_VALS = C.Map(Boolean.TYPE, false, Character.TYPE, Character.valueOf('\u0000'), Byte.TYPE, 0, Short.TYPE, 0, Integer.TYPE, 0, Float.TYPE, 0, Long.TYPE, 0, Double.TYPE, 0);
    public static final Lang.TypeConverter<Void, Object> NULL_CONVERTER = new Lang.TypeConverter<Void, Object>(Void.class, Object.class){

        @Override
        public Object convert(Void aVoid) {
            return null;
        }
    };
    public static final TypeConverterRegistry INSTANCE = new TypeConverterRegistry();
    private Map<Lang.Pair<Class, Class>, Lang.TypeConverter> paths = new HashMap<Lang.Pair<Class, Class>, Lang.TypeConverter>();

    public TypeConverterRegistry() {
        this.registerBuiltInConverters();
    }

    public <FROM, TO> Lang.TypeConverter<FROM, TO> get(Class<FROM> fromType, Class<TO> toType) {
        Lang.TypeConverter converter = (Lang.TypeConverter)$.cast(this.paths.get($.Pair(fromType, toType)));
        if (null == converter && Void.class == fromType) {
            return (Lang.TypeConverter)$.cast(NULL_CONVERTER);
        }
        if (null == converter) {
            Set<Class> types = $.allTypesOf(fromType);
            for (Class c : types) {
                Lang.TypeConverter<FROM, TO> converter1 = this.get(c, toType);
                if (null == converter1) continue;
                this.register(converter1, fromType, toType);
                return converter1;
            }
        }
        return converter;
    }

    public TypeConverterRegistry register(Lang.TypeConverter typeConverter) {
        for (Lang.Pair<Class, Class> key : this.allKeyOf(typeConverter)) {
            if (this.paths.containsKey(key)) continue;
            this.addIntoPath(key, typeConverter);
        }
        this.buildPaths(typeConverter);
        return this;
    }

    private void register(Lang.TypeConverter typeConverter, Class fromType, Class toType) {
        Lang.T2<Class, Class> key = $.Pair(fromType, toType);
        this.register(typeConverter, key);
    }

    private void register(Lang.TypeConverter typeConverter, Lang.Pair<Class, Class> key) {
        this.addIntoPath(key, typeConverter);
        this.buildPaths(typeConverter, (Class)key.left(), (Class)key.right());
    }

    private void registerBuiltInConverters() {
        for (Class<? extends Number> clazz : N.NUMBER_CLASSES) {
            this.addIntoPath(this.keyOf(clazz, Number.class), new Lang.TypeConverter(clazz, Number.class){

                public Object convert(Object o) {
                    return o;
                }
            });
        }
        for (Field field : Lang.TypeConverter.class.getFields()) {
            if (!Lang.TypeConverter.class.isAssignableFrom(field.getType())) continue;
            try {
                Lang.TypeConverter converter = (Lang.TypeConverter)$.cast(field.get(null));
                this.register(converter);
            }
            catch (IllegalAccessException e) {
                throw E.unexpected(e);
            }
        }
        for (final Map.Entry entry : NULL_VALS.entrySet()) {
            this.register(new Lang.TypeConverter<Void, Object>(Void.class, (Class)entry.getKey()){

                @Override
                public Object convert(Void aVoid) {
                    return entry.getValue();
                }
            });
        }
        this.register(NULL_CONVERTER);
    }

    private Lang.Pair<Class, Class> keyOf(Class<?> from, Class<?> to) {
        return (Lang.Pair)$.cast($.Pair(from, to));
    }

    private Lang.Pair<Class, Class> keyOf(Lang.TypeConverter typeConverter) {
        return $.Pair(typeConverter.fromType, typeConverter.toType);
    }

    private Set<Lang.Pair<Class, Class>> allKeyOf(Lang.TypeConverter typeConverter) {
        HashSet<Lang.Pair<Class, Class>> set = new HashSet<Lang.Pair<Class, Class>>();
        Class fromType = typeConverter.fromType;
        Class toType = typeConverter.toType;
        set.add($.Pair(fromType, toType));
        for (Class intf : $.interfacesOf(toType)) {
            set.add($.Pair(fromType, intf));
        }
        for (Class parent : $.superClassesOf(toType)) {
            set.add($.Pair(fromType, parent));
        }
        return set;
    }

    private void buildPaths(Lang.TypeConverter typeConverter) {
        this.buildPaths(typeConverter, typeConverter.fromType, typeConverter.toType);
    }

    private void buildPaths(Lang.TypeConverter typeConverter, Class fromType, Class toType) {
        Set<Lang.TypeConverter> upstreams = this.upstreams(fromType);
        for (Lang.TypeConverter upstream : upstreams) {
            ChainedConverter chained = new ChainedConverter(upstream, typeConverter);
            Lang.Pair<Class, Class> key = this.keyOf(chained);
            Lang.TypeConverter current = this.paths.get(key);
            if (null != current && !TypeConverterRegistry.isShorterPath(chained, current)) continue;
            if (typeConverter.fromType.isAssignableFrom(upstream.fromType)) {
                this.register(typeConverter, key);
                continue;
            }
            this.register(chained, key);
        }
        Set<Lang.TypeConverter> downstreams = this.downstreams(toType);
        for (Lang.TypeConverter downstream : downstreams) {
            ChainedConverter chained = new ChainedConverter(typeConverter, downstream);
            Lang.Pair<Class, Class> key = this.keyOf(chained);
            Lang.TypeConverter current = this.paths.get(key);
            if (null != current && !TypeConverterRegistry.isShorterPath(chained, current)) continue;
            if (downstream.toType.isAssignableFrom(typeConverter.toType)) {
                this.register(typeConverter, key);
                continue;
            }
            this.register(chained, key);
        }
    }

    private Set<Lang.TypeConverter> upstreams(Class toType) {
        HashSet<Lang.TypeConverter> set = new HashSet<Lang.TypeConverter>();
        for (Map.Entry<Lang.Pair<Class, Class>, Lang.TypeConverter> entry : this.paths.entrySet()) {
            if (!toType.isAssignableFrom((Class)entry.getKey().right())) continue;
            set.add(entry.getValue());
        }
        return set;
    }

    private Set<Lang.TypeConverter> downstreams(Class fromType) {
        HashSet<Lang.TypeConverter> set = new HashSet<Lang.TypeConverter>();
        for (Map.Entry<Lang.Pair<Class, Class>, Lang.TypeConverter> entry : this.paths.entrySet()) {
            if (!((Class)entry.getKey().left()).isAssignableFrom(fromType)) continue;
            set.add(entry.getValue());
        }
        return set;
    }

    private void addIntoPath(Lang.Pair<Class, Class> key, Lang.TypeConverter converter) {
        Class primitiveToType;
        this.paths.put(key, converter);
        Class toType = (Class)key.right();
        if (Number.class.isAssignableFrom(toType) && null != (primitiveToType = $.primitiveTypeOf(toType)) && toType != primitiveToType) {
            this.addIntoPath(key.set2(primitiveToType), converter);
        }
    }

    private static boolean isShorterPath(Lang.TypeConverter left, Lang.TypeConverter right) {
        int rightHops;
        int leftHops = TypeConverterRegistry.hops(left);
        return leftHops < (rightHops = TypeConverterRegistry.hops(right));
    }

    private static int hops(Lang.TypeConverter typeConverter) {
        if (!(typeConverter instanceof ChainedConverter)) {
            return TypeConverterRegistry.distance(typeConverter);
        }
        ChainedConverter chainedConverter = (ChainedConverter)$.cast(typeConverter);
        return TypeConverterRegistry.hops(chainedConverter.upstream) + TypeConverterRegistry.hops(chainedConverter.downstream);
    }

    private static int distance(Lang.TypeConverter typeConverter) {
        return TypeConverterRegistry.distance(typeConverter.fromType) + TypeConverterRegistry.distance(typeConverter.toType);
    }

    private static int distance(Class<?> type) {
        if (type == Object.class) {
            return 100;
        }
        if (type.isInterface()) {
            Set<Class> interfaces = $.interfacesOf(type);
            return 100 - interfaces.size();
        }
        if (type.isArray()) {
            return TypeConverterRegistry.distance(type.getComponentType());
        }
        if ($.isSimpleType(type)) {
            return 0;
        }
        return TypeConverterRegistry.distance(type.getSuperclass()) - 1;
    }

    private static class ChainedConverter
    extends Lang.TypeConverter {
        private final Lang.TypeConverter upstream;
        private final Lang.TypeConverter downstream;

        public ChainedConverter(Lang.TypeConverter upstream, Lang.TypeConverter downStream) {
            super(upstream.fromType, downStream.toType);
            this.upstream = upstream;
            this.downstream = downStream;
        }

        public Object convert(Object o) {
            return this.downstream.convert(this.upstream.convert(o));
        }

        @Override
        public String toString() {
            return S.concat(this.upstream, (Object)" | ", this.downstream);
        }
    }
}

