/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.OsglConfig;
import org.osgl.exception.MappingException;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.Keyword;
import org.osgl.util.S;
import org.osgl.util.converter.TypeConverterRegistry;

public class DataMapper {
    private Rule rule;
    private StringBuilder context = new StringBuilder();
    private PropertyFilter filter;
    private Object source;
    private Class<?> sourceType;
    private Object target;
    private Class<?> targetType;
    private Class<?> targetComponentType;
    private Class<?> targetKeyType;
    Map<Class, Object> conversionHints;
    Lang.Function<Class, ?> instanceFactory;
    TypeConverterRegistry typeConverterRegistry;
    private boolean ignoreError;

    public DataMapper(Object source, Object target, Class<?> targetKeyType, Class<?> targetComponentType, Rule rule, String filterSpec, boolean ignoreError, Map<Class, Object> conversionHints, Lang.Function<Class, ?> instanceFactory, TypeConverterRegistry typeConverterRegistry) {
        this.targetType = target.getClass();
        E.illegalArgumentIf(DataMapper.isImmutable(this.targetType), "target type is immutable: " + this.targetType.getName());
        this.sourceType = source.getClass();
        if (rule == Rule.STRICT_NAME_TYPE && !this.targetType.isAssignableFrom(this.sourceType)) {
            this.logError("Type mismatch. Source type: %s; Target type: %s", this.sourceType.getName(), this.targetType.getName());
            return;
        }
        this.targetKeyType = targetKeyType;
        this.targetComponentType = targetComponentType;
        this.rule = $.requireNotNull(rule);
        this.filter = new PropertyFilter(filterSpec);
        this.conversionHints = null == conversionHints ? C.Map(new Object[0]) : conversionHints;
        this.instanceFactory = null == instanceFactory ? OsglConfig.INSTANCE_FACTORY : instanceFactory;
        this.source = source;
        this.target = target;
        this.ignoreError = ignoreError;
        this.typeConverterRegistry = null == typeConverterRegistry ? TypeConverterRegistry.INSTANCE : typeConverterRegistry;
        this.doMapping();
    }

    private DataMapper(Object source, Object target, String targetName, Class targetKeyType, Class targetComponentType, DataMapper parentMapper) {
        this.sourceType = source.getClass();
        this.source = source;
        this.targetType = target.getClass();
        this.target = target;
        this.targetKeyType = targetKeyType;
        this.targetComponentType = targetComponentType;
        this.rule = parentMapper.rule;
        this.filter = parentMapper.filter;
        this.ignoreError = parentMapper.ignoreError;
        this.conversionHints = parentMapper.conversionHints;
        this.instanceFactory = parentMapper.instanceFactory;
        this.typeConverterRegistry = parentMapper.typeConverterRegistry;
        this.context = new StringBuilder();
        String parentContext = parentMapper.context.toString();
        this.context.append(parentContext);
        if (S.notBlank(targetName)) {
            if (S.notBlank(parentContext)) {
                this.context.append(".").append(targetName);
            } else {
                this.context.append(targetName);
            }
        }
        this.doMapping();
    }

    public Object getTarget() {
        return this.target;
    }

    private void doMapping() {
        boolean targetIsCollection;
        boolean targetIsArray = this.targetType.isArray();
        boolean bl = targetIsCollection = !targetIsArray && Collection.class.isAssignableFrom(this.targetType);
        if (targetIsArray || targetIsCollection) {
            this.mapToArrayOrCollection(targetIsArray);
        } else {
            boolean targetIsMap = Map.class.isAssignableFrom(this.targetType);
            if (targetIsMap) {
                this.mapToMap();
            } else {
                this.mapToPojo();
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void mapToArrayOrCollection(boolean targetIsArray) {
        ArrayList<Object> sourceIterable;
        Collection targetCollection = null;
        List targetList = null;
        int targetLen = 0;
        boolean targetIsList = false;
        if (targetIsArray) {
            targetLen = Array.getLength(this.target);
            if (targetLen == 0) {
                return;
            }
            this.targetComponentType = this.targetType.getComponentType();
        } else {
            targetCollection = (Collection)this.target;
            if (List.class.isAssignableFrom(this.targetType)) {
                targetIsList = true;
                targetList = (List)this.target;
                targetLen = targetList.size();
            }
            if (null == this.targetComponentType) {
                this.targetComponentType = $.commonSuperTypeOf(targetCollection);
            }
        }
        if (!DataMapper.isSequence(this.sourceType)) {
            sourceIterable = this.convertSourceTo(Iterable.class);
            if (null == sourceIterable) {
                if (this.rule == Rule.STRICT_NAME_TYPE) {
                    this.logMappingFailure();
                    return;
                }
                ArrayList<Object> pseudoList = new ArrayList<Object>();
                if (!this.targetComponentType.isAssignableFrom(this.sourceType)) {
                    Object convertedSource = this.convertSourceTo(this.targetComponentType);
                    if (null == convertedSource) {
                        this.logMappingFailure();
                        return;
                    }
                    pseudoList.add(convertedSource);
                } else {
                    pseudoList.add(this.source);
                }
                sourceIterable = pseudoList;
            }
        } else {
            sourceIterable = this.convertSourceTo(Iterable.class);
        }
        Iterator itr = sourceIterable.iterator();
        if (targetIsArray || null != targetList) {
            int cursor = 0;
            while (cursor < targetLen && itr.hasNext()) {
                void var10_15;
                Object object;
                Object sourceComponent = itr.next();
                if (null == sourceComponent) {
                    if (targetIsArray) {
                        Array.set(this.target, cursor, null);
                        continue;
                    }
                    targetList.set(cursor, null);
                    continue;
                }
                Object obj = this.convert(sourceComponent).to(this.targetComponentType);
                if (null != obj) {
                    if (targetIsList) {
                        targetList.set(cursor, obj);
                        continue;
                    }
                    Array.set(this.target, cursor, obj);
                    continue;
                }
                Object object2 = object = targetIsList ? targetList.get(cursor) : Array.get(this.target, cursor);
                if (null == object) {
                    Object obj2 = this.instanceFactory.apply(this.targetComponentType);
                    if (targetIsList) {
                        targetList.set(cursor, obj2);
                    } else {
                        Array.set(this.target, cursor, obj2);
                    }
                }
                new DataMapper(sourceComponent, var10_15, "", null, this.targetComponentType, this);
            }
        }
        if (!targetIsArray) {
            while (itr.hasNext()) {
                Object sourceComponent = itr.next();
                Object targetComponent = this.convert(sourceComponent).to(this.targetComponentType);
                if (null == targetComponent) continue;
                targetCollection.add(targetComponent);
            }
        }
    }

    private void mapToMap() {
        Map targetMap = (Map)this.target;
        if (null == this.targetKeyType) {
            this.targetKeyType = $.commonSuperTypeOf(targetMap.keySet());
            if (null == this.targetKeyType) {
                this.targetKeyType = String.class;
            }
        }
        if (null == this.targetComponentType) {
            this.targetComponentType = $.commonSuperTypeOf(targetMap.values());
            if (null == this.targetComponentType) {
                this.targetComponentType = Object.class;
            }
        }
        HashMap<Keyword, Lang.Pair<Object, Lang.Producer<Object>>> targetMapKeywordLookup = null;
        if (this.rule.keywordMatching() && String.class == this.targetKeyType) {
            targetMapKeywordLookup = new HashMap<Keyword, Lang.Pair<Object, Lang.Producer<Object>>>();
            for (Lang.Pair<Object, Lang.Producer<Object>> key : targetMap.keySet()) {
                targetMapKeywordLookup.put(Keyword.of(((Object)key).toString()), key);
            }
        }
        for (Lang.Pair<Object, Lang.Producer<Object>> sourceProperty : this.sourceProperties()) {
            Object targetKey;
            Object sourceKey = sourceProperty.left();
            Object sourceVal = sourceProperty.right();
            if (targetMapKeywordLookup != null) {
                Keyword keywordTargetKey = Keyword.of(sourceKey.toString());
                targetKey = targetMapKeywordLookup.get(keywordTargetKey);
            } else {
                targetKey = this.convert(sourceKey).to(this.targetKeyType);
            }
            if (null == sourceVal) {
                targetMap.remove(targetKey);
                continue;
            }
            Object targetVal = this.convert(sourceVal).to(this.targetComponentType);
            if (null != targetVal) {
                targetMap.put(targetKey, targetVal);
                continue;
            }
            targetVal = targetMap.get(targetKey);
            if (targetVal == null) {
                targetVal = this.instanceFactory.apply(this.targetComponentType);
            }
            new DataMapper(sourceVal, targetVal, targetKey.toString(), this.targetKeyType, this.targetComponentType, this);
        }
    }

    private void mapToPojo() {
        List<Field> targetFields = $.fieldsOf(this.targetType);
        String prefix = this.context.toString();
        Map sourceMap = Map.class.isAssignableFrom(this.sourceType) ? (Map)this.source : null;
        HashMap sourceMapByKeyword = null;
        if (this.rule.keywordMatching()) {
            sourceMapByKeyword = new HashMap();
            if (null != sourceMap) {
                for (Map.Entry entry : sourceMap.entrySet()) {
                    sourceMapByKeyword.put(Keyword.of(entry.getKey().toString()), entry.getValue());
                }
            } else {
                for (Field field : $.fieldsOf(this.sourceType)) {
                    sourceMapByKeyword.put(Keyword.of(field.getName()), field);
                }
            }
        }
        for (Field field : targetFields) {
            Type v;
            ParameterizedType pt;
            Type[] ta;
            Type targetGenericType;
            Object sourcePropValue;
            Class<?> targetFieldType = field.getType();
            String targetFieldName = field.getName();
            String key = S.notBlank(prefix) ? S.pathConcat(prefix, '.', targetFieldName) : targetFieldName;
            if (!this.filter.test(key)) continue;
            if (null != sourceMapByKeyword) {
                sourcePropValue = sourceMapByKeyword.get(Keyword.of(targetFieldName));
                if (null == sourcePropValue) continue;
                if (sourcePropValue instanceof Field) {
                    sourcePropValue = $.getFieldValue(this.source, (Field)sourcePropValue);
                }
            } else if (null != sourceMap) {
                sourcePropValue = sourceMap.get(targetFieldName);
            } else {
                Field sourceField = $.fieldOf(this.sourceType, targetFieldName);
                if (null == sourceField) continue;
                sourcePropValue = $.getFieldValue(this.source, sourceField);
            }
            if (null == sourcePropValue) {
                $.setFieldValue(this.target, field, null);
                continue;
            }
            Object targetFieldValue = this.convert(sourcePropValue).to(targetFieldType);
            if (null != targetFieldValue) {
                $.setFieldValue(this.target, field, targetFieldValue);
                continue;
            }
            targetFieldValue = $.getFieldValue(this.target, field);
            if (null == targetFieldValue) {
                targetFieldValue = this.instanceFactory.apply(targetFieldType);
                $.setFieldValue(this.target, field, targetFieldValue);
            }
            Class targetKeyType = null;
            Class targetComponentType = null;
            if (Map.class.isAssignableFrom(targetFieldType)) {
                targetGenericType = field.getGenericType();
                if (targetGenericType instanceof ParameterizedType && (ta = (pt = (ParameterizedType)targetGenericType).getActualTypeArguments()).length > 1) {
                    Type k = ta[0];
                    Type v2 = ta[1];
                    if (k instanceof Class) {
                        targetKeyType = (Class)k;
                    }
                    if (v2 instanceof Class) {
                        targetComponentType = (Class)v2;
                    }
                }
            } else if (Collection.class.isAssignableFrom(targetFieldType) && (targetGenericType = field.getGenericType()) instanceof ParameterizedType && (ta = (pt = (ParameterizedType)targetGenericType).getActualTypeArguments()).length > 0 && (v = ta[0]) instanceof Class) {
                targetComponentType = (Class)v;
            }
            new DataMapper(sourcePropValue, targetFieldValue, targetFieldName, targetKeyType, targetComponentType, this);
        }
    }

    private Iterable<Lang.Pair<Object, Lang.Producer<Object>>> sourceProperties() {
        if (Map.class.isAssignableFrom(this.sourceType)) {
            return C.list(((Map)this.source).entrySet()).filter(this.mapEntryFilter()).map(new Lang.Transformer<Map.Entry, Lang.Pair<Object, Lang.Producer<Object>>>(){

                @Override
                public Lang.T2<Object, Lang.Producer<Object>> transform(final Map.Entry entry) {
                    Lang.Producer<Object> producer = new Lang.Producer<Object>(){

                        @Override
                        public Object produce() {
                            return entry.getValue();
                        }
                    };
                    Object key = entry.getKey();
                    if (DataMapper.this.rule.keywordMatching() && key instanceof String) {
                        key = Keyword.of(key.toString());
                    }
                    return $.T2(key, producer);
                }
            });
        }
        List<Field> fields = $.fieldsOf(this.sourceType);
        return C.list(fields).filter(this.fieldFilter()).map(new Lang.Transformer<Field, Lang.Pair<Object, Lang.Producer<Object>>>(){

            @Override
            public Lang.Pair<Object, Lang.Producer<Object>> transform(final Field field) {
                Object name = field.getName();
                if (DataMapper.this.rule.keywordMatching()) {
                    name = Keyword.of(name.toString());
                }
                Lang.Producer<Object> producer = new Lang.Producer<Object>(){

                    @Override
                    public Object produce() {
                        return $.getFieldValue(DataMapper.this.source, field);
                    }
                };
                return $.T2(name, producer);
            }
        });
    }

    private Lang.Predicate<Map.Entry> mapEntryFilter() {
        if (this.filter.allEmpty) {
            return Lang.F.yes();
        }
        return new Lang.Predicate<Map.Entry>(){

            @Override
            public boolean test(Map.Entry entry) {
                String key = entry.getKey().toString();
                String prefix = DataMapper.this.context.toString();
                if (S.notBlank(prefix)) {
                    key = S.pathConcat(prefix, '.', key);
                }
                return DataMapper.this.filter.test(key);
            }
        };
    }

    private Lang.Predicate<Field> fieldFilter() {
        if (this.filter.allEmpty) {
            return Lang.F.yes();
        }
        return new Lang.Predicate<Field>(){

            @Override
            public boolean test(Field field) {
                String key = field.getName();
                String prefix = DataMapper.this.context.toString();
                if (S.notBlank(prefix)) {
                    key = S.pathConcat(prefix, '.', key);
                }
                return DataMapper.this.filter.test(key);
            }
        };
    }

    private void logError(Throwable cause, String message, Object ... messageArgs) {
        if (!this.ignoreError) {
            this.mappingError(cause, message, messageArgs);
        }
    }

    private void logError(String message, Object ... messageArgs) {
        if (!this.ignoreError) {
            this.mappingError(message, messageArgs);
        }
    }

    private void logMappingFailure() {
        this.logError("Mapping failure", new Object[0]);
    }

    private <T> T convertSourceTo(Class<T> type) {
        try {
            return this.convertStage(!this.ignoreError).to(type);
        }
        catch (Exception e) {
            this.logError(e, "Cannot convert source into " + type.getName(), new Object[0]);
            return null;
        }
    }

    private <T> T tryConvertSourceTo(Class<T> type) {
        return this.convertStage(false).to(type);
    }

    private Lang._ConvertStage<?> convertStage() {
        return this.convert(this.source, !this.ignoreError);
    }

    private Lang._ConvertStage<?> convertStage(boolean reportError) {
        return this.convert(this.source, reportError);
    }

    private Lang._ConvertStage<?> convert(Object source) {
        return this.convert(source, !this.ignoreError);
    }

    private Lang._ConvertStage<?> tryConvert(Object source) {
        return this.convert(source, false);
    }

    private Lang._ConvertStage<?> convert(Object source, boolean reportError) {
        Lang._ConvertStage stage = $.convert(source).customTypeConverters(this.typeConverterRegistry).hint(this.convertHintOf(this.sourceType));
        if (!reportError) {
            stage.reportError();
        }
        return stage;
    }

    private Object convertHintOf(Class type) {
        return this.conversionHints.get(type);
    }

    private void mappingError(Throwable cause, String message, Object ... messageArgs) {
        throw new MappingException(this.source, this.target, cause, message, messageArgs);
    }

    private MappingException mappingError(String message, Object ... messageArgs) {
        throw new MappingException(this.source, this.target, message, messageArgs);
    }

    private static boolean isSequence(Class<?> targetType) {
        return targetType.isArray() || Collection.class.isAssignableFrom(targetType);
    }

    private static Class elementTypeOf(Object o) {
        Class<?> type = o.getClass();
        if (type.isArray()) {
            return type.getComponentType();
        }
        Collection collection = (Collection)o;
        return $.commonSuperTypeOf(collection);
    }

    private static boolean isImmutable(Class<?> type) {
        return $.isSimpleType(type) || Date.class.isAssignableFrom(type);
    }

    class PropertyFilter
    extends Lang.Predicate<String> {
        private Set<String> whiteList = C.set();
        private Set<String> blackList = C.set();
        private Set<Keyword> whiteKeywords = C.set();
        private Set<Keyword> blackKeywords = C.set();
        private boolean allEmpty = true;

        PropertyFilter(String spec) {
            if (S.blank(spec)) {
                return;
            }
            S.List words = S.fastSplit(spec, ",");
            boolean useBlackList = false;
            for (String word : words) {
                if (useBlackList && !word.startsWith("-")) continue;
                if (word.startsWith("-")) {
                    useBlackList = true;
                    word = word.substring(1);
                }
                word = word.trim();
                if (useBlackList) {
                    if (DataMapper.this.rule == Rule.KEYWORD_MATCHING) {
                        if (this.blackKeywords == C.EMPTY_SET) {
                            this.blackKeywords = new HashSet<Keyword>();
                        }
                        this.blackKeywords.add(Keyword.of(word));
                        continue;
                    }
                    if (this.blackList == C.EMPTY_SET) {
                        this.blackList = new HashSet<String>();
                    }
                    this.blackList.add(word);
                    continue;
                }
                if (DataMapper.this.rule == Rule.KEYWORD_MATCHING) {
                    if (this.whiteKeywords == C.EMPTY_SET) {
                        this.whiteKeywords = new HashSet<Keyword>();
                    }
                    this.whiteKeywords.add(Keyword.of(word));
                    continue;
                }
                if (this.whiteList == C.EMPTY_SET) {
                    this.whiteList = new HashSet<String>();
                }
                this.whiteList.add(word);
            }
            if (useBlackList) {
                this.whiteKeywords = C.set();
                this.whiteList = C.set();
            }
            this.allEmpty = this.whiteKeywords.isEmpty() && this.whiteList.isEmpty() && this.blackKeywords.isEmpty() && this.blackList.isEmpty();
        }

        @Override
        public boolean test(String s) {
            E.illegalArgumentIf(S.blank(s));
            if (this.allEmpty) {
                return true;
            }
            String prefix = DataMapper.this.context.toString();
            if (S.notBlank(prefix)) {
                s = S.pathConcat(prefix, '.', s);
            }
            if (DataMapper.this.rule == Rule.KEYWORD_MATCHING) {
                Keyword keyword = Keyword.of(s);
                return this.blackKeywords.isEmpty() ? this.whiteKeywords.contains(keyword) : !this.blackKeywords.contains(keyword);
            }
            return this.blackList.isEmpty() ? this.whiteList.contains(s) : !this.blackList.contains(s);
        }
    }

    public static enum Rule {
        STRICT_NAME_TYPE,
        STRICT_NAME,
        KEYWORD_MATCHING;


        public boolean keywordMatching() {
            return this == KEYWORD_MATCHING;
        }
    }
}

