/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.ListBase;
import org.osgl.util.Nil;

class DelegatingList<T>
extends ListBase<T>
implements C.List<T>,
Serializable {
    private static EnumSet<C.Feature> freeFeatures = EnumSet.of(C.Feature.LAZY, C.Feature.PARALLEL);
    private static EnumSet<C.Feature> setableFeatures = EnumSet.of(C.Feature.READONLY);
    protected List<T> data;

    protected DelegatingList(boolean noInit) {
        if (noInit) {
            return;
        }
        this.data = C.randomAccessListFact.create(10);
    }

    DelegatingList() {
        this(10, C.randomAccessListFact);
    }

    DelegatingList(int initialCapacity) {
        this(initialCapacity, C.randomAccessListFact);
    }

    DelegatingList(C.ListFactory fact) {
        this(10, fact);
    }

    DelegatingList(int initialCapacity, C.ListFactory fact) {
        this.data = fact.create(initialCapacity);
    }

    DelegatingList(Iterable<? extends T> iterable) {
        this(iterable, C.randomAccessListFact);
    }

    DelegatingList(Iterable<? extends T> iterable, C.ListFactory fact) {
        E.NPE(iterable);
        if (iterable instanceof Collection) {
            this.data = fact.create((Collection)iterable);
        } else {
            this.data = fact.create();
            for (T t : iterable) {
                this.data.add(t);
            }
        }
    }

    private DelegatingList(List<T> list, boolean wrapDirectly) {
        E.NPE(list);
        this.data = wrapDirectly ? list : C.randomAccessListFact.create(list);
    }

    DelegatingList(Collection<T> col, C.ListFactory fact) {
        this.data = fact.create(col);
    }

    @Override
    protected EnumSet<C.Feature> initFeatures() {
        EnumSet<C.Feature> fs;
        EnumSet<C.Feature> enumSet = fs = this.data instanceof C.List ? ((C.List)this.data).features() : EnumSet.of(C.Feature.LIMITED, C.Feature.ORDERED);
        if (this.data instanceof RandomAccess) {
            fs.add(C.Feature.RANDOM_ACCESS);
        }
        return fs;
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.data.listIterator(index);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public T get(int index) {
        return this.data.get(index);
    }

    @Override
    public T set(int index, T element) {
        if (this.isMutable()) {
            return this.data.set(index, element);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        if (this.isMutable()) {
            this.data.add(index, element);
            return;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        if (this.isMutable()) {
            return this.data.remove(index);
        }
        throw new UnsupportedOperationException();
    }

    static <T> C.List<T> wrap(List<T> list) {
        C.List cl;
        if (list instanceof C.List && (cl = (C.List)list).is(C.Feature.IMMUTABLE) && cl.isEmpty()) {
            return Nil.list();
        }
        if (list instanceof DelegatingList) {
            list = ((DelegatingList)list).data;
        }
        return new DelegatingList<T>(list, true);
    }

    static <T> C.List<T> wrap(List<T> list, C.Feature f1) {
        C.List<T> l = DelegatingList.wrap(list);
        if (l instanceof DelegatingList) {
            DelegatingList dl = (DelegatingList)l;
            if (setableFeatures.contains((Object)f1)) {
                dl.features_().add(f1);
            }
        }
        return l;
    }

    static <T> C.List<T> wrap(List<T> list, C.Feature f1, C.Feature f2) {
        C.List<T> l = DelegatingList.wrap(list);
        if (l instanceof DelegatingList) {
            DelegatingList dl = (DelegatingList)l;
            if (setableFeatures.contains((Object)f1)) {
                dl.features_().add(f1);
            }
            if (setableFeatures.contains((Object)f2)) {
                dl.features_().add(f2);
            }
        }
        return l;
    }

    static <T> C.List<T> wrap(List<T> list, C.Feature f1, C.Feature f2, C.Feature f3) {
        C.List<T> l = DelegatingList.wrap(list);
        if (l instanceof DelegatingList) {
            DelegatingList dl = (DelegatingList)l;
            if (setableFeatures.contains((Object)f1)) {
                dl.features_().add(f1);
            }
            if (setableFeatures.contains((Object)f2)) {
                dl.features_().add(f2);
            }
            if (setableFeatures.contains((Object)f3)) {
                dl.features_().add(f3);
            }
        }
        return l;
    }

    static <T> DelegatingList<T> copyOf(Iterable<T> iterable) {
        return new DelegatingList<T>(iterable);
    }

    static <T> DelegatingList<T> copyOf(Iterable<T> iterable, C.Feature f1) {
        DelegatingList<T> l = DelegatingList.copyOf(iterable);
        if (setableFeatures.contains((Object)f1)) {
            l.features_().add(f1);
        }
        return l;
    }

    static <T> DelegatingList<T> copyOf(Iterable<T> iterable, C.Feature f1, C.Feature f2) {
        DelegatingList<T> l = DelegatingList.copyOf(iterable);
        if (setableFeatures.contains((Object)f1)) {
            l.features_().add(f1);
        }
        if (setableFeatures.contains((Object)f2)) {
            l.features_().add(f2);
        }
        return l;
    }

    static <T> DelegatingList<T> copyOf(Iterable<T> iterable, C.Feature f1, C.Feature f2, C.Feature f3) {
        DelegatingList<T> l = DelegatingList.copyOf(iterable);
        if (setableFeatures.contains((Object)f1)) {
            l.features_().add(f1);
        }
        if (setableFeatures.contains((Object)f2)) {
            l.features_().add(f2);
        }
        if (setableFeatures.contains((Object)f3)) {
            l.features_().add(f3);
        }
        return l;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.data);
        s.writeObject(this.features_());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.data = (List)s.readObject();
        EnumSet features = (EnumSet)s.readObject();
        this.features_().addAll(features);
    }

    static {
        setableFeatures.addAll(freeFeatures);
    }
}

