/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.osgl.util.C;
import org.osgl.util.SetBase;

class DelegatingSet<T>
extends SetBase<T>
implements C.Set<T>,
Serializable {
    protected Set<T> data;

    DelegatingSet(Collection<? extends T> c) {
        this.data = new HashSet<T>(c);
    }

    DelegatingSet() {
        this.data = new HashSet<T>();
    }

    DelegatingSet(Collection<? extends T> c, boolean immutable) {
        if (c instanceof C.Set) {
            C.Set set = (C.Set)c;
            boolean setIsImmutable = set.is(C.Feature.IMMUTABLE);
            this.data = immutable && setIsImmutable ? set : (immutable ? Collections.unmodifiableSet(set) : new HashSet<T>(set));
        } else if (c instanceof Set) {
            Set set = (Set)c;
            this.data = immutable ? Collections.unmodifiableSet(set) : new HashSet<T>(set);
        } else {
            HashSet<T> set = new HashSet<T>(c);
            this.data = immutable ? Collections.unmodifiableSet(set) : set;
        }
    }

    @Override
    protected EnumSet<C.Feature> initFeatures() {
        EnumSet<C.Feature> fs = this.data instanceof C.Set ? ((C.Set)this.data).features() : EnumSet.of(C.Feature.LIMITED);
        return fs;
    }

    @Override
    public Iterator<T> iterator() {
        return this.data.iterator();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.data.contains(o);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.data.toArray(a);
    }

    @Override
    public boolean add(T t) {
        return this.data.add(t);
    }

    @Override
    public boolean remove(Object o) {
        return this.data.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.data.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.data.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.data.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.data.removeAll(c);
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public int hashCode() {
        return this.data.hashCode() + DelegatingSet.class.hashCode();
    }
}

