/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.E;
import org.osgl.util.PropertyGetter;
import org.osgl.util.PropertyHandlerBase;

abstract class ReflectionPropertyHandler
extends PropertyHandlerBase {
    protected transient Class entityClass;
    protected transient Method m;
    protected String mn;
    protected transient Field f;
    protected String fn;
    protected transient Class propertyClass;
    protected String propertyClassName;

    ReflectionPropertyHandler(Lang.Function<Class<?>, Object> objectFactory, Lang.Func2<String, Class<?>, ?> stringValueResolver, Class entityClass, Method m, Field f2) {
        super(objectFactory, stringValueResolver);
        this.init(entityClass, m, f2);
    }

    ReflectionPropertyHandler(Lang.Function<Class<?>, Object> objectFactory, Lang.Func2<String, Class<?>, ?> stringValueResolver, PropertyGetter.NullValuePolicy nullValuePolicy, Class entityClass, Method m, Field f2) {
        super(objectFactory, stringValueResolver, nullValuePolicy);
        this.init(entityClass, m, f2);
    }

    ReflectionPropertyHandler(Class entityClass, Method m, Field f2) {
        this.init(entityClass, m, f2);
    }

    ReflectionPropertyHandler(PropertyGetter.NullValuePolicy nullValuePolicy, Class entityClass, Method m, Field f2) {
        super(nullValuePolicy);
        this.init(entityClass, m, f2);
    }

    public Class getPropertyClass(Object entity) {
        if (null != this.propertyClass) {
            return this.propertyClass;
        }
        return $.classForName(this.propertyClassName, entity.getClass().getClassLoader());
    }

    protected void ensureMethodOrField(Object obj) {
        block6: {
            if (null != this.m || null != this.f) {
                return;
            }
            try {
                if (null == this.entityClass) {
                    this.entityClass = obj.getClass();
                }
                if (null != this.mn) {
                    this.m = this.entityClass.getMethod(this.mn, new Class[0]);
                    this.m.setAccessible(true);
                    break block6;
                }
                if (null != this.fn) {
                    this.f = this.entityClass.getDeclaredField(this.fn);
                    this.f.setAccessible(true);
                    break block6;
                }
                throw E.unexpected("neither method name nor field name found", new Object[0]);
            }
            catch (Exception e) {
                throw E.unexpected(e);
            }
        }
    }

    private void init(Class c, Method m, Field f2) {
        E.illegalArgumentIf(null == m && null == f2);
        this.entityClass = c;
        this.m = m;
        this.f = f2;
        if (null != m) {
            this.mn = m.getName();
            this.propertyClass = m.getReturnType();
            if (Void.TYPE.equals(this.propertyClass)) {
                this.propertyClass = m.getParameterTypes()[0];
            }
        } else {
            this.fn = f2.getName();
            this.propertyClass = f2.getType();
        }
        this.propertyClassName = this.propertyClass.getName();
    }
}

