/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.E;
import org.osgl.util.PropertyGetter;
import org.osgl.util.PropertySetter;
import org.osgl.util.ReflectionPropertyHandler;
import org.osgl.util.S;

public class ReflectionPropertySetter
extends ReflectionPropertyHandler
implements PropertySetter {
    public ReflectionPropertySetter(Class c, Method m, Field f2) {
        super(c, m, f2);
        this.setNullValuePolicy(PropertyGetter.NullValuePolicy.CREATE_NEW);
    }

    public ReflectionPropertySetter(Lang.Function<Class<?>, Object> objectFactory, Lang.Func2<String, Class<?>, ?> stringValueResolver, Class entityClass, Method m, Field f2) {
        super(objectFactory, stringValueResolver, PropertyGetter.NullValuePolicy.CREATE_NEW, entityClass, m, f2);
    }

    @Override
    public void set(Object entity, Object value, Object index) {
        this.setProperty(entity, value);
    }

    private void setProperty(Object entity, Object value) throws NotAppliedException, Lang.Break {
        if (null == entity) {
            return;
        }
        this.ensureMethodOrField(entity);
        try {
            this.doSet(entity, value);
        }
        catch (Exception e) {
            throw E.unexpected(e);
        }
    }

    protected void doSet(Object entity, Object value) throws Exception {
        Class requiredClass = super.getPropertyClass(entity);
        value = this.convertValue(requiredClass, value);
        if (null != this.m) {
            this.m.invoke(entity, value);
        } else {
            this.f.set(entity, value);
        }
    }

    protected Object convertValue(Class requiredClass, Object value) {
        if (null == value || requiredClass.isAssignableFrom(value.getClass())) {
            return value;
        }
        return this.stringValueResolver.apply(S.string(value), requiredClass);
    }
}

