/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.Charsets;
import org.osgl.util.E;
import org.osgl.util.FastStr;
import org.osgl.util.FilteredIterator;
import org.osgl.util.S;
import org.osgl.util.StrBase;

public class Str
extends StrBase<Str> {
    public static final Str EMPTY_STR = new Str("");
    private String s;

    @Override
    protected Class<Str> _impl() {
        return Str.class;
    }

    @Override
    protected Str _empty() {
        return EMPTY_STR;
    }

    private Str(String s) {
        this.s = s;
    }

    protected Str() {
    }

    @Override
    public int length() {
        return this.s.length();
    }

    @Override
    public boolean isEmpty() {
        return EMPTY_STR == this || null == this.s || this.s.isEmpty();
    }

    @Override
    public boolean isBlank() {
        return this.isEmpty() || "".equals(this.s.trim());
    }

    @Override
    public Str subList(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return EMPTY_STR;
        }
        return Str.of(this.s.substring(fromIndex, toIndex));
    }

    @Override
    public Str takeWhile(Lang.Function<? super Character, Boolean> predicate) {
        if ("".equals(this.s)) {
            return EMPTY_STR;
        }
        return Str.of(new FilteredIterator<Character>(this.iterator(), predicate, FilteredIterator.Type.WHILE));
    }

    @Override
    public Str dropWhile(Lang.Function<? super Character, Boolean> predicate) {
        if ("".equals(this.s)) {
            return EMPTY_STR;
        }
        return Str.of(new FilteredIterator<Character>(this.iterator(), Lang.F.negate(predicate), FilteredIterator.Type.UNTIL));
    }

    @Override
    public Str remove(Lang.Function<? super Character, Boolean> predicate) {
        if ("".equals(this.s)) {
            return EMPTY_STR;
        }
        return Str.of(new FilteredIterator<Character>(this.iterator(), Lang.F.negate(predicate), FilteredIterator.Type.ALL));
    }

    @Override
    public Str insert(int index, char character) throws StringIndexOutOfBoundsException {
        int len = this.s.length();
        if (len < Math.abs(index)) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (index < 0) {
            index = len + index;
        }
        StringBuilder sb = new StringBuilder(this.s.substring(0, index));
        sb.append(character);
        sb.append(this.s.substring(index, this.size()));
        return Str.of(sb);
    }

    @Override
    public Str insert(int index, Character character) throws IndexOutOfBoundsException {
        return this.insert_(index, character);
    }

    @Override
    public Str insert(int index, Character ... ca) throws StringIndexOutOfBoundsException {
        return this.insert_(index, Str.of(ca));
    }

    @Override
    public Str insert(int index, char ... ca) throws StringIndexOutOfBoundsException {
        return this.insert_(index, Str.of(ca));
    }

    @Override
    public Str insert(int index, StrBase<?> str) throws StringIndexOutOfBoundsException {
        return this.insert_(index, str);
    }

    @Override
    public Str insert(int index, String s) throws StringIndexOutOfBoundsException {
        return this.insert_(index, s);
    }

    private Str insert_(int index, Object o) throws StringIndexOutOfBoundsException {
        int len = this.s.length();
        if (len < Math.abs(index)) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (index < 0) {
            index = len + index;
        }
        StringBuilder sb = new StringBuilder(this.s.substring(0, index));
        sb.append(o);
        sb.append(this.s.substring(index, this.size()));
        return Str.of(sb);
    }

    @Override
    public Str reverse() {
        return Str.of(new StringBuilder(this.s).reverse());
    }

    @Override
    public Str append(Collection<? extends Character> collection) {
        int sz = this.s.length();
        int sz2 = collection.size();
        if (0 == sz2) {
            return this;
        }
        if (0 == sz) {
            return Str.of(collection);
        }
        StringBuilder sb = new StringBuilder(sz + sz2).append(this.s);
        for (Character c : collection) {
            sb.append(c);
        }
        return Str.of(sb);
    }

    @Override
    public Str append(C.List<Character> list) {
        int sz = this.s.length();
        int sz2 = list.size();
        if (0 == sz2) {
            return this;
        }
        if (0 == sz) {
            return Str.of(list);
        }
        StringBuilder sb = new StringBuilder(sz + sz2).append(this.s);
        for (Character c : list) {
            sb.append(c);
        }
        return Str.of(sb);
    }

    @Override
    public Str append(char ... array) {
        int sz = this.s.length();
        int sz2 = array.length;
        if (0 == sz2) {
            return this;
        }
        if (0 == sz) {
            return Str.of(array);
        }
        StringBuilder sb = new StringBuilder(sz + sz2).append(this.s);
        char[] cArray = array;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            sb.append(c);
        }
        return Str.of(sb);
    }

    @Override
    public Str append(Character character) {
        StringBuilder sb = new StringBuilder(this.s).append(character);
        return Str.of(sb);
    }

    @Override
    public Str append(Str s) {
        if (s.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return s;
        }
        return Str.of(this.s.concat(s.s));
    }

    @Override
    public Str append(String s) {
        if ("".equals(s)) {
            return this;
        }
        if (EMPTY_STR.equals(this)) {
            return Str.of(s);
        }
        return Str.of(this.s.concat(s));
    }

    @Override
    public Str prepend(Collection<? extends Character> collection) {
        int sz = this.s.length();
        int sz2 = collection.size();
        if (0 == sz2) {
            return this;
        }
        if (0 == sz) {
            return Str.of(collection);
        }
        StringBuilder sb = new StringBuilder(sz + sz2);
        for (char c : collection) {
            sb.append(c);
        }
        sb.append(this.s);
        return Str.of(sb);
    }

    @Override
    public Str prepend(C.List<Character> list) {
        int sz = this.s.length();
        int sz2 = list.size();
        if (0 == sz2) {
            return this;
        }
        if (0 == sz) {
            return Str.of(list);
        }
        StringBuilder sb = new StringBuilder(sz + sz2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            sb.append(c);
        }
        sb.append(this.s);
        return Str.of(sb);
    }

    @Override
    public Str prepend(char ... chars) {
        int sz = this.s.length();
        int sz2 = chars.length;
        if (0 == sz2) {
            return this;
        }
        if (0 == sz) {
            return Str.of(chars);
        }
        StringBuilder sb = new StringBuilder(sz + sz2);
        for (char c : chars) {
            sb.append(c);
        }
        sb.append(this.s);
        return Str.of(sb);
    }

    @Override
    public Str prepend(Character character) {
        StringBuilder sb = new StringBuilder().append(character).append(this.s);
        return Str.of(sb);
    }

    @Override
    public Str prepend(Str s) {
        if (EMPTY_STR.equals(s)) {
            return this;
        }
        if (EMPTY_STR.equals(this)) {
            return s;
        }
        return Str.of(s.s.concat(this.s));
    }

    @Override
    public Str prepend(String s) {
        if ("".equals(s)) {
            return this;
        }
        if (EMPTY_STR.equals(this)) {
            return Str.of(s);
        }
        return Str.of(s.concat(this.s));
    }

    @Override
    public char charAt(int index) {
        return this.s.charAt(index);
    }

    @Override
    public Str subSequence(int start, int end) {
        return this.subList(start, end);
    }

    @Override
    public Str times(int n) {
        return Str.of(S.times(this.s, n));
    }

    @Override
    public Str padLeft(char c, int times) {
        char[] ca = new char[times];
        $.fill(c, ca);
        return this.prepend(ca);
    }

    @Override
    public Str lpad(char c, int times) {
        return this.padLeft(c, times);
    }

    @Override
    public Str padLeft(int times) {
        return this.padLeft(' ', times);
    }

    @Override
    public Str lpad(int times) {
        return this.padLeft(times);
    }

    @Override
    public Str padRight(char c, int times) {
        char[] ca = new char[times];
        $.fill(c, ca);
        return this.append(ca);
    }

    @Override
    public Str rpad(char c, int times) {
        return this.padRight(c, times);
    }

    @Override
    public Str padRight(int times) {
        return this.padRight(' ', times);
    }

    @Override
    public Str rpad(int times) {
        return this.padRight(times);
    }

    @Override
    public int compareTo(Str o) {
        return this.s.compareTo(o.s);
    }

    @Override
    public String toString() {
        return this.s;
    }

    @Override
    public FastStr toFastStr() {
        return FastStr.unsafeOf(this.s);
    }

    @Override
    public int hashCode() {
        return this.s.hashCode();
    }

    @Override
    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        this.s.getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    @Override
    public byte[] getBytes() {
        return this.s.getBytes();
    }

    @Override
    public byte[] getBytes(String charsetName) {
        if (null == charsetName) {
            return this.s.getBytes();
        }
        try {
            return this.s.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw E.encodingException(e);
        }
    }

    @Override
    public byte[] getBytes(Charset charset) {
        return null == charset ? this.s.getBytes() : this.s.getBytes(charset);
    }

    @Override
    public byte[] getBytesAscII() {
        if (this.isEmpty()) {
            return new byte[0];
        }
        return this.s.getBytes(Charsets.US_ASCII);
    }

    @Override
    public byte[] getBytesUTF8() {
        return this.s.getBytes(Charset.forName("UTF-8"));
    }

    @Override
    public boolean contentEquals(CharSequence x) {
        return this.s.contentEquals(x);
    }

    @Override
    public boolean contentEquals(Str x) {
        if (null == x) {
            return false;
        }
        return x.s.equals(this.s);
    }

    @Override
    public boolean equalsIgnoreCase(CharSequence x) {
        return null != x && this.s.equalsIgnoreCase(x.toString());
    }

    @Override
    public int compareTo(CharSequence x) {
        return this.s.compareTo(x.toString());
    }

    @Override
    public int compareToIgnoreCase(Str x) {
        return this.s.compareToIgnoreCase(x.s);
    }

    @Override
    public int compareToIgnoreCase(CharSequence x) {
        return this.s.compareToIgnoreCase(x.toString());
    }

    @Override
    public boolean regionMatches(boolean ignoreCase, int toffset, Str other, int ooffset, int len) {
        return this.s.regionMatches(ignoreCase, toffset, other.s, ooffset, len);
    }

    @Override
    public boolean regionMatches(boolean ignoreCase, int toffset, CharSequence other, int ooffset, int len) {
        return this.s.regionMatches(ignoreCase, toffset, other.toString(), ooffset, len);
    }

    @Override
    public boolean startsWith(Str prefix, int toffset) {
        return this.s.startsWith(prefix.s, toffset);
    }

    @Override
    public boolean startsWith(CharSequence prefix, int toffset) {
        return this.s.startsWith(prefix.toString(), toffset);
    }

    @Override
    private boolean endsWith(String suffix, int offset) {
        int prefixSz = suffix.length();
        if (0 == prefixSz) {
            return true;
        }
        int matchStart = this.length() - offset;
        if (matchStart < prefixSz) {
            return false;
        }
        String matchStr = this.s.substring(0, matchStart);
        return matchStr.endsWith(suffix);
    }

    @Override
    public boolean endsWith(CharSequence suffix, int offset) {
        return this.endsWith(suffix.toString(), offset);
    }

    @Override
    public boolean endsWith(Str suffix, int toffset) {
        return this.endsWith(suffix.toString(), toffset);
    }

    @Override
    public int indexOf(int ch, int fromIndex) {
        return this.s.indexOf(ch, fromIndex);
    }

    @Override
    public int lastIndexOf(int ch, int fromIndex) {
        return this.s.lastIndexOf(ch, fromIndex);
    }

    @Override
    public int indexOf(CharSequence str, int fromIndex) {
        return this.s.indexOf(str.toString(), fromIndex);
    }

    @Override
    public int indexOf(Str str, int fromIndex) {
        return this.s.indexOf(str.s, fromIndex);
    }

    @Override
    public int lastIndexOf(CharSequence str, int fromIndex) {
        return this.s.lastIndexOf(str.toString(), fromIndex);
    }

    @Override
    public int lastIndexOf(Str str, int fromIndex) {
        return this.s.lastIndexOf(str.s, fromIndex);
    }

    @Override
    public String substring(int beginIndex) {
        return this.s.substring(beginIndex);
    }

    @Override
    public String substring(int beginIndex, int endIndex) {
        return this.s.substring(beginIndex, endIndex);
    }

    @Override
    public Str replace(char oldChar, char newChar) {
        String s1 = this.s.replace(oldChar, newChar);
        if (s1 == this.s) {
            return this;
        }
        return Str.of(s1);
    }

    @Override
    public boolean matches(String regex) {
        return this.s.matches(regex);
    }

    @Override
    public boolean contains(CharSequence s) {
        return this.s.contains(s);
    }

    @Override
    public Str replaceFirst(String regex, String replacement) {
        return Str.of(this.s.replaceFirst(regex, replacement));
    }

    @Override
    public Str replaceAll(String regex, String replacement) {
        return Str.of(this.s.replaceAll(regex, replacement));
    }

    @Override
    public Str replace(CharSequence target, CharSequence replacement) {
        return Str.of(this.s.replace(target, replacement));
    }

    @Override
    public C.List<Str> split(String regex, int limit) {
        String[] sa = this.s.split(regex, limit);
        int len = sa.length;
        Str[] ssa = new Str[len];
        for (int i = 0; i < len; ++i) {
            ssa[i] = Str.of(sa[i]);
        }
        return C.listOf(ssa);
    }

    @Override
    public Str toLowerCase(Locale locale) {
        return Str.of(this.s.toLowerCase(locale));
    }

    @Override
    public Str toUpperCase(Locale locale) {
        return Str.of(this.s.toUpperCase(locale));
    }

    @Override
    public Str trim() {
        return Str.of(this.s.trim());
    }

    @Override
    public char[] charArray() {
        return this.s.toCharArray();
    }

    @Override
    public String intern() {
        return this.s.intern();
    }

    @Override
    public Str afterFirst(Str s) {
        return this.afterFirst(s.s);
    }

    @Override
    public Str afterLast(Str s) {
        return this.afterLast(s.s);
    }

    @Override
    public Str beforeLast(Str s) {
        return this.beforeLast(s.s);
    }

    @Override
    public Str afterFirst(String s) {
        return Str.of(S.afterFirst(this.s, s));
    }

    @Override
    public Str afterLast(String s) {
        return Str.of(S.afterLast(this.s, s));
    }

    @Override
    public Str afterFirst(char c) {
        return this.afterFirst(String.valueOf(c));
    }

    @Override
    public Str afterLast(char c) {
        return this.afterLast(String.valueOf(c));
    }

    @Override
    public Str beforeFirst(Str s) {
        return Str.of(S.beforeFirst(this.s, s.s));
    }

    @Override
    public Str beforeFirst(String s) {
        return Str.of(S.beforeFirst(this.s, s));
    }

    @Override
    public Str beforeLast(String s) {
        return Str.of(S.beforeLast(this.s, s));
    }

    @Override
    public Str strip(String prefix, String suffix) {
        return Str.of(S.strip(this.s, prefix, suffix));
    }

    @Override
    public Str beforeFirst(char c) {
        return this.beforeFirst(String.valueOf(c));
    }

    @Override
    public Str beforeLast(char c) {
        return this.beforeLast(String.valueOf(c));
    }

    @Override
    public Str urlEncode() {
        return Str.of(S.urlEncode(this.s));
    }

    @Override
    public Str decodeBASE64() {
        return Str.of(S.decodeBASE64(this.s));
    }

    @Override
    public Str encodeBASE64() {
        return Str.of(S.encodeBASE64(this.s));
    }

    @Override
    public Str capFirst() {
        return Str.of(S.capFirst(this.s));
    }

    @Override
    public int count(String search, boolean overlap) {
        return S.count(this.s, search, overlap);
    }

    @Override
    public int count(Str search, boolean overlap) {
        return S.count(this.s, search.s, overlap);
    }

    public static Str of(String s) {
        if (S.empty(s)) {
            return EMPTY_STR;
        }
        return new Str(s);
    }

    public static Str of(Character ... chars) {
        if (chars.length == 0) {
            return EMPTY_STR;
        }
        char[] ca = $.asPrimitive(chars);
        return new Str(new String(ca));
    }

    public static Str of(char ... ca) {
        if (ca.length == 0) {
            return EMPTY_STR;
        }
        return new Str(new String(ca));
    }

    public static Str of(StringBuilder sb) {
        if (sb.length() == 0) {
            return EMPTY_STR;
        }
        return new Str(sb.toString());
    }

    public static Str of(Iterable<Character> itr) {
        if (itr instanceof Str) {
            return (Str)itr;
        }
        if (itr instanceof Collection) {
            return Str.of((Collection)itr);
        }
        StringBuilder sb = new StringBuilder();
        for (Character c : itr) {
            sb.append(c);
        }
        return Str.of(sb);
    }

    public static Str of(Collection<Character> col) {
        if (col instanceof Str) {
            return (Str)col;
        }
        StringBuilder sb = new StringBuilder(col.size());
        sb.append((Object)col.toArray(new Character[0]));
        return Str.of(sb);
    }

    public static Str of(Iterator<Character> itr) {
        StringBuilder sb = new StringBuilder();
        while (itr.hasNext()) {
            sb.append(itr.next());
        }
        return Str.of(sb);
    }
}

