/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util.algo;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.algo.ArrayAlgorithm;
import org.osgl.util.algo.ArraySearch;

public class ArrayBinarySearch<T>
implements ArraySearch<T> {
    @Override
    public Integer apply(T[] ts, Integer from, Integer to, T key, final Comparator<T> comp) {
        ArrayAlgorithm.Util.checkIndex(ts, from, to);
        T t0 = ts[from];
        T tn = ts[to - 1];
        if (comp.compare(t0, key) == 0) {
            return 0;
        }
        if (comp.compare(tn, key) == 0) {
            return to - 1;
        }
        int i = comp.compare(t0, tn);
        if (i == 0) {
            return 0;
        }
        boolean ascending = i < 0;
        Comparator c = comp;
        if (!ascending) {
            c = new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    return comp.compare(o2, o1);
                }
            };
        }
        return this.search(ts, from, to - 1, key, c);
    }

    private int search(T[] ts, int from, int to, T k, Comparator<T> c) {
        while (from <= to) {
            int mid = from + to >>> 1;
            T tm = ts[mid];
            int cm = c.compare(tm, k);
            if (cm == 0) {
                return mid;
            }
            if (cm > 0) {
                to = mid - 1;
                continue;
            }
            from = mid + 1;
        }
        return -(from + 1);
    }

    private static Lang.T2<Long, Integer> osgl(Integer[] a, int k, ArrayBinarySearch<Integer> s) {
        long start = System.nanoTime();
        int loc = s.apply((T[])a, 0, a.length, k, Lang.F.NATURAL_ORDER);
        long time = System.nanoTime() - start;
        return $.T2(time, loc);
    }

    private static Lang.T2<Long, Integer> jdk(Integer[] a, int k) {
        long start = System.nanoTime();
        int loc = Arrays.binarySearch(a, k, Lang.F.NATURAL_ORDER);
        long time = System.nanoTime() - start;
        return $.T2(time, loc);
    }

    public static void main(String[] args) {
        ArrayBinarySearch.test();
    }

    private static void test() {
        ArrayBinarySearch<Integer> s = new ArrayBinarySearch<Integer>();
        Integer[] ia = new Integer[]{1, 20, 300, 4000, 50000};
        Lang.T2<Long, Integer> o = ArrayBinarySearch.osgl(ia, -1, s);
        Lang.T2<Long, Integer> j = ArrayBinarySearch.jdk(ia, -1);
        System.out.println(o._2 + ":" + j._2);
        o = ArrayBinarySearch.osgl(ia, 1000000, s);
        j = ArrayBinarySearch.jdk(ia, 1000000);
        System.out.println(o._2 + ":" + j._2);
        ia = new Integer[]{10, 8, 2, 1, -1};
        System.out.println(ArrayBinarySearch.osgl(ia, 3, s));
        ia = new Integer[]{-1, 1, 2, 8, 10};
        System.out.println(ArrayBinarySearch.osgl(ia, 0, s));
        System.out.println(ArrayBinarySearch.jdk(ia, 0));
    }

    private static void benchmark() {
        int MAX = 0x3FFFFF;
        int TIMES = 1000000;
        Integer[] ia = new Integer[0x3FFFFF];
        for (int i = 0; i < 0x3FFFFF; ++i) {
            ia[i] = i;
        }
        new ArrayBinarySearch<Integer>().apply((T[])ia, 0, ia.length, 48, Lang.F.NATURAL_ORDER);
        Lang.Var<Long> osgl = $.var(0L);
        Lang.Var<Long> jdk = $.var(0L);
        ArrayBinarySearch<Integer> s = new ArrayBinarySearch<Integer>();
        for (int time = 0; time < 1000000; ++time) {
            Random r = new Random();
            int k = r.nextInt(0x3FFFFF);
            Lang.T2<Long, Integer> jdkRet = ArrayBinarySearch.jdk(ia, k);
            Lang.T2<Long, Integer> osglRet = ArrayBinarySearch.osgl(ia, k, s);
            if (!((Integer)jdkRet._2).equals(osglRet._2)) {
                throw new RuntimeException(String.format("jdk: %s; osgl: %s; k: %s", jdkRet._2, osglRet._2, k));
            }
            if (time <= 0) continue;
            jdk.set((Long)jdkRet._1 + jdk.get());
            osgl.set((Long)osglRet._1 + osgl.get());
        }
        System.out.println(String.format("osgl: %s; jdk: %s", osgl.get() / 1000000L, jdk.get() / 1000000L));
    }
}

