/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util.algo;

import org.osgl.$;
import org.osgl.Lang;
import org.osgl.OsglConfig;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.S;
import org.osgl.util.algo.StringSearch;

public abstract class StringReplace
implements Lang.Func4<char[], char[], char[], Integer, char[]> {
    @Override
    public final char[] apply(char[] text, char[] target, char[] replacement, Integer firstId) throws NotAppliedException, Lang.Break {
        return this.replace(text, target, replacement, firstId);
    }

    public abstract char[] replace(char[] var1, char[] var2, char[] var3, int var4);

    public static StringReplace wrap(final Lang.Func4<char[], char[], char[], Integer, char[]> replaceLogic) {
        return $.notNull(replaceLogic) instanceof StringReplace ? (StringReplace)replaceLogic : new StringReplace(){

            @Override
            public char[] replace(char[] text, char[] target, char[] replacement, int firstId) {
                return (char[])replaceLogic.apply(text, target, replacement, firstId);
            }
        };
    }

    public static class SimpleStringReplace
    extends StringReplace {
        private final StringSearch searcher;

        public SimpleStringReplace(StringSearch searcher) {
            this.searcher = $.notNull(searcher);
        }

        public SimpleStringReplace() {
            this(OsglConfig.DEF_STRING_SEARCH);
        }

        @Override
        public char[] replace(char[] text, char[] target, char[] replacement, int firstId) {
            StringSearch searcher = this.searcher;
            int textLen = text.length;
            int targetLen = target.length;
            int i = 0;
            int j = 0;
            if (textLen == 0 || targetLen == 0) {
                return text;
            }
            int n = i = firstId < 0 ? searcher.search(text, target, 0) : firstId;
            if (i < 0) {
                return text;
            }
            S.Buffer buf = S.buffer();
            if (i > j) {
                buf.append(text, j, i - j);
            }
            buf.append(replacement);
            j = i += targetLen;
            while ((i = searcher.search(text, target, i)) >= 0) {
                if (i > j) {
                    buf.append(text, j, i - j);
                }
                buf.append(replacement);
                j = i += targetLen;
            }
            if (textLen > j) {
                buf.append(text, j, textLen - j);
            }
            int len = buf.length();
            char[] result = new char[len];
            buf.getChars(0, len, result, 0);
            return result;
        }
    }
}

