/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util.converter;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.N;
import org.osgl.util.S;

public class TypeConverterRegistry {
    public static Lang.TypeConverter ME_TO_ME = new Lang.TypeConverter(false){

        public Object convert(Object o) {
            return o;
        }
    };
    private Map<Class, Node> nodeMap = new IdentityHashMap<Class, Node>();
    private Map<Lang.TypeConverter, Link> linkMap = new IdentityHashMap<Lang.TypeConverter, Link>();
    private static final Map<Class, Object> NULL_VALS = C.Map(Boolean.TYPE, false, Character.TYPE, Character.valueOf('\u0000'), Byte.TYPE, 0, Short.TYPE, 0, Integer.TYPE, 0, Float.TYPE, 0, Long.TYPE, 0, Double.TYPE, 0);
    public static final Lang.TypeConverter<Void, Object> NULL_CONVERTER = new Lang.TypeConverter<Void, Object>(Void.class, Object.class){

        @Override
        public Object convert(Void aVoid) {
            return null;
        }
    };
    public static final TypeConverterRegistry INSTANCE = new TypeConverterRegistry(true);
    private Map<Lang.Pair<Class, Class>, Lang.TypeConverter> paths = new HashMap<Lang.Pair<Class, Class>, Lang.TypeConverter>();
    private TypeConverterRegistry parent;

    private synchronized Node nodeOf(Class<?> type) {
        Node node = this.nodeMap.get(type);
        if (null == node) {
            node = new Node(type, this);
            this.nodeMap.put(type, node);
        }
        return node;
    }

    public TypeConverterRegistry() {
        this(false);
    }

    private TypeConverterRegistry(boolean isGlobalInstance) {
        if (isGlobalInstance) {
            this.registerBuiltInConverters();
        } else {
            this.parent = INSTANCE;
        }
    }

    public synchronized <FROM, TO> Lang.TypeConverter<FROM, TO> get(Class<FROM> fromType, Class<TO> toType) {
        Node node;
        Link link;
        fromType = fromType.isArray() ? fromType : $.wrapperClassOf(fromType);
        Class clazz = toType = toType.isArray() ? toType : $.wrapperClassOf(toType);
        if (fromType == toType || fromType.isAssignableFrom(toType)) {
            return ME_TO_ME;
        }
        Lang.Pair<Class, Class> key = this.keyOf(fromType, toType);
        Lang.TypeConverter<Object, Object> converter = this.paths.get(key);
        if (null == converter && null != (link = (node = this.nodeOf(fromType)).pathTo(this.nodeOf(toType), this, new HashSet()))) {
            this.paths.put(key, link.converter);
            return link.converter;
        }
        if (null == converter) {
            if (null != this.parent) {
                converter = this.parent.get(fromType, toType);
            } else if (String.class == toType) {
                converter = Lang.TypeConverter.ANY_TO_STRING;
                this.paths.put(key, converter);
            } else if (Boolean.class == toType) {
                converter = Lang.TypeConverter.ANY_TO_BOOLEAN;
                this.paths.put(key, converter);
            }
        }
        return converter;
    }

    public synchronized TypeConverterRegistry register(Lang.TypeConverter typeConverter) {
        if (!this.linkMap.containsKey(typeConverter)) {
            this.linkMap.put(typeConverter, new Link(typeConverter, this));
            Lang.Pair<Class, Class> key = this.keyOf(typeConverter);
            this.addIntoPath(key, typeConverter);
        }
        return this;
    }

    public int size() {
        return this.paths.size();
    }

    private void register(Lang.TypeConverter typeConverter, Lang.Pair<Class, Class> key) {
        this.addIntoPath(key, typeConverter);
        this.buildPaths(typeConverter, (Class)key.left(), (Class)key.right());
    }

    private void registerBuiltInConverters() {
        for (Class<? extends Number> clazz : N.NUMBER_CLASSES) {
            this.addIntoPath(this.keyOf(clazz, Number.class), new Lang.TypeConverter(clazz, Number.class){

                public Object convert(Object o) {
                    return o;
                }
            });
        }
        for (Field field : Lang.TypeConverter.class.getFields()) {
            if (!Lang.TypeConverter.class.isAssignableFrom(field.getType())) continue;
            try {
                Lang.TypeConverter converter = (Lang.TypeConverter)$.cast(field.get(null));
                this.register(converter);
            }
            catch (IllegalAccessException e) {
                throw E.unexpected(e);
            }
        }
        for (final Map.Entry entry : NULL_VALS.entrySet()) {
            this.register(new Lang.TypeConverter<Void, Object>(Void.class, (Class)entry.getKey()){

                @Override
                public Object convert(Void aVoid) {
                    return entry.getValue();
                }
            });
        }
        this.register(NULL_CONVERTER);
    }

    private Lang.Pair<Class, Class> keyOf(Class<?> from, Class<?> to) {
        return (Lang.Pair)$.cast($.Pair(from, to));
    }

    private Lang.Pair<Class, Class> keyOf(Lang.TypeConverter typeConverter) {
        return $.Pair(typeConverter.fromType, typeConverter.toType);
    }

    private List<Lang.Pair<Class, Class>> allKeyOf(Lang.TypeConverter typeConverter) {
        ArrayList<Lang.Pair<Class, Class>> set = new ArrayList<Lang.Pair<Class, Class>>();
        Class fromType = typeConverter.fromType;
        Class toType = typeConverter.toType;
        set.add($.Pair(fromType, toType));
        for (Class intf : $.interfacesOf(toType)) {
            if (intf == Comparable.class || intf == Serializable.class) continue;
            set.add($.Pair(fromType, intf));
        }
        for (Class parent : $.superClassesOf(toType)) {
            if (parent == Object.class) continue;
            set.add($.Pair(fromType, parent));
        }
        return set;
    }

    private void buildPaths(Lang.TypeConverter typeConverter) {
        this.buildPaths(typeConverter, typeConverter.fromType, typeConverter.toType);
    }

    private void buildPaths(Lang.TypeConverter typeConverter, Class fromType, Class toType) {
        Set<Lang.TypeConverter> upstreams = this.upstreams(fromType);
        for (Lang.TypeConverter upstream : upstreams) {
            ChainedConverter chained = new ChainedConverter(upstream, typeConverter);
            Lang.Pair<Class, Class> key = this.keyOf(chained);
            Lang.TypeConverter current = this.paths.get(key);
            if (null != current && !TypeConverterRegistry.isShorterPath(chained, current)) continue;
            if (typeConverter.fromType.isAssignableFrom(upstream.fromType)) {
                this.register(typeConverter, key);
                continue;
            }
            this.register(chained, key);
        }
        Set<Lang.TypeConverter> downstreams = this.downstreams(toType);
        for (Lang.TypeConverter downstream : downstreams) {
            ChainedConverter chained = new ChainedConverter(typeConverter, downstream);
            Lang.Pair<Class, Class> key = this.keyOf(chained);
            Lang.TypeConverter current = this.paths.get(key);
            if (null != current && !TypeConverterRegistry.isShorterPath(chained, current)) continue;
            if (downstream.toType.isAssignableFrom(typeConverter.toType)) {
                this.register(typeConverter, key);
                continue;
            }
            this.register(chained, key);
        }
    }

    private Set<Lang.TypeConverter> upstreams(Class toType) {
        HashSet<Lang.TypeConverter> set = new HashSet<Lang.TypeConverter>();
        for (Map.Entry<Lang.Pair<Class, Class>, Lang.TypeConverter> entry : this.paths.entrySet()) {
            if (!toType.isAssignableFrom((Class)entry.getKey().right())) continue;
            set.add(entry.getValue());
        }
        return set;
    }

    private Set<Lang.TypeConverter> downstreams(Class fromType) {
        HashSet<Lang.TypeConverter> set = new HashSet<Lang.TypeConverter>();
        for (Map.Entry<Lang.Pair<Class, Class>, Lang.TypeConverter> entry : this.paths.entrySet()) {
            if (!((Class)entry.getKey().left()).isAssignableFrom(fromType)) continue;
            set.add(entry.getValue());
        }
        return set;
    }

    private void addIntoPath(Lang.Pair<Class, Class> key, Lang.TypeConverter converter) {
        Class primitiveToType;
        this.paths.put(key, converter);
        Class toType = (Class)key.right();
        if (Number.class.isAssignableFrom(toType) && null != (primitiveToType = $.primitiveTypeOf(toType)) && toType != primitiveToType) {
            this.addIntoPath(key.set2(primitiveToType), converter);
        }
    }

    private static boolean isShorterPath(Lang.TypeConverter left, Lang.TypeConverter right) {
        int rightHops;
        int leftHops = TypeConverterRegistry.hops(left);
        return leftHops < (rightHops = TypeConverterRegistry.hops(right));
    }

    private static int hops(Lang.TypeConverter typeConverter) {
        if (!(typeConverter instanceof ChainedConverter)) {
            return TypeConverterRegistry.distance(typeConverter);
        }
        ChainedConverter chainedConverter = (ChainedConverter)$.cast(typeConverter);
        return TypeConverterRegistry.hops(chainedConverter.upstream) + TypeConverterRegistry.hops(chainedConverter.downstream);
    }

    private static int distance(Lang.TypeConverter typeConverter) {
        return TypeConverterRegistry.distance(typeConverter.fromType) + TypeConverterRegistry.distance(typeConverter.toType);
    }

    private static int distance(Class<?> type) {
        if (type == Object.class) {
            return 100;
        }
        if (type.isInterface()) {
            Set<Class> interfaces = $.interfacesOf(type);
            return 100 - interfaces.size();
        }
        if (type.isArray()) {
            return TypeConverterRegistry.distance(type.getComponentType());
        }
        if ($.isSimpleType(type)) {
            return 0;
        }
        return TypeConverterRegistry.distance(type.getSuperclass()) - 1;
    }

    private static int distanceBetween(Class<?> source, Class<?> target) {
        return Math.abs(TypeConverterRegistry.distance(source) - TypeConverterRegistry.distance(target));
    }

    private static class ChainedConverter
    extends Lang.TypeConverter {
        private final Lang.TypeConverter upstream;
        private final Lang.TypeConverter downstream;

        public ChainedConverter(Lang.TypeConverter upstream, Lang.TypeConverter downStream) {
            super(upstream.fromType, downStream.toType);
            this.upstream = upstream;
            this.downstream = downStream;
        }

        @Override
        public int hops() {
            return this.upstream.hops() + this.downstream.hops();
        }

        public Object convert(Object o) {
            return this.downstream.convert(this.upstream.convert(o));
        }

        @Override
        public String toString() {
            return S.concat(this.upstream, (Object)" | ", this.downstream);
        }
    }

    private static class Link {
        private Node from;
        private Node to;
        private Lang.TypeConverter converter;

        private Link(Lang.TypeConverter converter, TypeConverterRegistry registry) {
            this.from = registry.nodeOf(converter.fromType);
            this.to = registry.nodeOf(converter.toType);
            this.converter = converter;
            this.from.addFanOut(this);
            this.to.addFanIn(this);
        }

        public String toString() {
            return S.fmt("%s => %s", this.from, this.to);
        }

        private Link cascadeWith(Link downstream, TypeConverterRegistry registry) {
            E.unexpectedIfNot(downstream.isSource(this.to));
            ChainedConverter chained = new ChainedConverter(this.converter, downstream.converter);
            return new Link(chained, registry);
        }

        private boolean isSource(Node node) {
            if (node == this.from || this.from.subTypes.contains(node)) {
                return true;
            }
            if (this.from.type.isAssignableFrom(node.type)) {
                this.from.subTypes.add(node);
                return true;
            }
            return false;
        }

        private boolean isTarget(Node node) {
            return node == this.to || node.superTypes.contains(this.to);
        }
    }

    private static class Node {
        private Comparator<Node> nodeComparator = new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                return this.distanceTo(o1.type) - this.distanceTo(o2.type);
            }

            private int distanceTo(Class<?> target) {
                return TypeConverterRegistry.distanceBetween(Node.this.type, target);
            }
        };
        private Comparator<Link> linkComparator = new Comparator<Link>(){

            @Override
            public int compare(Link o1, Link o2) {
                if (o1 == o2) {
                    return 0;
                }
                int n = o1.converter.hops() - o2.converter.hops();
                if (n != 0) {
                    return n;
                }
                Node from1 = o1.from;
                Node to1 = o1.to;
                Node from2 = o2.from;
                Node to2 = o2.to;
                n = TypeConverterRegistry.distanceBetween(from1.type, to1.type) - TypeConverterRegistry.distanceBetween(from2.type, to2.type);
                if (n != 0) {
                    return n;
                }
                if (from1 == from2) {
                    return to1.toString().compareTo(to2.toString());
                }
                if (to1 == to2) {
                    return from1.toString().compareTo(from2.toString());
                }
                return o1.toString().compareTo(o2.toString());
            }
        };
        private Class<?> type;
        private SortedSet<Node> superTypes = new TreeSet<Node>(this.nodeComparator);
        private SortedSet<Node> subTypes = new TreeSet<Node>(this.nodeComparator);
        private SortedSet<Link> fanIn = new TreeSet<Link>(this.linkComparator);
        private HashMap<Node, Link> fanOut = new HashMap();

        private Node(Class<?> type, TypeConverterRegistry registry) {
            this.type = $.requireNotNull(type);
            this.exploreSuperTypes(registry);
        }

        public String toString() {
            return S.fmt("[%s]", this.type.getName());
        }

        private void addFanIn(Link link) {
            this.fanIn.add(link);
            for (Node superType : this.superTypes) {
                superType.fanIn.add(link);
            }
        }

        private void addFanOut(Link link) {
            Link existing = this.fanOut.get(link.to);
            if (null == existing || this.linkComparator.compare(link, existing) < 0) {
                this.fanOut.put(link.to, link);
                for (Node subType : this.subTypes) {
                    existing = subType.fanOut.get(link.to);
                    if (null != existing && this.linkComparator.compare(link, existing) >= 0) continue;
                    subType.fanOut.put(link.to, link);
                }
            }
        }

        private List<Link> fanOutLinks() {
            ArrayList<Link> links = new ArrayList<Link>();
            links.addAll(this.fanOut.values());
            Collections.sort(links, this.linkComparator);
            return links;
        }

        private void exploreSuperTypes(TypeConverterRegistry registry) {
            Set<Class> interfaces = $.interfacesOf(this.type);
            for (Class intf : interfaces) {
                if (intf == Serializable.class || intf == Comparable.class) continue;
                Node superNode = registry.nodeOf(intf);
                this.superTypes.add(superNode);
                superNode.subTypes.add(this);
            }
            for (Class<?> superType = this.type.getSuperclass(); superType != null && superType != Object.class; superType = superType.getSuperclass()) {
                Node superNode = registry.nodeOf(superType);
                this.superTypes.add(superNode);
                superNode.subTypes.add(this);
            }
        }

        private Link pathTo(Node target, TypeConverterRegistry registry, Set<Node> recursiveDetector) {
            Link directLink = this.fanOut.get(target);
            if (null != directLink) {
                return directLink;
            }
            TreeSet<Link> candidates = new TreeSet<Link>(this.linkComparator);
            this.exploreLinks(candidates, target, registry, recursiveDetector);
            return candidates.isEmpty() ? null : (Link)candidates.iterator().next();
        }

        private void exploreLinks(Set<Link> linkJar, Node target, TypeConverterRegistry registry, Set<Node> recursiveDetector) {
            Link direct = this.fanOut.get(target);
            if (null != direct) {
                linkJar.add(direct);
                return;
            }
            for (Link link : this.fanOutLinks()) {
                if (link.to == this || recursiveDetector.contains(link.to) || recursiveDetector.contains(link.from)) continue;
                recursiveDetector.add(link.to);
                recursiveDetector.add(link.from);
                Link downstream = link.to.pathTo(target, registry, recursiveDetector);
                recursiveDetector.remove(link.to);
                recursiveDetector.remove(link.from);
                if (null == downstream) continue;
                linkJar.add(link.cascadeWith(downstream, registry));
            }
            for (Node superType : this.superTypes) {
                superType.exploreLinks(linkJar, target, registry, recursiveDetector);
            }
        }
    }
}

