/*
 * Decompiled with CFR 0.152.
 */
package org.osgl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;
import org.osgl.util.UtilConfig;
import org.osgl.util.algo.StringReplace;
import org.osgl.util.algo.StringSearch;

public class OsglConfig {
    public static StringSearch DEF_STRING_SEARCH = new StringSearch.SimpleStringSearch();
    public static StringReplace DEF_STRING_REPLACE = new StringReplace.SimpleStringReplace();
    public static Lang.Function<Class, ?> INSTANCE_FACTORY = new Lang.Function<Class, Object>(){

        @Override
        public Object apply(Class aClass) throws NotAppliedException, Lang.Break {
            if (List.class == aClass) {
                return new ArrayList();
            }
            if (Map.class == aClass) {
                return new HashMap();
            }
            if (Set.class == aClass) {
                return new HashSet();
            }
            if (SortedSet.class == aClass) {
                return new TreeSet();
            }
            if (SortedMap.class == aClass) {
                return new TreeMap();
            }
            return $.newInstance(aClass);
        }
    };
    private static final Set<String> immutableClassNames = new HashSet<String>();
    private static Set<String> mappingDisabledFields;
    private static List<Lang.Predicate<String>> mappingDisabledFieldPredicates;

    public static void registerImmutableClassNames(Collection<String> immutableClassNames) {
        OsglConfig.immutableClassNames.addAll(immutableClassNames);
    }

    static boolean isImmutable(Class<?> c) {
        return immutableClassNames.contains(c.getName());
    }

    public static boolean globalMappingFilter_shouldIgnore(String s) {
        if (mappingDisabledFields.contains(s)) {
            return true;
        }
        if (mappingDisabledFieldPredicates.isEmpty()) {
            return false;
        }
        for (Lang.Predicate<String> tester : mappingDisabledFieldPredicates) {
            if (!tester.test(s)) continue;
            return true;
        }
        return false;
    }

    public static void addGlobalMappingFilters(String filterSpec, String ... filterSpecs) {
        OsglConfig.addGlobalMappingFilter(filterSpec);
        for (String s : filterSpecs) {
            OsglConfig.addGlobalMappingFilter(s);
        }
    }

    public static void addGlobalMappingFilters(Collection<String> filterSpecs) {
        for (String filter : filterSpecs) {
            OsglConfig.addGlobalMappingFilter(filter);
        }
    }

    public static void addGlobalMappingFilter(String filterSpec) {
        S.List list = S.fastSplit(filterSpec, ",");
        for (String s : list) {
            if (S.blank(s)) continue;
            OsglConfig.addSingleGlobalMappingFilter(s.trim());
        }
    }

    private static void addSingleGlobalMappingFilter(String filterSpec) {
        E.illegalArgumentIf(S.blank(filterSpec), "Invalid filter: " + filterSpec);
        if (filterSpec.startsWith("contains:")) {
            String text = filterSpec.substring(9);
            E.illegalArgumentIf(S.blank(text), "Invalid filter: " + filterSpec);
            mappingDisabledFieldPredicates.add(S.F.contains(text));
        } else if (filterSpec.startsWith("reg:")) {
            String text = filterSpec.substring(4);
            E.illegalArgumentIf(S.blank(text), "Invalid filter: " + filterSpec);
            final Pattern pattern = Pattern.compile(text);
            mappingDisabledFieldPredicates.add(new Lang.Predicate<String>(){

                @Override
                public boolean test(String s) {
                    return pattern.matcher(s).matches();
                }
            });
        } else if (filterSpec.startsWith("starts:")) {
            String text = filterSpec.substring(7);
            E.illegalArgumentIf(S.blank(text), "Invalid filter: " + filterSpec);
            mappingDisabledFieldPredicates.add(S.F.startsWith(text));
        } else if (filterSpec.startsWith("ends:")) {
            String text = filterSpec.substring(5);
            E.illegalArgumentIf(S.blank(text), "Invalid filter: " + filterSpec);
            mappingDisabledFieldPredicates.add(S.F.endsWith(text));
        } else {
            mappingDisabledFields.add(filterSpec);
        }
    }

    public static void setThreadLocalBufferLimit(int limit) {
        UtilConfig.setThreadLocalBufferLimit(limit);
    }

    public static void setThreadLocalCharBufferLimit(int limit) {
        UtilConfig.setThreadLocalCharBufferLimit(limit);
    }

    public static int getThreadLocalCharBufferLimit() {
        return UtilConfig.getThreadLocalCharBufferLimit();
    }

    public static void setThreadLocalCharBufferInitSize(int size) {
        UtilConfig.setThreadLocalCharBufferInitSize(size);
    }

    public static int getThreadLocalCharBufferInitSize() {
        return UtilConfig.getThreadLocalCharBufferInitSize();
    }

    public static void setThreadLocalByteArrayBufferLimit(int limit) {
        UtilConfig.setThreadLocalByteArrayBufferLimit(limit);
    }

    public static int getThreadLocalByteArrayBufferLimit() {
        return UtilConfig.getThreadLocalByteArrayBufferLimit();
    }

    public static void setThreadLocalByteArrayBufferInitSize(int size) {
        UtilConfig.setThreadLocalByteArrayBufferInitSize(size);
    }

    public static int getThreadLocalByteArrayBufferInitSize() {
        return UtilConfig.getThreadLocalByteArrayBufferInitSize();
    }

    public static void setInstanceFactory(Lang.Function<Class, ?> instanceFactory) {
        INSTANCE_FACTORY = $.requireNotNull(instanceFactory);
    }

    static {
        immutableClassNames.addAll(IO.read(OsglConfig.class.getResource("immutable-classes.list")).toLines());
        mappingDisabledFields = new HashSet<String>();
        mappingDisabledFieldPredicates = new ArrayList<Lang.Predicate<String>>();
    }
}

