/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;
import org.osgl.exception.UnexpectedException;
import org.osgl.util.Base64;
import org.osgl.util.Charsets;
import org.osgl.util.E;
import org.osgl.util.UrlSafeBase64;

public class Codec {
    public static final char URL_SAFE_BASE64_PADDING_CHAR = '~';

    public static String UUID() {
        return UUID.randomUUID().toString();
    }

    public static String uuid() {
        return Codec.UUID();
    }

    @Deprecated
    public static String encodeBASE64(String value) {
        return new String(Base64.encode(value.getBytes(Charsets.UTF_8)));
    }

    public static String encodeBase64(String value) {
        return new String(Base64.encode(value.getBytes(Charsets.UTF_8)));
    }

    public static String encodeUrlSafeBase64(String value) {
        return new String(UrlSafeBase64.encode(value.getBytes(Charsets.UTF_8)));
    }

    @Deprecated
    public static String encodeBASE64(byte[] value) {
        return Codec.encodeBase64(value);
    }

    public static String encodeBase64(byte[] value) {
        return new String(Base64.encode(value));
    }

    public static String encodeUrlSafeBase64(byte[] value) {
        return new String(UrlSafeBase64.encode(value));
    }

    @Deprecated
    public static byte[] decodeBASE64(String value) {
        return Base64.decode(value);
    }

    public static byte[] decodeBase64(String value) {
        return Base64.decode(value);
    }

    public static byte[] decodeUrlSafeBase64(String value) {
        return UrlSafeBase64.decode(value);
    }

    public static String hexMD5(String value) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(value.getBytes("utf-8"));
            byte[] digest = messageDigest.digest();
            return Codec.byteToHexString(digest);
        }
        catch (Exception ex) {
            throw new UnexpectedException(ex);
        }
    }

    public static String hexSHA1(String value) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(value.getBytes("utf-8"));
            byte[] digest = md.digest();
            return Codec.byteToHexString(digest);
        }
        catch (Exception ex) {
            throw new UnexpectedException(ex);
        }
    }

    public static String byteToHexString(byte[] bytes) {
        return DatatypeConverter.printHexBinary((byte[])bytes);
    }

    public static byte[] hexStringToByte(String hexString) {
        return DatatypeConverter.parseHexBinary((String)hexString);
    }

    public static String encodeUrl(String s, Charset enc) {
        try {
            return URLEncoder.encode(s, enc.name());
        }
        catch (UnsupportedEncodingException e) {
            throw E.encodingException(e);
        }
    }

    public static String encodeUrl(String s) {
        try {
            return URLEncoder.encode(s, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw E.encodingException(e);
        }
    }

    public static String decodeUrl(String s, Charset enc) {
        try {
            return URLDecoder.decode(s, enc.name());
        }
        catch (UnsupportedEncodingException e) {
            throw E.encodingException(e);
        }
    }

    public static String decodeUrl(String s) {
        try {
            return URLDecoder.decode(s, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw E.encodingException(e);
        }
    }
}

