/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.OsglConfig;
import org.osgl.exception.MappingException;
import org.osgl.exception.UnexpectedException;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.Keyword;
import org.osgl.util.S;
import org.osgl.util.converter.TypeConverterRegistry;

public class DataMapper {
    private MappingRule rule;
    private Semantic semantic;
    private StringBuilder context = new StringBuilder();
    private Set<Class> circularReferenceDetector;
    private PropertyFilter filter;
    private Object source;
    private Class<?> sourceType;
    private Object target;
    private Class<?> targetType;
    private ParameterizedType targetGenericType;
    private ParameterizedType targetComponentType;
    private Class<?> targetComponentRawType = Object.class;
    private Class<?> targetKeyType;
    Map<Class, Object> conversionHints;
    Lang.Function<Class, ?> instanceFactory;
    TypeConverterRegistry typeConverterRegistry;
    private boolean ignoreError;
    private boolean ignoreGlobalFilter;
    private Class rootClass;
    private List<Field> targetFields;
    private boolean targetIsArray;
    private boolean targetIsCollection;
    private boolean targetIsList;
    private boolean targetIsMap;
    private boolean targetIsPojo;
    private int targetLength = -1;
    private Collection targetCollection;
    private List targetList;
    private Map targetMap;

    public DataMapper(Object source, Object target, ParameterizedType targetGenericType, MappingRule rule, Semantic semantic, String filterSpec, boolean ignoreError, boolean ignoreGlobalFilter, Map<Class, Object> conversionHints, Lang.Function<Class, ?> instanceFactory, TypeConverterRegistry typeConverterRegistry, Class<?> rootClass) {
        this.targetType = target.getClass();
        E.illegalArgumentIf(DataMapper.isImmutable(this.targetType), "target type is immutable: " + this.targetType.getName());
        this.targetGenericType = targetGenericType;
        this.sourceType = source.getClass();
        this.rule = $.requireNotNull(rule);
        this.semantic = $.requireNotNull(semantic);
        this.filter = new PropertyFilter(filterSpec);
        this.conversionHints = null == conversionHints ? C.Map(new Object[0]) : conversionHints;
        this.instanceFactory = null == instanceFactory ? OsglConfig.INSTANCE_FACTORY : instanceFactory;
        this.source = source;
        this.target = target;
        this.ignoreError = ignoreError;
        this.ignoreGlobalFilter = ignoreGlobalFilter;
        this.typeConverterRegistry = null == typeConverterRegistry ? TypeConverterRegistry.INSTANCE : typeConverterRegistry;
        this.rootClass = null == rootClass ? Object.class : rootClass;
        this.circularReferenceDetector = new HashSet<Class>();
        this.circularReferenceDetector.add(this.targetType);
        E.illegalArgumentIfNot(this.rootClass.isAssignableFrom(this.targetType), "root class[%s] must be assignable from target type[%s]", rootClass.getName(), this.targetType.getName());
        this.doMapping();
    }

    private DataMapper(Object source, Object target, String targetName, ParameterizedType targetGenericType, DataMapper parentMapper) {
        this.sourceType = source.getClass();
        this.source = source;
        this.targetType = target.getClass();
        this.target = target;
        this.targetGenericType = targetGenericType;
        this.rule = parentMapper.rule;
        this.semantic = parentMapper.semantic;
        this.filter = parentMapper.filter;
        this.ignoreError = parentMapper.ignoreError;
        this.ignoreGlobalFilter = parentMapper.ignoreGlobalFilter;
        this.conversionHints = parentMapper.conversionHints;
        this.instanceFactory = parentMapper.instanceFactory;
        this.typeConverterRegistry = parentMapper.typeConverterRegistry;
        this.context = new StringBuilder();
        String parentContext = parentMapper.context.toString();
        this.context.append(parentContext);
        if (S.notBlank(targetName)) {
            if (S.notBlank(parentContext)) {
                this.context.append(".").append(targetName);
            } else {
                this.context.append(targetName);
            }
        }
        this.rootClass = Object.class;
        this.circularReferenceDetector = new HashSet<Class>();
        this.circularReferenceDetector.addAll(parentMapper.circularReferenceDetector);
        this.circularReferenceDetector.add(this.targetType);
        this.doMapping();
    }

    public Object getTarget() {
        return this.target;
    }

    private void doMapping() {
        try {
            this.probeTargetType();
            if (this.targetIsArray || this.targetIsCollection) {
                this.mapToArrayOrCollection();
            } else if (this.targetIsMap) {
                this.mapToMap();
            } else {
                this.mapToPojo();
            }
        }
        catch (MappingException e) {
            throw e;
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    private void mapToArrayOrCollection() {
        List sourceList = null;
        if (!DataMapper.isSequence(this.sourceType)) {
            if (this.semantic.isMapping()) {
                sourceList = this.convert(this.source).to(List.class);
            }
            if (null == sourceList) {
                this.logError("Cannot map source[%s] into array or collection", this.sourceType.getName());
                return;
            }
        } else {
            sourceList = this.convert(this.source).to(List.class);
        }
        Object nullVal = $.convert(null).to(this.targetComponentRawType);
        if (this.semantic.isCopy()) {
            int i;
            if (this.targetIsArray) {
                for (i = 0; i < this.targetLength; ++i) {
                    Array.set(this.target, i, nullVal);
                }
            } else if (this.targetIsList) {
                for (i = 0; i < this.targetLength; ++i) {
                    this.targetList.set(i, nullVal);
                }
            } else {
                this.targetCollection.clear();
            }
        }
        int sourceLength = sourceList.size();
        int originTargetLength = this.targetLength;
        if (this.targetLength < sourceLength) {
            if (this.targetIsArray) {
                Object target0 = this.target;
                this.target = Array.newInstance(this.targetComponentRawType, sourceLength);
                System.arraycopy(target0, 0, this.target, 0, this.targetLength);
                this.targetLength = sourceLength;
            } else if (this.targetIsList) {
                for (int i = this.targetLength; i < sourceLength; ++i) {
                    this.targetList.add(nullVal);
                }
                this.targetLength = sourceLength;
            }
        }
        boolean targetComponentIsContainer = DataMapper.isContainer(this.targetComponentRawType);
        Iterator itr = sourceList.iterator();
        int cursor = 0;
        while (itr.hasNext()) {
            Object sourceComponent = itr.next();
            if (null == sourceComponent) {
                if (this.semantic.isMapping() || this.semantic.isMerge()) continue;
                if (this.targetIsList) {
                    this.targetList.set(cursor++, nullVal);
                    continue;
                }
                if (!this.targetIsArray) continue;
                Array.set(this.target, cursor++, nullVal);
                continue;
            }
            boolean componentRawTypeMatches = $.is(sourceComponent).allowBoxing().instanceOf(this.targetComponentRawType);
            if (!this.semantic.isMapping() && !componentRawTypeMatches) {
                this.logError("component type mismatch. Source component type: %s, target component type: %s", sourceComponent.getClass().getName(), this.targetComponentRawType.getName());
                continue;
            }
            Object targetComponent = null;
            if ((this.targetIsArray || this.targetIsList) && !this.semantic.isCopy() && cursor < originTargetLength) {
                if (this.targetIsArray) {
                    targetComponent = Array.get(this.target, cursor);
                } else if (this.targetIsList) {
                    targetComponent = this.targetList.get(cursor);
                }
            }
            targetComponent = this.prepareTargetComponent(sourceComponent, targetComponent, this.targetComponentRawType, this.targetComponentType, targetComponentIsContainer, "");
            if (this.targetIsArray || this.targetIsList) {
                if (this.targetIsList) {
                    this.targetList.set(cursor++, targetComponent);
                    continue;
                }
                if (!this.targetIsArray) continue;
                Array.set(this.target, cursor++, targetComponent);
                continue;
            }
            this.targetCollection.add(targetComponent);
        }
    }

    private void mapToMap() {
        boolean targetComponentIsSequence;
        this.targetMap.clear();
        HashMap targetMapKeywordLookup = null;
        if (this.rule.keywordMatching() && String.class == this.targetKeyType) {
            targetMapKeywordLookup = new HashMap();
            for (Object key : this.targetMap.keySet()) {
                targetMapKeywordLookup.put(Keyword.of(key.toString()), key);
            }
        }
        boolean targetComponentIsMap = !(targetComponentIsSequence = DataMapper.isSequence(this.targetComponentRawType)) && DataMapper.isMap(this.targetComponentRawType);
        boolean targetComponentIsContainer = targetComponentIsMap || targetComponentIsSequence;
        String prefix = this.context.toString();
        for (Lang.Triple<Object, Keyword, Lang.Producer<Object>> sourceProperty : this.sourceProperties()) {
            Object sourceKey = sourceProperty.first();
            if (!this.ignoreGlobalFilter && sourceKey instanceof String && OsglConfig.globalMappingFilter_shouldIgnore(sourceKey.toString())) continue;
            if (!this.semantic.isMapping() && !$.is(sourceKey).allowBoxing().instanceOf(this.targetKeyType)) {
                this.logError("map key type mismatch, required: %s; found: %s", this.targetKeyType, sourceKey.getClass().getName());
                continue;
            }
            Object sourceVal = sourceProperty.last().produce();
            if (null == sourceVal) continue;
            Keyword sourceKeyword = sourceProperty.second();
            Object targetKey = null;
            if (targetMapKeywordLookup != null) {
                targetKey = targetMapKeywordLookup.get(sourceKeyword);
            }
            if (targetKey == null) {
                targetKey = this.semantic.isMapping() ? this.convert(sourceKey).to(this.targetKeyType) : sourceKey;
            }
            String key = S.notBlank(prefix) ? S.pathConcat(prefix, '.', targetKey.toString()) : targetKey.toString();
            Object targetVal = this.targetMap.get(targetKey);
            targetVal = this.prepareTargetComponent(sourceVal, targetVal, this.targetComponentRawType, this.targetComponentType, targetComponentIsContainer, "");
            this.targetMap.put(targetKey, targetVal);
        }
    }

    private void mapToPojo() {
        Map sourceMap = Map.class.isAssignableFrom(this.sourceType) ? (Map)this.source : null;
        HashMap sourceMapByKeyword = null;
        if (this.rule.keywordMatching()) {
            sourceMapByKeyword = new HashMap();
            if (null != sourceMap) {
                for (Map.Entry entry : sourceMap.entrySet()) {
                    sourceMapByKeyword.put(Keyword.of(entry.getKey().toString()), entry.getValue());
                }
            } else {
                for (Field field : $.fieldsOf(this.sourceType)) {
                    sourceMapByKeyword.put(Keyword.of(field.getName()), field);
                }
            }
        }
        String prefix = this.context.toString();
        for (Field targetField : this.targetFields) {
            Object sourcePropValue;
            ParameterizedType targetFieldGenericType;
            String key;
            Class<?> targetFieldType = targetField.getType();
            if (this.circularReferenceDetector.contains(targetFieldType)) continue;
            String targetFieldName = targetField.getName();
            if (!this.ignoreGlobalFilter && OsglConfig.globalMappingFilter_shouldIgnore(targetFieldName) || !this.filter.test(key = S.notBlank(prefix) ? S.pathConcat(prefix, '.', targetFieldName) : targetFieldName)) continue;
            Type type = targetField.getGenericType();
            ParameterizedType parameterizedType = targetFieldGenericType = type instanceof ParameterizedType ? (ParameterizedType)type : null;
            if (null != sourceMapByKeyword) {
                sourcePropValue = sourceMapByKeyword.get(Keyword.of(targetFieldName));
                if (null == sourcePropValue) continue;
                if (sourcePropValue instanceof Field) {
                    sourcePropValue = $.getFieldValue(this.source, (Field)sourcePropValue);
                }
            } else if (null != sourceMap) {
                sourcePropValue = sourceMap.get(targetFieldName);
            } else {
                Field sourceField = $.fieldOf(this.sourceType, targetFieldName);
                if (null == sourceField) continue;
                sourcePropValue = $.getFieldValue(this.source, sourceField);
            }
            if (null == sourcePropValue) {
                if (!this.semantic.isCopy()) continue;
                $.setFieldValue(this.target, targetField, $.convert(null).to(targetFieldType));
                continue;
            }
            boolean targetFieldIsContainer = DataMapper.isContainer(targetFieldType);
            if (!(targetFieldIsContainer || this.semantic.isMapping() || $.is(sourcePropValue).allowBoxing().instanceOf(targetFieldType))) {
                this.logError("Type mismatch copy source [%s] to field[%s|%s]", sourcePropValue.getClass().getName(), targetFieldName, targetFieldType.getName());
                continue;
            }
            Object targetFieldValue = $.getFieldValue(this.target, targetField);
            targetFieldValue = this.prepareTargetComponent(sourcePropValue, targetFieldValue, targetFieldType, targetFieldGenericType, targetFieldIsContainer, targetFieldName);
            $.setFieldValue(this.target, targetField, targetFieldValue);
        }
    }

    private Iterable<Lang.Triple<Object, Keyword, Lang.Producer<Object>>> sourceProperties() {
        if (Map.class.isAssignableFrom(this.sourceType)) {
            return C.list(((Map)this.source).entrySet()).map(new Lang.Transformer<Map.Entry, Lang.Triple<Object, Keyword, Lang.Producer<Object>>>(){

                @Override
                public Lang.Triple<Object, Keyword, Lang.Producer<Object>> transform(final Map.Entry entry) {
                    Lang.Producer<Object> producer = new Lang.Producer<Object>(){

                        @Override
                        public Object produce() {
                            return entry.getValue();
                        }
                    };
                    Object key = entry.getKey();
                    Keyword keyword = null;
                    if (DataMapper.this.rule.keywordMatching() && key instanceof String) {
                        keyword = Keyword.of(key.toString());
                    }
                    return $.T3(key, keyword, producer);
                }
            });
        }
        List<Field> fields = $.fieldsOf(this.sourceType);
        return C.list(fields).filter(this.fieldFilter()).map(new Lang.Transformer<Field, Lang.Triple<Object, Keyword, Lang.Producer<Object>>>(){

            @Override
            public Lang.Triple<Object, Keyword, Lang.Producer<Object>> transform(final Field field) {
                String name = field.getName();
                Keyword keyword = null;
                if (DataMapper.this.rule.keywordMatching()) {
                    keyword = Keyword.of(name.toString());
                }
                Lang.Producer<Object> producer = new Lang.Producer<Object>(){

                    @Override
                    public Object produce() {
                        return $.getFieldValue(DataMapper.this.source, field);
                    }
                };
                return $.T3(name, keyword, producer);
            }
        });
    }

    private Lang.Predicate<Field> fieldFilter() {
        if (this.filter.allEmpty) {
            return Lang.F.yes();
        }
        return new Lang.Predicate<Field>(){

            @Override
            public boolean test(Field field) {
                String key = field.getName();
                if (OsglConfig.globalMappingFilter_shouldIgnore(key)) {
                    return false;
                }
                String prefix = DataMapper.this.context.toString();
                if (S.notBlank(prefix)) {
                    key = S.pathConcat(prefix, '.', key);
                }
                return DataMapper.this.filter.test(key);
            }
        };
    }

    private Object prepareTargetComponent(Object sourceComponent, Object targetComponent, Class targetComponentType, ParameterizedType targetComponentGenericType, boolean targetComponentIsContainer, String key) {
        if (this.semantic.isShallowCopy() || DataMapper.isImmutable(targetComponentType)) {
            if (this.semantic.isMapping() && !$.is(sourceComponent).allowBoxing().instanceOf(targetComponentType)) {
                return this.convert(sourceComponent).to(targetComponentType);
            }
            return sourceComponent;
        }
        Object convertedTargetComponent = null;
        if (!targetComponentIsContainer && this.semantic.isMapping()) {
            convertedTargetComponent = this.convert(sourceComponent).to(targetComponentType);
        }
        if (null != convertedTargetComponent) {
            return convertedTargetComponent;
        }
        if (null != targetComponent) {
            if (targetComponentType.isInterface()) {
                Class<?> realComponentType = targetComponent.getClass();
                if (Map.class == targetComponentType && HashMap.class != realComponentType) {
                    HashMap map = new HashMap();
                    map.putAll(targetComponent);
                    targetComponent = map;
                } else if (List.class == targetComponentType && ArrayList.class != realComponentType) {
                    ArrayList list = new ArrayList();
                    list.addAll((List)((Object)targetComponent));
                    targetComponent = list;
                } else if (Set.class == targetComponentType && HashSet.class != realComponentType) {
                    HashSet set = new HashSet();
                    set.addAll((Set)((Object)targetComponent));
                    targetComponent = set;
                } else if (SortedMap.class == targetComponentType && TreeMap.class != realComponentType) {
                    TreeMap map = new TreeMap();
                    map.putAll(targetComponent);
                    targetComponent = map;
                } else if (SortedSet.class == targetComponentType && TreeSet.class != realComponentType) {
                    TreeSet set = new TreeSet();
                    set.addAll((Set)((Object)targetComponent));
                    targetComponent = set;
                }
            }
            targetComponent = new DataMapper(sourceComponent, targetComponent, key, targetComponentGenericType, this).getTarget();
        } else {
            targetComponent = this.copyOrReferenceOf(sourceComponent, sourceComponent.getClass(), key, targetComponentType, targetComponentGenericType);
        }
        return targetComponent;
    }

    private void logError(Throwable cause) {
        if (!this.ignoreError) {
            this.mappingError(cause, "Error mapping from %s to %s", this.sourceType.getName(), this.targetType.getName());
        }
    }

    private void logError(Throwable cause, String message, Object ... messageArgs) {
        if (!this.ignoreError) {
            this.mappingError(cause, message, messageArgs);
        }
    }

    private void logError(String message, Object ... messageArgs) {
        if (!this.ignoreError) {
            this.mappingError(message, messageArgs);
        }
    }

    private void logMappingFailure() {
        this.logError("Error mapping from %s to %s", this.sourceType.getName(), this.targetType.getName());
    }

    private <T> T convertSourceTo(Class<T> type) {
        try {
            return this.convertStage(!this.ignoreError).to(type);
        }
        catch (Exception e) {
            this.logError(e, "Cannot convert source into " + type.getName(), new Object[0]);
            return null;
        }
    }

    private <T> T tryConvertSourceTo(Class<T> type) {
        return this.convertStage(false).to(type);
    }

    private Lang._ConvertStage<?> convertStage() {
        return this.convert(this.source, !this.ignoreError);
    }

    private Lang._ConvertStage<?> convertStage(boolean reportError) {
        return this.convert(this.source, reportError);
    }

    private Lang._ConvertStage<?> convert(Object source) {
        return this.convert(source, !this.ignoreError);
    }

    private Lang._ConvertStage<?> convert(Object source, boolean reportError) {
        Lang._ConvertStage stage = $.convert(source).customTypeConverters(this.typeConverterRegistry).hint(this.convertHintOf(this.sourceType));
        if (!reportError) {
            stage.reportError();
        }
        return stage;
    }

    private Object convertHintOf(Class type) {
        return this.conversionHints.get(type);
    }

    private void mappingError(Throwable cause, String message, Object ... messageArgs) {
        throw new MappingException(this.source, this.target, cause, message, messageArgs);
    }

    private MappingException mappingError(String message, Object ... messageArgs) {
        throw new MappingException(this.source, this.target, message, messageArgs);
    }

    private void probeTargetType() {
        this.targetIsArray = this.targetType.isArray();
        this.targetCollection = !this.targetIsArray && Collection.class.isAssignableFrom(this.targetType) ? (Collection)this.target : null;
        this.targetIsCollection = null != this.targetCollection;
        this.targetList = this.targetIsCollection && List.class.isAssignableFrom(this.targetType) ? (List)this.target : null;
        this.targetIsList = null != this.targetList;
        this.targetMap = !this.targetIsArray && null == this.targetCollection && Map.class.isAssignableFrom(this.targetType) ? (Map)this.target : null;
        this.targetIsMap = null != this.targetMap;
        boolean bl = this.targetIsPojo = !this.targetIsArray && !this.targetIsCollection && !this.targetIsMap;
        if (this.targetIsArray) {
            this.targetLength = Array.getLength(this.target);
            this.targetComponentRawType = this.targetType.getComponentType();
        } else {
            if (this.targetIsPojo) {
                this.targetFields = $.fieldsOf(this.targetType, this.rootClass, true);
            }
            if (null != this.targetGenericType) {
                Type[] ta = this.targetGenericType.getActualTypeArguments();
                Type componentType = null;
                if (null != this.targetMap) {
                    this.targetKeyType = (Class)ta[0];
                    componentType = ta[1];
                } else if (null != this.targetCollection) {
                    componentType = ta[0];
                }
                if (null != componentType) {
                    if (componentType instanceof ParameterizedType) {
                        this.targetComponentType = (ParameterizedType)componentType;
                        this.targetComponentRawType = (Class)this.targetComponentType.getRawType();
                    } else {
                        this.targetComponentRawType = (Class)componentType;
                    }
                }
            }
            if (this.targetList != null) {
                this.targetLength = this.targetList.size();
            }
        }
        if (this.targetIsMap) {
            if (null == this.targetKeyType) {
                this.targetKeyType = $.commonSuperTypeOf(this.targetMap.keySet());
                if (null == this.targetKeyType) {
                    this.targetKeyType = String.class;
                }
            }
            if (null == this.targetComponentRawType) {
                this.targetComponentRawType = $.commonSuperTypeOf(this.targetMap.values());
                if (null == this.targetComponentRawType) {
                    this.targetComponentRawType = Object.class;
                }
            }
        }
        if (this.targetIsCollection && null == this.targetComponentRawType) {
            this.targetComponentRawType = $.commonSuperTypeOf(this.targetCollection);
        }
    }

    private Object copyOrReferenceOf(Object source) {
        return this.copyOrReferenceOf(source, "", null, null);
    }

    private Object copyOrReferenceOf(Object source, String targetName, Class targetType, ParameterizedType targetGenericType) {
        return this.copyOrReferenceOf(source, source.getClass(), targetName, targetType, targetGenericType);
    }

    private Object copyOrReferenceOf(Object source, Class sourceType, String targetName, Class targetType, ParameterizedType targetGenericType) {
        Object target;
        if (this.semantic.isShallowCopy() || DataMapper.isImmutable(sourceType)) {
            return source;
        }
        if (targetType.isArray()) {
            int len;
            if (sourceType.isArray()) {
                len = Array.getLength(source);
            } else if (Collection.class.isAssignableFrom(sourceType)) {
                len = ((Collection)source).size();
            } else {
                throw new UnexpectedException("oops, how come source is not a array/collection??");
            }
            target = Array.newInstance(targetType.getComponentType(), len);
        } else {
            try {
                target = this.instanceFactory.apply(targetType);
            }
            catch (Exception e) {
                return source;
            }
        }
        return new DataMapper(source, target, targetName, targetGenericType, this).getTarget();
    }

    private static boolean isSequence(Class<?> type) {
        return type.isArray() || Collection.class.isAssignableFrom(type);
    }

    private static boolean isMap(Class<?> type) {
        return Map.class.isAssignableFrom(type);
    }

    private static boolean isContainer(Class<?> type) {
        return DataMapper.isSequence(type) || DataMapper.isMap(type);
    }

    private static Class elementTypeOf(Object o) {
        Class<?> type = o.getClass();
        if (type.isArray()) {
            return type.getComponentType();
        }
        Collection collection = (Collection)o;
        return $.commonSuperTypeOf(collection);
    }

    private static boolean isImmutable(Class<?> type) {
        return !type.isArray() && ($.isSimpleType(type) || Lang.isImmutable(type));
    }

    class PropertyFilter
    extends Lang.Predicate<String> {
        private Set<String> whiteList = C.set();
        private Set<String> blackList = C.set();
        private Set<Keyword> whiteKeywords = C.set();
        private Set<Keyword> blackKeywords = C.set();
        private boolean allEmpty = true;

        PropertyFilter(String spec) {
            if (S.blank(spec)) {
                return;
            }
            S.List words = S.fastSplit(spec, ",");
            boolean useBlackList = false;
            for (String word : words) {
                if (useBlackList && !word.startsWith("-")) continue;
                if (word.startsWith("-")) {
                    useBlackList = true;
                    word = word.substring(1);
                }
                word = word.trim();
                if (useBlackList) {
                    if (DataMapper.this.rule == MappingRule.KEYWORD_MATCHING) {
                        if (this.blackKeywords == C.EMPTY_SET) {
                            this.blackKeywords = new HashSet<Keyword>();
                        }
                        this.blackKeywords.add(Keyword.of(word));
                        continue;
                    }
                    if (this.blackList == C.EMPTY_SET) {
                        this.blackList = new HashSet<String>();
                    }
                    this.blackList.add(word);
                    continue;
                }
                if (DataMapper.this.rule == MappingRule.KEYWORD_MATCHING) {
                    if (this.whiteKeywords == C.EMPTY_SET) {
                        this.whiteKeywords = new HashSet<Keyword>();
                    }
                    this.whiteKeywords.add(Keyword.of(word));
                    continue;
                }
                if (this.whiteList == C.EMPTY_SET) {
                    this.whiteList = new HashSet<String>();
                }
                this.whiteList.add(word);
            }
            if (useBlackList) {
                this.whiteKeywords = C.set();
                this.whiteList = C.set();
            }
            this.allEmpty = this.whiteKeywords.isEmpty() && this.whiteList.isEmpty() && this.blackKeywords.isEmpty() && this.blackList.isEmpty();
        }

        @Override
        public boolean test(String s) {
            E.illegalArgumentIf(S.blank(s));
            if (this.allEmpty) {
                return true;
            }
            String prefix = DataMapper.this.context.toString();
            if (S.notBlank(prefix)) {
                s = S.pathConcat(prefix, '.', s);
            }
            if (DataMapper.this.rule == MappingRule.KEYWORD_MATCHING) {
                Keyword keyword = Keyword.of(s);
                return this.blackKeywords.isEmpty() ? this.whiteKeywords.contains(keyword) : !this.blackKeywords.contains(keyword);
            }
            return this.blackList.isEmpty() ? this.whiteList.contains(s) : !this.blackList.contains(s);
        }
    }

    public static enum Semantic {
        SHALLOW_COPY,
        DEEP_COPY,
        MERGE,
        MAP;


        boolean isShallowCopy() {
            return this == SHALLOW_COPY;
        }

        boolean isDeepCopy() {
            return this == DEEP_COPY;
        }

        boolean isCopy() {
            return this.isShallowCopy() || this.isDeepCopy();
        }

        boolean isMerge() {
            return this == MERGE;
        }

        boolean isMapping() {
            return this == MAP;
        }
    }

    public static enum MappingRule {
        STRICT_MATCHING,
        KEYWORD_MATCHING;


        public boolean keywordMatching() {
            return this == KEYWORD_MATCHING;
        }
    }
}

