/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.stream.ImageInputStream;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.storage.ISObject;
import org.osgl.storage.impl.SObject;
import org.osgl.util.Codec;
import org.osgl.util.E;
import org.osgl.util.OS;
import org.osgl.util.ReaderInputStream;
import org.osgl.util.S;
import org.osgl.util.TypeReference;

public class IO {
    public static CharSequenceWriteStage write(CharSequence csq) {
        return new CharSequenceWriteStage(csq);
    }

    public static ReaderWriteStage write(Reader reader) {
        return new ReaderWriteStage(reader);
    }

    public static InputStreamWriteStage write(InputStream inputStream) {
        return new InputStreamWriteStage(inputStream);
    }

    public static InputStreamWriteStage write(byte[] bytes) {
        return IO.write(new ByteArrayInputStream(bytes));
    }

    public static FileWriteStage write(File file) {
        return new FileWriteStage(file);
    }

    public static UrlWriteStage write(URL url) {
        return new UrlWriteStage(url);
    }

    public static SObjectWriteStage write(ISObject sobj) {
        return new SObjectWriteStage(sobj);
    }

    public static CharSequenceReadStage read(CharSequence csq) {
        return new CharSequenceReadStage(csq);
    }

    public static ReaderReadStage read(Reader reader) {
        return new ReaderReadStage(reader);
    }

    public static InputStreamReadStage read(InputStream inputStream) {
        return new InputStreamReadStage(inputStream);
    }

    public static SObjectReadStage read(ISObject sobj) {
        return new SObjectReadStage(sobj);
    }

    public static InputStreamReadStage read(byte[] bytes) {
        return IO.read(new ByteArrayInputStream(bytes));
    }

    public static UrlReadStage read(URL url) {
        return new UrlReadStage(url);
    }

    public static FileReadStage read(File file) {
        return new FileReadStage(file);
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void flush(Flushable flushable) {
        try {
            flushable.flush();
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static void flush(ObjectOutput oo) {
        try {
            oo.flush();
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static void flush(ImageInputStream flushable) {
        if (null == flushable) {
            return;
        }
        try {
            flushable.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static File child(File file, String fn) {
        return new File(file, fn);
    }

    public static List<File> children(File file) {
        return Arrays.asList(file.listFiles());
    }

    public static File parent(File file) {
        return file.getParentFile();
    }

    public static File tmpFile() {
        return IO.tmpFile(S.random(3), null, null);
    }

    public static File tmpFile(String prefix, String suffix) {
        return IO.tmpFile(prefix, suffix, null);
    }

    public static File tmpFile(String prefix, String suffix, File dir) {
        if (null == prefix) {
            prefix = S.random(3);
        }
        try {
            return File.createTempFile(prefix, suffix, dir);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    @Deprecated
    public static OutputStream os() {
        return new ByteArrayOutputStream();
    }

    public static ByteArrayOutputStream baos() {
        return new ByteArrayOutputStream();
    }

    public static OutputStream outputStream(File file) {
        return IO.os(file);
    }

    @Deprecated
    public static OutputStream os(File file) {
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw E.ioException(e);
        }
    }

    public static Writer writer() {
        return new StringWriter();
    }

    public static Writer writer(File file) {
        try {
            return new FileWriter(file);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static InputStream inputStream() {
        return IO.is();
    }

    @Deprecated
    public static InputStream is() {
        byte[] ba = new byte[]{};
        return new ByteArrayInputStream(ba);
    }

    public static InputStream inputStream(File file) {
        return IO.is(file);
    }

    @Deprecated
    public static InputStream is(File file) {
        if (!file.exists()) {
            file = file.getAbsoluteFile();
        }
        if (!file.exists()) {
            throw E.ioException("File does not exists: %s", file.getPath());
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw E.ioException(e);
        }
    }

    public static InputStream inputStream(byte[] ba) {
        return IO.is(ba);
    }

    @Deprecated
    public static InputStream is(byte[] ba) {
        return new ByteArrayInputStream(ba);
    }

    public static InputStream inputStream(String content) {
        return IO.inputStream(content.getBytes(StandardCharsets.UTF_8));
    }

    @Deprecated
    public static InputStream is(String content) {
        return IO.is(content.getBytes());
    }

    public static InputStream inputStream(URL url) {
        return IO.is(url);
    }

    public static InputStream is(URL url) {
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static Reader reader() {
        return new StringReader("");
    }

    public static Reader reader(File file) {
        E.illegalArgumentIfNot(file.canRead(), "file not readable: " + file.getPath());
        try {
            return new FileReader(file);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static Reader reader(byte[] ba) {
        return new StringReader(new String(ba));
    }

    public static Reader reader(InputStream is) {
        return new InputStreamReader(is);
    }

    public static Reader reader(URL url) {
        try {
            return IO.reader(url.openStream());
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static Reader reader(String content) {
        return new StringReader(content);
    }

    public static BufferedOutputStream buffered(OutputStream os) {
        if (os instanceof BufferedOutputStream) {
            return (BufferedOutputStream)os;
        }
        return new BufferedOutputStream(os);
    }

    public static BufferedInputStream buffered(InputStream is) {
        if (is instanceof BufferedInputStream) {
            return (BufferedInputStream)is;
        }
        return new BufferedInputStream(is);
    }

    public static BufferedWriter buffered(Writer w) {
        if (w instanceof BufferedWriter) {
            return (BufferedWriter)w;
        }
        return new BufferedWriter(w);
    }

    public static BufferedReader buffered(Reader r) {
        if (r instanceof BufferedReader) {
            return (BufferedReader)r;
        }
        return new BufferedReader(r);
    }

    public static String checksum(File file) {
        return IO.checksum(IO.is(file));
    }

    public static String checksum(InputStream is) {
        try {
            int nread;
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] dataBytes = new byte[1024];
            while ((nread = is.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            byte[] mdbytes = md.digest();
            S.Buffer sb = S.buffer();
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw E.unexpected("SHA1 algorithm not found", new Object[0]);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static void delete(File file) {
        IO.delete(file, false);
    }

    public static void delete(File f2, boolean deleteChildren) {
        String[] sa;
        if (null == f2 || !f2.exists()) {
            return;
        }
        if (f2.isDirectory() && null != (sa = f2.list()) && sa.length > 0) {
            if (!deleteChildren) {
                return;
            }
            for (File f0 : f2.listFiles()) {
                IO.delete(f0, true);
            }
        }
        if (!f2.delete()) {
            f2.deleteOnExit();
        }
    }

    public static Properties loadProperties(File file) {
        return IO.loadProperties(IO.is(file));
    }

    public static Properties loadProperties(InputStream inputStream) {
        Properties prop = new Properties();
        try {
            prop.load(inputStream);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
        finally {
            IO.close(inputStream);
        }
        return prop;
    }

    public static Properties loadProperties(Reader reader) {
        Properties prop = new Properties();
        try {
            prop.load(reader);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
        finally {
            IO.close(reader);
        }
        return prop;
    }

    public static Properties loadProperties(String content) {
        return IO.loadProperties(new StringReader(content));
    }

    public static byte[] readContent(File file) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            IO.copy(new BufferedInputStream(new FileInputStream(file)), baos);
        }
        catch (FileNotFoundException e) {
            throw E.ioException(e);
        }
        return baos.toByteArray();
    }

    public static byte[] readContent(InputStream is) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IO.copy(is, baos);
        return baos.toByteArray();
    }

    public static String readContentAsString(File file) {
        return IO.readContentAsString(file, "utf-8");
    }

    public static String readContentAsString(URL url, String encoding) {
        try {
            return IO.readContentAsString(url.openStream(), encoding);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static String readContentAsString(URL url) {
        return IO.readContentAsString(url, "utf-8");
    }

    public static String readContentAsString(File file, String encoding) {
        try {
            return IO.readContentAsString(new FileInputStream(file), encoding);
        }
        catch (FileNotFoundException e) {
            throw E.ioException(e);
        }
    }

    public static String readContentAsString(InputStream is) {
        return IO.readContentAsString(is, "utf-8");
    }

    public static String readContentAsString(InputStream is, String encoding) {
        try {
            String line;
            StringWriter result = new StringWriter();
            PrintWriter out = new PrintWriter(result);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, encoding));
            int lineNo = 0;
            while ((line = reader.readLine()) != null) {
                if (lineNo++ > 0) {
                    out.println();
                }
                out.print(line);
            }
            String string = result.toString();
            return string;
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
        finally {
            IO.close(is);
        }
    }

    public static List<String> readLines(File file) {
        return IO.readLines(file, 0);
    }

    public static List<String> readLines(File file, int limit) {
        return IO.readLines(file, "utf-8", limit);
    }

    public static List<String> readLines(File file, String encoding) {
        return IO.readLines(file, encoding, 0);
    }

    public static List<String> readLines(File file, String encoding, int limit) {
        List<String> lines = null;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            lines = IO.readLines(is, encoding, limit);
        }
        catch (IOException ex) {
            try {
                throw E.ioException(ex);
            }
            catch (Throwable throwable) {
                IO.close(is);
                throw throwable;
            }
        }
        IO.close(is);
        return lines;
    }

    public static List<String> readLines(InputStream is, String encoding) {
        return IO.readLines(is, encoding, 0);
    }

    public static List<String> readLines(InputStream is, String encoding, int limit) {
        InputStreamReader r;
        if (encoding == null) {
            return IO.readLines(is, limit);
        }
        try {
            r = new InputStreamReader(is, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw E.encodingException(e);
        }
        return IO.readLines(r, limit);
    }

    public static List<String> readLines(InputStream inputStream) {
        return IO.readLines(inputStream, 0);
    }

    public static List<String> readLines(InputStream inputStream, int limit) {
        InputStreamReader r = new InputStreamReader(inputStream);
        return IO.readLines(r, limit);
    }

    public static List<String> readLines(Reader input) {
        return IO.readLines(input, 0);
    }

    public static List<String> readLines(Reader input, int limit) {
        BufferedReader reader = new BufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        if (limit < 1) {
            limit = Integer.MAX_VALUE;
        }
        try {
            int n = 0;
            String line = reader.readLine();
            while (n++ < limit && line != null) {
                list.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
        return list;
    }

    public static List<String> readLines(URL url) {
        return IO.readLines(url, 0);
    }

    public static List<String> readLines(URL url, int limit) {
        try {
            return IO.readLines(url.openStream(), limit);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static List<String> readLines(URL url, String encode) {
        return IO.readLines(url, encode, 0);
    }

    public static List<String> readLines(URL url, String encode, int limit) {
        try {
            return IO.readLines(url.openStream(), encode, limit);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    @Deprecated
    public static void writeContent(CharSequence content, File file) {
        IO.write(content, file, "utf-8");
    }

    public static void write(CharSequence content, File file) {
        IO.write(content, file, "utf-8");
    }

    @Deprecated
    public static void writeContent(CharSequence content, File file, String encoding) {
        IO.write(content, file, encoding);
    }

    public static void write(CharSequence content, File file, String encoding) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)os, encoding));
            printWriter.println(content);
            printWriter.flush();
            os.flush();
        }
        catch (IOException e) {
            try {
                throw E.unexpected(e);
            }
            catch (Throwable throwable) {
                IO.close(os);
                throw throwable;
            }
        }
        IO.close(os);
    }

    public static void write(char c, Writer writer) {
        try {
            writer.write(c);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    @Deprecated
    public static void writeContent(CharSequence content, Writer writer) {
        IO.write(content, writer);
    }

    public static void append(CharSequence content, Writer writer) {
        IO.write(content, writer, false);
    }

    public static void write(CharSequence content, Writer writer) {
        IO.write(content, writer, true);
    }

    public static void write(CharSequence content, Writer writer, boolean closeOs) {
        try {
            PrintWriter printWriter = new PrintWriter(writer);
            printWriter.println(content);
            printWriter.flush();
            writer.flush();
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
        finally {
            if (closeOs) {
                IO.close(writer);
            }
        }
    }

    public static int append(InputStream is, OutputStream os) {
        return IO.copy(is, os, false);
    }

    public static int copy(InputStream is, OutputStream os) {
        return IO.copy(is, os, true);
    }

    public static int copy(InputStream is, OutputStream os, boolean closeOs) {
        try {
            int read;
            int total = 0;
            byte[] buffer = new byte[8096];
            while ((read = is.read(buffer)) > 0) {
                os.write(buffer, 0, read);
                total += read;
            }
            int n = total;
            return n;
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
        finally {
            IO.close(is);
            if (closeOs) {
                IO.close(os);
            }
        }
    }

    public static int copy(Reader reader, Writer writer) {
        return IO.copy(reader, writer, true);
    }

    public static int copy(Reader reader, Writer writer, boolean closeWriter) {
        if (closeWriter) {
            return ((ReaderWriteStage)IO.write(reader).ensureCloseSink()).to(writer);
        }
        return IO.write(reader).to(writer);
    }

    public static int write(InputStream is, OutputStream os) {
        return IO.copy(is, os);
    }

    public static int write(InputStream is, File f2) {
        try {
            return IO.copy(is, new BufferedOutputStream(new FileOutputStream(f2)));
        }
        catch (FileNotFoundException e) {
            throw E.ioException(e);
        }
    }

    public static void write(byte b, OutputStream os) {
        try {
            os.write(b);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static void write(byte[] data, File file) {
        try {
            IO.write((InputStream)new ByteArrayInputStream(data), (OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
        }
        catch (FileNotFoundException e) {
            throw E.ioException(e);
        }
    }

    public static void write(byte[] data, OutputStream os) {
        IO.write((InputStream)new ByteArrayInputStream(data), os);
    }

    public static void copyDirectory(File source, File target) {
        if (source.isDirectory()) {
            if (!target.exists()) {
                target.mkdir();
            }
            for (String child : source.list()) {
                IO.copyDirectory(new File(source, child), new File(target, child));
            }
        } else {
            try {
                IO.write((InputStream)new FileInputStream(source), (OutputStream)new FileOutputStream(target));
            }
            catch (IOException e) {
                if (target.isDirectory()) {
                    if (!target.exists() && !target.mkdirs()) {
                        throw E.ioException("cannot copy [%s] to [%s]", source, target);
                    }
                    target = new File(target, source.getName());
                } else {
                    File targetFolder = target.getParentFile();
                    if (!targetFolder.exists() && !targetFolder.mkdirs()) {
                        throw E.ioException("cannot copy [%s] to [%s]", source, target);
                    }
                }
                try {
                    IO.write((InputStream)new FileInputStream(source), (OutputStream)new FileOutputStream(target));
                }
                catch (IOException e0) {
                    throw E.ioException(e0);
                }
            }
        }
    }

    public static int write(Reader reader, Writer writer) {
        return IO.copy(reader, writer);
    }

    public static int write(Reader reader, Writer writer, boolean closeWriter) {
        return IO.copy(reader, writer, closeWriter);
    }

    public static ISObject zip(ISObject ... objects) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        try {
            for (ISObject obj : objects) {
                ZipEntry entry = new ZipEntry(obj.getAttribute("filename"));
                InputStream is = obj.asInputStream();
                zos.putNextEntry(entry);
                IO.copy(is, zos, false);
                zos.closeEntry();
            }
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
        finally {
            IO.close(zos);
        }
        return SObject.of((String)Codec.encodeUrl(S.random()), (byte[])baos.toByteArray());
    }

    public static File zip(File ... files) {
        try {
            File temp = File.createTempFile("osgl", ".zip");
            IO.zipInto(temp, files);
            return temp;
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static void zipInto(File target, File ... files) {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(target)));
            byte[] buffer = new byte[128];
            for (File f2 : files) {
                ZipEntry entry = new ZipEntry(f2.getName());
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(f2));
                zos.putNextEntry(entry);
                int read = 0;
                while ((read = ((InputStream)is).read(buffer)) != -1) {
                    zos.write(buffer, 0, read);
                }
                zos.closeEntry();
                IO.close(is);
            }
        }
        catch (IOException e) {
            try {
                throw E.ioException(e);
            }
            catch (Throwable throwable) {
                IO.close(zos);
                throw throwable;
            }
        }
        IO.close(zos);
    }

    public static final class F {
        public static Lang.Function PRINTLN = F.print("", "\n", System.out);
        public static Lang.Function PRINT = F.print("", "", System.out);
        public static final Lang.Function<File, InputStream> FILE_TO_IS = new Lang.F1<File, InputStream>(){

            @Override
            public InputStream apply(File file) throws NotAppliedException, Lang.Break {
                try {
                    return new BufferedInputStream(new FileInputStream(file));
                }
                catch (IOException e) {
                    throw E.ioException(e);
                }
            }
        };

        public static <T> Lang.Function<?, T> println() {
            return PRINTLN;
        }

        public static <T> Lang.Function<?, T> print() {
            return PRINT;
        }

        public static <T> Lang.Function<T, ?> print(String prefix, String suffix) {
            return F.print(prefix, suffix, System.out);
        }

        public static <T> Lang.Function<T, ?> print(String prefix, String suffix, PrintStream ps) {
            return new Lang.F4<T, String, String, PrintStream, Void>(){

                @Override
                public Void apply(T t, String prefix, String suffix, PrintStream ps) {
                    StringBuilder sb = new StringBuilder(prefix).append(t).append(suffix);
                    ps.print(sb);
                    return null;
                }
            }.curry(prefix, suffix, ps);
        }
    }

    public static class UrlReadStage
    extends ReadStageBase<URL, UrlReadStage> {
        public UrlReadStage(URL url) {
            super(url);
        }

        @Override
        protected InputStream load() {
            return IO.is((URL)this.source);
        }
    }

    public static class SObjectReadStage
    extends ReadStageBase<ISObject, SObjectReadStage> {
        public SObjectReadStage(ISObject isObject) {
            super(isObject);
        }

        @Override
        protected InputStream load() {
            return ((ISObject)this.source).asInputStream();
        }
    }

    public static class CharSequenceReadStage
    extends ReadStageBase<CharSequence, CharSequenceReadStage> {
        private String lineSep = OS.get().lineSeparator();

        public CharSequenceReadStage(CharSequence charSequence) {
            super(charSequence);
        }

        @Override
        protected InputStream load() throws IOException {
            return new ReaderInputStream(this.toReader(), this.charset);
        }

        @Override
        public Reader toReader() {
            return new StringReader(((CharSequence)this.source).toString());
        }

        @Override
        public String toString() {
            return ((CharSequence)this.source).toString();
        }

        public CharSequenceReadStage lineSeparator(String lineSeparator) {
            this.lineSep = $.requireNotNull(lineSeparator);
            return this;
        }

        @Override
        public List<String> toLines() {
            return S.fastSplit(((CharSequence)this.source).toString(), this.lineSep);
        }

        @Override
        public ISObject toSObject() {
            return SObject.of((String)((CharSequence)this.source).toString());
        }

        @Override
        public byte[] toByteArray() {
            return ((CharSequence)this.source).toString().getBytes(this.charset);
        }
    }

    public static class FileReadStage
    extends ReadStageBase<File, FileReadStage> {
        public FileReadStage(File file) {
            super(file);
        }

        @Override
        protected InputStream load() throws IOException {
            return IO.buffered(IO.is((File)this.source));
        }
    }

    public static class ReaderReadStage
    extends ReadStageBase<Reader, ReaderReadStage> {
        public ReaderReadStage(Reader reader) {
            super(reader);
        }

        @Override
        protected InputStream load() {
            return new ReaderInputStream((Reader)this.source, this.charset);
        }
    }

    public static class InputStreamReadStage
    extends ReadStageBase<InputStream, InputStreamReadStage> {
        public InputStreamReadStage(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        protected InputStream load() {
            return (InputStream)this.source;
        }
    }

    public static abstract class ReadStageBase<SOURCE, STAGE extends ReadStageBase> {
        protected SOURCE source;
        protected Object hint;
        protected Charset charset = StandardCharsets.UTF_8;

        public ReadStageBase(SOURCE source) {
            this.source = $.requireNotNull(source);
        }

        public STAGE encoding(Charset charset) {
            this.charset = $.requireNotNull(charset);
            return this.me();
        }

        public STAGE hint(Object hint) {
            this.hint = hint;
            return this.me();
        }

        public String toString() {
            return IO.readContentAsString(this.toInputStream());
        }

        public List<String> toLines() {
            return IO.readLines(this.toInputStream());
        }

        public ISObject toSObject() {
            return SObject.of((InputStream)this.toInputStream());
        }

        public Reader toReader() {
            return new InputStreamReader(this.toInputStream(), this.charset);
        }

        public Properties toProperties() {
            return IO.loadProperties(this.toInputStream());
        }

        public InputStream toInputStream() {
            try {
                InputStream inputStream = this.load();
                return inputStream;
            }
            catch (IOException e) {
                throw E.ioException(e);
            }
            finally {
                this.ensureCloseSource();
            }
        }

        public byte[] toByteArray() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IO.copy(this.toInputStream(), baos);
            return baos.toByteArray();
        }

        public <T> T to(Class<T> type) {
            return this._to(type);
        }

        private <T> T _to(Type type) {
            Object o;
            if (String.class == type) {
                o = this.toString();
            } else if (TypeReference.LIST_STRING == type) {
                o = this.toLines();
            } else if (InputStream.class == type) {
                o = this.toInputStream();
            } else if (Reader.class == type) {
                o = this.toReader();
            } else if (ISObject.class == type || SObject.class == type) {
                o = this.toSObject();
            } else if (Properties.class == type) {
                o = this.toProperties();
            } else if (byte[].class == type) {
                o = this.toByteArray();
            } else {
                throw new UnsupportedOperationException();
            }
            return $.cast(o);
        }

        public <T> T to(TypeReference typeReference) {
            return this._to(typeReference.getType());
        }

        protected abstract InputStream load() throws IOException;

        protected void ensureCloseSource() {
        }

        protected STAGE me() {
            return (STAGE)this;
        }
    }

    public static class SObjectWriteStage
    extends WriteStageBase<ISObject, SObjectWriteStage> {
        protected SObjectWriteStage(ISObject isObject) {
            super(isObject);
        }

        @Override
        protected int doWriteTo(Writer sink) throws IOException {
            try {
                int n = IO.write(((ISObject)this.source).asInputStream()).doWriteTo(sink);
                return n;
            }
            finally {
                if (this.closeSink) {
                    IO.close(sink);
                }
            }
        }

        @Override
        protected int doWriteTo(OutputStream sink) throws IOException {
            try {
                int n = IO.write(((ISObject)this.source).asInputStream()).doWriteTo(sink);
                return n;
            }
            finally {
                if (this.closeSink) {
                    IO.close(sink);
                }
            }
        }
    }

    public static class UrlWriteStage
    extends WriteStageBase<URL, UrlWriteStage> {
        UrlWriteStage(URL url) {
            super(url);
        }

        @Override
        protected int doWriteTo(Writer sink) throws IOException {
            return new ReaderWriteStage(IO.buffered(IO.reader((URL)this.source))).doWriteTo(sink);
        }

        @Override
        protected int doWriteTo(OutputStream sink) throws IOException {
            return new InputStreamWriteStage(IO.buffered(IO.is((URL)this.source))).doWriteTo(sink);
        }
    }

    public static class FileWriteStage
    extends WriteStageBase<File, FileWriteStage> {
        FileWriteStage(File file) {
            super(file);
        }

        @Override
        protected int doWriteTo(Writer sink) throws IOException {
            return new ReaderWriteStage(IO.buffered(IO.reader((File)this.source))).doWriteTo(sink);
        }

        @Override
        protected int doWriteTo(OutputStream sink) throws IOException {
            return new InputStreamWriteStage(IO.buffered(IO.is((File)this.source))).doWriteTo(sink);
        }
    }

    public static class InputStreamWriteStage
    extends WriteStageBase<InputStream, InputStreamWriteStage> {
        boolean closeSource = true;
        boolean consumed;

        InputStreamWriteStage(InputStream source) {
            super(source);
        }

        InputStreamWriteStage keepSourceOpen() {
            this.closeSource = false;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int doWriteTo(OutputStream sink) throws IOException {
            this.ensureNotConsumed();
            try {
                int read;
                int total = 0;
                byte[] buffer = new byte[8096];
                while ((read = ((InputStream)this.source).read(buffer)) > 0) {
                    sink.write(buffer, 0, read);
                    total += read;
                }
                int n = total;
                return n;
            }
            finally {
                this.consumed = true;
                if (this.closeSource) {
                    IO.close((Closeable)this.source);
                }
            }
        }

        @Override
        protected int doWriteTo(Writer sink) throws IOException {
            this.ensureNotConsumed();
            try {
                int n = new ReaderWriteStage(new InputStreamReader((InputStream)this.source, this.charset)).doWriteTo(sink);
                return n;
            }
            finally {
                this.consumed = true;
                if (this.closeSource) {
                    IO.close((Closeable)this.source);
                }
            }
        }

        private void ensureNotConsumed() {
            E.illegalStateIf(this.consumed, "Input stream already consumed");
        }
    }

    public static class ReaderWriteStage
    extends WriteStageBase<Reader, ReaderWriteStage> {
        boolean closeSource = true;
        boolean consumed;

        ReaderWriteStage(Reader source) {
            super(source);
        }

        ReaderWriteStage keepSourceOpen() {
            this.closeSource = false;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int doWriteTo(Writer sink) throws IOException {
            this.ensureNotConsumed();
            char[] buffer = new char[1024];
            int ttl = 0;
            try {
                int len;
                while ((len = ((Reader)this.source).read(buffer)) >= 0) {
                    sink.write(buffer, 0, len);
                    ttl += len;
                }
                int n = ttl;
                return n;
            }
            finally {
                if (this.closeSource) {
                    IO.close((Closeable)this.source);
                }
                this.consumed = true;
            }
        }

        @Override
        protected int doWriteTo(OutputStream sink) throws IOException {
            this.ensureNotConsumed();
            try {
                int n = new InputStreamWriteStage(new ReaderInputStream((Reader)this.source, this.charset)).doWriteTo(sink);
                return n;
            }
            finally {
                this.consumed = true;
                if (this.closeSource) {
                    IO.close((Closeable)this.source);
                }
            }
        }

        private void ensureNotConsumed() {
            E.illegalStateIf(this.consumed, "Reader already consumed");
        }
    }

    public static class CharSequenceWriteStage
    extends WriteStageBase<CharSequence, CharSequenceWriteStage> {
        CharSequenceWriteStage(CharSequence csq) {
            super(csq);
        }

        @Override
        public int doWriteTo(Writer sink) throws IOException {
            String s = ((CharSequence)this.source).toString();
            sink.write(s);
            return s.length();
        }

        @Override
        protected int doWriteTo(OutputStream sink) throws IOException {
            byte[] ba = ((CharSequence)this.source).toString().getBytes(this.charset);
            sink.write(ba);
            return ba.length;
        }
    }

    public static abstract class WriteStageBase<SOURCE, STAGE extends WriteStageBase> {
        protected SOURCE source;
        protected boolean closeSink;
        protected Charset charset = StandardCharsets.UTF_8;

        protected WriteStageBase(SOURCE source) {
            this.source = $.requireNotNull(source);
        }

        public STAGE ensureCloseSink() {
            this.closeSink = true;
            return this.me();
        }

        public STAGE encoding(Charset charset) {
            this.charset = $.requireNotNull(charset);
            return this.me();
        }

        public int to(Writer sink) {
            try {
                int n = this.doWriteTo(sink);
                return n;
            }
            catch (IOException e) {
                throw E.ioException(e);
            }
            finally {
                if (this.closeSink) {
                    IO.close(sink);
                } else {
                    IO.flush(sink);
                }
            }
        }

        public int to(OutputStream sink) {
            try {
                int n = this.doWriteTo(sink);
                return n;
            }
            catch (IOException e) {
                throw E.ioException(e);
            }
            finally {
                if (this.closeSink) {
                    IO.close(sink);
                } else {
                    IO.flush(sink);
                }
            }
        }

        public int to(File file) {
            E.illegalArgumentIfNot(file.canWrite(), "Target file not writable");
            BufferedOutputStream bos = IO.buffered(IO.os(file));
            return this.to(bos);
        }

        protected abstract int doWriteTo(Writer var1) throws IOException;

        protected abstract int doWriteTo(OutputStream var1) throws IOException;

        protected final STAGE me() {
            return (STAGE)this;
        }
    }
}

