/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.C;
import org.osgl.util.CompositeList;
import org.osgl.util.CompositeSeq;
import org.osgl.util.EnumerationIterator;
import org.osgl.util.IndexIterable;
import org.osgl.util.IterableSeq;
import org.osgl.util.ListBuilder;
import org.osgl.util.ListIteratorCursor;
import org.osgl.util.MappedList;
import org.osgl.util.Nil;
import org.osgl.util.RandomAccessSubList;
import org.osgl.util.ReadOnlyDelegatingList;
import org.osgl.util.ReverseList;
import org.osgl.util.SequenceBase;
import org.osgl.util.SubList;
import org.osgl.util.ZippedList;
import org.osgl.util.ZippedRSeq;
import org.osgl.util.ZippedSeq;

public abstract class ListBase<T>
extends AbstractList<T>
implements C.List<T> {
    private boolean sorted = false;
    private volatile EnumSet<C.Feature> features_;

    protected final boolean isLazy() {
        return this.is(C.Feature.LAZY);
    }

    protected final boolean isImmutable() {
        return this.is(C.Feature.IMMUTABLE);
    }

    protected final boolean isReadOnly() {
        return this.is(C.Feature.READONLY);
    }

    protected final boolean isMutable() {
        return !this.isImmutable() && !this.isReadOnly();
    }

    protected void forEachLeft(Lang.Visitor<? super T> visitor) throws Lang.Break {
        for (T t : this) {
            try {
                visitor.apply((Object)t);
            }
            catch (NotAppliedException notAppliedException) {}
        }
    }

    protected void forEachLeft(Lang.IndexedVisitor<Integer, ? super T> indexedVisitor) throws Lang.Break {
        int j = this.size();
        for (int i = 0; i < j; ++i) {
            try {
                indexedVisitor.apply((Object)i, this.get(i));
                continue;
            }
            catch (NotAppliedException notAppliedException) {
                // empty catch block
            }
        }
    }

    protected void forEachRight(Lang.Visitor<? super T> visitor) throws Lang.Break {
        Iterator<T> itr = this.reverseIterator();
        while (itr.hasNext()) {
            try {
                visitor.apply((Object)itr.next());
            }
            catch (NotAppliedException notAppliedException) {}
        }
    }

    protected void forEachRight(Lang.IndexedVisitor<Integer, ? super T> indexedVisitor) throws Lang.Break {
        for (int i = this.size() - 1; i >= 0; --i) {
            try {
                indexedVisitor.apply((Object)i, this.get(i));
                continue;
            }
            catch (NotAppliedException notAppliedException) {
                // empty catch block
            }
        }
    }

    @Override
    public C.List<T> parallel() {
        this.setFeature(C.Feature.PARALLEL);
        return this;
    }

    @Override
    public C.List<T> sequential() {
        this.unsetFeature(C.Feature.PARALLEL);
        return this;
    }

    @Override
    public C.List<T> lazy() {
        this.setFeature(C.Feature.LAZY);
        return this;
    }

    @Override
    public C.List<T> eager() {
        this.unsetFeature(C.Feature.LAZY);
        return this;
    }

    @Override
    public C.List<T> snapshot() {
        if (this.isImmutable()) {
            return this;
        }
        return ListBuilder.toList(this);
    }

    @Override
    public C.List<T> readOnly() {
        if (this.isMutable()) {
            return new ReadOnlyDelegatingList(this);
        }
        return this;
    }

    @Override
    public C.List<T> copy() {
        return C.newList(this);
    }

    @Override
    public C.List<T> sorted() {
        if (this.size() == 0) {
            return C.newList();
        }
        Object t = this.get(0);
        C.List<T> l = this.copy();
        if (!(t instanceof Comparable)) {
            return l;
        }
        Object[] a = l.toArray();
        Arrays.sort(a);
        ListIterator<Object> i = l.listIterator();
        for (int j = 0; j < a.length; ++j) {
            i.next();
            i.set(a[j]);
        }
        ((ListBase)l).setFeature(C.Feature.SORTED);
        this.sorted = true;
        return l;
    }

    @Override
    public C.List<T> sorted(Comparator<? super T> comparator) {
        C.List<T> l = this.copy();
        Collections.sort(l, comparator);
        ((ListBase)l).setFeature(C.Feature.SORTED);
        return l;
    }

    @Override
    public C.List<T> unique() {
        C.Set set = C.newSet();
        C.List retList = null;
        int i = 0;
        for (T t : this) {
            ++i;
            if (set.contains(t)) {
                if (null == retList) {
                    retList = C.newSizedList(this.size());
                    retList.addAll(this.subList(0, i - 1));
                }
            } else if (null != retList) {
                retList.add(t);
            }
            set.add(t);
        }
        return null == retList ? this : retList;
    }

    @Override
    public C.List<T> unique(Comparator<T> comp) {
        TreeSet<T> set = new TreeSet<T>(comp);
        C.List retList = null;
        int i = 0;
        for (T t : this) {
            ++i;
            if (set.contains(t)) {
                if (null == retList) {
                    retList = C.newSizedList(this.size());
                    retList.addAll(this.subList(0, i - 1));
                }
            } else if (null != retList) {
                retList.add(t);
            }
            set.add(t);
        }
        return null == retList ? this : retList;
    }

    @Override
    public C.List<T> subList(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return Nil.list();
        }
        if (this.is(C.Feature.RANDOM_ACCESS)) {
            return new RandomAccessSubList(this, fromIndex, toIndex);
        }
        return new SubList(this, fromIndex, toIndex);
    }

    @Override
    public boolean add(T t) {
        boolean b = super.add(t);
        if (b) {
            this.sorted = false;
        }
        return b;
    }

    @Override
    public void add(int index, T element) {
        super.add(index, element);
        this.sorted = false;
        this.unsetFeature(C.Feature.SORTED);
    }

    @Override
    public boolean addAll(Iterable<? extends T> iterable) {
        boolean modified = false;
        Iterator<T> e = iterable.iterator();
        while (e.hasNext()) {
            if (!this.add(e.next())) continue;
            modified = true;
        }
        boolean bl = this.sorted = !modified;
        if (!this.sorted) {
            this.unsetFeature(C.Feature.SORTED);
        }
        return modified;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + $.hc(this.features_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final EnumSet<C.Feature> features_() {
        if (null == this.features_) {
            ListBase listBase = this;
            synchronized (listBase) {
                if (null == this.features_) {
                    this.features_ = this.initFeatures();
                    assert (null != this.features_);
                }
            }
        }
        return this.features_;
    }

    protected abstract EnumSet<C.Feature> initFeatures();

    @Override
    public final EnumSet<C.Feature> features() {
        return EnumSet.copyOf(this.features_());
    }

    @Override
    public final boolean is(C.Feature feature) {
        return this.features_().contains((Object)feature);
    }

    protected ListBase<T> setFeature(C.Feature feature) {
        this.features_().add(feature);
        return this;
    }

    protected ListBase<T> unsetFeature(C.Feature feature) {
        this.features_().remove((Object)feature);
        return this;
    }

    @Override
    public boolean allMatch(Lang.Function<? super T, Boolean> predicate) {
        return !this.anyMatch(Lang.F.negate(predicate));
    }

    @Override
    public boolean anyMatch(Lang.Function<? super T, Boolean> predicate) {
        return this.findOne(predicate).isDefined();
    }

    @Override
    public boolean noneMatch(Lang.Function<? super T, Boolean> predicate) {
        return !this.anyMatch(predicate);
    }

    @Override
    public Lang.Option<T> findOne(final Lang.Function<? super T, Boolean> predicate) {
        try {
            this.forEach(new Lang.Visitor<T>(){

                @Override
                public void visit(T t) throws Lang.Break {
                    if (((Boolean)predicate.apply(t)).booleanValue()) {
                        throw new Lang.Break(t);
                    }
                }
            });
            return $.none();
        }
        catch (Lang.Break b) {
            Object t = b.get();
            return $.some(t);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public abstract ListIterator<T> listIterator(int var1);

    @Override
    public Iterator<T> reverseIterator() {
        final ListIterator<T> li = this.listIterator(this.size());
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return li.hasPrevious();
            }

            @Override
            public T next() {
                return li.previous();
            }

            @Override
            public void remove() {
                li.remove();
            }
        };
    }

    @Override
    public final T first() throws NoSuchElementException {
        return this.head();
    }

    @Override
    public T head() throws NoSuchElementException {
        return this.iterator().next();
    }

    @Override
    public T last() throws NoSuchElementException {
        return this.reverseIterator().next();
    }

    @Override
    public C.List<T> take(int n) {
        boolean immutable = this.isImmutable();
        if (n == 0) {
            if (immutable) {
                return Nil.list();
            }
            return C.newList();
        }
        if (n < 0) {
            return this.drop(this.size() + n);
        }
        if (n >= this.size()) {
            return this;
        }
        if (immutable) {
            return this.subList(0, n);
        }
        C.List l = C.newSizedList(n);
        l.addAll(this.subList(0, n));
        return l;
    }

    @Override
    public C.List<T> takeWhile(Lang.Function<? super T, Boolean> predicate) {
        boolean immutable = this.isImmutable();
        int sz = this.size();
        if (immutable) {
            if (0 == sz) {
                return Nil.list();
            }
            ListBuilder<T> lb = new ListBuilder<T>(sz);
            for (T t : this) {
                if (!predicate.apply(t).booleanValue()) break;
                lb.add(t);
            }
            return lb.toList();
        }
        if (0 == sz) {
            return C.newList();
        }
        C.List l = C.newSizedList(sz);
        for (T t : this) {
            if (!predicate.apply(t).booleanValue()) break;
            l.add(t);
        }
        return l;
    }

    @Override
    public C.List<T> drop(int n) throws IndexOutOfBoundsException {
        int sz = this.size();
        boolean immutable = this.isImmutable();
        if (n < 0) {
            if ((n = -n) >= sz) {
                if (immutable) {
                    return C.newList();
                }
                return C.list();
            }
            return this.take(sz - n);
        }
        if (0 == n) {
            return this;
        }
        if (immutable) {
            return this.subList(n, this.size());
        }
        if (n >= sz) {
            return C.newList();
        }
        C.List l = C.newSizedList(sz - n);
        l.addAll(this.subList(n, sz));
        return l;
    }

    @Override
    public C.List<T> dropWhile(Lang.Function<? super T, Boolean> predicate) {
        boolean immutable = this.isImmutable();
        int sz = this.size();
        if (immutable) {
            if (0 == sz) {
                return Nil.list();
            }
            ListBuilder<T> lb = new ListBuilder<T>(sz);
            boolean found = false;
            for (T t : this) {
                if (!found && predicate.apply(t).booleanValue()) continue;
                found = true;
                lb.add(t);
            }
            return lb.toList();
        }
        if (0 == sz) {
            return C.newList();
        }
        C.List l = C.newSizedList(sz);
        boolean found = false;
        for (T t : this) {
            if (!found && predicate.apply(t).booleanValue()) continue;
            found = true;
            l.add(t);
        }
        return l;
    }

    @Override
    public C.List<T> remove(Lang.Function<? super T, Boolean> predicate) {
        boolean immutable = this.isImmutable();
        int sz = this.size();
        if (immutable) {
            if (0 == sz) {
                return Nil.list();
            }
            ListBuilder lb = new ListBuilder(sz);
            this.forEach((Lang.Visitor)$.visitor($.predicate(predicate).elseThen(C.F.addTo(lb))));
            return lb.toList();
        }
        if (0 == sz) {
            return C.newList();
        }
        C.List l = C.newSizedList(sz);
        this.forEach((Lang.Visitor)$.visitor($.predicate(predicate).elseThen(C.F.addTo(l))));
        return l;
    }

    @Override
    public <R> C.List<R> map(Lang.Function<? super T, ? extends R> mapper) {
        boolean immutable = this.isImmutable();
        int sz = this.size();
        if (this.isLazy()) {
            return MappedList.of(this, mapper);
        }
        if (immutable) {
            if (0 == sz) {
                return Nil.list();
            }
            ListBuilder lb = new ListBuilder(sz);
            this.forEach((Lang.Visitor)$.visitor($.f1(mapper).andThen(C.F.addTo(lb))));
            return lb.toList();
        }
        if (0 == sz) {
            return C.newList();
        }
        C.List l = C.newSizedList(sz);
        this.forEach((Lang.Visitor)$.visitor($.f1(mapper).andThen(C.F.addTo(l))));
        return l;
    }

    @Override
    public <R> C.List<R> flatMap(Lang.Function<? super T, ? extends Iterable<? extends R>> mapper) {
        boolean immutable = this.isImmutable();
        int sz = this.size();
        if (immutable) {
            if (0 == sz) {
                return Nil.list();
            }
            ListBuilder lb = new ListBuilder(sz * 3);
            this.forEach((Lang.Visitor)$.visitor($.f1(mapper).andThen(C.F.addAllTo(lb))));
            return lb.toList();
        }
        if (0 == sz) {
            return C.newList();
        }
        C.List l = C.newSizedList(sz * 3);
        this.forEach((Lang.Visitor)$.visitor($.f1(mapper).andThen(C.F.addAllTo(l))));
        return l;
    }

    @Override
    public C.List<T> filter(Lang.Function<? super T, Boolean> predicate) {
        boolean immutable = this.isImmutable();
        int sz = this.size();
        if (immutable) {
            if (0 == sz) {
                return Nil.list();
            }
            ListBuilder lb = new ListBuilder(sz);
            this.forEach((Lang.Visitor)$.visitor($.predicate(predicate).ifThen(C.F.addTo(lb))));
            return lb.toList();
        }
        if (0 == sz) {
            return C.newList();
        }
        C.List l = C.newSizedList(sz);
        this.forEach((Lang.Visitor)$.visitor($.predicate(predicate).ifThen(C.F.addTo(l))));
        return l;
    }

    @Override
    public Lang.T2<C.List<T>, C.List<T>> split(final Lang.Function<? super T, Boolean> predicate) {
        final C.List left = C.newList();
        final C.List right = C.newList();
        this.accept(new Lang.Visitor<T>(){

            @Override
            public void visit(T t) throws Lang.Break {
                if (((Boolean)predicate.apply(t)).booleanValue()) {
                    left.add(t);
                } else {
                    right.add(t);
                }
            }
        });
        if (this.isImmutable() || this.isReadOnly()) {
            return $.T2(C.list(left), C.list(right));
        }
        return $.T2(left, right);
    }

    private C.List.Cursor<T> fromLeft() {
        return new ListIteratorCursor<T>(this.listIterator(0));
    }

    private C.List.Cursor<T> fromRight() {
        return new ListIteratorCursor<T>(this.listIterator(this.size()));
    }

    @Override
    public C.List.Cursor<T> locateFirst(Lang.Function<T, Boolean> predicate) {
        C.List.Cursor<T> c = this.fromLeft();
        while (c.hasNext()) {
            T t = c.forward().get();
            if (!predicate.apply(t).booleanValue()) continue;
            return c;
        }
        return c;
    }

    @Override
    public C.List.Cursor<T> locate(Lang.Function<T, Boolean> predicate) {
        return this.locateFirst(predicate);
    }

    @Override
    public C.List.Cursor<T> locateLast(Lang.Function<T, Boolean> predicate) {
        C.List.Cursor<T> c = this.fromRight();
        while (c.hasPrevious()) {
            T t = c.backward().get();
            if (!predicate.apply(t).booleanValue()) continue;
            return c;
        }
        return c;
    }

    @Override
    public C.List<T> insert(int index, T t) throws IndexOutOfBoundsException {
        int sz = this.size();
        if (sz < Math.abs(index)) {
            throw new IndexOutOfBoundsException();
        }
        if (index < 0) {
            index = sz + index;
        }
        if (this.isMutable()) {
            this.add(index, t);
            return this;
        }
        if (this.isImmutable()) {
            ListBuilder<T> lb = new ListBuilder<T>(sz + 1);
            if (index > 0) {
                lb.addAll(this.subList(0, index));
            }
            lb.add(t);
            if (index < sz) {
                lb.addAll(this.subList(index, sz));
            }
            return lb.toList();
        }
        C.List l = C.newSizedList(sz + 1);
        if (index > 0) {
            l.addAll(this.subList(0, index));
        }
        l.add(t);
        if (index < sz) {
            l.addAll(this.subList(index, sz));
        }
        return l;
    }

    @Override
    public C.List<T> insert(int index, T ... ta) throws IndexOutOfBoundsException {
        if (ta.length == 0) {
            return this;
        }
        return this.insert(index, C.listOf(ta));
    }

    @Override
    public C.List<T> insert(int index, List<T> subList) throws IndexOutOfBoundsException {
        if (subList.isEmpty()) {
            return this;
        }
        int sz = this.size();
        if (sz < Math.abs(index)) {
            throw new IndexOutOfBoundsException();
        }
        if (index < 0) {
            index = sz + index;
        }
        if (this.isMutable()) {
            this.addAll(index, subList);
            return this;
        }
        if (this.isImmutable()) {
            int delta = subList.size();
            ListBuilder<T> lb = new ListBuilder<T>(sz + delta);
            if (index > 0) {
                lb.addAll(this.subList(0, index));
            }
            lb.addAll((Collection<T>)subList);
            if (index < sz) {
                lb.addAll(this.subList(index, sz));
            }
            return lb.toList();
        }
        C.List l = C.newSizedList(sz + 1);
        if (index > 0) {
            l.addAll(this.subList(0, index));
        }
        l.addAll(subList);
        if (index < sz) {
            l.addAll(this.subList(index, sz));
        }
        return l;
    }

    @Override
    public C.List<T> reverse() {
        if (this.isLazy()) {
            return ReverseList.wrap(this);
        }
        boolean immutable = this.isImmutable();
        int sz = this.size();
        if (immutable) {
            if (0 == sz) {
                return Nil.list();
            }
            ListBuilder<T> lb = new ListBuilder<T>(sz);
            Iterator<T> itr = this.reverseIterator();
            while (itr.hasNext()) {
                lb.add(itr.next());
            }
            return lb.toList();
        }
        if (0 == sz) {
            return C.newList();
        }
        C.List l = C.newSizedList(sz);
        Iterator<T> itr = this.reverseIterator();
        while (itr.hasNext()) {
            l.add(itr.next());
        }
        return l;
    }

    @Override
    public C.List<T> without(Collection<? super T> col) {
        return this.filter((Lang.Function)Lang.F.negate(C.F.containsIn(col)));
    }

    @Override
    public C.List<T> without(T element) {
        return this.filter((Lang.Function)Lang.F.ne().curry(element));
    }

    @Override
    public C.List<T> without(T element, T ... elements) {
        T t0;
        elements = $.concat(elements, element);
        C.List<T> l = this.without(element);
        int len = elements.length;
        if (0 == len) {
            return l;
        }
        boolean c = false;
        if (8 < len && (t0 = elements[0]) instanceof Comparable) {
            c = true;
            Arrays.sort(elements);
        }
        C.List lr = C.newSizedList(l.size());
        if (c) {
            for (Object t : l) {
                int id = Arrays.binarySearch(elements, t);
                if (id == -1) continue;
                lr.add(t);
            }
        } else {
            for (Object t : l) {
                boolean found = false;
                for (int i = 0; i < len; ++i) {
                    if (!$.eq(elements[i], t)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                lr.add(t);
            }
        }
        return lr;
    }

    @Override
    public C.List<T> accept(Lang.Visitor<? super T> visitor) {
        this.forEachLeft(visitor);
        return this;
    }

    @Override
    public C.List<T> each(Lang.Visitor<? super T> visitor) {
        return this.accept((Lang.Visitor)visitor);
    }

    @Override
    public C.List<T> forEach(Lang.Visitor<? super T> visitor) {
        return this.accept((Lang.Visitor)visitor);
    }

    @Override
    public C.List<T> acceptLeft(Lang.Visitor<? super T> visitor) {
        this.forEachLeft(visitor);
        return this;
    }

    @Override
    public C.List<T> acceptRight(Lang.Visitor<? super T> visitor) {
        this.forEachRight(visitor);
        return this;
    }

    @Override
    public C.List<T> accept(Lang.IndexedVisitor<Integer, ? super T> indexedVisitor) {
        this.forEachLeft(indexedVisitor);
        return this;
    }

    @Override
    public C.List<T> each(Lang.IndexedVisitor<Integer, ? super T> indexedVisitor) {
        return this.accept(indexedVisitor);
    }

    @Override
    public C.List<T> forEach(Lang.IndexedVisitor<Integer, ? super T> indexedVisitor) {
        return this.accept(indexedVisitor);
    }

    @Override
    public C.List<T> acceptLeft(Lang.IndexedVisitor<Integer, ? super T> indexedVisitor) {
        this.forEachLeft(indexedVisitor);
        return this;
    }

    @Override
    public C.List<T> acceptRight(Lang.IndexedVisitor<Integer, ? super T> indexedVisitor) {
        this.forEachRight(indexedVisitor);
        return this;
    }

    @Override
    public C.List<T> head(int n) {
        return this.take(n);
    }

    @Override
    public C.List<T> tail() {
        int sz = this.size();
        if (0 == sz) {
            throw new UnsupportedOperationException();
        }
        if (this.isImmutable()) {
            return this.subList(1, sz);
        }
        C.List l = C.newSizedList(sz - 1);
        l.addAll(this.subList(1, sz));
        return l;
    }

    @Override
    public C.List<T> tail(int n) {
        boolean immutable = this.isImmutable();
        int sz = this.size();
        if (n < 0) {
            return this.head(-n);
        }
        if (n == 0) {
            if (immutable) {
                return Nil.list();
            }
            return C.newList();
        }
        if (n >= sz) {
            return this;
        }
        List sl = this.subList(sz - n, sz);
        if (immutable) {
            return sl;
        }
        C.List l = C.newSizedList(n);
        l.addAll(sl);
        return l;
    }

    private C.List<T> unLazyAppend(Iterable<? extends T> iterable) {
        if (this.isMutable()) {
            if (iterable instanceof Collection) {
                ((AbstractCollection)this).addAll((Collection)iterable);
            } else {
                C.forEach(iterable, $.visitor(C.F.addTo(this)));
            }
            return this;
        }
        if (this.isImmutable()) {
            ListBuilder lb = new ListBuilder(this.size() * 2);
            lb.append(this).append(iterable);
            return lb.toList();
        }
        C.List<? extends T> l = C.newSizedList(this.size() * 2);
        l.addAll(this);
        l.addAll(iterable);
        return l;
    }

    private C.List<T> unLazyAppend(Iterator<? extends T> iterator) {
        if (this.isMutable()) {
            C.forEach(iterator, $.visitor(C.F.addTo(this)));
            return this;
        }
        ListBuilder lb = new ListBuilder(this.size() * 2);
        lb.append(this).append(iterator);
        return lb.toList();
    }

    private C.List<T> unLazyAppend(Enumeration<? extends T> enumeration) {
        if (this.isMutable()) {
            C.forEach(new EnumerationIterator<T>(enumeration), $.visitor(C.F.addTo(this)));
            return this;
        }
        ListBuilder lb = new ListBuilder(this.size() * 2);
        lb.append(this).append(enumeration);
        return lb.toList();
    }

    @Override
    public C.Sequence<T> append(Iterable<? extends T> iterable) {
        if (iterable instanceof C.List) {
            return this.appendList((C.List)iterable);
        }
        if (iterable instanceof C.Sequence) {
            return this.append((C.Sequence)iterable);
        }
        if (iterable instanceof Collection) {
            return this.append((T)((Collection)iterable));
        }
        if (this.isLazy()) {
            return CompositeSeq.of(this, IterableSeq.of(iterable));
        }
        return this.unLazyAppend(iterable);
    }

    @Override
    public C.List<T> append(Collection<? extends T> collection) {
        if (collection instanceof C.List) {
            return this.appendList((C.List)collection);
        }
        return this.unLazyAppend(collection);
    }

    @Override
    public C.Sequence<T> append(C.Sequence<? extends T> seq) {
        if (seq instanceof C.List) {
            return this.appendList((C.List)seq);
        }
        if (this.isLazy()) {
            return CompositeSeq.of(this, seq);
        }
        return this.unLazyAppend(seq);
    }

    @Override
    public C.Sequence<T> append(Iterator<? extends T> iterator) {
        if (this.isLazy()) {
            return CompositeSeq.of(this, C.seq(iterator));
        }
        return this.unLazyAppend(iterator);
    }

    @Override
    public C.Sequence<T> append(Enumeration<? extends T> enumeration) {
        return this.append((Iterator<? extends T>)new EnumerationIterator<T>(enumeration));
    }

    protected C.ReversibleSequence<T> appendReversibleSeq(C.ReversibleSequence<T> seq) {
        if (seq instanceof C.List) {
            return this.appendList((C.List)seq);
        }
        return this.unLazyAppend(seq);
    }

    @Override
    public C.ReversibleSequence<T> append(C.ReversibleSequence<T> seq) {
        return this.appendReversibleSeq(seq);
    }

    protected C.List<T> appendList(C.List<T> list) {
        if (this.isLazy()) {
            return CompositeList.of(this, list);
        }
        return this.unLazyAppend(list);
    }

    @Override
    public C.List<T> append(C.List<T> list) {
        return this.appendList(list);
    }

    @Override
    public C.List<T> append(T t) {
        if (this.isMutable()) {
            this.add(t);
            return this;
        }
        if (this.isImmutable()) {
            ListBuilder<T> lb = new ListBuilder<T>(this.size() + 1);
            lb.addAll(this);
            lb.add(t);
            return lb.toList();
        }
        C.List l = C.newSizedList(this.size() + 1);
        l.addAll(this);
        l.add(t);
        return l;
    }

    private C.List<T> unLazyPrepend(Iterable<? extends T> iterable) {
        if (this.isMutable()) {
            int pos = 0;
            for (T t : iterable) {
                this.add(pos++, t);
            }
            return this;
        }
        if (this.isImmutable()) {
            ListBuilder<T> lb = new ListBuilder<T>(this.size() * 2);
            lb.append(iterable).append(this);
            return lb.toList();
        }
        C.List<T> l = C.newSizedList(this.size() * 2);
        l.addAll(iterable);
        l.addAll(this);
        return l;
    }

    private C.List<T> unLazyPrepend(Iterator<? extends T> iterator) {
        if (this.isMutable()) {
            int pos = 0;
            while (iterator.hasNext()) {
                this.add(pos++, iterator.next());
            }
            return this;
        }
        ListBuilder<T> lb = new ListBuilder<T>(this.size() * 2);
        lb.append(iterator).append(this);
        return lb.toList();
    }

    private C.List<T> unLazyPrepend(Enumeration<? extends T> enumeration) {
        if (this.isMutable()) {
            int pos = 0;
            while (enumeration.hasMoreElements()) {
                this.add(pos++, enumeration.nextElement());
            }
            return this;
        }
        ListBuilder<T> lb = new ListBuilder<T>(this.size() * 2);
        lb.append(enumeration).append(this);
        return lb.toList();
    }

    @Override
    public C.List<T> prepend(Collection<? extends T> collection) {
        if (collection instanceof C.List) {
            return this.prependList((C.List)collection);
        }
        return this.unLazyPrepend(collection);
    }

    @Override
    public C.Sequence<T> prepend(Iterable<? extends T> iterable) {
        if (iterable instanceof C.List) {
            return this.prependList((C.List)iterable);
        }
        if (iterable instanceof C.Sequence) {
            return this.prepend((C.Sequence)iterable);
        }
        if (iterable instanceof Collection) {
            return this.prepend((T)((Collection)iterable));
        }
        if (this.isLazy()) {
            return CompositeSeq.of(IterableSeq.of(iterable), this);
        }
        return this.unLazyPrepend(iterable);
    }

    @Override
    public C.Sequence<T> prepend(Iterator<? extends T> iterator) {
        if (!iterator.hasNext()) {
            return this;
        }
        if (this.isLazy()) {
            return CompositeSeq.of(C.seq(iterator), this);
        }
        return this.unLazyAppend(iterator);
    }

    @Override
    public C.Sequence<T> prepend(Enumeration<? extends T> enumeration) {
        if (this.isLazy()) {
            return CompositeSeq.of(C.seq(enumeration), this);
        }
        return this.unLazyAppend(enumeration);
    }

    @Override
    public C.Sequence<T> prepend(C.Sequence<? extends T> seq) {
        if (seq instanceof C.List) {
            return this.prependList((C.List)seq);
        }
        if (this.isLazy()) {
            return new CompositeSeq<T>(seq, this);
        }
        return this.unLazyPrepend(seq);
    }

    protected C.ReversibleSequence<T> prependReversibleSeq(C.ReversibleSequence<T> seq) {
        if (seq instanceof C.List) {
            return this.prependList((C.List)seq);
        }
        return this.unLazyPrepend(seq);
    }

    @Override
    public C.ReversibleSequence<T> prepend(C.ReversibleSequence<T> seq) {
        return this.prependReversibleSeq(seq);
    }

    protected C.List<T> prependList(C.List<T> list) {
        if (this.isLazy()) {
            return CompositeList.of(list, this);
        }
        return this.unLazyPrepend(list);
    }

    @Override
    public C.List<T> prepend(C.List<T> list) {
        return this.prependList(list);
    }

    @Override
    public C.List<T> prepend(T t) {
        if (this.isMutable()) {
            this.add(0, t);
            return this;
        }
        if (this.isImmutable()) {
            ListBuilder<T> lb = new ListBuilder<T>(this.size() + 1);
            lb.add(t);
            lb.addAll(this);
            return lb.toList();
        }
        C.List l = C.newSizedList(this.size() + 1);
        l.add(t);
        l.addAll(this);
        return l;
    }

    @Override
    public <R> R reduce(R identity, Lang.Func2<R, T, R> accumulator) {
        return this.reduceLeft(identity, accumulator);
    }

    @Override
    public <R> R reduceLeft(R identity, Lang.Func2<R, T, R> accumulator) {
        R ret = identity;
        for (T t : this) {
            ret = accumulator.apply(ret, t);
        }
        return ret;
    }

    @Override
    public <R> R reduceRight(R identity, Lang.Func2<R, T, R> accumulator) {
        R ret = identity;
        Iterator<T> i = this.reverseIterator();
        while (i.hasNext()) {
            ret = accumulator.apply(ret, i.next());
        }
        return ret;
    }

    @Override
    public Lang.Option<T> reduce(Lang.Func2<T, T, T> accumulator) {
        return this.reduceLeft(accumulator);
    }

    private Lang.Option<T> reduceIterator(Iterator<T> itr, Lang.Func2<T, T, T> accumulator) {
        if (!itr.hasNext()) {
            return $.none();
        }
        T ret = itr.next();
        while (itr.hasNext()) {
            ret = accumulator.apply(ret, itr.next());
        }
        return $.some(ret);
    }

    @Override
    public Lang.Option<T> reduceLeft(Lang.Func2<T, T, T> accumulator) {
        return this.reduceIterator(this.iterator(), accumulator);
    }

    @Override
    public Lang.Option<T> reduceRight(Lang.Func2<T, T, T> accumulator) {
        return this.reduceIterator(this.reverseIterator(), accumulator);
    }

    private Lang.Option<T> findIterator(Iterator<T> itr, Lang.Function<? super T, Boolean> predicate) {
        while (itr.hasNext()) {
            T t = itr.next();
            if (!predicate.apply(t).booleanValue()) continue;
            return $.some(t);
        }
        return $.none();
    }

    @Override
    public Lang.Option<T> findFirst(Lang.Function<? super T, Boolean> predicate) {
        return this.findIterator(this.iterator(), predicate);
    }

    @Override
    public Lang.Option<T> findLast(Lang.Function<? super T, Boolean> predicate) {
        return this.findIterator(this.reverseIterator(), predicate);
    }

    @Override
    public <T2> C.List<Lang.Binary<T, T2>> zip(List<T2> list) {
        return new ZippedList(this, list);
    }

    @Override
    public <T2> C.List<Lang.Binary<T, T2>> zipAll(List<T2> list, T def1, T2 def2) {
        return new ZippedList<T, T2>(this, list, def1, def2);
    }

    @Override
    public C.Sequence<Lang.Binary<T, Integer>> zipWithIndex() {
        return new ZippedSeq(this, new IndexIterable(this));
    }

    @Override
    public <T2> C.Sequence<? extends Lang.Binary<T, T2>> zip(Iterable<T2> iterable) {
        if (iterable instanceof List) {
            return this.zip((List)iterable);
        }
        return new ZippedSeq(this, iterable);
    }

    @Override
    public <T2> C.Sequence<? extends Lang.Binary<T, T2>> zipAll(Iterable<T2> iterable, T def1, T2 def2) {
        if (iterable instanceof List) {
            return this.zipAll((List)iterable, def1, def2);
        }
        return new ZippedSeq<T, T2>(this, iterable, def1, def2);
    }

    @Override
    public <T2> C.ReversibleSequence<Lang.Binary<T, T2>> zip(C.ReversibleSequence<T2> rseq) {
        if (rseq instanceof C.List) {
            return this.zip((List)((Object)rseq));
        }
        return new ZippedRSeq(this, rseq);
    }

    @Override
    public <T2> C.ReversibleSequence<Lang.Binary<T, T2>> zipAll(C.ReversibleSequence<T2> rseq, T def1, T2 def2) {
        if (rseq instanceof C.List) {
            return this.zipAll((List)((Object)rseq), def1, def2);
        }
        return new ZippedRSeq<T, T2>(this, rseq, def1, def2);
    }

    @Override
    public int count(T t) {
        if (this.sorted) {
            int pos = this.indexOf(t);
            if (pos < 0) {
                return 0;
            }
            int n = 1;
            for (int i = pos + 1; i < this.size() && $.eq(t, this.get(i)); ++i) {
                ++n;
            }
            return n;
        }
        return SequenceBase.count(this, t);
    }

    @Override
    public <K, V> C.Map<K, V> toMap(Lang.Function<? super T, ? extends K> keyExtractor, Lang.Function<? super T, ? extends V> valExtractor) {
        C.Map<K, V> map = C.newMap(new Object[0]);
        for (T v : this) {
            map.put(keyExtractor.apply(v), valExtractor.apply(v));
        }
        return map;
    }

    @Override
    public <K> C.Map<K, T> toMapByVal(Lang.Function<? super T, ? extends K> keyExtractor) {
        C.Map<K, T> map = C.newMap(new Object[0]);
        for (T v : this) {
            map.put(keyExtractor.apply(v), v);
        }
        return map;
    }

    @Override
    public <V> C.Map<T, V> toMapByKey(Lang.Function<? super T, ? extends V> valExtractor) {
        C.Map<T, V> map = C.newMap(new Object[0]);
        for (T v : this) {
            map.put(v, valExtractor.apply(v));
        }
        return map;
    }

    int modCount() {
        return this.modCount;
    }

    void removeRange2(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
    }
}

