/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.ListBase;
import org.osgl.util.ZippedListIterator;

class ZippedList<A, B>
extends ListBase<Lang.Binary<A, B>> {
    private List<A> a;
    private List<B> b;
    private Lang.Option<A> defA = $.none();
    private Lang.Option<B> defB = $.none();

    ZippedList(List<A> a, List<B> b) {
        E.NPE(a, b);
        this.a = a;
        this.b = b;
    }

    ZippedList(List<A> a, List<B> b, A defA, B defB) {
        E.NPE(a, b);
        this.a = a;
        this.b = b;
        this.defA = $.some(defA);
        this.defB = $.some(defB);
    }

    @Override
    protected EnumSet<C.Feature> initFeatures() {
        return EnumSet.of(C.Feature.LAZY, C.Feature.READONLY, C.Feature.LIMITED);
    }

    @Override
    public int size() {
        if (this.defA.isDefined()) {
            return Math.max(this.a.size(), this.b.size());
        }
        return Math.min(this.a.size(), this.b.size());
    }

    @Override
    public Lang.T2<A, B> get(int index) {
        return $.T2(this.a.get(index), this.b.get(index));
    }

    @Override
    public ListIterator<Lang.Binary<A, B>> listIterator(int index) {
        if (this.defA.isDefined()) {
            return new ZippedListIterator<A, B>(this.a.listIterator(), this.b.listIterator(), this.defA.get(), this.defB.get());
        }
        return new ZippedListIterator<A, B>(this.a.listIterator(), this.b.listIterator());
    }
}

