/*
 * Decompiled with CFR 0.152.
 */
package org.osgl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.cache.CacheService;
import org.osgl.cache.impl.InteralCacheService;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;
import org.osgl.util.UtilConfig;
import org.osgl.util.algo.StringReplace;
import org.osgl.util.algo.StringSearch;

public class OsglConfig {
    private static CacheService internalCache = new InteralCacheService();
    public static final String OSGL_EXTENSION_LIST = "META-INF/osgl/extension.list";
    public static StringSearch DEF_STRING_SEARCH = new StringSearch.SimpleStringSearch();
    public static StringReplace DEF_STRING_REPLACE = new StringReplace.SimpleStringReplace();
    public static Lang.Function<Class, ?> INSTANCE_FACTORY = new Lang.Function<Class, Object>(){

        @Override
        public Object apply(Class aClass) throws NotAppliedException, Lang.Break {
            if (List.class == aClass) {
                return new ArrayList();
            }
            if (Map.class == aClass) {
                return new HashMap();
            }
            if (Set.class == aClass) {
                return new HashSet();
            }
            if (SortedSet.class == aClass) {
                return new TreeSet();
            }
            if (SortedMap.class == aClass) {
                return new TreeMap();
            }
            if (C.Map.class == aClass) {
                return C.newMap(new Object[0]);
            }
            if (C.List.class == aClass) {
                return C.newList();
            }
            return $.newInstance(aClass);
        }
    };
    private static Lang.Predicate _singletonChecker = new Lang.Predicate(){

        public boolean test(Object o) {
            Class<?> type = o instanceof Class ? (Class<?>)o : o.getClass();
            return null != type.getAnnotation(Singleton.class);
        }
    };
    private static final Set<String> immutableClassNames = new HashSet<String>();
    private static Lang.Predicate<Class> immutableClassPredicate = Lang.F.no();
    private static Set<String> mappingDisabledFields;
    private static List<Lang.Predicate<String>> mappingDisabledFieldPredicates;
    private static Lang.Predicate<Readable> binaryDataProbe;
    private static String xmlRootTag;
    private static String xmlListItemTag;
    private static int BIGLINE_ITERATOR_BUF_SIZE;

    public static void setInternalCache(CacheService cache) {
        internalCache = $.requireNotNull(cache);
    }

    public static CacheService internalCache() {
        return internalCache;
    }

    public static Lang.Function<Class, ?> globalInstanceFactory() {
        return INSTANCE_FACTORY;
    }

    public static void setSingletonChecker(Lang.Predicate singletonChecker) {
        _singletonChecker = $.requireNotNull(singletonChecker);
    }

    public static boolean isSingleton(Object o) {
        return _singletonChecker.test(o);
    }

    public static void registerGlobalInstanceFactory(Lang.Function<Class, ?> instanceFactory) {
        INSTANCE_FACTORY = $.requireNotNull(instanceFactory);
    }

    public static void registerImmutableClassNames(Collection<String> immutableClassNames) {
        OsglConfig.immutableClassNames.addAll(immutableClassNames);
    }

    public static void registerImmutableClassPredicate(Lang.Predicate<Class> predicate) {
        immutableClassPredicate = $.requireNotNull(predicate);
    }

    static boolean isImmutable(Class<?> c) {
        return immutableClassNames.contains(c.getName()) || immutableClassPredicate.test(c);
    }

    public static boolean globalMappingFilter_shouldIgnore(String s) {
        if (mappingDisabledFields.contains(s)) {
            return true;
        }
        if (mappingDisabledFieldPredicates.isEmpty()) {
            return false;
        }
        for (Lang.Predicate<String> tester : mappingDisabledFieldPredicates) {
            if (!tester.test(s)) continue;
            return true;
        }
        return false;
    }

    public static void addGlobalMappingFilters(String filterSpec, String ... filterSpecs) {
        OsglConfig.addGlobalMappingFilter(filterSpec);
        for (String s : filterSpecs) {
            OsglConfig.addGlobalMappingFilter(s);
        }
    }

    public static void addGlobalMappingFilters(Collection<String> filterSpecs) {
        for (String filter : filterSpecs) {
            OsglConfig.addGlobalMappingFilter(filter);
        }
    }

    public static void addGlobalMappingFilter(String filterSpec) {
        S.List list = S.fastSplit(filterSpec, ",");
        for (String s : list) {
            if (S.blank(s)) continue;
            OsglConfig.addSingleGlobalMappingFilter(s.trim());
        }
    }

    private static void addSingleGlobalMappingFilter(String filterSpec) {
        E.illegalArgumentIf(S.blank(filterSpec), "Invalid filter: " + filterSpec);
        if (filterSpec.startsWith("contains:")) {
            String text = filterSpec.substring(9);
            E.illegalArgumentIf(S.blank(text), "Invalid filter: " + filterSpec);
            mappingDisabledFieldPredicates.add(S.F.contains(text));
        } else if (filterSpec.startsWith("reg:")) {
            String text = filterSpec.substring(4);
            E.illegalArgumentIf(S.blank(text), "Invalid filter: " + filterSpec);
            final Pattern pattern = Pattern.compile(text);
            mappingDisabledFieldPredicates.add(new Lang.Predicate<String>(){

                @Override
                public boolean test(String s) {
                    return pattern.matcher(s).matches();
                }
            });
        } else if (filterSpec.startsWith("starts:")) {
            String text = filterSpec.substring(7);
            E.illegalArgumentIf(S.blank(text), "Invalid filter: " + filterSpec);
            mappingDisabledFieldPredicates.add(S.F.startsWith(text));
        } else if (filterSpec.startsWith("ends:")) {
            String text = filterSpec.substring(5);
            E.illegalArgumentIf(S.blank(text), "Invalid filter: " + filterSpec);
            mappingDisabledFieldPredicates.add(S.F.endsWith(text));
        } else {
            mappingDisabledFields.add(filterSpec);
        }
    }

    public static void setThreadLocalBufferLimit(int limit) {
        UtilConfig.setThreadLocalBufferLimit(limit);
    }

    public static void setThreadLocalCharBufferLimit(int limit) {
        UtilConfig.setThreadLocalCharBufferLimit(limit);
    }

    public static int getThreadLocalCharBufferLimit() {
        return UtilConfig.getThreadLocalCharBufferLimit();
    }

    public static void setThreadLocalCharBufferInitSize(int size) {
        UtilConfig.setThreadLocalCharBufferInitSize(size);
    }

    public static int getThreadLocalCharBufferInitSize() {
        return UtilConfig.getThreadLocalCharBufferInitSize();
    }

    public static void setThreadLocalByteArrayBufferLimit(int limit) {
        UtilConfig.setThreadLocalByteArrayBufferLimit(limit);
    }

    public static int getThreadLocalByteArrayBufferLimit() {
        return UtilConfig.getThreadLocalByteArrayBufferLimit();
    }

    public static void setThreadLocalByteArrayBufferInitSize(int size) {
        UtilConfig.setThreadLocalByteArrayBufferInitSize(size);
    }

    public static int getThreadLocalByteArrayBufferInitSize() {
        return UtilConfig.getThreadLocalByteArrayBufferInitSize();
    }

    public static void registerExtensions() {
        try {
            Enumeration<URL> systemResources = Lang.class.getClassLoader().getResources(OSGL_EXTENSION_LIST);
            while (systemResources.hasMoreElements()) {
                InputStream is = systemResources.nextElement().openStream();
                List<String> lines = IO.read(is).toLines();
                for (String extensionClass : lines) {
                    if (S.blank(extensionClass) || (extensionClass = extensionClass.trim()).startsWith("#")) continue;
                    try {
                        $.classForName(extensionClass);
                    }
                    catch (Exception e) {
                        System.out.println("[osgl] Warning: error loading extension class [" + extensionClass + "]");
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException e) {
            System.out.println("[osgl] Warning: error loading extensions due to IO exception");
            e.printStackTrace();
        }
    }

    public static Lang.Predicate<Readable> binaryDataProbe() {
        return binaryDataProbe;
    }

    public static void registerBinaryDataProbe(Lang.Predicate<Readable> probe) {
        binaryDataProbe = $.requireNotNull(probe);
    }

    public static void setXmlRootTag(String tag) {
        xmlRootTag = S.requireNotBlank(tag);
    }

    public static String xmlRootTag() {
        return xmlRootTag;
    }

    public static void setXmlListItemTag(String tag) {
        xmlListItemTag = tag;
    }

    public static String xmlListItemTag() {
        return xmlListItemTag;
    }

    public static void setBiglineIteratorBufSize(int size) {
        if (size < 1000) {
            size = 1000;
        }
        BIGLINE_ITERATOR_BUF_SIZE = size;
    }

    public static int getBiglineIteratorBufSize() {
        return BIGLINE_ITERATOR_BUF_SIZE;
    }

    static {
        immutableClassNames.addAll(IO.read(OsglConfig.class.getResource("immutable-classes.list")).toLines());
        mappingDisabledFields = new HashSet<String>();
        mappingDisabledFieldPredicates = new ArrayList<Lang.Predicate<String>>();
        binaryDataProbe = new Lang.Predicate<Readable>(){

            @Override
            public boolean test(Readable readable) {
                CharBuffer buf = CharBuffer.allocate(100);
                try {
                    int n = readable.read(buf);
                    if (n < 0) {
                        boolean bl = false;
                        return bl;
                    }
                    buf.flip();
                    for (int i = 0; i < n; ++i) {
                        char c = buf.charAt(i);
                        if (!Character.isISOControl(c) || c == '\n' || c == '\r') continue;
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                catch (IOException e) {
                    throw E.ioException(e);
                }
                finally {
                    buf.clear();
                }
            }
        };
        xmlRootTag = "xml";
        xmlListItemTag = "xmlListItem";
        BIGLINE_ITERATOR_BUF_SIZE = 20000;
    }
}

