/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.cache.impl;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.osgl.cache.CacheService;
import org.osgl.util.E;

public class InteralCacheService
implements CacheService {
    private Map<String, Object> store = new WeakHashMap<String, Object>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private CacheService.State state = CacheService.State.INITIALIZED;

    @Override
    public void put(String key, Object value, int ttl) {
        E.unsupport();
    }

    @Override
    public void put(String key, Object value) {
        this.writeLock.lock();
        try {
            this.store.put(key, value);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void evict(String key) {
        this.writeLock.lock();
        try {
            this.store.remove(key);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public <T> T get(String key) {
        this.readLock.lock();
        try {
            Object object = this.store.get(key);
            return (T)object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int incr(String key) {
        throw E.unsupport();
    }

    @Override
    public int incr(String key, int ttl) {
        throw E.unsupport();
    }

    @Override
    public int decr(String key) {
        throw E.unsupport();
    }

    @Override
    public int decr(String key, int ttl) {
        throw E.unsupport();
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.store.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void setDefaultTTL(int ttl) {
        throw E.unsupport();
    }

    @Override
    public void shutdown() {
        this.state = CacheService.State.SHUTDOWN;
    }

    @Override
    public void startup() {
        this.state = CacheService.State.STARTED;
    }

    @Override
    public CacheService.State state() {
        return this.state;
    }
}

