/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.storage.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.OsglConfig;
import org.osgl.exception.AccessDeniedException;
import org.osgl.exception.NotAppliedException;
import org.osgl.exception.ResourceNotFoundException;
import org.osgl.exception.UnexpectedIOException;
import org.osgl.storage.ISObject;
import org.osgl.storage.IStorageService;
import org.osgl.util.C;
import org.osgl.util.Codec;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.Keyword;
import org.osgl.util.MimeType;
import org.osgl.util.S;

public abstract class SObject
implements ISObject {
    private String key;
    private Map<String, String> attrs = new HashMap<String, String>();
    protected boolean exists = true;
    protected boolean accessDenied = false;
    protected RuntimeException cause = null;

    public SObject(String key) {
        if (null == key) {
            throw new NullPointerException();
        }
        this.key = key;
    }

    @Override
    public boolean isDumb() {
        return false;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    protected void setCause(Throwable cause) {
        SObject.setCause(cause, this);
    }

    protected void setAttrs(Map<String, String> attrs) {
        this.assertValid();
        if (null == attrs) {
            return;
        }
        this.attrs.putAll(attrs);
    }

    @Override
    public String getUrl() {
        this.assertValid();
        return this.attrs.get("url");
    }

    @Override
    public String getFilename() {
        this.assertValid();
        return this.getAttribute("filename");
    }

    @Override
    public String getContentType() {
        this.assertValid();
        return this.getAttribute("content-type");
    }

    @Override
    public void setFilename(String filename) {
        E.illegalArgumentIf(S.blank(filename));
        this.assertValid();
        this.setAttribute("filename", filename);
    }

    @Override
    public void setContentType(String contentType) {
        E.illegalArgumentIf(S.blank(contentType));
        this.assertValid();
        this.setAttribute("content-type", contentType);
    }

    @Override
    public String getAttribute(String key) {
        this.assertValid();
        return this.attrs.get(key);
    }

    @Override
    public ISObject setAttribute(String key, String val) {
        this.assertValid();
        this.attrs.put(key, val);
        return this;
    }

    @Override
    public ISObject setAttributes(Map<String, String> attrs) {
        this.assertValid();
        this.setAttrs(attrs);
        return this;
    }

    @Override
    public boolean hasAttribute() {
        this.assertValid();
        return !this.attrs.isEmpty();
    }

    @Override
    public Map<String, String> getAttributes() {
        this.assertValid();
        return C.newMap(this.attrs);
    }

    @Override
    public boolean isEmpty() {
        this.assertValid();
        String s = this.asString();
        return null == s || "".equals(s);
    }

    @Override
    public boolean isExists() {
        return this.exists;
    }

    @Override
    public boolean isValid() {
        return null == this.cause;
    }

    @Override
    public boolean isAccessDenied() {
        return this.accessDenied;
    }

    @Override
    public Throwable getException() {
        return this.cause;
    }

    @Override
    public void consumeOnce(Lang.Function<InputStream, ?> consumer) {
        this.assertValid();
        InputStream is = null;
        try {
            is = this.asInputStream();
            consumer.apply(is);
        }
        finally {
            IO.close(is);
        }
    }

    @Override
    public boolean isBinary() {
        if (this.isDumb() || !this.isValid()) {
            return false;
        }
        this.assertValid();
        return this.probeBinary();
    }

    protected boolean probeBinary() {
        MimeType mimeType;
        String contentType = this.getContentType();
        if (null != contentType && null != (mimeType = MimeType.findByContentType(contentType))) {
            return !mimeType.test(MimeType.Trait.text);
        }
        final Lang.Var<Boolean> var = new Lang.Var<Boolean>(false);
        this.consumeOnce(new Lang.F1<InputStream, Object>(){

            @Override
            public Object apply(InputStream is) throws NotAppliedException, Lang.Break {
                boolean isBinary = (Boolean)OsglConfig.binaryDataProbe().apply((Object)$.convert(is).to(Reader.class));
                var.set(isBinary);
                return null;
            }
        });
        return var.get();
    }

    protected final String suffix() {
        int pos;
        this.assertValid();
        String originalFilename = this.getAttribute("filename");
        if (S.notBlank(originalFilename) && (pos = originalFilename.lastIndexOf(".")) > -1) {
            return originalFilename.substring(pos, originalFilename.length());
        }
        return "";
    }

    private void assertValid() {
        if (null != this.cause) {
            throw this.cause;
        }
    }

    private static void setCause(Throwable cause, SObject sobj) {
        sobj.cause = cause instanceof RuntimeException ? (RuntimeException)$.cast(cause) : (cause instanceof IOException ? E.ioException((IOException)cause) : E.unexpected(cause));
    }

    public static SObject getInvalidObject(String key, Throwable cause) {
        SObject sobj = SObject.of(key, "");
        SObject.setCause(cause, sobj);
        Keyword className = Keyword.of(cause.getClass().getSimpleName());
        sobj.accessDenied = className.contains("AccessDenied") || className.contains("NoAccess");
        sobj.exists = !sobj.accessDenied && className.contains("NotFound");
        return sobj;
    }

    public static SObject invalidObject(String key, Throwable cause) {
        return SObject.getInvalidObject(key, cause);
    }

    public static SObject notFoundObject(String key, Throwable cause) {
        SObject sobj = SObject.of(key, "");
        SObject.setCause(cause, sobj);
        sobj.exists = false;
        return sobj;
    }

    public static SObject accessDeniedObject(String key, Throwable cause) {
        SObject sobj = SObject.of(key, "");
        SObject.setCause(cause, sobj);
        sobj.accessDenied = true;
        return sobj;
    }

    public static SObject of(File file) {
        return SObject.of(file.getPath(), file);
    }

    public static SObject of(String key, File file) {
        if (!file.exists()) {
            return SObject.notFoundObject(key, new ResourceNotFoundException("File not found: %s", file.getPath()));
        }
        if (!file.canRead()) {
            return SObject.accessDeniedObject(key, new AccessDeniedException("File not readable: %s", file.getPath()));
        }
        if (!file.isFile()) {
            return SObject.getInvalidObject(key, new IllegalArgumentException("Cannot create SObject from directory: " + file.getPath()));
        }
        FileSObject sobj = new FileSObject(key, file);
        String fileName = file.getName();
        sobj.setAttribute("filename", file.getName());
        String fileExtension = S.fileExtension(fileName);
        MimeType mimeType = MimeType.findByFileExtension(fileExtension);
        String type = null != mimeType ? mimeType.type() : null;
        sobj.setAttribute("content-type", type);
        sobj.setAttribute("length", S.string(file.length()));
        return sobj;
    }

    @Deprecated
    public static SObject valueOf(String key, File f2) {
        return SObject.of(key, f2);
    }

    public static SObject of(String key, File file, Map<String, String> attributes) {
        SObject sobj = SObject.of(key, $.requireNotNull(file));
        sobj.setAttributes(attributes);
        return sobj;
    }

    @Deprecated
    public static SObject valueOf(String key, File file, Map<String, String> conf) {
        return SObject.of(key, file, conf);
    }

    public static SObject of(String key, File file, String ... attrs) {
        SObject sobj = SObject.of(key, $.requireNotNull(file));
        C.Map<String, String> map = C.Map(attrs);
        sobj.setAttributes(map);
        return sobj;
    }

    @Deprecated
    public static SObject valueOf(String key, File file, String ... attrs) {
        return SObject.of(key, file, attrs);
    }

    public static SObject of(InputStream is) {
        return SObject.of(SObject.randomKey(), $.requireNotNull(is));
    }

    public static SObject of(URL url) {
        String protocol = url.getProtocol();
        if ("file".equals(protocol)) {
            return SObject.of(new File(url.getFile()));
        }
        try {
            return SObject.of(url.openStream());
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static SObject loadResource(String url) {
        InputStream is = SObject.class.getResourceAsStream(url);
        if (null == is) {
            return null;
        }
        String filename = S.afterLast(url, "/");
        if (S.blank(filename)) {
            filename = url;
        }
        return SObject.of(SObject.randomKey(), is, "filename", filename);
    }

    public static SObject of(String key, InputStream is) {
        try {
            return new InputStreamSObject(key, $.requireNotNull(is));
        }
        catch (Exception e) {
            return SObject.getInvalidObject(key, e);
        }
    }

    @Deprecated
    public static SObject valueOf(String key, InputStream is) {
        return SObject.of(key, is);
    }

    public static SObject of(String key, InputStream is, Map<String, String> conf) {
        SObject sobj = SObject.of(key, is);
        sobj.setAttributes(conf);
        return sobj;
    }

    @Deprecated
    public static SObject valueOf(String key, InputStream is, Map<String, String> conf) {
        return SObject.of(key, is, conf);
    }

    public static SObject of(String key, InputStream is, String ... attrs) {
        SObject sobj = SObject.of(key, is);
        C.Map<String, String> map = C.Map(attrs);
        sobj.setAttributes(map);
        return sobj;
    }

    @Deprecated
    public static SObject valueOf(String key, InputStream is, String ... attrs) {
        return SObject.of(key, is, attrs);
    }

    public static SObject of(String content) {
        return new StringSObject(SObject.randomKey(), content);
    }

    public static SObject of(String key, String content) {
        return new StringSObject(key, $.requireNotNull(content));
    }

    @Deprecated
    public static SObject valueOf(String key, String content) {
        return SObject.of(key, content);
    }

    public static SObject of(String key, String content, Map<String, String> attrs) {
        SObject sobj = SObject.of(key, content);
        sobj.setAttributes(attrs);
        return sobj;
    }

    @Deprecated
    public static SObject valueOf(String key, String content, Map<String, String> attrs) {
        return SObject.of(key, content, attrs);
    }

    public static SObject of(String key, String content, String ... attrs) {
        SObject sobj = SObject.of(key, content);
        C.Map<String, String> map = C.Map(attrs);
        sobj.setAttributes(map);
        return sobj;
    }

    @Deprecated
    public static SObject valueOf(String key, String content, String ... attrs) {
        return SObject.of(key, content, attrs);
    }

    public static SObject of(byte[] buf) {
        return SObject.of(SObject.randomKey(), $.requireNotNull(buf));
    }

    public static SObject of(String key, byte[] buf) {
        return new ByteArraySObject(key, $.requireNotNull(buf));
    }

    public static SObject of(byte[] buf, int len) {
        return SObject.of(SObject.randomKey(), buf, len);
    }

    public static SObject of(String key, byte[] buf, int len) {
        if (len <= 0) {
            return SObject.of(key, new byte[0]);
        }
        if (len >= buf.length) {
            return SObject.of(key, buf);
        }
        byte[] ba = new byte[len];
        System.arraycopy(buf, 0, ba, 0, len);
        return SObject.of(key, ba);
    }

    @Deprecated
    public static SObject valueOf(String key, byte[] buf) {
        return SObject.of(key, buf);
    }

    public static SObject of(String key, byte[] buf, Map<String, String> attrs) {
        SObject sobj = SObject.of(key, $.requireNotNull(buf));
        sobj.setAttributes(attrs);
        return sobj;
    }

    @Deprecated
    public static SObject valueOf(String key, byte[] buf, Map<String, String> attrs) {
        return SObject.of(key, buf, attrs);
    }

    public static SObject of(String key, byte[] buf, String ... attrs) {
        SObject sobj = SObject.of(key, $.requireNotNull(buf));
        C.Map<String, String> map = C.Map(attrs);
        sobj.setAttributes(map);
        return sobj;
    }

    @Deprecated
    public static SObject valueOf(String key, byte[] buf, String ... attrs) {
        return SObject.of(key, buf, attrs);
    }

    public static SObject valueOf(String key, ISObject copy) {
        SObject sobj = SObject.of(key, copy.asByteArray());
        sobj.setAttrs(copy.getAttributes());
        return sobj;
    }

    public static SObject lazyLoad(String key, IStorageService ss) {
        return new LazyLoadSObject(key, ss);
    }

    public static SObject lazyLoad(String key, IStorageService ss, Map<String, String> conf) {
        SObject sobj = SObject.lazyLoad(key, ss);
        sobj.setAttributes(conf);
        return sobj;
    }

    public static SObject lazyLoad(String key, IStorageService ss, String ... attrs) {
        SObject sobj = SObject.lazyLoad(key, ss);
        C.Map<String, String> map = C.Map(attrs);
        sobj.setAttributes(map);
        return sobj;
    }

    private static File createTempFile(String suffix) {
        try {
            return File.createTempFile("sobj_", suffix);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    private static String randomKey() {
        return Codec.encodeUrl(S.random());
    }

    public static class LazyLoadSObject
    extends SObject {
        private volatile ISObject sobj_;
        private IStorageService ss_;

        LazyLoadSObject(String key, IStorageService ss) {
            super(key);
            E.NPE(ss);
            this.ss_ = ss;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ISObject force() {
            if (null == this.sobj_) {
                LazyLoadSObject lazyLoadSObject = this;
                synchronized (lazyLoadSObject) {
                    if (null == this.sobj_) {
                        this.sobj_ = this.ss_.get(this.getKey());
                    }
                }
            }
            return this.sobj_;
        }

        @Override
        public long getLength() {
            return null == this.sobj_ ? -1L : this.sobj_.getLength();
        }

        @Override
        public File asFile() throws UnexpectedIOException {
            return this.force().asFile();
        }

        @Override
        public String asString() throws UnexpectedIOException {
            return this.force().asString();
        }

        @Override
        public String asString(Charset charset) throws UnexpectedIOException {
            return this.force().asString(charset);
        }

        @Override
        public byte[] asByteArray() throws UnexpectedIOException {
            return this.force().asByteArray();
        }

        @Override
        public InputStream asInputStream() throws UnexpectedIOException {
            return this.force().asInputStream();
        }
    }

    public static class InputStreamSObject
    extends SObject {
        private final InputStream is_;

        InputStreamSObject(String key, InputStream is) {
            super(key);
            E.NPE(is);
            this.is_ = is;
        }

        @Override
        public byte[] asByteArray() {
            return IO.readContent(this.is_);
        }

        @Override
        public File asFile() {
            File tmpFile = SObject.createTempFile(this.suffix());
            IO.write(this.is_, tmpFile);
            return tmpFile;
        }

        @Override
        public InputStream asInputStream() {
            return this.is_;
        }

        @Override
        public String asString() {
            return this.asString(StandardCharsets.UTF_8);
        }

        @Override
        public String asString(Charset charset) throws UnexpectedIOException {
            return new String(this.asByteArray(), charset);
        }

        @Override
        public long getLength() {
            throw E.unsupport();
        }
    }

    public static class ByteArraySObject
    extends SObject {
        protected byte[] buf_;

        ByteArraySObject(String key, byte[] buf) {
            super(key);
            E.NPE(buf);
            this.buf_ = buf;
        }

        @Override
        public byte[] asByteArray() {
            int len = this.buf_.length;
            byte[] ba = new byte[len];
            System.arraycopy(this.buf_, 0, ba, 0, len);
            return ba;
        }

        @Override
        public File asFile() {
            File tmpFile = SObject.createTempFile(this.suffix());
            IO.write(this.buf_, tmpFile);
            return tmpFile;
        }

        @Override
        public InputStream asInputStream() {
            return IO.inputStream(this.buf_);
        }

        @Override
        public String asString() {
            return this.asString(StandardCharsets.UTF_8);
        }

        @Override
        public String asString(Charset charset) throws UnexpectedIOException {
            return new String(this.buf_, charset);
        }

        @Override
        public long getLength() {
            return this.buf_.length;
        }
    }

    public static class FileSObject
    extends SObject {
        private File file_;
        private SoftReference<byte[]> cache;

        FileSObject(String key, File file) {
            super(key);
            E.NPE(file);
            this.file_ = file;
        }

        private synchronized byte[] read() {
            byte[] ba;
            if (null != this.cache && null != (ba = this.cache.get())) {
                return ba;
            }
            ba = IO.readContent(this.file_);
            this.cache = new SoftReference<byte[]>(ba);
            return ba;
        }

        @Override
        public long getLength() {
            return this.file_.length();
        }

        @Override
        public File asFile() throws UnexpectedIOException {
            return this.file_;
        }

        @Override
        public String asString() throws UnexpectedIOException {
            return this.asString(StandardCharsets.UTF_8);
        }

        @Override
        public String asString(Charset charset) throws UnexpectedIOException {
            return new String(this.read(), charset);
        }

        @Override
        public byte[] asByteArray() throws UnexpectedIOException {
            return this.read();
        }

        @Override
        public InputStream asInputStream() throws UnexpectedIOException {
            return IO.inputStream(this.file_);
        }

        @Override
        public String getFilename() {
            return this.file_.getName();
        }

        @Override
        public String getContentType() {
            String suffix;
            MimeType type;
            String fn = this.getFilename();
            if (fn.contains(".") && null != (type = MimeType.findByFileExtension(suffix = S.cut(this.getFilename()).afterLast(".")))) {
                return type.type();
            }
            return super.getContentType();
        }

        @Override
        protected boolean probeBinary() {
            String suffix;
            MimeType type;
            String fn = this.getFilename();
            if (fn.contains(".") && null != (type = MimeType.findByFileExtension(suffix = S.cut(this.getFilename()).afterLast(".")))) {
                return !type.test(MimeType.Trait.text);
            }
            return super.probeBinary();
        }
    }

    public static class StringSObject
    extends SObject {
        private String s_ = null;
        private boolean dumb = false;

        StringSObject(String key, String s) {
            super(key);
            this.s_ = null == s ? "" : s;
        }

        @Override
        public byte[] asByteArray() {
            return this.s_.getBytes();
        }

        @Override
        public File asFile() {
            File tmpFile = SObject.createTempFile(this.suffix());
            IO.write((CharSequence)this.s_, tmpFile);
            return tmpFile;
        }

        @Override
        public InputStream asInputStream() {
            return IO.is(this.asByteArray());
        }

        @Override
        public String asString() {
            return this.s_;
        }

        @Override
        public String asString(Charset charset) throws UnexpectedIOException {
            return this.s_;
        }

        @Override
        public long getLength() {
            return this.s_.length();
        }

        @Override
        public boolean isDumb() {
            return this.dumb;
        }

        public int hashCode() {
            return $.hc(this.getKey());
        }

        public String toString() {
            return this.s_;
        }

        @Override
        public boolean isBinary() {
            return false;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof SObject) {
                SObject that = (SObject)obj;
                return $.eq(that.getKey(), this.getKey()) && $.eq(that.asString().toString(), this.toString());
            }
            return false;
        }
    }
}

