/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import org.osgl.util.AnnotationAware;

public interface BeanInfo<T extends BeanInfo>
extends AnnotationAware {
    public Type type();

    public List<Type> typeParams();

    public Class rawType();

    public String name();

    public boolean isArray();

    public Annotation[] allAnnotations();

    public int getModifiers();

    public boolean isTransient();

    public boolean isStatic();

    public boolean isPrivate();

    public boolean isPublic();

    public boolean isProtected();

    public boolean isFinal();

    public boolean isInterface();

    public boolean isInstanceOf(Class var1);

    public boolean isInstance(Object var1);

    public static class Util {
        public static boolean isGetter(Method method) {
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) {
                return false;
            }
            Class<?> returnType = method.getReturnType();
            if (Void.TYPE == returnType || Void.class == returnType) {
                return false;
            }
            if (method.getParameterTypes().length > 0) {
                return false;
            }
            String name = method.getName();
            if (name.length() < 4) {
                return false;
            }
            return name.startsWith("get") && !name.equals("getClass");
        }

        public static boolean isSetter(Method method) {
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) {
                return false;
            }
            Class<?> returnType = method.getReturnType();
            if (Void.TYPE != returnType) {
                return false;
            }
            if (method.getParameterTypes().length != 1) {
                return false;
            }
            String name = method.getName();
            if (name.length() < 4) {
                return false;
            }
            return name.startsWith("set");
        }
    }
}

