/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;

public class BigLines
implements Iterable<String> {
    private File file;
    private volatile Integer lines;
    private String firstLine;
    private boolean iterateFirstLine;

    public BigLines(File file) {
        E.illegalArgumentIfNot(file.exists() && file.isFile() && file.canRead(), "file must exists and be a readable file: " + file);
        this.file = file;
    }

    public String getName() {
        return this.file.getName();
    }

    public boolean isEmpty() {
        return 0 == this.lines();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String firstLine() {
        if (null == this.lines) {
            BigLines bigLines = this;
            synchronized (bigLines) {
                if (null == this.lines && this.lines() > 0) {
                    this.firstLine = this.fetch(0);
                }
            }
        }
        return this.firstLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lines() {
        if (null == this.lines) {
            BigLines bigLines = this;
            synchronized (bigLines) {
                if (null == this.lines) {
                    this.lines = this.countLines();
                }
            }
        }
        return this.lines;
    }

    public void setIterateFirstLine(boolean flag) {
        this.iterateFirstLine = flag;
    }

    public List<String> preview() {
        return this.preview(5, false);
    }

    public List<String> preview(int limit) {
        return this.preview(limit, false);
    }

    public List<String> preview(int limit, boolean noHeaderLine) {
        E.illegalArgumentIf(limit < 1, "limit must be positive integer");
        return this.fetch(noHeaderLine ? 1 : 0, limit);
    }

    public String fetch(int lineNumber) {
        E.illegalArgumentIf(lineNumber < 0, "line number must not be negative number: " + lineNumber);
        E.illegalArgumentIf(lineNumber >= this.lines(), "line number is out of range: " + lineNumber);
        List<String> list = this.fetch(lineNumber, 1);
        return list.isEmpty() ? null : list.get(0);
    }

    public List<String> fetch(int offset, int limit) {
        return this.fetch(offset, limit, new ArrayList<String>(limit));
    }

    private List<String> fetch(int offset, int limit, List<String> buf) {
        int i;
        buf.clear();
        if (this.isEmpty()) {
            return buf;
        }
        E.illegalArgumentIf(offset < 0, "offset must not be negative number");
        E.illegalArgumentIf(offset >= this.lines(), "offset is out of range: " + offset);
        E.illegalArgumentIf(limit < 1, "limit must be at least 1");
        BufferedReader reader = IO.buffered(IO.reader(this.file));
        try {
            for (i = 0; i < offset && null != reader.readLine(); ++i) {
            }
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
        try {
            String line;
            for (i = 0; i < limit && null != (line = reader.readLine()); ++i) {
                buf.add(line);
            }
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
        return buf;
    }

    public List<String> fetchAround(int lineNumber, int before, int after) {
        int offset = lineNumber - before;
        int limit = after - before;
        return this.fetch(offset, limit);
    }

    public List<String> cherrypick(int[] index) {
        if (index.length < 1) {
            return C.list();
        }
        Arrays.sort(index);
        int len = index.length;
        BufferedReader reader = IO.buffered(IO.reader(this.file));
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            int max = index[len - 1] + 1;
            for (int i = 0; i < max && null != (line = reader.readLine()); ++i) {
                if (Arrays.binarySearch(index, i) <= -1) continue;
                lines.add(line);
            }
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
        return lines;
    }

    public List<String> sampling(int number) {
        E.illegalArgumentIf(number < 1, "sample number must be positive integer");
        if (number > 1100) {
            number = 1100;
        }
        int[] index = new int[number];
        ThreadLocalRandom r = ThreadLocalRandom.current();
        int max = (long)this.lines.intValue() > Integer.MAX_VALUE ? Integer.MAX_VALUE : this.lines;
        for (int i = 0; i < number; ++i) {
            index[i] = 1 + ((Random)r).nextInt(max - 1);
        }
        return this.cherrypick(index);
    }

    public void accept(LineReader lineReader) {
        if (this.lines < 100000) {
            int lineNo = 0;
            BufferedReader reader = IO.buffered(IO.reader(this.file));
            int max = this.lines;
            try {
                String line;
                for (int i = 0; i < max && null != (line = reader.readLine()); ++i) {
                    if (0 == i && !this.iterateFirstLine) continue;
                    lineReader.read(line, lineNo++);
                }
                lineReader.batchFinished();
            }
            catch (IOException e) {
                throw E.ioException(e);
            }
        } else {
            int threads = this.lines / 100 * 100 * 10 + 1;
            threads = Math.min(threads, 20);
            Integer gap = this.lines / threads + 1;
            ArrayList<Thread> threadStore = new ArrayList<Thread>();
            for (int i = 0; i < threads; ++i) {
                Thread t = new ReadThread(i * gap, gap, lineReader);
                threadStore.add(t);
                t.start();
            }
            for (Thread t : threadStore) {
                try {
                    t.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw E.unexpected(e);
                }
            }
        }
    }

    @Deprecated
    public Iterable<String> asIterable(int bufSize) {
        return this;
    }

    @Override
    public Iterator<String> iterator() {
        final BufferedReader br = IO.buffered(IO.reader(this.file));
        Iterator<String> iter = new Iterator<String>(){
            String nextLine = null;

            @Override
            public boolean hasNext() {
                if (this.nextLine != null) {
                    return true;
                }
                try {
                    this.nextLine = br.readLine();
                    return this.nextLine != null;
                }
                catch (IOException e) {
                    throw E.ioException(e);
                }
            }

            @Override
            public String next() {
                if (this.nextLine != null || this.hasNext()) {
                    String line = this.nextLine;
                    this.nextLine = null;
                    return line;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw E.unsupport();
            }
        };
        return iter;
    }

    private int countLines() {
        BufferedInputStream is = IO.buffered(IO.inputStream(this.file));
        try {
            int i;
            byte[] c = new byte[1024];
            int readChars = ((InputStream)is).read(c);
            if (readChars == -1) {
                int n = 0;
                return n;
            }
            int count = 0;
            while (readChars == 1024) {
                i = 0;
                while (i < 1024) {
                    if (c[i++] != 10) continue;
                    ++count;
                }
                readChars = ((InputStream)is).read(c);
            }
            while (readChars != -1) {
                for (i = 0; i < readChars; ++i) {
                    if (c[i] != 10) continue;
                    ++count;
                }
                readChars = ((InputStream)is).read(c);
            }
            int n = count;
            return n;
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
        finally {
            IO.close(is);
        }
    }

    public static void main(String[] args) {
        BigLines bigLines = new BigLines(new File("/tmp/1.csv"));
        System.out.println(bigLines.lines());
        System.out.println(bigLines.firstLine());
        List<String> lines = bigLines.fetch(555554, 2);
        System.out.println(S.join("\n", lines));
        bigLines = new BigLines(new File("/tmp/2.txt"));
        System.out.println(bigLines.lines());
        for (String line : bigLines) {
            System.out.println(line);
        }
    }

    class BigLinesIterator
    implements Iterator<String> {
        private int bufSize;
        private List<String> buf;
        private int offset;
        private int bufCursor;

        BigLinesIterator(int bufSize) {
            this.bufSize = bufSize;
            this.buf = BigLines.this.fetch(this.offset, bufSize);
            this.offset = bufSize;
        }

        @Override
        public boolean hasNext() {
            return this.offset - this.bufSize + this.bufCursor < BigLines.this.lines();
        }

        @Override
        public String next() {
            if (this.bufSize <= this.bufCursor) {
                BigLines.this.fetch(this.offset, this.bufSize, this.buf);
                this.offset += this.bufSize;
                this.bufCursor = 0;
            }
            return this.buf.get(this.bufCursor++);
        }

        @Override
        public void remove() {
            throw E.unsupport();
        }
    }

    private class ReadThread
    extends Thread {
        private Integer offset;
        private Integer limit;
        private LineReader lineReader;

        public ReadThread(Integer offset, Integer limit, LineReader lineReader) {
            this.offset = offset;
            this.limit = limit;
            this.lineReader = lineReader;
        }

        @Override
        public void run() {
            BufferedReader reader = IO.buffered(IO.reader(BigLines.this.file));
            try {
                for (int i = 0; i < this.offset && null != reader.readLine(); ++i) {
                }
            }
            catch (IOException e) {
                throw E.ioException(e);
            }
            try {
                String line;
                int start;
                int lineNo = start = 0;
                for (int i = start; i < this.limit && null != (line = reader.readLine()); ++i) {
                    if (0 == this.offset && 0 == i && !BigLines.this.iterateFirstLine) continue;
                    this.lineReader.read(line, lineNo++);
                }
                this.lineReader.batchFinished();
            }
            catch (IOException e) {
                throw E.ioException(e);
            }
        }
    }

    public static abstract class LineReader {
        public abstract void read(String var1, int var2);

        public abstract void batchFinished();
    }
}

