/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import org.osgl.$;
import org.osgl.OsglConfig;
import org.osgl.util.ByteArrayBuffer;
import org.osgl.util.E;
import org.osgl.util.Output;
import org.osgl.util.S;

public class BufferedOutput
implements Output {
    private Output sink;
    private S.Buffer charBuf;
    private ByteArrayBuffer byteBuf;
    private int charBufLimit;
    private int byteBufLimit;

    private BufferedOutput(Output output) {
        this.sink = $.requireNotNull(output);
        this.charBufLimit = OsglConfig.getThreadLocalCharBufferLimit();
        this.byteBufLimit = OsglConfig.getThreadLocalByteArrayBufferLimit();
    }

    @Override
    public void open() {
        this.sink.open();
    }

    @Override
    public void close() {
        this.flush();
        this.sink.close();
    }

    @Override
    public Output append(CharSequence csq) {
        int size = csq.length();
        if (0 == size) {
            return this;
        }
        if (this.charBuf().length() + size >= this.charBufLimit) {
            this.flush();
        }
        this.charBuf().append(csq);
        return this;
    }

    @Override
    public Output append(CharSequence csq, int start, int end) {
        return this.append(csq.subSequence(start, end));
    }

    public Output append(char[] chars, int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > chars.length) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException(end - start);
        }
        int size = end - start;
        if (size == 0) {
            return this;
        }
        if (this.charBuf().length() + size >= this.charBufLimit) {
            this.flush();
        }
        this.charBuf().append(chars, start, end);
        return this;
    }

    @Override
    public Output append(char c) {
        if (this.charBuf().length() + 1 >= this.charBufLimit) {
            this.flush();
        }
        this.charBuf().append(c);
        return this;
    }

    @Override
    public Output append(byte[] bytes) {
        int size = bytes.length;
        if (0 == size) {
            return this;
        }
        if (this.byteBuf().length() + size >= this.byteBufLimit) {
            this.flush();
        }
        this.byteBuf().append(bytes);
        return this;
    }

    @Override
    public Output append(byte[] bytes, int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > bytes.length) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException(end - start);
        }
        int size = end - start;
        if (0 == size) {
            return this;
        }
        if (this.byteBuf().length() + size >= this.byteBufLimit) {
            this.flush();
        }
        this.byteBuf().append(bytes, start, end);
        return this;
    }

    @Override
    public Output append(byte b) {
        if (this.byteBuf().length() + 1 >= this.byteBufLimit) {
            this.flush();
        }
        this.byteBuf().append(b);
        return this;
    }

    @Override
    public Output append(ByteBuffer buffer) {
        if (this.byteBuf().length() + buffer.remaining() >= this.byteBufLimit) {
            this.flush();
        }
        this.byteBuf().append(buffer);
        return this;
    }

    @Override
    public OutputStream asOutputStream() {
        return new OutputStream(){

            @Override
            public void write(int b) {
                BufferedOutput.this.append((byte)b);
            }

            @Override
            public void write(byte[] b) {
                BufferedOutput.this.append(b);
            }

            @Override
            public void write(byte[] b, int off, int len) {
                BufferedOutput.this.append(b, off, len);
            }

            @Override
            public void close() {
                BufferedOutput.this.close();
            }
        };
    }

    @Override
    public Writer asWriter() {
        return new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
                BufferedOutput.this.append(cbuf, off, len);
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
                BufferedOutput.this.close();
            }
        };
    }

    @Override
    public void flush() {
        this.flushCharBuf();
        this.flushByteBuf();
    }

    private void flushCharBuf() {
        if (null == this.charBuf || this.charBuf.isEmpty()) {
            return;
        }
        String s = this.charBuf.toString();
        this.charBuf.reset();
        this.sink.append(s);
    }

    private void flushByteBuf() {
        if (null == this.byteBuf || this.byteBuf.isEmpty()) {
            return;
        }
        byte[] bytes = this.byteBuf.consume();
        this.byteBuf.reset();
        this.sink.append(bytes);
    }

    private S.Buffer charBuf() {
        E.illegalStateIf(null != this.byteBuf, "This buffered output has already been used to output byte stream");
        if (null == this.charBuf) {
            this.charBuf = S.buffer();
        }
        return this.charBuf;
    }

    private ByteArrayBuffer byteBuf() {
        E.illegalStateIf(null != this.charBuf, "This buffered output has already been used to output char stream");
        if (null == this.byteBuf) {
            this.byteBuf = ByteArrayBuffer.buffer();
        }
        return this.byteBuf;
    }

    public static Output wrap(Output output) {
        int limit = OsglConfig.getThreadLocalCharBufferLimit();
        if (limit <= 2048) {
            return output;
        }
        return new BufferedOutput(output);
    }
}

