/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import org.osgl.util.E;

class ByteArrayBuffer
extends ByteArrayOutputStream {
    static int BUFFER_INIT_SIZE = 1024;
    static int BUFFER_RETENTION_LIMIT = 10240;
    private boolean consumed = false;
    private static final ThreadLocal<ByteArrayBuffer> _buf = new ThreadLocal<ByteArrayBuffer>(){

        @Override
        protected ByteArrayBuffer initialValue() {
            ByteArrayBuffer buf = new ByteArrayBuffer(BUFFER_INIT_SIZE);
            buf.consumed = true;
            return buf;
        }
    };

    ByteArrayBuffer(int size) {
        super(size);
    }

    public final boolean consumed() {
        return this.consumed;
    }

    public final byte[] consume() {
        this.consumed = true;
        return super.toByteArray();
    }

    String consumeToString() {
        return new String(this.consume());
    }

    @Override
    public void reset() {
        super.reset();
        this.consumed = false;
    }

    public ByteArrayBuffer clear() {
        super.reset();
        return this;
    }

    public final boolean isEmpty() {
        return this.count == 0;
    }

    public final int length() {
        return this.count;
    }

    @Override
    public synchronized byte[] toByteArray() {
        return this.consume();
    }

    public byte[] view() {
        return super.toByteArray();
    }

    public ByteArrayBuffer append(byte[] bytes) {
        return this.append(bytes, 0, bytes.length);
    }

    public ByteArrayBuffer append(byte[] bytes, int start, int end) {
        this.ensureNotConsumed();
        int size = end - start;
        if (0 == size) {
            return this;
        }
        this.write(bytes, start, end);
        return this;
    }

    public ByteArrayBuffer append(byte b) {
        this.ensureNotConsumed();
        this.write(b);
        return this;
    }

    public ByteArrayBuffer append(ByteBuffer buffer) {
        this.ensureNotConsumed();
        int n = buffer.remaining();
        for (int i = 0; i < n; ++i) {
            this.write(buffer.get());
        }
        return this;
    }

    private int capacity() {
        return this.buf.length;
    }

    private void ensureNotConsumed() {
        E.illegalStateIf(this.consumed, "this buffer has already been consumed");
    }

    static ByteArrayBuffer buffer() {
        ByteArrayBuffer buf = _buf.get();
        if (!buf.consumed() || buf.capacity() > BUFFER_RETENTION_LIMIT) {
            buf = new ByteArrayBuffer(BUFFER_INIT_SIZE);
            _buf.set(buf);
            return buf;
        }
        buf.reset();
        return buf;
    }
}

