/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.ListIterator;
import org.osgl.util.E;

class CompositeListIterator<T>
implements ListIterator<T> {
    private final ListIterator<T> left_;
    private final ListIterator<T> right_;
    private boolean leftOver_;

    CompositeListIterator(ListIterator<T> l1, ListIterator<T> l2) {
        E.NPE(l1, l2);
        this.left_ = l1;
        this.right_ = l2;
        this.leftOver_ = !l1.hasNext();
    }

    @Override
    public boolean hasNext() {
        if (!this.leftOver_) {
            return true;
        }
        return this.right_.hasNext();
    }

    @Override
    public T next() {
        if (!this.leftOver_) {
            T t = this.left_.next();
            this.leftOver_ = !this.left_.hasNext();
            return t;
        }
        return this.right_.next();
    }

    @Override
    public boolean hasPrevious() {
        if (this.leftOver_) {
            if (this.right_.hasPrevious()) {
                return true;
            }
            return this.left_.hasPrevious();
        }
        return this.left_.hasPrevious();
    }

    @Override
    public T previous() {
        if (this.leftOver_) {
            if (this.right_.hasPrevious()) {
                return this.right_.previous();
            }
            this.leftOver_ = false;
            return this.left_.previous();
        }
        return this.left_.previous();
    }

    @Override
    public int nextIndex() {
        if (this.leftOver_) {
            return this.left_.nextIndex() + this.right_.nextIndex();
        }
        return this.left_.nextIndex();
    }

    @Override
    public int previousIndex() {
        if (this.leftOver_) {
            return this.left_.nextIndex() + this.right_.previousIndex();
        }
        return this.left_.previousIndex();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(T t) {
        throw new UnsupportedOperationException();
    }
}

