/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.osgl.util.Base64;
import org.osgl.util.Charsets;
import org.osgl.util.Codec;
import org.osgl.util.CryptoService;
import org.osgl.util.E;
import org.osgl.util.KeyPair;
import org.osgl.util.S;

public enum Crypto {

    private static CryptoService svc;
    private static final String ALGO = "AES/CBC/PKCS5Padding";
    private static final HashType DEFAULT_HASH_TYPE;
    static final char[] HEX_CHARS;
    public static final String ALGO_RSA = "RSA";
    private static final char[] digits;
    private static final int[] POWER_OF_TEN;
    private static final int DIGITS_SIZE;
    private static final char[] symbols;
    private static final int SYMBOL_SIZE;

    public static void setCryptoService(CryptoService service) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new RuntimePermission("OSGL.SetCryptoService"));
        }
        svc = service;
    }

    public static char[] generatePassword() {
        return Crypto.generatePassword(null);
    }

    public static char[] generatePassword(int len) {
        return Crypto.generatePassword(new char[len]);
    }

    public static char[] generatePassword(char[] ca) {
        return Crypto.generatePassword(ca, new SecureRandom());
    }

    private static char[] generatePassword(char[] ca, Random r) {
        int len;
        int n = len = null == ca ? 0 : ca.length;
        if (0 == len) {
            len = Math.abs(r.nextInt(6)) + 12;
            ca = new char[len];
        }
        char[] chars = S._COMMON_CHARS_;
        int charsLen = S._COMMON_CHARS_LEN_;
        while (len-- > 0) {
            int i = r.nextInt(charsLen);
            ca[len] = chars[i];
        }
        return ca;
    }

    public static String sign(String message, byte[] key) {
        if (key.length == 0) {
            return message;
        }
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            SecretKeySpec signingKey = new SecretKeySpec(key, "HmacSHA1");
            mac.init(signingKey);
            byte[] messageBytes = message.getBytes("utf-8");
            byte[] result = mac.doFinal(messageBytes);
            int len = result.length;
            char[] hexChars = new char[len * 2];
            int charIndex = 0;
            int startIndex = 0;
            while (charIndex < hexChars.length) {
                int bite = result[startIndex++] & 0xFF;
                hexChars[charIndex++] = HEX_CHARS[bite >> 4];
                hexChars[charIndex++] = HEX_CHARS[bite & 0xF];
            }
            return new String(hexChars);
        }
        catch (UnsupportedEncodingException ex) {
            throw E.encodingException(ex);
        }
        catch (Exception ex) {
            throw E.unexpected(ex);
        }
    }

    public static String passwordHash(String input) {
        return Crypto.passwordHash(input, DEFAULT_HASH_TYPE);
    }

    public static String passwordHash(String input, HashType hashType) {
        try {
            MessageDigest m = MessageDigest.getInstance(hashType.toString());
            byte[] out = m.digest(input.getBytes());
            return new String(Base64.encode(out));
        }
        catch (NoSuchAlgorithmException e) {
            throw E.unexpected(e);
        }
    }

    public static char[] passwordHash(char[] input) {
        return Crypto.passwordHash(input, DEFAULT_HASH_TYPE);
    }

    public static char[] passwordHash(char[] input, HashType hashType) {
        try {
            MessageDigest m = MessageDigest.getInstance(hashType.toString());
            byte[] out = m.digest(Crypto.toByte(input));
            return Base64.encode(out);
        }
        catch (NoSuchAlgorithmException e) {
            throw E.unexpected(e);
        }
    }

    @Deprecated
    public static String encryptAES(String value, String privateKey) {
        return Crypto.encryptAES(value, privateKey.getBytes(Charsets.UTF_8));
    }

    public static String encryptAES(String value, byte[] privateKey) {
        if (null == value) {
            return null;
        }
        try {
            if (null != svc) {
                return svc.encrypt(value, privateKey);
            }
            MessageDigest md = MessageDigest.getInstance("SHA-384");
            md.update(privateKey);
            byte[] ba = md.digest();
            byte[] key = new byte[32];
            byte[] iv = new byte[16];
            System.arraycopy(ba, 0, key, 0, 32);
            SecureRandom sr = new SecureRandom();
            sr.nextBytes(iv);
            SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance(ALGO);
            cipher.init(1, (Key)keySpec, ivSpec);
            ba = cipher.doFinal(value.getBytes(Charsets.UTF_8));
            byte[] ba2 = new byte[ba.length + 16];
            System.arraycopy(ba, 0, ba2, 0, ba.length);
            System.arraycopy(iv, 0, ba2, ba.length, 16);
            return Codec.byteToHexString(ba2);
        }
        catch (Exception ex) {
            throw E.unexpected(ex);
        }
    }

    @Deprecated
    public static String encryptAES(String value, String privateKey, String salt) {
        return Crypto.encryptAES(value, privateKey.getBytes(Charsets.UTF_8), salt.getBytes(Charsets.UTF_8));
    }

    public static String encryptAES(String value, byte[] privateKey, byte[] salt) {
        if (null == value) {
            return null;
        }
        try {
            if (null != svc) {
                return svc.encrypt(value, privateKey, salt);
            }
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(privateKey);
            byte[] key = md.digest();
            md = MessageDigest.getInstance("SHA-1");
            md.update(salt);
            byte[] tmp = md.digest();
            byte[] iv = new byte[16];
            System.arraycopy(tmp, 0, iv, 0, 16);
            SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance(ALGO);
            cipher.init(1, (Key)keySpec, ivSpec);
            byte[] ba = cipher.doFinal(value.getBytes("utf-8"));
            return Codec.byteToHexString(ba);
        }
        catch (Exception ex) {
            throw E.unexpected(ex);
        }
    }

    @Deprecated
    public static String decryptAES(String value, String privateKey) {
        return Crypto.decryptAES(value, privateKey.getBytes(Charsets.UTF_8));
    }

    public static String decryptAES(String value, byte[] privateKey) {
        if (null == value) {
            return null;
        }
        try {
            if (null != svc) {
                return svc.decrypt(value, privateKey);
            }
            byte[] ba0 = Codec.hexStringToByte(value);
            byte[] baVal = new byte[ba0.length - 16];
            System.arraycopy(ba0, 0, baVal, 0, ba0.length - 16);
            MessageDigest md = MessageDigest.getInstance("SHA-384");
            md.update(privateKey);
            byte[] ba = md.digest();
            byte[] key = new byte[32];
            byte[] iv = new byte[16];
            System.arraycopy(ba, 0, key, 0, 32);
            System.arraycopy(ba0, ba0.length - 16, iv, 0, 16);
            SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance(ALGO);
            cipher.init(2, (Key)keySpec, ivSpec);
            ba = cipher.doFinal(baVal);
            return new String(ba);
        }
        catch (Exception ex) {
            throw E.unexpected(ex);
        }
    }

    @Deprecated
    public static String decryptAES(String value, String privateKey, String salt) {
        return Crypto.decryptAES(value, privateKey.getBytes(Charsets.UTF_8), salt.getBytes(Charsets.UTF_8));
    }

    public static String decryptAES(String value, byte[] privateKey, byte[] salt) {
        if (null == value) {
            return null;
        }
        try {
            if (null != svc) {
                return svc.decrypt(value, privateKey, salt);
            }
            byte[] baVal = Codec.hexStringToByte(value);
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(privateKey);
            byte[] key = md.digest();
            md = MessageDigest.getInstance("SHA-1");
            md.update(salt);
            byte[] tmp = md.digest();
            byte[] iv = new byte[16];
            System.arraycopy(tmp, 0, iv, 0, 16);
            SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance(ALGO);
            cipher.init(2, (Key)keySpec, ivSpec);
            byte[] ba = cipher.doFinal(baVal);
            return new String(ba);
        }
        catch (Exception ex) {
            throw E.unexpected(ex);
        }
    }

    public static String encryptRSA(String value, String urlSafeBase64EncodedPublicKey) {
        return Crypto.encryptRSA(value, Codec.decodeUrlSafeBase64(urlSafeBase64EncodedPublicKey));
    }

    public static String encryptRSA(String value, byte[] publicKey) {
        try {
            PublicKey key = KeyFactory.getInstance(ALGO_RSA).generatePublic(new X509EncodedKeySpec(publicKey));
            Cipher cipher = Cipher.getInstance(ALGO_RSA);
            cipher.init(1, key);
            byte[] ba = cipher.doFinal(value.getBytes(Charsets.UTF_8));
            return Codec.byteToHexString(ba);
        }
        catch (Exception e) {
            throw E.unexpected(e);
        }
    }

    public static String decryptRSA(String value, String urlSafeBase64EncodedPrivateKey) {
        return Crypto.decryptRSA(value, Codec.decodeUrlSafeBase64(urlSafeBase64EncodedPrivateKey));
    }

    public static String decryptRSA(String value, byte[] privateKey) {
        try {
            PrivateKey key = KeyFactory.getInstance(ALGO_RSA).generatePrivate(new PKCS8EncodedKeySpec(privateKey));
            Cipher cipher = Cipher.getInstance(ALGO_RSA);
            cipher.init(2, key);
            byte[] ba = cipher.doFinal(Codec.hexStringToByte(value));
            return new String(ba);
        }
        catch (Exception e) {
            throw E.unexpected(e);
        }
    }

    public static KeyPair generateKeyPair() {
        return Crypto.generateKeyPair(1024);
    }

    public static KeyPair generateKeyPair(int keysize) {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(ALGO_RSA);
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "SUN");
            keyGen.initialize(keysize, random);
            return new KeyPair(keyGen.generateKeyPair());
        }
        catch (Exception e) {
            throw E.unexpected(e);
        }
    }

    public static String genSecret(int len) {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[len];
        random.nextBytes(bytes);
        String s = Codec.encodeUrlSafeBase64(bytes);
        if (s.endsWith(".")) {
            s = S.beforeFirst(s, ".");
        }
        return s;
    }

    public static String genSecret() {
        return Crypto.genSecret(4);
    }

    public static String genRandomDigits(int len) {
        E.illegalArgumentIf(len < 1);
        if (len < 10) {
            int base;
            SecureRandom random = new SecureRandom();
            int n = random.nextInt(POWER_OF_TEN[len]);
            if (n < (base = POWER_OF_TEN[len - 1])) {
                n += base;
            }
            return String.valueOf(n);
        }
        return Crypto.genRandomX(len, digits, DIGITS_SIZE);
    }

    public static String genRandomDigits() {
        SecureRandom random = new SecureRandom();
        int n = random.nextInt(8) + 4;
        return Crypto.genRandomDigits(n);
    }

    public static String genRandomStr(int len) {
        E.illegalArgumentIf(len < 1);
        return Crypto.genRandomX(len, symbols, SYMBOL_SIZE);
    }

    private static String genRandomX(int len, char[] space, int spaceSize) {
        SecureRandom random = new SecureRandom();
        char[] ca = new char[len];
        for (int i = 0; i < len; ++i) {
            ca[i] = space[random.nextInt(spaceSize)];
        }
        return new String(ca);
    }

    public static String genRandomStr() {
        SecureRandom random = new SecureRandom();
        int len = random.nextInt(12) + 4;
        return Crypto.genRandomStr(len);
    }

    private static byte[] toByte(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = Charset.forName("UTF-8").encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(charBuffer.array(), '\u0000');
        Arrays.fill(byteBuffer.array(), (byte)0);
        return bytes;
    }

    public static void main(String[] args) {
        KeyPair keyPair = Crypto.generateKeyPair();
        String privateKey = keyPair.getPrivateKeyAsString();
        String publicKey = keyPair.getPublicKeyAsString();
        String s = "Hello world";
        String encrypted = Crypto.encryptRSA(s, publicKey);
        System.out.println("publicKey: " + publicKey);
        System.out.println(Crypto.decryptRSA(encrypted, privateKey));
    }

    static {
        DEFAULT_HASH_TYPE = HashType.MD5;
        HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        POWER_OF_TEN = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
        DIGITS_SIZE = digits.length;
        symbols = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '!', '.', '-', '*'};
        SYMBOL_SIZE = symbols.length;
    }

    public static enum HashType {
        MD5("MD5"),
        SHA1("SHA-1"),
        SHA256("SHA-256"),
        SHA512("SHA-512");

        private String algorithm;

        private HashType(String algorithm) {
            this.algorithm = algorithm;
        }

        public String toString() {
            return this.algorithm;
        }
    }
}

