/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.OsglConfig;
import org.osgl.exception.MappingException;
import org.osgl.exception.NotAppliedException;
import org.osgl.exception.UnexpectedException;
import org.osgl.util.AdaptiveMap;
import org.osgl.util.ArrayObjectIterator;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.Keyword;
import org.osgl.util.ResultSetRecordConverter;
import org.osgl.util.S;
import org.osgl.util.converter.TypeConverterRegistry;

public class DataMapper {
    private Map<String, String> specialMapping = C.Map(new Object[0]);
    private Map<String, String> specialMappingsReversed = C.Map(new Object[0]);
    private Set<String> intermediates = C.Set();
    private MappingRule rule;
    private Semantic semantic;
    private StringBuilder context = new StringBuilder();
    private Set<Class> circularReferenceDetector;
    private PropertyFilter filter;
    private Object source;
    private Class<?> sourceType;
    private Object target;
    private Class<?> targetType;
    private ParameterizedType targetGenericType;
    private ParameterizedType targetComponentType;
    private Class<?> targetComponentRawType = Object.class;
    private Class<?> targetKeyType;
    Map<Class, Object> conversionHints;
    Lang.Function<Class, ?> instanceFactory;
    TypeConverterRegistry typeConverterRegistry;
    private boolean ignoreError;
    private boolean ignoreGlobalFilter;
    private Class rootClass;
    private List<Field> targetFields;
    private boolean targetIsArray;
    private boolean targetIsCollection;
    private boolean targetIsList;
    private boolean targetIsMap;
    private boolean targetIsSimpleType;
    private boolean targetIsPojo;
    private int targetLength = -1;
    private Collection targetCollection;
    private List targetList;
    private Map targetMap;
    private DataMapper root;
    private Lang.Function<Object, Object> keyTransformer;
    private static final Set<Class<?>> WAIVE_TYPE_LIST = C.setOf(Class.class, Object.class);
    private static Map<Keyword.Style, Lang.Function> keywordTransformers = Collections.synchronizedMap(new EnumMap(Keyword.Style.class));

    public DataMapper(Object source, Object target, ParameterizedType targetGenericType, MappingRule rule, Semantic semantic, String filterSpec, boolean ignoreError, boolean ignoreGlobalFilter, Lang.Function keyTransformer, Map<Class, Object> conversionHints, Lang.Function<Class, ?> instanceFactory, TypeConverterRegistry typeConverterRegistry, Class<?> rootClass, Map<String, String> specialMapping) {
        if (source instanceof ResultSet) {
            ResultSet rs = (ResultSet)$.cast(source);
            if (target instanceof List) {
                List targetList = (List)target;
                if (null != targetGenericType) {
                    Class targetElementType = (Class)$.cast(targetGenericType.getActualTypeArguments()[0]);
                    try {
                        while (rs.next()) {
                            targetList.add(new ResultSetRecordConverter(rs, targetElementType, specialMapping).doConvert());
                        }
                    }
                    catch (SQLException e) {
                        throw E.sqlException(e);
                    }
                }
                try {
                    while (rs.next()) {
                        targetList.add(new ResultSetRecordConverter<Map>(rs, Map.class, specialMapping).doConvert());
                    }
                }
                catch (SQLException e) {
                    throw E.sqlException(e);
                }
                this.target = targetList;
            } else {
                this.target = new ResultSetRecordConverter(rs, target.getClass(), specialMapping).doConvert();
            }
            return;
        }
        this.targetType = target.getClass();
        E.illegalArgumentIf(DataMapper.isImmutable(this.targetType), "target type is immutable: " + this.targetType.getName());
        this.targetGenericType = targetGenericType;
        this.sourceType = source.getClass();
        this.rule = $.requireNotNull(rule);
        this.semantic = $.requireNotNull(semantic);
        E.illegalStateIf(this.semantic.isFlatCopy() && !Map.class.isAssignableFrom(this.targetType), "flat copy only applied when target type is Map");
        this.filter = new PropertyFilter(filterSpec);
        this.conversionHints = null == conversionHints ? C.Map(new Object[0]) : conversionHints;
        this.instanceFactory = null == instanceFactory ? OsglConfig.globalInstanceFactory() : instanceFactory;
        this.source = source;
        this.target = target;
        this.ignoreError = ignoreError;
        this.ignoreGlobalFilter = ignoreGlobalFilter;
        this.typeConverterRegistry = null == typeConverterRegistry ? TypeConverterRegistry.INSTANCE : typeConverterRegistry;
        this.rootClass = null == rootClass ? Object.class : rootClass;
        this.circularReferenceDetector = new HashSet<Class>();
        this.circularReferenceDetector.add(this.targetType);
        E.illegalArgumentIfNot(this.rootClass.isAssignableFrom(this.targetType), "root class[%s] must be assignable from target type[%s]", rootClass.getName(), this.targetType.getName());
        if (null != specialMapping) {
            this.intermediates = new HashSet<String>();
            this.specialMapping = specialMapping;
            this.specialMappingsReversed = C.Map(specialMapping).flipped();
            for (Map.Entry<String, String> entry : specialMapping.entrySet()) {
                String s = entry.getKey();
                while (s.contains(".")) {
                    s = S.cut(s).beforeLast(".");
                    this.intermediates.add(s);
                }
                this.filter.addIntoBlackList(entry.getValue());
            }
        }
        this.keyTransformer = keyTransformer;
        this.root = this;
        this.doMapping();
    }

    private DataMapper(Object source, Object target, String targetName, ParameterizedType targetGenericType, DataMapper parentMapper) {
        this.sourceType = source.getClass();
        this.source = source;
        this.targetType = target.getClass();
        this.target = target;
        this.targetGenericType = targetGenericType;
        this.rule = parentMapper.rule;
        this.semantic = parentMapper.semantic;
        this.filter = parentMapper.filter;
        this.ignoreError = parentMapper.ignoreError;
        this.ignoreGlobalFilter = parentMapper.ignoreGlobalFilter;
        this.conversionHints = parentMapper.conversionHints;
        this.instanceFactory = parentMapper.instanceFactory;
        this.typeConverterRegistry = parentMapper.typeConverterRegistry;
        this.context = new StringBuilder();
        String parentContext = parentMapper.context.toString();
        this.context.append(parentContext);
        if (S.notBlank(targetName)) {
            if (S.notBlank(parentContext)) {
                this.context.append(".").append(targetName);
            } else {
                this.context.append(targetName);
            }
        }
        this.rootClass = Object.class;
        this.circularReferenceDetector = new HashSet<Class>();
        this.circularReferenceDetector.addAll(parentMapper.circularReferenceDetector);
        this.circularReferenceDetector.add(this.targetType);
        this.specialMapping = parentMapper.specialMapping;
        this.specialMappingsReversed = parentMapper.specialMappingsReversed;
        this.root = parentMapper.root;
        this.keyTransformer = parentMapper.keyTransformer;
        this.doMapping();
    }

    public Object getTarget() {
        return this.target;
    }

    private void doMapping() {
        try {
            this.probeTargetType();
            if (this.targetIsArray || this.targetIsCollection) {
                this.toArrayOrCollection();
            } else if (this.targetIsMap) {
                this.toMap();
            } else if (this.targetIsSimpleType) {
                if (this.targetType.isInstance(this.source)) {
                    this.target = this.source;
                } else if (this.semantic.allowTypeConvert()) {
                    this.target = this.convert(this.source, this.targetType).to(this.targetType);
                } else {
                    this.logMappingFailure();
                }
            } else {
                Set<String> mapped = this.toPojo();
                if (this.target instanceof AdaptiveMap) {
                    this.toAdaptiveMap(mapped);
                }
            }
        }
        catch (MappingException e) {
            throw e;
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    private void toArrayOrCollection() {
        int sourceLength;
        List<Object> sourceList = null;
        Object sourceArray = null;
        if (this.sourceType.isArray()) {
            sourceArray = this.source;
            sourceLength = Array.getLength(sourceArray);
        } else if (List.class.isAssignableFrom(this.sourceType)) {
            sourceList = (ArrayList)this.source;
            sourceLength = sourceList.size();
        } else if (Collection.class.isAssignableFrom(this.sourceType)) {
            Collection c = (Collection)this.source;
            sourceList = new ArrayList(c);
            sourceLength = sourceList.size();
        } else if (Iterable.class.isAssignableFrom(this.sourceType)) {
            Iterable iterable = (Iterable)this.source;
            sourceList = C.list(iterable);
            sourceLength = sourceList.size();
        } else {
            this.logError("Cannot map source[%s] into array or collection", this.sourceType.getName());
            return;
        }
        Object nullVal = $.convert(null).to(this.targetComponentRawType);
        if (this.semantic.isCopy()) {
            if (this.targetIsArray) {
                $.resetArray(this.target);
            } else if (this.targetIsList) {
                for (int i = 0; i < this.targetLength; ++i) {
                    this.targetList.set(i, nullVal);
                }
            } else {
                this.targetCollection.clear();
            }
        }
        int originTargetLength = this.targetLength;
        if (this.targetLength < sourceLength) {
            if (this.targetIsArray) {
                Object target0 = this.target;
                this.target = Array.newInstance(this.targetComponentRawType, sourceLength);
                System.arraycopy(target0, 0, this.target, 0, this.targetLength);
                this.targetLength = sourceLength;
            } else if (this.targetIsList) {
                for (int i = this.targetLength; i < sourceLength; ++i) {
                    this.targetList.add(nullVal);
                }
                this.targetLength = sourceLength;
            }
        }
        if (this.targetIsArray && this.targetType == this.sourceType && DataMapper.isImmutable(this.targetComponentRawType)) {
            System.arraycopy(sourceArray, 0, this.target, 0, sourceLength);
            return;
        }
        boolean targetComponentIsContainer = DataMapper.isContainer(this.targetComponentRawType);
        Iterator itr = null == sourceList ? new ArrayObjectIterator(sourceArray) : sourceList.iterator();
        int cursor = 0;
        while (itr.hasNext()) {
            Object sourceComponent = itr.next();
            if (null == sourceComponent) {
                if (this.semantic.isAppend()) continue;
                if (this.targetIsList) {
                    this.targetList.set(cursor++, nullVal);
                    continue;
                }
                if (!this.targetIsArray) continue;
                Array.set(this.target, cursor++, nullVal);
                continue;
            }
            boolean componentRawTypeMatches = $.is(sourceComponent).allowBoxing().instanceOf(this.targetComponentRawType);
            if (!this.semantic.allowTypeConvert() && !componentRawTypeMatches) {
                this.logError("component type mismatch. Source component type: %s, target component type: %s", sourceComponent.getClass().getName(), this.targetComponentRawType.getName());
                continue;
            }
            Object targetComponent = null;
            if ((this.targetIsArray || this.targetIsList) && !this.semantic.isCopy() && cursor < originTargetLength) {
                if (this.targetIsArray) {
                    targetComponent = Array.get(this.target, cursor);
                } else if (this.targetIsList) {
                    targetComponent = this.targetList.get(cursor);
                }
            }
            targetComponent = this.prepareTargetComponent(sourceComponent, targetComponent, this.targetComponentRawType, this.targetComponentType, targetComponentIsContainer, "");
            if (this.targetIsArray || this.targetIsList) {
                if (this.targetIsList) {
                    this.targetList.set(cursor++, targetComponent);
                    continue;
                }
                if (!this.targetIsArray) continue;
                Array.set(this.target, cursor++, targetComponent);
                continue;
            }
            this.targetCollection.add(targetComponent);
        }
    }

    private void toAdaptiveMap(Set<String> mapped) {
        boolean targetComponentIsSequence;
        AdaptiveMap adaptiveMap = (AdaptiveMap)this.target;
        HashSet<Keyword> mappedKeywords = new HashSet<Keyword>();
        boolean keywordMatching = this.rule.keywordMatching();
        if (keywordMatching) {
            for (String s : mapped) {
                mappedKeywords.add(Keyword.of(s));
            }
        }
        boolean targetComponentIsMap = !(targetComponentIsSequence = DataMapper.isSequence(this.targetComponentRawType)) && DataMapper.isMap(this.targetComponentRawType);
        boolean targetComponentIsContainer = targetComponentIsMap || targetComponentIsSequence;
        String prefix = this.context.toString();
        Class<String> targetKeyType = String.class;
        for (Lang.Triple<Object, Keyword, Lang.Producer<Object>> sourceProperty : this.sourceProperties()) {
            Object sourceKey = sourceProperty.first();
            if (mapped.contains(sourceKey) || keywordMatching && mappedKeywords.contains(Keyword.of(S.string(sourceKey))) || !this.ignoreGlobalFilter && sourceKey instanceof String && OsglConfig.globalMappingFilter_shouldIgnore(sourceKey.toString())) continue;
            if (!this.semantic.allowTypeConvert() && !$.is(sourceKey).allowBoxing().instanceOf(targetKeyType)) {
                this.logError("map key type mismatch, required: %s; found: %s", targetKeyType, sourceKey.getClass().getName());
                continue;
            }
            Object sourceVal = sourceProperty.last().produce();
            if (null == sourceVal) continue;
            String targetKey = this.specialMappingsReversed.get(sourceKey);
            if (null == targetKey) {
                String key;
                targetKey = S.string(sourceKey);
                if (null != this.keyTransformer) {
                    targetKey = S.string(this.keyTransformer.apply(targetKey));
                }
                String string = key = S.notBlank(prefix) ? S.pathConcat(prefix, '.', targetKey) : targetKey;
                if (!this.filter.test(key)) continue;
            }
            Object targetVal = adaptiveMap.getValue(targetKey);
            targetVal = this.prepareTargetComponent(sourceVal, targetVal, this.targetComponentRawType, this.targetComponentType, targetComponentIsContainer, "");
            adaptiveMap.putValue(targetKey, targetVal);
        }
    }

    private void toMap() {
        boolean targetComponentIsSequence;
        this.targetMap.clear();
        HashMap targetMapKeywordLookup = null;
        if (this.rule.keywordMatching() && String.class == this.targetKeyType) {
            targetMapKeywordLookup = new HashMap();
            for (Object key : this.targetMap.keySet()) {
                targetMapKeywordLookup.put(Keyword.of(key.toString()), key);
            }
        }
        boolean targetComponentIsMap = !(targetComponentIsSequence = DataMapper.isSequence(this.targetComponentRawType)) && DataMapper.isMap(this.targetComponentRawType);
        boolean targetComponentIsContainer = targetComponentIsMap || targetComponentIsSequence;
        String prefix = this.context.toString();
        for (Lang.Triple<Object, Keyword, Lang.Producer<Object>> sourceProperty : this.sourceProperties()) {
            Object sourceKey = sourceProperty.first();
            if (!this.ignoreGlobalFilter && sourceKey instanceof String && OsglConfig.globalMappingFilter_shouldIgnore(sourceKey.toString())) continue;
            if (!this.semantic.allowTypeConvert() && !$.is(sourceKey).allowBoxing().instanceOf(this.targetKeyType)) {
                this.logError("map key type mismatch, required: %s; found: %s", this.targetKeyType, sourceKey.getClass().getName());
                continue;
            }
            Object sourceVal = sourceProperty.last().produce();
            if (null == sourceVal || WAIVE_TYPE_LIST.contains(sourceVal.getClass())) continue;
            Keyword sourceKeyword = sourceProperty.second();
            Object targetKey = this.specialMappingsReversed.get(sourceKey);
            if (null == targetKey) {
                String key;
                if (targetMapKeywordLookup != null) {
                    targetKey = targetMapKeywordLookup.get(sourceKeyword);
                }
                if (targetKey == null) {
                    Object object = targetKey = this.semantic.isMapping() ? this.convert(sourceKey, this.targetKeyType).to(this.targetKeyType) : sourceKey;
                }
                if (null != this.keyTransformer) {
                    targetKey = this.keyTransformer.apply(targetKey);
                }
                String string = key = S.notBlank(prefix) ? S.pathConcat(prefix, '.', targetKey.toString()) : targetKey.toString();
                if (!this.filter.test(key)) continue;
            }
            Object targetVal = this.targetMap.get(targetKey);
            targetVal = this.prepareTargetComponent(sourceVal, targetVal, this.targetComponentRawType, this.targetComponentType, targetComponentIsContainer, targetKey instanceof String ? (String)targetKey : "");
            this.targetMap.put(targetKey, targetVal);
        }
    }

    private Set<String> toPojo() {
        HashSet<String> mapped = new HashSet<String>();
        Map sourceMap = Map.class.isAssignableFrom(this.sourceType) ? (Map)this.source : null;
        HashMap sourceMapByKeyword = null;
        if (this.rule.keywordMatching()) {
            sourceMapByKeyword = new HashMap();
            if (null != sourceMap) {
                for (Map.Entry entry : sourceMap.entrySet()) {
                    sourceMapByKeyword.put(Keyword.of(entry.getKey().toString()), entry.getValue());
                }
            } else {
                for (Field field : $.fieldsOf(this.sourceType)) {
                    sourceMapByKeyword.put(Keyword.of(field.getName()), field);
                }
            }
        }
        String prefix = this.context.toString();
        for (Field targetField : this.targetFields) {
            IntermediatePlaceHolder sourcePropValue;
            String specialMap;
            String key;
            String targetFieldName;
            Class<?> targetFieldType;
            block26: {
                targetFieldType = targetField.getType();
                if (this.circularReferenceDetector.contains(targetFieldType)) continue;
                targetFieldName = targetField.getName();
                if (!this.ignoreGlobalFilter && OsglConfig.globalMappingFilter_shouldIgnore(targetFieldName)) continue;
                String string = key = S.notBlank(prefix) ? S.pathConcat(prefix, '.', targetFieldName) : targetFieldName;
                if (!this.filter.test(key)) continue;
                specialMap = this.specialMapping.get(key);
                sourcePropValue = null;
                if (null != specialMap) {
                    if (this.source instanceof IntermediatePlaceHolder) {
                        Object root = ((IntermediatePlaceHolder)this.source).rootSource;
                        sourcePropValue = (IntermediatePlaceHolder)$.getProperty(root, specialMap);
                    } else {
                        try {
                            sourcePropValue = (IntermediatePlaceHolder)$.getProperty(this.source, specialMap);
                        }
                        catch (Exception e) {
                            if (S.notBlank(prefix) && this.specialMapping.containsKey(prefix)) {
                                String targetPrefix = this.specialMapping.get(prefix);
                                if (specialMap.startsWith(targetPrefix + ".")) {
                                    specialMap = specialMap.substring(targetPrefix.length() + 1);
                                }
                            }
                            if (!specialMap.contains(".")) break block26;
                            specialMap = S.cut(specialMap).afterLast(".");
                        }
                    }
                }
            }
            ParameterizedType targetFieldGenericType = null;
            if (null == sourcePropValue) {
                Type type = targetField.getGenericType();
                ParameterizedType parameterizedType = targetFieldGenericType = type instanceof ParameterizedType ? (ParameterizedType)type : null;
                if (null != sourceMapByKeyword) {
                    sourcePropValue = sourceMapByKeyword.get(Keyword.of(null == specialMap ? targetFieldName : specialMap));
                    if (null == sourcePropValue) continue;
                    if (sourcePropValue instanceof Field) {
                        sourcePropValue = $.getFieldValue(this.source, (Field)((Object)sourcePropValue));
                    }
                } else if (null != sourceMap) {
                    sourcePropValue = sourceMap.get(null == specialMap ? targetFieldName : specialMap);
                } else {
                    Field sourceField = $.fieldOf(this.sourceType, null == specialMap ? targetFieldName : specialMap);
                    IntermediatePlaceHolder intermediatePlaceHolder = sourcePropValue = null == sourceField ? null : (IntermediatePlaceHolder)$.getFieldValue(this.source, sourceField);
                }
            }
            if (null == sourcePropValue) {
                if (!this.semantic.isShallowCopy() && this.intermediates.contains(key)) {
                    sourcePropValue = new IntermediatePlaceHolder(this.source);
                }
                if (null == sourcePropValue) {
                    if (!this.semantic.isCopy()) continue;
                    $.setFieldValue(this.target, targetField, $.convert(null).to(targetFieldType));
                    continue;
                }
            }
            if (this.semantic.isShallowCopy() || this.isTransient(targetField)) {
                try {
                    $.setFieldValue(this.target, targetField, sourcePropValue);
                }
                catch (Exception e) {
                    this.logError(e, "Error setting field for shallow copy", new Object[0]);
                }
                continue;
            }
            boolean targetFieldIsContainer = DataMapper.isContainer(targetFieldType);
            if (!(targetFieldIsContainer || this.semantic.allowTypeConvert() || this.isIntermediatePlaceHolder(sourcePropValue) || $.is(sourcePropValue).allowBoxing().instanceOf(targetFieldType))) {
                this.logError("Type mismatch copy source [%s] to field[%s|%s]", sourcePropValue.getClass().getName(), targetFieldName, targetFieldType.getName());
                continue;
            }
            Object targetFieldValue = $.getFieldValue(this.target, targetField);
            targetFieldValue = this.prepareTargetComponent(sourcePropValue, targetFieldValue, targetFieldType, targetFieldGenericType, targetFieldIsContainer, targetFieldName);
            $.setFieldValue(this.target, targetField, targetFieldValue);
            mapped.add(key);
        }
        return mapped;
    }

    private boolean isTransient(Field field) {
        return Modifier.isTransient(field.getModifiers());
    }

    private boolean isIntermediatePlaceHolder(Object o) {
        return o instanceof IntermediatePlaceHolder;
    }

    private Iterable<Lang.Triple<Object, Keyword, Lang.Producer<Object>>> sourceProperties() {
        return this.sourceProperties(this.semantic.isFlatCopy());
    }

    private Iterable<Lang.Triple<Object, Keyword, Lang.Producer<Object>>> sourceProperties(boolean flat) {
        if (flat) {
            return this.flatSourceProperties();
        }
        Class<Object> sourceType = this.sourceType;
        Map<String, Object> source = this.source;
        if (AdaptiveMap.class.isAssignableFrom(sourceType)) {
            sourceType = Map.class;
            source = ((AdaptiveMap)((Object)source)).asMap();
        }
        if (Map.class.isAssignableFrom(sourceType)) {
            return C.list(source.entrySet()).map(new Lang.Transformer<Map.Entry, Lang.Triple<Object, Keyword, Lang.Producer<Object>>>(){

                @Override
                public Lang.Triple<Object, Keyword, Lang.Producer<Object>> transform(final Map.Entry entry) {
                    Lang.Producer<Object> producer = new Lang.Producer<Object>(){

                        @Override
                        public Object produce() {
                            return entry.getValue();
                        }
                    };
                    Object key = entry.getKey();
                    Keyword keyword = null;
                    if (DataMapper.this.rule.keywordMatching() && key instanceof String) {
                        keyword = Keyword.of(key.toString());
                    }
                    return $.T3(key, keyword, producer);
                }
            });
        }
        List<Field> fields = $.fieldsOf(sourceType);
        return C.list(fields).filter(this.fieldFilter()).map(new Lang.Transformer<Field, Lang.Triple<Object, Keyword, Lang.Producer<Object>>>(){

            @Override
            public Lang.Triple<Object, Keyword, Lang.Producer<Object>> transform(final Field field) {
                String name = field.getName();
                Keyword keyword = null;
                if (DataMapper.this.rule.keywordMatching()) {
                    keyword = Keyword.of(name.toString());
                }
                Lang.Producer<Object> producer = new Lang.Producer<Object>(){

                    @Override
                    public Object produce() {
                        return $.getFieldValue(DataMapper.this.source, field);
                    }
                };
                return $.T3(name, keyword, producer);
            }
        });
    }

    private Iterable<Lang.Triple<Object, Keyword, Lang.Producer<Object>>> flatSourceProperties() {
        ArrayList<Lang.Triple<Object, Keyword, Lang.Producer<Object>>> retVal = new ArrayList<Lang.Triple<Object, Keyword, Lang.Producer<Object>>>();
        this.buildFlatSourceProperties(retVal, "", this.sourceType, this.source);
        return retVal;
    }

    private void buildFlatSourceProperties(List<Lang.Triple<Object, Keyword, Lang.Producer<Object>>> retVal, String context, Class<?> sourceType, Object source) {
        if (AdaptiveMap.class.isAssignableFrom(sourceType)) {
            source = ((AdaptiveMap)((Object)source)).asMap();
            sourceType = Map.class;
        }
        if (Map.class.isAssignableFrom(sourceType)) {
            for (Map.Entry<String, Object> o : source.entrySet()) {
                Map.Entry entry = (Map.Entry)$.cast(o);
                final Object v = entry.getValue();
                if (null == v) continue;
                Class<?> vType = v.getClass();
                String key = S.string(entry.getKey());
                if (S.notBlank(context)) {
                    key = S.concat(context, ".", key);
                }
                if (OsglConfig.globalMappingFilter_shouldIgnore(key) || !this.filter.test(key)) continue;
                Keyword keyword = null;
                if (this.rule.keywordMatching()) {
                    keyword = Keyword.of(key);
                }
                if ($.isImmutable(vType)) {
                    Lang.Producer<Object> producer = new Lang.Producer<Object>(){

                        @Override
                        public Object produce() {
                            return v;
                        }
                    };
                    retVal.add($.T3(key, keyword, producer));
                    continue;
                }
                this.buildFlatSourceProperties(retVal, key, vType, v);
            }
        } else {
            List<Field> fields = $.fieldsOf(sourceType);
            Lang.Predicate<Field> filter = this.fieldFilter();
            for (Field field : fields) {
                Class<?> vType;
                Object v;
                if (!filter.test(field) || null == (v = $.getFieldValue(source, field))) continue;
                String key = field.getName();
                if (S.notBlank(context)) {
                    key = S.concat(context, ".", key);
                }
                Keyword keyword = null;
                if (this.rule.keywordMatching()) {
                    keyword = Keyword.of(key);
                }
                if (DataMapper.isTerminateType(vType = field.getType())) {
                    Lang.Producer<Object> producer = new Lang.Producer<Object>(){

                        @Override
                        public Object produce() {
                            return v;
                        }
                    };
                    retVal.add($.T3(key, keyword, producer));
                    continue;
                }
                this.buildFlatSourceProperties(retVal, key, vType, v);
            }
        }
    }

    private Lang.Predicate<Field> fieldFilter() {
        if (this.filter.allEmpty) {
            return Lang.F.yes();
        }
        return new Lang.Predicate<Field>(){

            @Override
            public boolean test(Field field) {
                String key = field.getName();
                if (OsglConfig.globalMappingFilter_shouldIgnore(key)) {
                    return false;
                }
                String prefix = DataMapper.this.context.toString();
                if (S.notBlank(prefix)) {
                    key = S.pathConcat(prefix, '.', key);
                }
                return DataMapper.this.filter.test(key);
            }
        };
    }

    private Object prepareTargetComponent(Object sourceComponent, Object targetComponent, Class targetComponentType, ParameterizedType targetComponentGenericType, boolean targetComponentIsContainer, String key) {
        if (this.semantic.isShallowCopy() || DataMapper.isImmutable(targetComponentType)) {
            if (this.semantic.allowTypeConvert() && !$.is(sourceComponent).allowBoxing().instanceOf(targetComponentType)) {
                return this.convert(sourceComponent, targetComponentType).to(targetComponentType);
            }
            return sourceComponent;
        }
        Object convertedTargetComponent = null;
        if (!targetComponentIsContainer && DataMapper.isTerminateType(targetComponentType) && this.semantic.isMapping()) {
            convertedTargetComponent = this.convert(sourceComponent, targetComponentType).to(targetComponentType);
        }
        if (null != convertedTargetComponent) {
            return convertedTargetComponent;
        }
        if (null != targetComponent) {
            if (targetComponentType.isInterface()) {
                Class<?> realComponentType = targetComponent.getClass();
                if (Map.class == targetComponentType) {
                    if (HashMap.class != realComponentType && LinkedHashMap.class != realComponentType && TreeMap.class != realComponentType) {
                        if (C.Map.class.isAssignableFrom(realComponentType)) {
                            C.Map map = (C.Map)((Object)targetComponent);
                            if (map.isReadOnly()) {
                                C.Map newMap = C.newMap(map);
                                targetComponent = newMap;
                            }
                        } else {
                            HashMap map = new HashMap();
                            map.putAll((Map)((Object)targetComponent));
                            targetComponent = map;
                        }
                    }
                } else if (List.class == targetComponentType) {
                    if (ArrayList.class != realComponentType && LinkedList.class != realComponentType && JSONArray.class != realComponentType && Vector.class != realComponentType) {
                        if (C.List.class.isAssignableFrom(realComponentType)) {
                            C.List realComponentList = targetComponent;
                            if (realComponentList.is(C.Feature.READONLY)) {
                                C.List list = C.newList();
                                list.addAll(realComponentList);
                                targetComponent = list;
                            }
                        } else {
                            ArrayList list = new ArrayList();
                            list.addAll(targetComponent);
                            targetComponent = list;
                        }
                    }
                } else if (Set.class == targetComponentType) {
                    if (HashSet.class != realComponentType && TreeSet.class != realComponentType && LinkedHashSet.class != realComponentType) {
                        if (C.Set.class.isAssignableFrom(realComponentType)) {
                            C.Set set = (C.Set)((Object)targetComponent);
                            if (set.is(C.Feature.READONLY)) {
                                C.Set newSet = C.newSet(set);
                                targetComponent = newSet;
                            }
                        } else {
                            HashSet set = new HashSet();
                            set.addAll((Set)((Object)targetComponent));
                            targetComponent = set;
                        }
                    }
                } else if (SortedMap.class == targetComponentType) {
                    if (TreeMap.class != realComponentType) {
                        TreeMap map = new TreeMap();
                        map.putAll((Map)((Object)targetComponent));
                        targetComponent = map;
                    }
                } else if (SortedSet.class == targetComponentType && TreeSet.class != realComponentType) {
                    TreeSet set = new TreeSet();
                    set.addAll((Set)((Object)targetComponent));
                    targetComponent = set;
                }
            }
            targetComponent = new DataMapper(sourceComponent, targetComponent, key, targetComponentGenericType, this).getTarget();
        } else {
            targetComponent = this.copyOrReferenceOf(sourceComponent, sourceComponent.getClass(), key, targetComponentType, targetComponentGenericType);
        }
        return targetComponent;
    }

    private void logError(Throwable cause) {
        if (!this.ignoreError) {
            this.mappingError(cause, "Error mapping from %s to %s", this.sourceType.getName(), this.targetType.getName());
        }
    }

    private void logError(Throwable cause, String message, Object ... messageArgs) {
        if (!this.ignoreError) {
            this.mappingError(cause, message, messageArgs);
        }
    }

    private void logError(String message, Object ... messageArgs) {
        if (!this.ignoreError) {
            this.mappingError(message, messageArgs);
        }
    }

    private void logMappingFailure() {
        this.logError("Error mapping from %s to %s", this.sourceType.getName(), this.targetType.getName());
    }

    private <T> T convertSourceTo(Class<T> type) {
        try {
            return this.convertStage(type, !this.ignoreError).to(type);
        }
        catch (Exception e) {
            this.logError(e, "Cannot convert source into " + type.getName(), new Object[0]);
            return null;
        }
    }

    private <T> T tryConvertSourceTo(Class<T> type) {
        return this.convertStage(type, false).to(type);
    }

    private Lang._ConvertStage<?> convertStage() {
        return this.convert(this.source, this.targetType, !this.ignoreError);
    }

    private Lang._ConvertStage<?> convertStage(Class targetType, boolean reportError) {
        return this.convert(this.source, targetType, reportError);
    }

    private Lang._ConvertStage<?> convert(Object source, Class targetType) {
        return this.convert(source, targetType, !this.ignoreError);
    }

    private Lang._ConvertStage<?> convert(Object source, Class targetType, boolean reportError) {
        Lang._ConvertStage<Object> stage = $.convert(source).customTypeConverters(this.typeConverterRegistry).hint(this.convertHintOf(targetType));
        if (!reportError) {
            stage.reportError();
        }
        return stage;
    }

    private Object convertHintOf(Class type) {
        return this.conversionHints.get(type);
    }

    private void mappingError(Throwable cause, String message, Object ... messageArgs) {
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        throw new MappingException(this.source, this.target, cause, message, messageArgs);
    }

    private MappingException mappingError(String message, Object ... messageArgs) {
        throw new MappingException(this.source, this.target, message, messageArgs);
    }

    private void probeTargetType() {
        this.targetIsArray = this.targetType.isArray();
        boolean bl = this.targetIsSimpleType = !this.targetIsArray && $.isSimpleType(this.targetType);
        if (!this.targetIsSimpleType) {
            this.targetCollection = !this.targetIsArray && Collection.class.isAssignableFrom(this.targetType) ? (Collection)this.target : null;
            this.targetIsCollection = null != this.targetCollection;
            this.targetList = this.targetIsCollection && List.class.isAssignableFrom(this.targetType) ? (List)this.target : null;
            this.targetIsList = null != this.targetList;
            this.targetMap = !this.targetIsArray && null == this.targetCollection && Map.class.isAssignableFrom(this.targetType) ? (Map)this.target : null;
            this.targetIsMap = null != this.targetMap;
            boolean bl2 = this.targetIsPojo = !this.targetIsArray && !this.targetIsCollection && !this.targetIsMap;
        }
        if (this.targetIsArray) {
            this.targetLength = Array.getLength(this.target);
            this.targetComponentRawType = this.targetType.getComponentType();
        } else {
            if (this.targetIsPojo) {
                this.targetFields = $.fieldsOf(this.targetType, this.rootClass, true);
            }
            if (null != this.targetGenericType) {
                Type[] ta = this.targetGenericType.getActualTypeArguments();
                Type componentType = null;
                if (null != this.targetMap) {
                    this.targetKeyType = (Class)ta[0];
                    componentType = ta[1];
                } else if (null != this.targetCollection) {
                    componentType = ta[0];
                }
                if (null != componentType) {
                    if (componentType instanceof ParameterizedType) {
                        this.targetComponentType = (ParameterizedType)componentType;
                        this.targetComponentRawType = (Class)this.targetComponentType.getRawType();
                    } else {
                        this.targetComponentRawType = (Class)componentType;
                    }
                }
            }
            if (this.targetList != null) {
                this.targetLength = this.targetList.size();
            }
        }
        if (this.targetIsMap) {
            if (null == this.targetKeyType) {
                this.targetKeyType = $.commonSuperTypeOf(this.targetMap.keySet());
                if (null == this.targetKeyType) {
                    this.targetKeyType = String.class;
                }
            }
            if (null == this.targetComponentRawType) {
                this.targetComponentRawType = $.commonSuperTypeOf(this.targetMap.values());
                if (null == this.targetComponentRawType) {
                    this.targetComponentRawType = Object.class;
                }
            }
        }
        if (this.targetIsCollection && null == this.targetComponentRawType) {
            this.targetComponentRawType = $.commonSuperTypeOf(this.targetCollection);
        }
    }

    private Object copyOrReferenceOf(Object source) {
        return this.copyOrReferenceOf(source, "", null, null);
    }

    private Object copyOrReferenceOf(Object source, String targetName, Class targetType, ParameterizedType targetGenericType) {
        return this.copyOrReferenceOf(source, source.getClass(), targetName, targetType, targetGenericType);
    }

    private Object copyOrReferenceOf(Object source, Class sourceType, String targetName, Class targetType, ParameterizedType targetGenericType) {
        if (this.semantic.isShallowCopy() || DataMapper.isImmutable(sourceType)) {
            if (!targetType.isInstance(source)) {
                if (this.semantic.isMapping() || this.semantic.isMergeMapping()) {
                    return this.convert(source, targetType).reportError().to(targetType);
                }
                throw E.unexpected("Cannot convert source[%s] to target type: %s", source, targetType);
            }
            return source;
        }
        Object target = null;
        if (Object.class == targetType) {
            if (sourceType.isArray()) {
                targetType = sourceType;
            } else if (List.class.isAssignableFrom(sourceType)) {
                target = LinkedList.class.isAssignableFrom(sourceType) ? new LinkedList() : new ArrayList();
            } else if (Map.class.isAssignableFrom(sourceType)) {
                target = SortedMap.class.isAssignableFrom(sourceType) ? new TreeMap() : (LinkedHashMap.class.isAssignableFrom(sourceType) ? new LinkedHashMap() : new HashMap());
            } else if (Set.class.isAssignableFrom(sourceType)) {
                target = SortedSet.class.isAssignableFrom(sourceType) ? new TreeSet() : (LinkedHashSet.class.isAssignableFrom(sourceType) ? new LinkedHashMap() : new HashSet());
            } else if (DataMapper.isTerminateType(sourceType)) {
                targetType = sourceType;
            } else {
                target = new JSONObject();
            }
        } else if (targetType.isAssignableFrom(sourceType)) {
            if (!sourceType.isArray()) {
                try {
                    target = this.instanceFactory.apply(sourceType);
                    targetType = sourceType;
                }
                catch (Exception e) {
                    if (List.class.isAssignableFrom(sourceType) && targetType.isAssignableFrom(List.class)) {
                        targetType = ArrayList.class;
                    } else if (Map.class.isAssignableFrom(sourceType) && targetType.isAssignableFrom(Map.class)) {
                        targetType = HashMap.class;
                    } else if (Set.class.isAssignableFrom(sourceType) && targetType.isAssignableFrom(Set.class)) {
                        targetType = HashSet.class;
                    }
                }
            } else {
                targetType = sourceType;
            }
        }
        if (null == target) {
            if (targetType.isArray()) {
                int len;
                if (sourceType.isArray()) {
                    len = Array.getLength(source);
                } else if (Collection.class.isAssignableFrom(sourceType)) {
                    len = ((Collection)source).size();
                } else {
                    throw new UnexpectedException("oops, how come source is not a array/collection??");
                }
                target = Array.newInstance(targetType.getComponentType(), len);
            } else {
                try {
                    target = this.instanceFactory.apply(targetType);
                }
                catch (Exception e) {
                    try {
                        target = this.convert(source, targetType).to(targetType);
                    }
                    catch (Exception e2) {
                        throw E.unexpected(e, "", new Object[0]);
                    }
                }
            }
        }
        return new DataMapper(source, target, targetName, targetGenericType, this).getTarget();
    }

    private static boolean isSequence(Class<?> type) {
        return type.isArray() || Collection.class.isAssignableFrom(type);
    }

    private static boolean isMap(Class<?> type) {
        return Map.class.isAssignableFrom(type);
    }

    private static boolean isContainer(Class<?> type) {
        return DataMapper.isSequence(type) || DataMapper.isMap(type);
    }

    private static Class elementTypeOf(Object o) {
        Class<?> type = o.getClass();
        if (type.isArray()) {
            return type.getComponentType();
        }
        Collection collection = (Collection)o;
        return $.commonSuperTypeOf(collection);
    }

    private static boolean isImmutable(Class<?> type) {
        return !type.isArray() && ($.isSimpleType(type) || $.isImmutable(type));
    }

    private static boolean isTerminateType(Class<?> type) {
        return DataMapper.isImmutable(type) || Date.class.isAssignableFrom(type) || Calendar.class.isAssignableFrom(type);
    }

    public static Lang.Function keyTransformer(final Keyword.Style targetStyle) {
        Lang.Function f2 = keywordTransformers.get((Object)targetStyle);
        if (null == f2) {
            f2 = new Lang.Function(){

                public Object apply(Object o) throws NotAppliedException, Lang.Break {
                    return targetStyle.toString(Keyword.of(o.toString()));
                }
            };
            keywordTransformers.put(targetStyle, f2);
        }
        return f2;
    }

    class PropertyFilter
    extends Lang.Predicate<String> {
        private NameList whiteList;
        private NameList blackList;
        private NameList grayList;
        private NameList greenList;
        private boolean allEmpty;

        /*
         * WARNING - void declaration
         */
        PropertyFilter(String spec) {
            this.whiteList = new NameList(DataMapper.this.rule.keywordMatching());
            this.blackList = new NameList(DataMapper.this.rule.keywordMatching());
            this.grayList = new NameList(DataMapper.this.rule.keywordMatching());
            this.greenList = new NameList(DataMapper.this.rule.keywordMatching());
            this.allEmpty = true;
            if (S.blank(spec)) {
                return;
            }
            C.List<S.List> words = C.newList(S.fastSplit(spec, ","));
            Collections.sort(words, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1.startsWith("-")) {
                        return o2.startsWith("-") ? o1.compareTo(o2) : -1;
                    }
                    if (o2.startsWith("-")) {
                        return 1;
                    }
                    return o1.compareTo(o2);
                }
            });
            boolean removeDefaultContextFromGreenList = false;
            for (String string : words) {
                void var6_10;
                boolean isBlackList = false;
                if (string.startsWith("-")) {
                    isBlackList = true;
                    String string2 = string.substring(1);
                } else if (string.startsWith("+")) {
                    String string3 = string.substring(1);
                }
                String string4 = var6_10.trim();
                String context = "";
                if (string4.contains(".")) {
                    context = S.cut(string4).beforeLast(".");
                }
                if (isBlackList) {
                    if (this.grayList.contains(string4)) continue;
                    this.blackList.add(string4);
                    this.greenList.add(context);
                    continue;
                }
                if (this.blackList.contains(string4)) continue;
                this.whiteList.add(string4);
                if (string4.contains(".")) {
                    this.blackList.remove(context);
                    this.grayList.add(context);
                    continue;
                }
                removeDefaultContextFromGreenList = true;
            }
            if (removeDefaultContextFromGreenList) {
                this.greenList.remove("");
            }
            this.allEmpty = this.blackList.isEmpty() && this.whiteList.isEmpty();
        }

        private boolean isContextIn(String s, NameList list) {
            if (s.contains(".")) {
                String context = S.beforeLast(s, ".");
                return list.contains(context) || this.isContextIn(context, list);
            }
            return list.contains("");
        }

        @Override
        public boolean test(String s) {
            if (this.allEmpty) {
                return true;
            }
            E.illegalArgumentIf(S.blank(s));
            if (this.whiteList.contains(s) || this.grayList.contains(s) || this.isContextIn(s, this.whiteList)) {
                return true;
            }
            if (this.blackList.contains(s)) {
                return false;
            }
            if (this.isContextIn(s, this.grayList)) {
                return false;
            }
            if (this.isContextIn(s, this.greenList)) {
                return true;
            }
            return this.whiteList.isEmpty();
        }

        private void addIntoBlackList(String s) {
            this.blackList.add(s);
            this.allEmpty = false;
        }
    }

    private static class NameList {
        private boolean useKeyword;
        private Set<String> stringList = C.Set();
        private Set<Keyword> keywordList = C.Set();

        NameList(boolean useKeywordMatching) {
            this.useKeyword = useKeywordMatching;
            if (useKeywordMatching) {
                this.keywordList = new HashSet<Keyword>();
            } else {
                this.stringList = new HashSet<String>();
            }
        }

        void add(String key) {
            if (this.useKeyword) {
                this.keywordList.add(Keyword.of(key));
            } else {
                this.stringList.add(key);
            }
        }

        boolean remove(String key) {
            if (this.useKeyword) {
                return this.keywordList.remove(Keyword.of(key));
            }
            return this.stringList.remove(key);
        }

        boolean isEmpty() {
            return this.stringList.isEmpty() && this.keywordList.isEmpty();
        }

        boolean contains(String key) {
            return this.useKeyword ? this.keywordList.contains(Keyword.of(key)) : this.stringList.contains(key);
        }
    }

    public static enum Semantic {
        SHALLOW_COPY,
        DEEP_COPY,
        FLAT_COPY,
        MERGE,
        MAP,
        MERGE_MAP;


        boolean isShallowCopy() {
            return this == SHALLOW_COPY;
        }

        boolean isDeepCopy() {
            return this == DEEP_COPY;
        }

        boolean isFlatCopy() {
            return this == FLAT_COPY;
        }

        boolean isCopy() {
            return this.isShallowCopy() || this.isDeepCopy() || this.isMapping();
        }

        boolean isMerge() {
            return this == MERGE;
        }

        boolean isMapping() {
            return this == MAP;
        }

        boolean isMergeMapping() {
            return this == MERGE_MAP;
        }

        boolean isAppend() {
            return this.isMerge() || this.isMergeMapping();
        }

        boolean allowTypeConvert() {
            return this.isMapping() || this.isMergeMapping();
        }
    }

    public static enum MappingRule {
        STRICT_MATCHING,
        KEYWORD_MATCHING;


        public boolean keywordMatching() {
            return this == KEYWORD_MATCHING;
        }
    }

    private static final class IntermediatePlaceHolder {
        private Object rootSource;

        IntermediatePlaceHolder(Object rootSource) {
            this.rootSource = rootSource;
        }
    }
}

