/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgl.$;
import org.osgl.exception.UnexpectedException;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class Generics {
    public static <T> Class<T> classOf(Type type) {
        if (type instanceof Class) {
            return (Class)$.cast(type);
        }
        if (type instanceof ParameterizedType) {
            return (Class)$.cast(((ParameterizedType)type).getRawType());
        }
        throw new IllegalArgumentException("Cannot find class from type: " + type);
    }

    public static List<Type> typeParamImplementations(Class theClass, Class rootClass) {
        if (rootClass.getTypeParameters().length == 0) {
            return C.list();
        }
        try {
            return Generics.typeParamImplementations(theClass, rootClass, new ArrayList<Type>(), true);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(S.fmt("Cannot infer type parameter implementation on %s against %s", theClass.getName(), rootClass.getName()), e);
        }
    }

    public static List<Type> tryGetTypeParamImplementations(Class theClass, Class rootClass) {
        if (rootClass.getTypeParameters().length == 0) {
            return C.list();
        }
        try {
            return Generics.typeParamImplementations(theClass, rootClass, new ArrayList<Type>(), false);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(S.fmt("Cannot infer type parameter implementation on %s against %s", theClass.getName(), rootClass.getName()), e);
        }
    }

    public static Map<String, Class> subLookup(Map<String, Class> lookup, String prefix) {
        if (S.blank(prefix)) {
            return lookup;
        }
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        HashMap<String, Class> subLookup = new HashMap<String, Class>();
        if (null == lookup) {
            return subLookup;
        }
        for (Map.Entry<String, Class> entry : lookup.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(prefix)) continue;
            subLookup.put(key.substring(prefix.length()), entry.getValue());
        }
        return subLookup;
    }

    public static Map<String, Class> buildTypeParamImplLookup(Class theClass) {
        HashMap<String, Class> lookup = new HashMap<String, Class>();
        Generics.buildTypeParamImplLookup(theClass, lookup);
        return lookup;
    }

    public static void buildTypeParamImplLookup(Class theClass, Map<String, Class> lookup) {
        if (null == theClass || Object.class == theClass) {
            return;
        }
        Type superType = theClass.getGenericSuperclass();
        if (superType instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)$.cast(superType);
            Type[] typeParams = ptype.getActualTypeArguments();
            TypeVariable[] typeArgs = theClass.getSuperclass().getTypeParameters();
            Generics.buildTypeParamImplLookup("", typeParams, typeArgs, lookup);
        }
        Generics.buildTypeParamImplLookup(theClass.getSuperclass(), lookup);
    }

    public static void buildTypeParamImplLookup(String prefix, Type[] typeParams, TypeVariable[] typeArgs, Map<String, Class> lookup) {
        int len = typeParams.length;
        for (int i = 0; i < len; ++i) {
            Type typeParam = typeParams[i];
            if (typeParam instanceof Class) {
                TypeVariable typeVar = typeArgs[i];
                lookup.put(Generics.lookupKey(typeVar, prefix), (Class)typeParam);
                continue;
            }
            if (typeParam instanceof TypeVariable) {
                TypeVariable var = (TypeVariable)$.cast(typeParam);
                String name = var.getName();
                Class impl = lookup.get(name);
                TypeVariable typeVar = typeArgs[i];
                if (null != impl) {
                    lookup.put(Generics.lookupKey(typeVar, prefix), impl);
                } else {
                    Type bound;
                    Type[] ta = var.getBounds();
                    if (null != ta && ta.length == 1 && (bound = ta[0]) instanceof Class) {
                        lookup.put(Generics.lookupKey(typeVar, prefix), (Class)bound);
                    }
                }
                Map<String, Class> subLookup = Generics.subLookup(lookup, name);
                if (subLookup.isEmpty()) continue;
                String newPrefix = typeVar.getName() + ".";
                for (Map.Entry<String, Class> entry : subLookup.entrySet()) {
                    lookup.put(newPrefix + entry.getKey(), entry.getValue());
                }
                continue;
            }
            if (!(typeParam instanceof ParameterizedType)) continue;
            ParameterizedType ptype0 = (ParameterizedType)typeParam;
            TypeVariable typeVar = typeArgs[i];
            Type rawType = ptype0.getRawType();
            if (rawType instanceof Class) {
                lookup.put(Generics.lookupKey(typeVar, prefix), (Class)rawType);
                Generics.buildTypeParamImplLookup(Generics.lookupKey(typeVar, prefix), ptype0.getActualTypeArguments(), ((Class)rawType).getTypeParameters(), lookup);
                continue;
            }
            throw new UnexpectedException("Unknown typeParam: " + ptype0);
        }
    }

    private static String lookupKey(TypeVariable typeVar, String prefix) {
        return S.isBlank(prefix) ? typeVar.getName() : S.concat(prefix, ".", typeVar.getName());
    }

    public static Class<?> getReturnType(Method method, Class<?> theClass) {
        String name;
        Map<String, Class> lookup;
        Class realType;
        Type type = method.getGenericReturnType();
        if (type == Class.class) {
            return (Class)$.cast(type);
        }
        if (type instanceof TypeVariable && null != (realType = (lookup = Generics.buildTypeParamImplLookup(theClass)).get(name = ((TypeVariable)type).getName()))) {
            return realType;
        }
        return method.getReturnType();
    }

    private static List<Type> typeParamImplementations(Class theClass, Class rootClass, List<Type> subClassTypeParams, boolean raiseExceptionIfNotFound) {
        Type[] interfaces;
        Type superType = null;
        for (Type intf : interfaces = theClass.getGenericInterfaces()) {
            Type rawType;
            if (!(intf instanceof ParameterizedType) || !$.eq(rawType = ((ParameterizedType)intf).getRawType(), rootClass)) continue;
            superType = intf;
        }
        if (null == superType) {
            superType = theClass.getGenericSuperclass();
        }
        Class superClass = null;
        boolean theClassIsInterface = theClass.isInterface();
        while (!(superType instanceof ParameterizedType) && Object.class != superType) {
            if (theClassIsInterface) {
                try {
                    Type[] types;
                    if (null == superClass) {
                        superClass = theClass;
                    }
                    if ((types = superClass.getGenericInterfaces()).length == 0) break;
                    superType = types[0];
                    Class<?>[] intfs = theClass.getInterfaces();
                    superClass = intfs[0];
                    continue;
                }
                catch (RuntimeException e) {
                    throw new UnexpectedException("Cannot find type implementation for %s", theClass);
                }
            }
            if (null == superClass) {
                superClass = theClass.getSuperclass();
            }
            superType = superClass.getGenericSuperclass();
            superClass = superClass.getSuperclass();
        }
        if (superType instanceof ParameterizedType) {
            TypeVariable<Class<T>>[] declaredTypeVariables = theClass.getTypeParameters();
            ParameterizedType pSuperType = (ParameterizedType)$.cast(superType);
            Type[] superTypeParams = pSuperType.getActualTypeArguments();
            ArrayList<Type> nextList = new ArrayList<Type>();
            for (Type stp : superTypeParams) {
                if (stp instanceof Class || stp instanceof ParameterizedType) {
                    nextList.add(stp);
                    continue;
                }
                if (!(stp instanceof TypeVariable)) continue;
                boolean found = false;
                for (int i = 0; i < declaredTypeVariables.length && subClassTypeParams.size() > i; ++i) {
                    TypeVariable declared = declaredTypeVariables[i];
                    if (!$.eq(declared, stp)) continue;
                    nextList.add(subClassTypeParams.get(i));
                    found = true;
                    break;
                }
                if (found) continue;
                if (raiseExceptionIfNotFound) {
                    E.illegalArgumentIf(!found, "Cannot find type implementation for %s", theClass);
                }
                return C.list();
            }
            superClass = (Class)pSuperType.getRawType();
            if ($.eq(superClass, rootClass)) {
                return nextList;
            }
            return Generics.typeParamImplementations(superClass, rootClass, nextList, raiseExceptionIfNotFound);
        }
        if (raiseExceptionIfNotFound) {
            throw E.unexpected("Cannot find type param implementation: super type %s of %s is not a parameterized type", superType, theClass);
        }
        return C.list();
    }

    public static void main(String[] args) {
        Class<Serializable> c = Serializable.class;
        System.out.println(c.getGenericSuperclass());
        System.out.println($.toString2(c.getGenericInterfaces()));
    }
}

