/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.stream.ImageInputStream;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.exception.ResourceNotFoundException;
import org.osgl.storage.ISObject;
import org.osgl.storage.impl.SObject;
import org.osgl.util.BeanInfo;
import org.osgl.util.ByteBufferInputStream;
import org.osgl.util.Codec;
import org.osgl.util.E;
import org.osgl.util.FastStr;
import org.osgl.util.Img;
import org.osgl.util.Keyword;
import org.osgl.util.MimeType;
import org.osgl.util.OS;
import org.osgl.util.ReaderInputStream;
import org.osgl.util.S;
import org.osgl.util.TypeReference;
import org.osgl.util.XML;
import org.w3c.dom.Document;

public class IO {
    private static Map<MimeType, InputStreamHandlerDispatcher> inputStreamHandlerLookup = new HashMap<MimeType, InputStreamHandlerDispatcher>();

    public static void registerInputStreamHandler(MimeType type, InputStreamHandler handler) {
        $.requireNotNull(handler);
        InputStreamHandlerDispatcher dispatcher = inputStreamHandlerLookup.get(type);
        if (null == dispatcher) {
            dispatcher = new InputStreamHandlerDispatcher(handler);
            inputStreamHandlerLookup.put(type, dispatcher);
        } else {
            dispatcher.add(handler);
        }
    }

    public static void registerInputStreamHandler(MimeType.Trait trait, InputStreamHandler handler) {
        $.requireNotNull(handler);
        List<MimeType> mimeTypes = MimeType.filterByTrait(trait);
        for (MimeType mimeType : mimeTypes) {
            IO.registerInputStreamHandler(mimeType, handler);
        }
    }

    public static CharSequenceWriteStage write(CharSequence csq) {
        return new CharSequenceWriteStage(csq);
    }

    public static ReaderWriteStage write(Reader reader) {
        return new ReaderWriteStage(reader);
    }

    public static InputStreamWriteStage write(InputStream inputStream) {
        return new InputStreamWriteStage(inputStream);
    }

    public static InputStreamWriteStage write(byte[] bytes) {
        return IO.write(new ByteArrayInputStream(bytes));
    }

    public static FileWriteStage write(File file) {
        return new FileWriteStage(file);
    }

    public static UrlWriteStage write(URL url) {
        return new UrlWriteStage(url);
    }

    public static BufferedImageWriteStage write(BufferedImage img) {
        return new BufferedImageWriteStage(img);
    }

    public static BufferedImageWriteStage write(BufferedImage img, String contentType) {
        return new BufferedImageWriteStage(img, contentType);
    }

    public static XMLDocumentWriteStage write(Document document) {
        return new XMLDocumentWriteStage(document);
    }

    public static InputStreamWriteStage write(ByteBuffer byteBuffer) {
        return IO.write(new ByteBufferInputStream(byteBuffer));
    }

    public static SObjectWriteStage write(ISObject sobj) {
        return new SObjectWriteStage(sobj);
    }

    public static CharSequenceReadStage read(CharSequence csq) {
        return new CharSequenceReadStage(csq);
    }

    public static CharSequenceWriteStage write(char[] chars) {
        return IO.write(FastStr.of(chars));
    }

    public static ReaderReadStage read(Reader reader) {
        return new ReaderReadStage(reader);
    }

    public static InputStreamReadStage read(InputStream inputStream) {
        return new InputStreamReadStage(inputStream);
    }

    public static SObjectReadStage read(ISObject sobj) {
        return new SObjectReadStage(sobj);
    }

    public static InputStreamReadStage read(byte[] bytes) {
        return IO.read(new ByteArrayInputStream(bytes));
    }

    public static ByteBufferReadStage read(ByteBuffer byteBuffer) {
        return new ByteBufferReadStage(byteBuffer);
    }

    public static UrlReadStage read(URL url) {
        return new UrlReadStage(url);
    }

    public static FileReadStage read(File file) {
        return new FileReadStage(file);
    }

    public static BufferedImageReadStage read(BufferedImage image) {
        return new BufferedImageReadStage(image);
    }

    public static BufferedImageReadStage read(BufferedImage image, String contentType) {
        return new BufferedImageReadStage(image, contentType);
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void flush(Flushable flushable) {
        try {
            flushable.flush();
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static void flush(ObjectOutput oo) {
        try {
            oo.flush();
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static void flush(ImageInputStream flushable) {
        if (null == flushable) {
            return;
        }
        try {
            flushable.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static File child(File file, String fn) {
        return new File(file, fn);
    }

    public static List<File> children(File file) {
        return Arrays.asList(file.listFiles());
    }

    public static File parent(File file) {
        return file.getParentFile();
    }

    public static File tmpFile() {
        return IO.tmpFile(S.random(3), null, null);
    }

    public static File tmpFile(String prefix, String suffix) {
        return IO.tmpFile(prefix, suffix, null);
    }

    public static File tmpFile(String prefix, String suffix, File dir) {
        if (null == prefix) {
            prefix = S.random(3);
        }
        try {
            return File.createTempFile(prefix, suffix, dir);
        }
        catch (AccessDeniedException e) {
            throw new org.osgl.exception.AccessDeniedException(e);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    @Deprecated
    public static OutputStream os() {
        return new ByteArrayOutputStream();
    }

    public static ByteArrayOutputStream baos() {
        return new ByteArrayOutputStream();
    }

    public static OutputStream outputStream(File file) {
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
    }

    @Deprecated
    public static OutputStream os(File file) {
        return IO.outputStream(file);
    }

    public static Writer writer() {
        return new StringWriter();
    }

    public static Writer writer(File file) {
        try {
            return new FileWriter(file);
        }
        catch (AccessDeniedException e) {
            throw new org.osgl.exception.AccessDeniedException(e);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static InputStream inputStream() {
        byte[] ba = new byte[]{};
        return new ByteArrayInputStream(ba);
    }

    @Deprecated
    public static InputStream is() {
        return IO.inputStream();
    }

    public static InputStream inputStream(File file) {
        if (!file.exists()) {
            file = file.getAbsoluteFile();
        }
        if (!file.exists()) {
            throw new ResourceNotFoundException(file.getPath());
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
    }

    @Deprecated
    public static InputStream is(File file) {
        return IO.inputStream(file);
    }

    public static InputStream inputStream(byte[] ba) {
        return new ByteArrayInputStream(ba);
    }

    @Deprecated
    public static InputStream is(byte[] ba) {
        return IO.inputStream(ba);
    }

    public static InputStream inputStream(String content) {
        return IO.inputStream(content.getBytes(StandardCharsets.UTF_8));
    }

    @Deprecated
    public static InputStream is(String content) {
        return IO.inputStream(content.getBytes());
    }

    public static InputStream inputStream(URL url) {
        try {
            return url.openStream();
        }
        catch (AccessDeniedException e) {
            throw new org.osgl.exception.AccessDeniedException(e);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    @Deprecated
    public static InputStream is(URL url) {
        return IO.inputStream(url);
    }

    public static Reader reader() {
        return new StringReader("");
    }

    public static Reader reader(File file) {
        E.illegalArgumentIfNot(file.canRead(), "file not readable: " + file.getPath());
        try {
            return new FileReader(file);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static Reader reader(byte[] ba) {
        return new StringReader(new String(ba));
    }

    public static Reader reader(InputStream is) {
        return new InputStreamReader(is);
    }

    public static Reader reader(URL url) {
        try {
            return IO.reader(url.openStream());
        }
        catch (AccessDeniedException e) {
            throw new org.osgl.exception.AccessDeniedException(e);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static Reader reader(String content) {
        return new StringReader(content);
    }

    public static BufferedOutputStream buffered(OutputStream os) {
        if (os instanceof BufferedOutputStream) {
            return (BufferedOutputStream)os;
        }
        return new BufferedOutputStream(os);
    }

    public static BufferedInputStream buffered(InputStream is) {
        if (is instanceof BufferedInputStream) {
            return (BufferedInputStream)is;
        }
        return new BufferedInputStream(is);
    }

    public static BufferedWriter buffered(Writer w) {
        if (w instanceof BufferedWriter) {
            return (BufferedWriter)w;
        }
        return new BufferedWriter(w);
    }

    public static BufferedReader buffered(Reader r) {
        if (r instanceof BufferedReader) {
            return (BufferedReader)r;
        }
        return new BufferedReader(r);
    }

    public static String checksum(File file) {
        return IO.checksum(IO.inputStream(file));
    }

    public static String checksum(InputStream is) {
        try {
            int nread;
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] dataBytes = new byte[1024];
            while ((nread = is.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            byte[] mdbytes = md.digest();
            S.Buffer sb = S.buffer();
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw E.unexpected("SHA1 algorithm not found", new Object[0]);
        }
        catch (AccessDeniedException e) {
            throw new org.osgl.exception.AccessDeniedException(e);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static String checksum(byte[] ba) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(ba);
            byte[] mdbytes = md.digest();
            S.Buffer sb = S.buffer();
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw E.unexpected("SHA1 algorithm not found", new Object[0]);
        }
    }

    public static void delete(File file) {
        IO.delete(file, false);
    }

    public static void delete(File f2, boolean deleteChildren) {
        String[] sa;
        if (null == f2 || !f2.exists()) {
            return;
        }
        if (f2.isDirectory() && null != (sa = f2.list()) && sa.length > 0) {
            if (!deleteChildren) {
                return;
            }
            for (File f0 : f2.listFiles()) {
                IO.delete(f0, true);
            }
        }
        if (!f2.delete()) {
            f2.deleteOnExit();
        }
    }

    public static Properties loadProperties(URL url) {
        if (null == url) {
            return new Properties();
        }
        return IO.loadProperties(IO.inputStream(url));
    }

    public static Properties loadProperties(File file) {
        return IO.loadProperties(IO.inputStream(file));
    }

    public static Properties loadProperties(InputStream inputStream) {
        Properties prop = new Properties();
        try {
            String encoding = System.getProperty("java.util.PropertyResourceBundle.encoding");
            if (S.blank(encoding) || Keyword.eq(encoding, "ISO-8859-1")) {
                prop.load(inputStream);
            } else {
                InputStreamReader isr = new InputStreamReader(inputStream, encoding);
                prop.load(isr);
            }
        }
        catch (AccessDeniedException e) {
            throw new org.osgl.exception.AccessDeniedException(e);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
        finally {
            IO.close(inputStream);
        }
        return prop;
    }

    public static Properties loadProperties(Reader reader) {
        Properties prop = new Properties();
        try {
            prop.load(reader);
        }
        catch (AccessDeniedException e) {
            throw new org.osgl.exception.AccessDeniedException(e);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
        finally {
            IO.close(reader);
        }
        return prop;
    }

    public static Properties loadProperties(String content) {
        return IO.loadProperties(new StringReader(content));
    }

    public static byte[] readContent(File file) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            IO.copy(new BufferedInputStream(new FileInputStream(file)), baos);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        return baos.toByteArray();
    }

    public static byte[] readContent(InputStream is) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IO.copy(is, baos);
        return baos.toByteArray();
    }

    public static String readContentAsString(File file) {
        return IO.readContentAsString(file, "utf-8");
    }

    public static String readContentAsString(URL url, String encoding) {
        try {
            return IO.readContentAsString(url.openStream(), encoding);
        }
        catch (AccessDeniedException e) {
            throw new org.osgl.exception.AccessDeniedException(e);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static String readContentAsString(URL url) {
        return IO.readContentAsString(url, "utf-8");
    }

    public static String readContentAsString(File file, String encoding) {
        try {
            return IO.readContentAsString(new FileInputStream(file), encoding);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
    }

    public static String readContentAsString(InputStream is) {
        return IO.readContentAsString(is, "utf-8");
    }

    public static String readContentAsString(InputStream is, String encoding) {
        try {
            String line;
            StringWriter result = new StringWriter();
            PrintWriter out = new PrintWriter(result);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, encoding));
            int lineNo = 0;
            while ((line = reader.readLine()) != null) {
                if (lineNo++ > 0) {
                    out.println();
                }
                out.print(line);
            }
            String string = result.toString();
            return string;
        }
        catch (AccessDeniedException e) {
            throw new org.osgl.exception.AccessDeniedException(e);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
        finally {
            IO.close(is);
        }
    }

    public static List<String> readLines(File file) {
        return IO.readLines(file, 0);
    }

    public static List<String> readLines(File file, int limit) {
        return IO.readLines(file, "utf-8", limit);
    }

    public static List<String> readLines(File file, String encoding) {
        return IO.readLines(file, encoding, 0);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readLines(File file, String encoding, int limit) {
        List<String> list;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            list = IO.readLines(is, encoding, limit);
        }
        catch (FileNotFoundException e) {
            try {
                throw new ResourceNotFoundException(e);
                catch (IOException ex) {
                    throw E.ioException(ex);
                }
            }
            catch (Throwable throwable) {
                IO.close(is);
                throw throwable;
            }
        }
        IO.close(is);
        return list;
    }

    public static List<String> readLines(InputStream is, String encoding) {
        return IO.readLines(is, encoding, 0);
    }

    public static List<String> readLines(InputStream is, String encoding, int limit) {
        InputStreamReader r;
        if (encoding == null) {
            return IO.readLines(is, limit);
        }
        try {
            r = new InputStreamReader(is, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw E.encodingException(e);
        }
        return IO.readLines(r, limit);
    }

    public static List<String> readLines(InputStream inputStream) {
        return IO.readLines(inputStream, 0);
    }

    public static List<String> readLines(InputStream inputStream, int limit) {
        InputStreamReader r = new InputStreamReader(inputStream);
        return IO.readLines(r, limit);
    }

    public static List<String> readLines(Reader input) {
        return IO.readLines(input, 0);
    }

    public static List<String> readLines(Reader input, int limit) {
        BufferedReader reader = new BufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        if (limit < 1) {
            limit = Integer.MAX_VALUE;
        }
        try {
            int n = 0;
            String line = reader.readLine();
            while (n++ < limit && line != null) {
                list.add(line);
                line = reader.readLine();
            }
        }
        catch (AccessDeniedException e) {
            throw new org.osgl.exception.AccessDeniedException(e);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
        return list;
    }

    public static List<String> readLines(URL url) {
        return IO.readLines(url, 0);
    }

    public static List<String> readLines(URL url, int limit) {
        try {
            return IO.readLines(url.openStream(), limit);
        }
        catch (AccessDeniedException e) {
            throw new org.osgl.exception.AccessDeniedException(e);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static List<String> readLines(URL url, String encode) {
        return IO.readLines(url, encode, 0);
    }

    public static List<String> readLines(URL url, String encode, int limit) {
        try {
            return IO.readLines(url.openStream(), encode, limit);
        }
        catch (AccessDeniedException e) {
            throw new org.osgl.exception.AccessDeniedException(e);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    @Deprecated
    public static void writeContent(CharSequence content, File file) {
        IO.write(content, file, "utf-8");
    }

    @Deprecated
    public static void writeContent(CharSequence content, File file, String encoding) {
        IO.write(content, file, encoding);
    }

    @Deprecated
    public static void writeContent(CharSequence content, Writer writer) {
        IO.write(content, writer);
    }

    public static void write(CharSequence content, File file) {
        IO.write(content, file, "utf-8");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void write(CharSequence content, File file, String encoding) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)os, encoding));
            printWriter.print(content);
            printWriter.flush();
            os.flush();
        }
        catch (AccessDeniedException e) {
            try {
                throw new org.osgl.exception.AccessDeniedException(e);
                catch (FileNotFoundException e2) {
                    throw new ResourceNotFoundException(e2);
                }
                catch (IOException e3) {
                    throw E.unexpected(e3);
                }
            }
            catch (Throwable throwable) {
                IO.close(os);
                throw throwable;
            }
        }
        IO.close(os);
    }

    public static void write(char c, Writer writer) {
        try {
            writer.write(c);
        }
        catch (AccessDeniedException e) {
            throw new org.osgl.exception.AccessDeniedException(e);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static void append(char c, Writer writer) {
        IO.write(c, writer);
    }

    public static void append(CharSequence content, Writer writer) {
        IO.write(content, writer, false);
    }

    public static void write(CharSequence content, Writer writer) {
        IO.write(content, writer, true);
    }

    public static void write(CharSequence content, Writer writer, boolean closeOs) {
        try {
            writer.write(content.toString());
        }
        catch (AccessDeniedException e) {
            throw new org.osgl.exception.AccessDeniedException(e);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
        finally {
            if (closeOs) {
                IO.close(writer);
            }
        }
    }

    public static int append(InputStream is, OutputStream os) {
        return IO.copy(is, os, false);
    }

    public static int copy(InputStream is, OutputStream os) {
        return IO.copy(is, os, true);
    }

    public static int write(InputStream is, OutputStream os) {
        return IO.copy(is, os);
    }

    public static int copy(InputStream is, OutputStream os, boolean closeOs) {
        if (closeOs) {
            return ((InputStreamWriteStage)IO.write(is).ensureCloseSink()).to(os);
        }
        return IO.write(is).to(os);
    }

    public static int write(InputStream is, OutputStream os, boolean closeSink) {
        return IO.copy(is, os, closeSink);
    }

    public static int write(InputStream is, File f2) {
        try {
            return IO.copy(is, new BufferedOutputStream(new FileOutputStream(f2)));
        }
        catch (FileNotFoundException e) {
            throw E.ioException(e);
        }
    }

    public static int copy(Reader reader, Writer writer) {
        return IO.copy(reader, writer, true);
    }

    public static int copy(Reader reader, Writer writer, boolean closeWriter) {
        if (closeWriter) {
            return ((ReaderWriteStage)IO.write(reader).ensureCloseSink()).to(writer);
        }
        return IO.write(reader).to(writer);
    }

    public static void write(byte b, OutputStream os) {
        try {
            os.write(b);
        }
        catch (AccessDeniedException e) {
            throw new org.osgl.exception.AccessDeniedException(e);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static void append(byte b, OutputStream outputStream) {
        IO.write(b, outputStream);
    }

    public static void write(byte[] data, File file) {
        try {
            IO.write((InputStream)new ByteArrayInputStream(data), (OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
    }

    public static void write(byte[] data, OutputStream os) {
        IO.write(data, os, true);
    }

    public static void append(byte[] data, OutputStream os) {
        IO.write(data, os, false);
    }

    public static void write(byte[] data, OutputStream os, boolean closeSink) {
        try {
            os.write(data);
        }
        catch (AccessDeniedException e) {
            throw new org.osgl.exception.AccessDeniedException(e);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
        finally {
            if (closeSink) {
                IO.close(os);
            }
        }
    }

    public static int write(Reader reader, Writer writer) {
        return IO.copy(reader, writer);
    }

    public static int write(Reader reader, Writer writer, boolean closeWriter) {
        return IO.copy(reader, writer, closeWriter);
    }

    public static void copyDirectory(File source, File target) {
        if (source.isDirectory()) {
            if (!target.exists()) {
                target.mkdir();
            }
            for (String child : source.list()) {
                IO.copyDirectory(new File(source, child), new File(target, child));
            }
        } else {
            try {
                IO.write((InputStream)new FileInputStream(source), (OutputStream)new FileOutputStream(target));
            }
            catch (IOException e) {
                if (target.isDirectory()) {
                    if (!target.exists() && !target.mkdirs()) {
                        throw E.ioException("cannot copy [%s] to [%s]", source, target);
                    }
                    target = new File(target, source.getName());
                } else {
                    File targetFolder = target.getParentFile();
                    if (!targetFolder.exists() && !targetFolder.mkdirs()) {
                        throw E.ioException("cannot copy [%s] to [%s]", source, target);
                    }
                }
                try {
                    IO.write((InputStream)new FileInputStream(source), (OutputStream)new FileOutputStream(target));
                }
                catch (FileNotFoundException e0) {
                    throw new ResourceNotFoundException(e);
                }
            }
        }
    }

    public static ISObject zip(ISObject ... objects) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        try {
            for (ISObject obj : objects) {
                ZipEntry entry = new ZipEntry(obj.getAttribute("filename"));
                InputStream is = obj.asInputStream();
                zos.putNextEntry(entry);
                IO.copy(is, zos, false);
                zos.closeEntry();
            }
        }
        catch (AccessDeniedException e) {
            throw new org.osgl.exception.AccessDeniedException(e);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
        finally {
            IO.close(zos);
        }
        return SObject.of(Codec.encodeUrl(S.random()), baos.toByteArray());
    }

    public static File zip(File ... files) {
        try {
            File temp = File.createTempFile("osgl", ".zip");
            IO.zipInto(temp, files);
            return temp;
        }
        catch (AccessDeniedException e) {
            throw new org.osgl.exception.AccessDeniedException(e);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zipInto(File target, File ... files) {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(target)));
            byte[] buffer = new byte[128];
            for (File f2 : files) {
                ZipEntry entry = new ZipEntry(f2.getName());
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(f2));
                zos.putNextEntry(entry);
                int read = 0;
                while ((read = ((InputStream)is).read(buffer)) != -1) {
                    zos.write(buffer, 0, read);
                }
                zos.closeEntry();
                IO.close(is);
            }
        }
        catch (AccessDeniedException e) {
            try {
                throw new org.osgl.exception.AccessDeniedException(e);
                catch (FileNotFoundException e2) {
                    throw new ResourceNotFoundException(e2);
                }
                catch (IOException e3) {
                    throw E.ioException(e3);
                }
            }
            catch (Throwable throwable) {
                IO.close(zos);
                throw throwable;
            }
        }
        IO.close(zos);
    }

    public static final class F {
        public static Lang.Function PRINTLN = F.print("", "\n", System.out);
        public static Lang.Function PRINT = F.print("", "", System.out);
        public static final Lang.Function<File, InputStream> FILE_TO_IS = new Lang.F1<File, InputStream>(){

            @Override
            public InputStream apply(File file) throws NotAppliedException, Lang.Break {
                try {
                    return new BufferedInputStream(new FileInputStream(file));
                }
                catch (FileNotFoundException e) {
                    throw new ResourceNotFoundException(e);
                }
            }
        };

        public static <T> Lang.Function<?, T> println() {
            return PRINTLN;
        }

        public static <T> Lang.Function<?, T> print() {
            return PRINT;
        }

        public static <T> Lang.Function<T, ?> print(String prefix, String suffix) {
            return F.print(prefix, suffix, System.out);
        }

        public static <T> Lang.Function<T, ?> print(String prefix, String suffix, PrintStream ps) {
            return new Lang.F4<T, String, String, PrintStream, Void>(){

                @Override
                public Void apply(T t, String prefix, String suffix, PrintStream ps) {
                    StringBuilder sb = new StringBuilder(prefix).append(t).append(suffix);
                    ps.print(sb);
                    return null;
                }
            }.curry(prefix, suffix, ps);
        }
    }

    public static class ByteBufferReadStage
    extends ReadStageBase<ByteBuffer, ByteBufferReadStage> {
        public ByteBufferReadStage(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        protected InputStream load() {
            return new ByteBufferInputStream((ByteBuffer)this.source);
        }
    }

    public static class UrlReadStage
    extends ReadStageBase<URL, UrlReadStage> {
        public UrlReadStage(URL url) {
            super(url);
            this.sourceName(url.getFile());
        }

        @Override
        protected InputStream load() {
            return IO.inputStream((URL)this.source);
        }
    }

    public static class SObjectReadStage
    extends ReadStageBase<ISObject, SObjectReadStage> {
        public SObjectReadStage(ISObject isObject) {
            super(isObject);
            this.sourceName = isObject.getFilename();
        }

        @Override
        protected InputStream load() {
            return ((ISObject)this.source).asInputStream();
        }
    }

    public static class CharSequenceReadStage
    extends ReadStageBase<CharSequence, CharSequenceReadStage> {
        private String lineSep = OS.get().lineSeparator();

        public CharSequenceReadStage(CharSequence charSequence) {
            super(charSequence);
        }

        @Override
        protected InputStream load() throws IOException {
            return new ReaderInputStream(this.toReader(), this.charset);
        }

        @Override
        public Reader toReader() {
            return new StringReader(((CharSequence)this.source).toString());
        }

        @Override
        public String toString() {
            return ((CharSequence)this.source).toString();
        }

        public CharSequenceReadStage lineSeparator(String lineSeparator) {
            this.lineSep = $.requireNotNull(lineSeparator);
            return this;
        }

        @Override
        public List<String> toLines() {
            return S.fastSplit(((CharSequence)this.source).toString(), this.lineSep);
        }

        @Override
        public ISObject toSObject() {
            return SObject.of(((CharSequence)this.source).toString());
        }

        @Override
        public byte[] toByteArray() {
            return ((CharSequence)this.source).toString().getBytes(this.charset);
        }
    }

    public static class FileReadStage
    extends ReadStageBase<File, FileReadStage> {
        public FileReadStage(File file) {
            super(file);
            this.sourceName = file.getName();
        }

        @Override
        protected InputStream load() {
            return IO.buffered(IO.inputStream((File)this.source));
        }
    }

    public static class ReaderReadStage
    extends ReadStageBase<Reader, ReaderReadStage> {
        public ReaderReadStage(Reader reader) {
            super(reader);
        }

        @Override
        protected InputStream load() {
            return new ReaderInputStream((Reader)this.source, this.charset);
        }
    }

    public static class BufferedImageReadStage
    extends ReadStageBase<BufferedImage, BufferedImageReadStage> {
        private String contentType = "image/png";

        public BufferedImageReadStage(BufferedImage img) {
            super(img);
        }

        public BufferedImageReadStage(BufferedImage img, String contentType) {
            super(img);
            this.contentType = S.requireNotBlank(contentType);
        }

        @Override
        protected InputStream load() throws IOException {
            return IO.inputStream(this.toByteArray());
        }

        @Override
        public byte[] toByteArray() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Img.source((BufferedImage)this.source).writeTo(baos, this.contentType);
            return baos.toByteArray();
        }
    }

    public static class InputStreamReadStage
    extends ReadStageBase<InputStream, InputStreamReadStage> {
        public InputStreamReadStage(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        protected InputStream load() {
            return (InputStream)this.source;
        }
    }

    public static abstract class ReadStageBase<SOURCE, STAGE extends ReadStageBase> {
        protected SOURCE source;
        protected String sourceName;
        private MimeType mimeType;
        protected Object hint;
        protected Charset charset = StandardCharsets.UTF_8;

        public ReadStageBase(SOURCE source) {
            this.source = $.requireNotNull(source);
        }

        public STAGE encoding(Charset charset) {
            this.charset = $.requireNotNull(charset);
            return this.me();
        }

        public STAGE hint(Object hint) {
            this.hint = hint;
            return this.me();
        }

        public STAGE sourceName(String name) {
            this.sourceName = name;
            if (null == this.mimeType) {
                this.mimeType = MimeType.findByFileExtension(S.fileExtension(this.sourceName));
            }
            return this.me();
        }

        public STAGE contentType(MimeType type) {
            this.mimeType = type;
            return this.me();
        }

        public STAGE contentType(String contentType) {
            MimeType type = MimeType.findByContentType(contentType);
            if (null == type) {
                type = MimeType.findByFileExtension(contentType);
            }
            if (null != type) {
                this.mimeType = type;
            } else {
                E.unexpected("Content type unrecognized: " + contentType, new Object[0]);
            }
            return this.me();
        }

        public String toString() {
            return IO.readContentAsString(this.toInputStream());
        }

        public List<String> toLines() {
            return IO.readLines(this.toReader());
        }

        public List<String> toLine(int limit) {
            E.illegalArgumentIf(limit < 0);
            return IO.readLines(this.toReader(), limit);
        }

        public ISObject toSObject() {
            return SObject.of(this.toInputStream());
        }

        public Reader toReader() {
            return new InputStreamReader(this.toInputStream(), this.charset);
        }

        public Properties toProperties() {
            return IO.loadProperties(this.toInputStream());
        }

        public InputStream toInputStream() {
            try {
                InputStream inputStream = this.load();
                return inputStream;
            }
            catch (AccessDeniedException e) {
                throw new org.osgl.exception.AccessDeniedException(e);
            }
            catch (FileNotFoundException e) {
                throw new ResourceNotFoundException(e);
            }
            catch (IOException e) {
                throw E.ioException(e);
            }
            finally {
                this.ensureCloseSource();
            }
        }

        public byte[] toByteArray() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IO.copy(this.toInputStream(), baos);
            return baos.toByteArray();
        }

        public <T> T to(Class<T> type) {
            return this._to(type);
        }

        public <T> T to(BeanInfo beanInfo) {
            return this._to(beanInfo.type());
        }

        public <T> T to(TypeReference typeReference) {
            return this._to(typeReference.getType());
        }

        private <T> T _to(Type type) {
            Object o;
            String sourceName;
            InputStreamHandlerDispatcher inputStreamHandler = null;
            MimeType mimeType = this.mimeType;
            if (null == mimeType && null != (sourceName = this.sourceName())) {
                String suffix = S.fileExtension(sourceName);
                mimeType = MimeType.findByFileExtension(suffix);
            }
            if (null != mimeType) {
                inputStreamHandler = (InputStreamHandlerDispatcher)inputStreamHandlerLookup.get(mimeType);
            }
            if (String.class == type) {
                o = this.toString();
            } else if (TypeReference.LIST_STRING == type) {
                if (null != inputStreamHandler && inputStreamHandler.support(type)) {
                    return inputStreamHandler.read(this.toInputStream(), type, mimeType, this.hint);
                }
                o = this.toLines();
            } else if (InputStream.class == type) {
                o = this.toInputStream();
            } else if (Reader.class == type) {
                o = this.toReader();
            } else if (ISObject.class == type || SObject.class == type) {
                o = this.toSObject();
            } else if (Properties.class == type) {
                if (null != inputStreamHandler && inputStreamHandler.support(type)) {
                    return inputStreamHandler.read(this.toInputStream(), type, mimeType, this.hint);
                }
                o = this.toProperties();
            } else if (byte[].class == type) {
                o = this.toByteArray();
            } else {
                if (null != inputStreamHandler) {
                    return inputStreamHandler.read(this.toInputStream(), type, mimeType, this.hint);
                }
                o = this.toUnknownType(type);
            }
            return $.cast(o);
        }

        protected abstract InputStream load() throws IOException;

        protected void ensureCloseSource() {
        }

        protected STAGE me() {
            return (STAGE)this;
        }

        protected <T> T toUnknownType(Type type) {
            InputStreamHandler h;
            if (null != this.mimeType && null != (h = (InputStreamHandler)inputStreamHandlerLookup.get(this.mimeType))) {
                return h.read(this.toInputStream(), type, this.mimeType, this.hint);
            }
            throw new UnsupportedOperationException("target type not supported: " + type);
        }

        protected String sourceName() {
            return this.sourceName;
        }
    }

    public static class SObjectWriteStage
    extends WriteStageBase<ISObject, SObjectWriteStage> {
        protected SObjectWriteStage(ISObject isObject) {
            super(isObject);
        }

        @Override
        protected int doWriteTo(Writer sink) throws IOException {
            try {
                int n = IO.write(((ISObject)this.source).asInputStream()).doWriteTo(sink);
                return n;
            }
            finally {
                if (this.closeSink) {
                    IO.close(sink);
                }
            }
        }

        @Override
        protected int doWriteTo(OutputStream sink) throws IOException {
            try {
                int n = IO.write(((ISObject)this.source).asInputStream()).doWriteTo(sink);
                return n;
            }
            finally {
                if (this.closeSink) {
                    IO.close(sink);
                }
            }
        }
    }

    public static class UrlWriteStage
    extends WriteStageBase<URL, UrlWriteStage> {
        UrlWriteStage(URL url) {
            super(url);
        }

        @Override
        protected int doWriteTo(Writer sink) throws IOException {
            return new ReaderWriteStage(IO.buffered(IO.reader((URL)this.source))).doWriteTo(sink);
        }

        @Override
        protected int doWriteTo(OutputStream sink) throws IOException {
            return new InputStreamWriteStage(IO.buffered(IO.is((URL)this.source))).doWriteTo(sink);
        }
    }

    public static class FileWriteStage
    extends WriteStageBase<File, FileWriteStage> {
        FileWriteStage(File file) {
            super(file);
        }

        @Override
        protected int doWriteTo(Writer sink) throws IOException {
            return new ReaderWriteStage(IO.buffered(IO.reader((File)this.source))).doWriteTo(sink);
        }

        @Override
        protected int doWriteTo(OutputStream sink) throws IOException {
            return new InputStreamWriteStage(IO.buffered(IO.inputStream((File)this.source))).doWriteTo(sink);
        }
    }

    public static class InputStreamWriteStage
    extends WriteStageBase<InputStream, InputStreamWriteStage> {
        boolean closeSource = true;
        boolean consumed;

        InputStreamWriteStage(InputStream source) {
            super(source);
        }

        InputStreamWriteStage keepSourceOpen() {
            this.closeSource = false;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int doWriteTo(OutputStream sink) throws IOException {
            this.ensureNotConsumed();
            try {
                int read;
                int total = 0;
                byte[] buffer = new byte[8096];
                while ((read = ((InputStream)this.source).read(buffer)) > -1) {
                    sink.write(buffer, 0, read);
                    total += read;
                }
                int n = total;
                return n;
            }
            finally {
                this.consumed = true;
                if (this.closeSource) {
                    IO.close((Closeable)this.source);
                }
            }
        }

        @Override
        protected int doWriteTo(Writer sink) throws IOException {
            this.ensureNotConsumed();
            try {
                int n = new ReaderWriteStage(new InputStreamReader((InputStream)this.source, this.charset)).doWriteTo(sink);
                return n;
            }
            finally {
                this.consumed = true;
                if (this.closeSource) {
                    IO.close((Closeable)this.source);
                }
            }
        }

        private void ensureNotConsumed() {
            E.illegalStateIf(this.consumed, "Input stream already consumed");
        }
    }

    public static class ReaderWriteStage
    extends WriteStageBase<Reader, ReaderWriteStage> {
        boolean closeSource = true;
        boolean consumed;

        ReaderWriteStage(Reader source) {
            super(source);
        }

        ReaderWriteStage keepSourceOpen() {
            this.closeSource = false;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int doWriteTo(Writer sink) throws IOException {
            this.ensureNotConsumed();
            char[] buffer = new char[1024];
            int ttl = 0;
            try {
                int len;
                while ((len = ((Reader)this.source).read(buffer)) >= 0) {
                    sink.write(buffer, 0, len);
                    ttl += len;
                }
                int n = ttl;
                return n;
            }
            finally {
                if (this.closeSource) {
                    IO.close((Closeable)this.source);
                }
                this.consumed = true;
            }
        }

        @Override
        protected int doWriteTo(OutputStream sink) throws IOException {
            this.ensureNotConsumed();
            try {
                int n = new InputStreamWriteStage(new ReaderInputStream((Reader)this.source, this.charset)).doWriteTo(sink);
                return n;
            }
            finally {
                this.consumed = true;
                if (this.closeSource) {
                    IO.close((Closeable)this.source);
                }
            }
        }

        private void ensureNotConsumed() {
            E.illegalStateIf(this.consumed, "Reader already consumed");
        }
    }

    public static class XMLDocumentWriteStage
    extends WriteStageBase<Document, XMLDocumentWriteStage> {
        private boolean pretty;

        protected XMLDocumentWriteStage(Document xmldoc) {
            super(xmldoc);
        }

        @Override
        protected int doWriteTo(Writer sink) {
            return this.doWriteTo($.convert(sink).to(OutputStream.class));
        }

        @Override
        protected int doWriteTo(OutputStream sink) {
            XML.print((Document)this.source, this.pretty, sink);
            return -1;
        }

        public XMLDocumentWriteStage pretty() {
            this.pretty = true;
            return this;
        }
    }

    public static class BufferedImageWriteStage
    extends WriteStageBase<BufferedImage, BufferedImageWriteStage> {
        private String contentType = "image/png";

        protected BufferedImageWriteStage(BufferedImage bufferedImage) {
            super(bufferedImage);
        }

        protected BufferedImageWriteStage(BufferedImage image, String contentType) {
            super(image);
            this.contentType = S.requireNotBlank(contentType);
        }

        @Override
        protected int doWriteTo(Writer sink) {
            throw E.unsupport();
        }

        @Override
        protected int doWriteTo(OutputStream sink) {
            Img.source((BufferedImage)this.source).writeTo(sink, this.contentType);
            return -1;
        }
    }

    public static class CharSequenceWriteStage
    extends WriteStageBase<CharSequence, CharSequenceWriteStage> {
        CharSequenceWriteStage(CharSequence csq) {
            super(csq);
        }

        @Override
        public int doWriteTo(Writer sink) throws IOException {
            String s = ((CharSequence)this.source).toString();
            sink.write(s);
            return s.length();
        }

        @Override
        protected int doWriteTo(OutputStream sink) throws IOException {
            byte[] ba = ((CharSequence)this.source).toString().getBytes(this.charset);
            sink.write(ba);
            return ba.length;
        }
    }

    public static abstract class WriteStageBase<SOURCE, STAGE extends WriteStageBase> {
        protected SOURCE source;
        protected boolean closeSink;
        protected Charset charset = StandardCharsets.UTF_8;

        protected WriteStageBase(SOURCE source) {
            this.source = $.requireNotNull(source);
        }

        public STAGE ensureCloseSink() {
            this.closeSink = true;
            return this.me();
        }

        public STAGE encoding(Charset charset) {
            this.charset = $.requireNotNull(charset);
            return this.me();
        }

        public int to(Writer sink) {
            try {
                int n = this.doWriteTo(sink);
                return n;
            }
            catch (AccessDeniedException e) {
                throw new org.osgl.exception.AccessDeniedException(e);
            }
            catch (IOException e) {
                throw E.ioException(e);
            }
            finally {
                if (this.closeSink) {
                    IO.close(sink);
                } else {
                    IO.flush(sink);
                }
            }
        }

        public int to(OutputStream sink) {
            try {
                int n = this.doWriteTo(sink);
                return n;
            }
            catch (AccessDeniedException e) {
                throw new org.osgl.exception.AccessDeniedException(e);
            }
            catch (IOException e) {
                throw E.ioException(e);
            }
            finally {
                if (this.closeSink) {
                    IO.close(sink);
                } else {
                    IO.flush(sink);
                }
            }
        }

        public int to(File file) {
            BufferedOutputStream bos = IO.buffered(IO.outputStream(file));
            return this.to(bos);
        }

        protected abstract int doWriteTo(Writer var1) throws IOException;

        protected abstract int doWriteTo(OutputStream var1) throws IOException;

        protected final STAGE me() {
            return (STAGE)this;
        }
    }

    private static class InputStreamHandlerDispatcher
    implements InputStreamHandler {
        private List<InputStreamHandler> realHandlers = new ArrayList<InputStreamHandler>();
        private InputStreamHandler priotyHandler;

        void add(InputStreamHandler handler) {
            this.realHandlers.add(handler);
        }

        InputStreamHandlerDispatcher(InputStreamHandler h) {
            if (!this.realHandlers.contains($.requireNotNull(h))) {
                this.realHandlers.add(h);
            }
        }

        @Override
        public boolean support(Type type) {
            InputStreamHandler h = this.priotyHandler;
            if (null != h && h.support(type)) {
                return true;
            }
            for (InputStreamHandler h0 : this.realHandlers) {
                if (!h0.support(type)) continue;
                this.priotyHandler = h0;
                return true;
            }
            return false;
        }

        @Override
        public <T> T read(InputStream is, Type targetType, MimeType mimeType, Object hint) {
            InputStreamHandler h = this.priotyHandler;
            if (null != h && h.support(targetType)) {
                return h.read(is, targetType, mimeType, hint);
            }
            for (InputStreamHandler h0 : this.realHandlers) {
                if (!h0.support(targetType)) continue;
                this.priotyHandler = h0;
                return h0.read(is, targetType, mimeType, hint);
            }
            throw new UnsupportedOperationException("Type[%s] not supported");
        }
    }

    public static interface InputStreamHandler {
        public boolean support(Type var1);

        public <T> T read(InputStream var1, Type var2, MimeType var3, Object var4);
    }
}

