/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.Codec;
import org.osgl.util.E;
import org.osgl.util.Generics;
import org.osgl.util.IO;
import org.osgl.util.N;
import org.osgl.util.S;

public enum Img {

    private static Processor COPIER = new Processor(){

        @Override
        protected BufferedImage run() {
            return this.source;
        }
    };
    public static final String DEF_MIME_TYPE = "image/png";
    public static final String GIF_MIME_TYPE = "image/gif";
    public static final String PNG_MIME_TYPE = "image/png";
    public static final String JPG_MIME_TYPE = "image/jpeg";
    public static final Color COLOR_TRANSPARENT = new Color(0, 0, 0, 0);
    public static final byte[] TRACKING_PIXEL_BYTES = new ProcessorStage(F.TRACKING_PIXEL).toByteArray("image/gif");
    public static final String TRACKING_PIXEL_BASE64 = Img.toBase64(TRACKING_PIXEL_BYTES, "image/gif");

    public static _Load source(InputStream is) {
        return new _Load(is);
    }

    public static _Load source(URL url) {
        return new _Load(IO.inputStream(url));
    }

    public static _Load source(File file) {
        return new _Load(IO.inputStream(file));
    }

    public static _Load source(Lang.Func0<BufferedImage> imageProducer) {
        return new ProcessorStage(imageProducer).pipeline();
    }

    public static _Load source(BufferedImage image) {
        return new ProcessorStage(image).pipeline();
    }

    public static Resizer.Stage resize(Lang.Func0<BufferedImage> imageProvider) {
        return Img.source(imageProvider).resize();
    }

    public static Cropper.Stage crop(Lang.Func0<BufferedImage> imageProvider) {
        return Img.source(imageProvider).crop();
    }

    public static Flip.Stage flip(Lang.Func0<BufferedImage> imageProvider) {
        return Img.source(imageProvider).flip();
    }

    public static Blur.Stage blur(Lang.Func0<BufferedImage> imageProvider) {
        return Img.source(imageProvider).blur();
    }

    public static TextWriter.Stage watermark(Lang.Func0<BufferedImage> imageProvider) {
        return Img.source(imageProvider).watermark();
    }

    public static Concatenater.Stage concat(Lang.Func0<BufferedImage> image1) {
        return new Concatenater.Stage(image1.apply());
    }

    public static Concatenater.Stage concat(Lang.Func0<BufferedImage> image1, Lang.Func0<BufferedImage> image2) {
        return Img.source(image1).appendWith(image2);
    }

    public static String toBase64(File image) {
        return Img.toBase64(IO.inputStream(image), Img.mimeType(image));
    }

    public static String toBase64(InputStream inputStream, String mimeType) {
        return Img.toBase64(IO.readContent(inputStream), mimeType);
    }

    public static String toBase64(byte[] bytes, String mimeType) {
        return "data:" + Img.mimeType(mimeType) + ";base64," + Codec.encodeBase64(bytes);
    }

    private static String mimeType(File target) {
        return Img.mimeType(target.getName());
    }

    private static String mimeType(String hint) {
        String mimeType = "image/png";
        if (S.blank(hint)) {
            return mimeType;
        }
        if (1 == S.count(hint, "/", false) && !hint.contains(".")) {
            return hint;
        }
        if (hint.endsWith("jpeg") || hint.endsWith("jpg")) {
            mimeType = JPG_MIME_TYPE;
        }
        if (hint.endsWith("gif")) {
            mimeType = GIF_MIME_TYPE;
        }
        return mimeType;
    }

    public static ImageOutputStream os(File file) {
        try {
            return new FileImageOutputStream(file);
        }
        catch (IOException e) {
            throw E.ioException(e);
        }
    }

    public static ImageOutputStream os(OutputStream os) {
        return new MemoryCacheImageOutputStream(os);
    }

    public static BufferedImage read(InputStream is) {
        try {
            return ImageIO.read(is);
        }
        catch (Exception e) {
            throw E.unexpected(e);
        }
    }

    public static BufferedImage read(File file) {
        try {
            return ImageIO.read(file);
        }
        catch (Exception e) {
            throw E.unexpected(e);
        }
    }

    public static BufferedImage read(URL url) {
        try {
            return ImageIO.read(url);
        }
        catch (Exception e) {
            throw E.unexpected(e);
        }
    }

    private static int randomColorValue() {
        return Img.randomColorValue(true);
    }

    private static int randomColorValue(boolean withAlpha) {
        int a = N.randInt(256);
        int r = N.randInt(256);
        int g = N.randInt(256);
        return withAlpha ? a << 24 | r << 16 | g << 8 : a << 24 | r << 16 | g << 8;
    }

    public static enum F {

        public static Lang.Producer<Color> RANDOM_COLOR = new Lang.Producer<Color>(){

            @Override
            public Color produce() {
                ThreadLocalRandom r = ThreadLocalRandom.current();
                return new Color(((java.util.Random)r).nextInt(255), ((java.util.Random)r).nextInt(255), ((java.util.Random)r).nextInt(255), ((java.util.Random)r).nextInt(255));
            }
        };
        public static Lang.Producer<BufferedImage> TRACKING_PIXEL = new Lang.Producer<BufferedImage>(){

            @Override
            public BufferedImage produce() {
                BufferedImage trackPixel = new BufferedImage(1, 1, 6);
                trackPixel.setRGB(0, 0, COLOR_TRANSPARENT.getRGB());
                return trackPixel;
            }
        };

        public static Lang.Producer<BufferedImage> background(int w, int h) {
            return F.background(w, h, $.val(COLOR_TRANSPARENT));
        }

        public static Lang.Producer<BufferedImage> randomPixels(int w, int h) {
            return F.randomPixels(w, h, 6);
        }

        public static Lang.Producer<BufferedImage> randomPixels(int w, int h, Color background) {
            return F.randomPixels(w, h, 7, background);
        }

        public static Lang.Producer<BufferedImage> randomPixels(int w, int h, int percent) {
            return F.randomPixels(w, h, percent, COLOR_TRANSPARENT);
        }

        public static Lang.Producer<BufferedImage> randomPixels(final int w, final int h, final int percent, Color background) {
            return F.background(w, h, $.val(background)).andThen(new Lang.Function<BufferedImage, BufferedImage>(){

                @Override
                public BufferedImage apply(BufferedImage img) throws NotAppliedException, Lang.Break {
                    ThreadLocalRandom r = ThreadLocalRandom.current();
                    for (int i = 0; i < w; ++i) {
                        for (int j = 0; j < h; ++j) {
                            if (((java.util.Random)r).nextInt(100) >= percent) continue;
                            int v = Img.randomColorValue(false);
                            img.setRGB(i, j, v);
                        }
                    }
                    return img;
                }
            });
        }

        public static Lang.Producer<BufferedImage> background(int w, int h, Color color) {
            return F.background(w, h, $.val(color));
        }

        public static Lang.Producer<BufferedImage> background(final int w, final int h, final Lang.Func0<Color> colorValueProvider) {
            $.NPE(colorValueProvider);
            N.requirePositive(w);
            N.requirePositive(h);
            return new Lang.Producer<BufferedImage>(){

                @Override
                public BufferedImage produce() {
                    BufferedImage b = new BufferedImage(w, h, 2);
                    Graphics2D g = b.createGraphics();
                    g.setPaint((Paint)colorValueProvider.apply());
                    g.fillRect(0, 0, w, h);
                    return b;
                }
            };
        }

        public static Lang.Provider<BufferedImage> source(final InputStream is) {
            return new Lang.Provider<BufferedImage>(){

                @Override
                public BufferedImage get() {
                    return Img.read(is);
                }
            };
        }

        public static Lang.Provider<BufferedImage> source(final File file) {
            return new Lang.Provider<BufferedImage>(){

                @Override
                public BufferedImage get() {
                    return Img.read(file);
                }
            };
        }

        public static Lang.Val<BufferedImage> source(BufferedImage image) {
            return Lang.F.provides(image);
        }
    }

    public static class Concatenater
    extends BinarySourceProcessor<Concatenater, Stage> {
        Direction dir = Direction.HORIZONTAL;
        BinarySourceProcessor.ScaleFix scaleFix = BinarySourceProcessor.ScaleFix.SCALE_TO_MAX;
        Color background = COLOR_TRANSPARENT;
        boolean reversed = false;

        private Concatenater() {
        }

        Concatenater(BufferedImage secondImage) {
            this.secondSource(secondImage);
        }

        Concatenater(BufferedImage secondImage, Direction dir, BinarySourceProcessor.ScaleFix scaleFix, Color background) {
            this.secondSource(secondImage);
            this.dir = Lang.requireNotNull(dir);
            this.scaleFix = Lang.requireNotNull(scaleFix);
            this.background = Lang.requireNotNull(background);
        }

        @Override
        protected BufferedImage run() {
            if (this.dir.isHorizontal()) {
                this.fixScale(this.sourceHeight, this.source2Height);
            } else {
                this.fixScale(this.sourceWidth, this.source2Width);
            }
            N.WH d = this.dir.concatenate(N.wh(this.sourceWidth, this.sourceHeight), N.wh(this.source2Width, this.source2Height));
            int w = d.w();
            int h = d.h();
            this.setTargetSpec(w, h);
            Graphics2D g = this.g();
            g.setColor(this.background);
            g.fillRect(0, 0, w, h);
            if (!this.reversed) {
                this.dir.drawImage(g, this.source, this.source2);
            } else {
                this.dir.drawImage(g, this.source2, this.source);
            }
            return this.target;
        }

        private void fixScale(int scale1, int scale2) {
            if (scale1 != scale2 && this.scaleFix.shouldFix()) {
                int targetScale = this.scaleFix.targetScale(scale1, scale2);
                float r1 = (float)targetScale / (float)scale1;
                float r2 = (float)targetScale / (float)scale2;
                if (N.neq(Float.valueOf(r1), Float.valueOf(1.0f))) {
                    this.source(new Resizer(r1).source(this.source).run());
                }
                if (N.neq(Float.valueOf(r2), Float.valueOf(1.0f))) {
                    this.secondSource(new Resizer(r2).source(this.source2).run());
                }
            }
        }

        public static class Stage
        extends ProcessorStage<Stage, Concatenater> {
            protected Stage(BufferedImage source) {
                super(source);
                this.processor = new Concatenater();
            }

            public Stage dir(Direction dir) {
                ((Concatenater)this.processor).dir = Lang.requireNotNull(dir);
                return this;
            }

            public Stage horizontally() {
                ((Concatenater)this.processor).dir = Direction.HORIZONTAL;
                return this;
            }

            public Stage vertically() {
                ((Concatenater)this.processor).dir = Direction.VERTICAL;
                return this;
            }

            public Stage shinkToSmall() {
                ((Concatenater)this.processor).scaleFix = BinarySourceProcessor.ScaleFix.SHRINK_TO_MIN;
                return this;
            }

            public Stage scaleToMax() {
                ((Concatenater)this.processor).scaleFix = BinarySourceProcessor.ScaleFix.SCALE_TO_MAX;
                return this;
            }

            public Stage noScaleFix() {
                ((Concatenater)this.processor).scaleFix = BinarySourceProcessor.ScaleFix.NO_FIX;
                return this;
            }

            public Stage scaleFix(BinarySourceProcessor.ScaleFix scaleFix) {
                ((Concatenater)this.processor).scaleFix = Lang.requireNotNull(scaleFix);
                return this;
            }

            public Stage background(Color backgroundColor) {
                ((Concatenater)this.processor).background = Lang.requireNotNull(backgroundColor);
                return this;
            }

            public Stage reverse() {
                ((Concatenater)this.processor).reversed = !((Concatenater)this.processor).reversed;
                return this;
            }

            public Stage with(Lang.Func0<BufferedImage> secondImage) {
                ((Concatenater)this.processor).secondSource(secondImage.apply());
                return this;
            }

            @Override
            public Stage appendWith(Lang.Func0<BufferedImage> anotherOne) {
                return Img.concat(this, anotherOne);
            }

            @Override
            public Stage appendTo(Lang.Func0<BufferedImage> anotherOne) {
                return Img.concat(anotherOne, this);
            }
        }
    }

    public static class TextWriter
    extends Filter<TextWriter, Stage> {
        Color color = Color.DARK_GRAY;
        Font font = new Font("Arial", 1, 32);
        float alpha = 1.0f;
        String text;
        int offsetX;
        int offsetY;
        Double theta;

        TextWriter() {
        }

        TextWriter(String text) {
            this.text = text;
        }

        TextWriter(String text, int offsetX, int offsetY, Color color, Font font, float alpha) {
            this.text = text;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.color = color;
            this.font = font;
            this.alpha = alpha;
        }

        @Override
        protected Stage createStage(BufferedImage source) {
            return new Stage(source, this);
        }

        @Override
        protected BufferedImage run() {
            int w = this.sourceWidth;
            int h = this.sourceHeight;
            Graphics2D g = this.g();
            g.setColor(this.color);
            g.setFont(this.font);
            if (null != this.theta) {
                g.rotate(this.theta);
            }
            g.setComposite(AlphaComposite.getInstance(10, this.alpha));
            FontMetrics metrics = g.getFontMetrics();
            int centerX = (w - metrics.stringWidth(this.text)) / 2;
            int centerY = (h - metrics.getHeight()) / 2 + metrics.getAscent();
            g.drawString(this.text, centerX, centerY);
            return this.target;
        }

        public static class Stage
        extends ProcessorStage<Stage, TextWriter> {
            public Stage(BufferedImage source) {
                super(source, new TextWriter());
            }

            public Stage(BufferedImage source, TextWriter processor) {
                super(source, processor);
            }

            @Override
            public Stage text(String text) {
                ((TextWriter)this.processor).text = S.requireNotBlank(text);
                return this;
            }

            public Stage color(Color color) {
                ((TextWriter)this.processor).color = Lang.requireNotNull(color);
                return this;
            }

            public Stage font(Font font) {
                ((TextWriter)this.processor).font = Lang.requireNotNull(font);
                return this;
            }

            public Stage alpha(float alpha) {
                ((TextWriter)this.processor).alpha = N.requireAlpha(alpha);
                return this;
            }

            public Stage offset(int offsetX, int offsetY) {
                ((TextWriter)this.processor).offsetX = offsetX;
                ((TextWriter)this.processor).offsetY = offsetY;
                return this;
            }

            public Stage offsetY(int offsetY) {
                ((TextWriter)this.processor).offsetY = offsetY;
                return this;
            }

            public Stage offsetX(int offsetX) {
                ((TextWriter)this.processor).offsetX = offsetX;
                return this;
            }

            public Stage rotate(double theta) {
                ((TextWriter)this.processor).theta = theta;
                return this;
            }
        }
    }

    public static class NoiseMaker
    extends Filter<NoiseMaker, Stage> {
        private int minArcs = 100;
        private int maxArcs = 200;
        private int maxArcSize = 5;
        private int minLines = 1;
        private int maxLines = 5;
        private int maxLineWidth = 2;

        @Override
        protected Stage createStage(BufferedImage source) {
            return new Stage(source, this);
        }

        @Override
        protected BufferedImage run() {
            int w = this.sourceWidth;
            int h = this.sourceHeight;
            ThreadLocalRandom r = ThreadLocalRandom.current();
            Graphics2D g = this.g();
            if (this.maxArcs < this.minArcs) {
                int tmp = this.maxArcs;
                this.maxArcs = this.minArcs;
                this.minArcs = tmp;
            }
            int dots = this.minArcs + ((java.util.Random)r).nextInt(this.maxArcs);
            for (int i = 0; i < dots; ++i) {
                g.setColor(new Color(Img.randomColorValue()));
                int xInt = ((java.util.Random)r).nextInt(w - 1);
                int yInt = ((java.util.Random)r).nextInt(h - 1);
                int sAngleInt = ((java.util.Random)r).nextInt(360);
                int eAngleInt = ((java.util.Random)r).nextInt(360);
                int wInt = 1 + ((java.util.Random)r).nextInt(this.maxArcSize);
                int hInt = 1 + ((java.util.Random)r).nextInt(this.maxArcSize);
                g.fillArc(xInt, yInt, wInt, hInt, sAngleInt, eAngleInt);
            }
            int lines = this.minLines + ((java.util.Random)r).nextInt(this.maxLines - this.minLines);
            for (int i = 0; i < lines; ++i) {
                int xInt = ((java.util.Random)r).nextInt(w - 1);
                int yInt = ((java.util.Random)r).nextInt(h - 1);
                int xInt2 = ((java.util.Random)r).nextInt(w - 1);
                int yInt2 = ((java.util.Random)r).nextInt(h - 1);
                g.setColor(Random.color());
                if (1 < this.maxLineWidth) {
                    int width = N.randInt(1, this.maxLineWidth + 1);
                    BasicStroke stroke = new BasicStroke(width);
                    g.setStroke(stroke);
                }
                g.drawLine(xInt, yInt, xInt2, yInt2);
            }
            return this.target;
        }

        public static class Stage
        extends ProcessorStage<Stage, NoiseMaker> {
            public Stage(BufferedImage source) {
                super(source, new NoiseMaker());
            }

            public Stage(BufferedImage source, NoiseMaker processor) {
                super(source, processor);
            }

            public Stage setMinArcs(int n) {
                ((NoiseMaker)this.processor).minArcs = N.requireNonNegative(n);
                return this;
            }

            public Stage setMaxArcs(int n) {
                ((NoiseMaker)this.processor).maxArcs = N.requirePositive(n);
                return this;
            }

            public Stage setMaxArcSize(int size) {
                ((NoiseMaker)this.processor).maxArcSize = size;
                return this;
            }

            public Stage setMaxLines(int n) {
                ((NoiseMaker)this.processor).maxLines = N.requirePositive(n);
                return this;
            }

            public Stage setMaxLineWidth(int n) {
                ((NoiseMaker)this.processor).maxLineWidth = N.requirePositive(n);
                return this;
            }
        }
    }

    public static class Blur
    extends Filter<Blur, Stage> {
        static final int DEFAULT_LEVEL = 3;
        float[] matrix;
        int level;

        Blur() {
            this.setLevel(3);
        }

        @Override
        protected Stage createStage(BufferedImage source) {
            return new Stage(source, this);
        }

        void setLevel(int level) {
            this.level = N.requirePositive(level);
            int max = level * level;
            this.matrix = new float[N.requirePositive(max)];
            for (int i = 0; i < max; ++i) {
                this.matrix[i] = 1.0f / (float)max;
            }
        }

        @Override
        protected BufferedImage run() {
            ConvolveOp op = new ConvolveOp(new Kernel(this.level, this.level, this.matrix), 1, null);
            this.target = op.filter(this.target, null);
            return this.target;
        }

        public static class Stage
        extends ProcessorStage<Stage, Blur> {
            public Stage(BufferedImage source) {
                super(source, new Blur());
            }

            public Stage(BufferedImage source, Blur processor) {
                super(source, processor);
            }

            public Stage level(int level) {
                ((Blur)this.processor).setLevel(level);
                return this;
            }
        }
    }

    public static class Flip
    extends Processor<Flip, Stage> {
        Direction dir = Direction.HORIZONTAL;

        Flip() {
        }

        @Override
        protected Stage createStage(BufferedImage source) {
            return new Stage(source, this);
        }

        @Override
        protected BufferedImage run() {
            Graphics2D g = this.g();
            if (this.dir.isHorizontal()) {
                g.drawImage(this.source, this.sourceWidth, 0, -this.sourceWidth, this.sourceHeight, null);
            } else {
                g.drawImage(this.source, 0, this.sourceHeight, this.sourceWidth, -this.sourceHeight, null);
            }
            return this.target;
        }

        public static class Stage
        extends ProcessorStage<Stage, Flip> {
            Stage(BufferedImage source, Flip processor) {
                super(source, processor);
            }

            Stage(BufferedImage source) {
                super(source, new Flip());
            }

            public Stage vertically() {
                ((Flip)this.processor).dir = Direction.VERTICAL;
                return this;
            }

            public Stage horizontally() {
                ((Flip)this.processor).dir = Direction.HORIZONTAL;
                return this;
            }

            public Stage dir(Direction dir) {
                ((Flip)this.processor).dir = Lang.requireNotNull(dir);
                return this;
            }
        }
    }

    public static class Cropper
    extends Processor<Cropper, Stage> {
        private int x1;
        private int y1;
        private int x2;
        private int y2;

        Cropper() {
        }

        @Override
        protected Stage createStage(BufferedImage source) {
            return new Stage(source, this);
        }

        @Override
        protected BufferedImage run() {
            int x2 = this.x2;
            x2 = x2 < 0 ? this.sourceWidth + x2 : x2;
            int y2 = this.y2;
            y2 = y2 < 0 ? this.sourceHeight + y2 : y2;
            int w = x2 - this.x1;
            int h = y2 - this.y1;
            if (w < 0) {
                this.x1 = x2;
                w = -w;
            }
            if (h < 0) {
                this.y1 = y2;
                h = -h;
            }
            this.setTargetSpec(w, h);
            BufferedImage croppedImage = this.source.getSubimage(this.x1, this.y1, w, h);
            Graphics2D g = this.g();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, w, h);
            g.drawImage((Image)croppedImage, 0, 0, null);
            return this.target;
        }

        public static class Stage
        extends ProcessorStage<Stage, Cropper> {
            Stage(BufferedImage source, Cropper processor) {
                super(source, processor);
            }

            Stage(BufferedImage source) {
                super(source, new Cropper());
            }

            public Stage from(int x, int y) {
                ((Cropper)this.processor).x1 = x;
                ((Cropper)this.processor).y1 = y;
                return this;
            }

            public Stage to(int x, int y) {
                ((Cropper)this.processor).x2 = x;
                ((Cropper)this.processor).y2 = y;
                return this;
            }
        }
    }

    public static class Resizer
    extends Processor<Resizer, Stage> {
        int w;
        int h;
        float scale = Float.NaN;
        boolean keepRatio;

        Resizer() {
        }

        Resizer(int w, int h, boolean keepRatio) {
            this.w = N.requireNonNegative(w);
            this.h = N.requireNonNegative(h);
            this.keepRatio = keepRatio;
        }

        Resizer(float scale) {
            this.scale = N.requireNotNaN(scale);
            this.keepRatio = true;
        }

        @Override
        protected Stage createStage(BufferedImage source) {
            return new Stage(source, this);
        }

        @Override
        protected BufferedImage run() {
            int w = this.w;
            int h = this.h;
            int maxWidth = w;
            int maxHeight = h;
            if (Float.isNaN(this.scale)) {
                if (w < 0 && h < 0) {
                    w = this.sourceWidth;
                    h = this.sourceHeight;
                }
                double ratio = this.sourceRatio;
                if (w < 0 && h > 0) {
                    w = (int)((double)h * ratio);
                }
                if (w > 0 && h < 0) {
                    h = (int)((double)w / ratio);
                }
                if (this.keepRatio) {
                    h = (int)((double)w / ratio);
                    if (h > maxHeight) {
                        h = maxHeight;
                        w = (int)((double)h * ratio);
                    }
                    if (w > maxWidth) {
                        w = maxWidth;
                        h = (int)((double)w / ratio);
                    }
                }
            } else {
                w = (int)((float)this.sourceWidth * this.scale);
                h = (int)((float)this.sourceHeight * this.scale);
            }
            this.setTargetSpec(w, h);
            Graphics g = this.g();
            if (!this.source.getColorModel().hasAlpha()) {
                g = this.target.getGraphics();
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, w, h);
            }
            Image srcResized = this.source.getScaledInstance(w, h, 4);
            g.drawImage(srcResized, 0, 0, null);
            return this.target;
        }

        public static class Stage
        extends ProcessorStage<Stage, Resizer> {
            Stage(BufferedImage source, Resizer processor) {
                super(source, processor);
            }

            Stage(BufferedImage source) {
                super(source, new Resizer());
            }

            public Stage dimension(int w, int h) {
                ((Resizer)this.processor).w = N.requireNonNegative(w);
                ((Resizer)this.processor).h = N.requireNonNegative(h);
                return this;
            }

            public Stage dimension(Lang.Tuple<Integer, Integer> dimension) {
                return this.to(dimension);
            }

            public Stage dimension(Dimension dimension) {
                return this.dimension(dimension.width, dimension.height);
            }

            public Stage to(int w, int h) {
                return this.dimension(w, h);
            }

            public Stage to(Lang.Tuple<Integer, Integer> dimension) {
                return this.to(dimension.left(), dimension.right());
            }

            public Stage to(Dimension dimension) {
                return this.to(dimension.width, dimension.height);
            }

            public Stage to(float scale) {
                return this.scale(scale);
            }

            public Stage scale(float scale) {
                ((Resizer)this.processor).scale = N.requirePositive(scale);
                return this;
            }

            public Stage keepRatio() {
                ((Resizer)this.processor).keepRatio = true;
                return this;
            }
        }
    }

    public static class _Load<T extends _Load>
    extends Lang.Provider<BufferedImage> {
        protected BufferedImage source;
        protected float compressionQuality = Float.NaN;

        private _Load(InputStream is) {
            this.source = Img.read(is);
        }

        private _Load(BufferedImage source) {
            this.source = Lang.requireNotNull(source);
        }

        public T compressionQuality(float compressionQuality) {
            this.compressionQuality = N.requireAlpha(compressionQuality);
            return this.me();
        }

        public void writeTo(String fileName) {
            this.writeTo(new File(fileName));
        }

        public void writeTo(File file, String mimeType) {
            this.writeTo(IO.outputStream(file), mimeType);
        }

        public void writeTo(File file) {
            this.writeTo(IO.outputStream(file), Img.mimeType(file));
        }

        public void writeTo(OutputStream os, String mimeType) {
            ImageWriter writer = ImageIO.getImageWritersByMIMEType(Img.mimeType(mimeType)).next();
            this.dropAlphaChannelIfJPEG(writer);
            ImageWriteParam params = writer.getDefaultWriteParam();
            if (!Float.isNaN(this.compressionQuality) && params.canWriteCompressed()) {
                params.setCompressionMode(2);
                params.setCompressionType(params.getCompressionTypes()[0]);
                params.setCompressionQuality(this.compressionQuality);
            }
            ImageOutputStream ios = Img.os(os);
            writer.setOutput(ios);
            IIOImage image = new IIOImage(this.get(), null, null);
            try {
                writer.write(null, image, params);
            }
            catch (IOException e) {
                throw E.ioException(e);
            }
            IO.flush(ios);
            writer.dispose();
        }

        public byte[] toByteArray() {
            return this.toByteArray("image/png");
        }

        public byte[] toByteArray(String mimeType) {
            ByteArrayOutputStream baos = IO.baos();
            this.writeTo(baos, Img.mimeType(mimeType));
            return baos.toByteArray();
        }

        public String toBase64() {
            return this.toBase64("image/png");
        }

        public String toBase64(String mimeType) {
            return Img.toBase64(this.toByteArray(mimeType), mimeType);
        }

        public void dropAlphaChannelIfJPEG(ImageWriter writer) {
            if (writer.getClass().getSimpleName().toUpperCase().contains("JPEG")) {
                BufferedImage src = this.source;
                BufferedImage convertedImg = new BufferedImage(src.getWidth(), src.getHeight(), 1);
                convertedImg.getGraphics().drawImage(src, 0, 0, null);
                this.source = convertedImg;
            }
        }

        @Override
        public BufferedImage get() {
            return this.source;
        }

        public <B extends ProcessorStage<B, P>, P extends Processor<P, B>> B pipeline(P processor) {
            return processor.createStage(this.get());
        }

        public ProcessorStage pipeline(Processor p, Processor ... others) {
            ProcessorStage stage = this.pipeline(p, new Processor[0]);
            for (Processor other : others) {
                stage = stage.pipeline(other);
            }
            return stage;
        }

        public ProcessorStage pipeline(List<? extends Processor> processors) {
            E.illegalArgumentIf(processors.isEmpty());
            int sz = processors.size();
            Processor first = processors.get(0);
            ProcessorStage stage = this.pipeline(first, new Processor[0]);
            for (int i = 1; i < sz; ++i) {
                stage = stage.pipeline(processors.get(i));
            }
            return stage;
        }

        public <B extends ProcessorStage<B, P>, P extends Processor<P, B>> B pipeline(Class<? extends P> processorClass) {
            return (B)((Processor)$.newInstance(processorClass)).createStage(this.get());
        }

        public Resizer.Stage resize() {
            return new Resizer.Stage(this.get());
        }

        public Resizer.Stage resize(float scale) {
            return new Resizer.Stage(this.get()).scale(scale);
        }

        public Resizer.Stage resize(int w, int h) {
            return new Resizer.Stage(this.get()).dimension(w, h);
        }

        public Resizer.Stage resize(Lang.Tuple<Integer, Integer> dimension) {
            return this.resize(dimension.left(), dimension.right());
        }

        public Resizer.Stage resize(Dimension dimension) {
            return this.resize(dimension.width, dimension.height);
        }

        public Cropper.Stage crop() {
            return new Cropper.Stage(this.get());
        }

        public Cropper.Stage crop(int x1, int y1, int x2, int y2) {
            return new Cropper.Stage(this.get()).from(x1, y1).to(x2, y2);
        }

        public Cropper.Stage crop(Lang.Tuple<Integer, Integer> leftTop, Lang.Tuple<Integer, Integer> rightBottom) {
            return this.crop((Integer)leftTop._1, (Integer)leftTop._2, (Integer)rightBottom._1, (Integer)rightBottom._2);
        }

        public TextWriter.Stage text(String text) {
            return new TextWriter.Stage(this.get()).text(text);
        }

        public TextWriter.Stage watermark() {
            return new TextWriter.Stage(this.get());
        }

        public TextWriter.Stage watermark(String text) {
            return new TextWriter.Stage(this.get()).color(Color.LIGHT_GRAY).alpha(0.8f).rotate(-0.4487989505128276).offset(-130, 80).text(text);
        }

        public Blur.Stage blur() {
            return new Blur.Stage(this.get());
        }

        public Blur.Stage blur(int level) {
            return new Blur.Stage(this.get()).level(level);
        }

        public NoiseMaker.Stage makeNoise() {
            return new NoiseMaker.Stage(this.get());
        }

        public Flip.Stage flip() {
            return this.flip(Direction.HORIZONTAL);
        }

        public Flip.Stage flipVertial() {
            return this.flip(Direction.VERTICAL);
        }

        public Flip.Stage flip(Direction dir) {
            return new Flip.Stage(this.get()).dir(dir);
        }

        public ProcessorStage compress(float compressionQuality) {
            return ((_Load)new ProcessorStage(this.get()).compressionQuality(compressionQuality)).pipeline((Processor)COPIER);
        }

        public ProcessorStage copy() {
            return new ProcessorStage(this.get()).pipeline(COPIER);
        }

        public ProcessorStage processor(Processor processor) {
            return processor.createStage();
        }

        public Concatenater.Stage appendWith(Lang.Func0<BufferedImage> secondImange) {
            return new Concatenater.Stage(this.get()).with(secondImange);
        }

        public Concatenater.Stage appendTo(Lang.Func0<BufferedImage> firstImage) {
            return this.appendWith(firstImage).reverse();
        }

        public Concatenater.Stage appendWith(BufferedImage secondImange) {
            return new Concatenater.Stage(this.get()).with(F.source(secondImange));
        }

        public Concatenater.Stage appendTo(BufferedImage firstImage) {
            return this.appendWith(firstImage).reverse();
        }

        protected T me() {
            return (T)((_Load)$.cast(this));
        }
    }

    public static class ProcessorStage<STAGE extends ProcessorStage<STAGE, PROCESSOR>, PROCESSOR extends Processor<PROCESSOR, STAGE>>
    extends _Load<STAGE> {
        protected volatile BufferedImage target;
        protected PROCESSOR processor;
        protected float compressionQuality = Float.NaN;

        private ProcessorStage(Lang.Func0<BufferedImage> source) {
            this(source.apply(), COPIER);
        }

        private ProcessorStage(BufferedImage source) {
            this(source, COPIER);
        }

        public ProcessorStage(Lang.Func0<BufferedImage> source, PROCESSOR processor) {
            this(source.apply(), processor);
        }

        public ProcessorStage(BufferedImage source, PROCESSOR processor) {
            super(source);
            this.processor = (Processor)Lang.requireNotNull(processor);
        }

        @Override
        public BufferedImage get() {
            return this.target();
        }

        public STAGE source(InputStream is) {
            this.source = Img.read(is);
            return (STAGE)((ProcessorStage)this.me());
        }

        public STAGE source(BufferedImage source) {
            this.source = Lang.requireNotNull(source);
            return (STAGE)((ProcessorStage)this.me());
        }

        public _Load pipeline() {
            return new _Load(this.target());
        }

        private BufferedImage target() {
            if (null == this.target) {
                this.doJob();
            }
            return this.target;
        }

        private synchronized void doJob() {
            this.preTransform();
            this.target = null == this.processor ? this.source : ((Processor)this.processor).source(this.source).produce();
        }

        protected void preTransform() {
        }
    }

    public static abstract class BinarySourceProcessor<PROCESSOR extends BinarySourceProcessor<PROCESSOR, STAGE>, STAGE extends ProcessorStage<STAGE, PROCESSOR>>
    extends Processor<PROCESSOR, STAGE> {
        protected BufferedImage source2;
        protected int source2Width;
        protected int source2Height;
        protected double source2Ratio;

        public Processor secondSource(BufferedImage source) {
            this.source2 = Lang.requireNotNull(source);
            this.source2Width = source.getWidth();
            this.source2Height = source.getHeight();
            this.source2Ratio = (double)this.sourceWidth / (double)this.sourceHeight;
            return this;
        }

        public static enum ScaleFix {
            SCALE_TO_MAX{

                @Override
                public int targetScale(int scale1, int scale2) {
                    return N.max(scale1, scale2);
                }
            }
            ,
            SHRINK_TO_MIN{

                @Override
                public int targetScale(int scale1, int scale2) {
                    return N.min(scale1, scale2);
                }
            }
            ,
            NO_FIX{

                @Override
                public boolean shouldFix() {
                    return false;
                }
            };


            public int targetScale(int scale1, int scale2) {
                throw E.unsupport();
            }

            public boolean shouldFix() {
                return true;
            }
        }
    }

    public static abstract class Filter<FILTER extends Filter<FILTER, STAGE>, STAGE extends ProcessorStage<STAGE, FILTER>>
    extends Processor<FILTER, STAGE> {
        @Override
        protected void beforeRun() {
            this.createTarget();
        }

        @Override
        protected void createTarget() {
            this.target = this.source;
        }
    }

    public static abstract class Processor<PROCESSOR extends Processor<PROCESSOR, STAGE>, STAGE extends ProcessorStage<STAGE, PROCESSOR>>
    extends Lang.Producer<BufferedImage> {
        protected BufferedImage source;
        protected int sourceWidth;
        protected int sourceHeight;
        protected double sourceRatio;
        protected BufferedImage target;
        protected Graphics2D g;
        private Class<STAGE> stageClass;

        protected Processor() {
            this.exploreStageClass();
        }

        protected final STAGE createStage() {
            return this.createStage((BufferedImage)this.get());
        }

        protected STAGE createStage(BufferedImage source) {
            return (STAGE)(null == this.stageClass ? new ProcessorStage(source, this) : ((ProcessorStage)$.newInstance(this.stageClass, source, this)).source(source));
        }

        @Override
        public BufferedImage produce() {
            try {
                this.beforeRun();
                BufferedImage bufferedImage = this.run();
                return bufferedImage;
            }
            finally {
                if (null != this.g) {
                    this.g.dispose();
                }
            }
        }

        protected void beforeRun() {
        }

        protected abstract BufferedImage run();

        public Processor source(BufferedImage source) {
            this.source = Lang.requireNotNull(source);
            this.sourceWidth = source.getWidth();
            this.sourceHeight = source.getHeight();
            this.sourceRatio = (double)this.sourceWidth / (double)this.sourceHeight;
            return this;
        }

        public STAGE process(InputStream is) {
            return this.createStage(Img.read(is));
        }

        public STAGE process(BufferedImage source) {
            return this.createStage(source);
        }

        protected Graphics2D g() {
            if (null == this.g) {
                this.g = this.createGraphics2D();
            }
            return this.g;
        }

        protected Graphics2D cloneSource() {
            this.g().drawImage((Image)this.source, 0, 0, null);
            return this.g;
        }

        protected Graphics2D createGraphics2D() {
            if (null == this.target) {
                this.createTarget();
            }
            return this.target.createGraphics();
        }

        protected void createTarget() {
            this.setTargetSpec(this.sourceWidth, this.sourceHeight, this.source.getColorModel().hasAlpha());
        }

        protected void setTargetSpec(int w, int h) {
            this.setTargetSpec(w, h, this.source.getColorModel().hasAlpha());
        }

        protected void setTargetSpec(int w, int h, boolean withAlphaChannel) {
            this.target = new BufferedImage(w, h, withAlphaChannel ? 2 : 1);
        }

        private void exploreStageClass() {
            try {
                List<Type> types = Generics.typeParamImplementations(this.getClass(), Processor.class);
                if (types.size() > 1) {
                    Type stageType = types.get(1);
                    this.stageClass = Generics.classOf(stageType);
                }
            }
            catch (RuntimeException e) {
                this.stageClass = null;
            }
        }
    }

    public static enum Random {


        public static Color color() {
            return new Color(N.randInt(255), N.randInt(255), N.randInt(255));
        }

        public static Color lightColor() {
            return Random.randomColor(170, 255, 170, 255, 170, 255);
        }

        public static Color darkColor() {
            return Random.randomColor(0, 85, 0, 85, 0, 85);
        }

        public static Color moderateColor() {
            return Random.randomColor(85, 170, 85, 170, 85, 170);
        }

        public static Color grayColor() {
            int n = N.randInt(255);
            return new Color(n, n, n);
        }

        public static Color lightGrayColor() {
            return Random.randomGrayColor(170, 255);
        }

        public static Color darkGrayColor() {
            return Random.randomGrayColor(0, 85);
        }

        public static Color moderateGrayColor() {
            return Random.randomGrayColor(85, 170);
        }

        public static Color randomLightRedColor() {
            return Random.randomColor(170, 255, 85, 170, 85, 170);
        }

        public static Color randomDarkRedColor() {
            return Random.randomColor(85, 170, 0, 85, 0, 85);
        }

        public static Color randomModerateRedColor() {
            return Random.randomColor(170, 255, 0, 85, 0, 85);
        }

        public static Color randomLightGreenColor() {
            return Random.randomColor(85, 170, 170, 255, 85, 170);
        }

        public static Color randomDarkGreenColor() {
            return Random.randomColor(0, 85, 85, 170, 0, 85);
        }

        public static Color randomModerateGreenColor() {
            return Random.randomColor(0, 85, 170, 255, 0, 85);
        }

        public static Color randomLightBlueColor() {
            return Random.randomColor(85, 170, 85, 170, 170, 255);
        }

        public static Color randomDarkBlueColor() {
            return Random.randomColor(0, 85, 0, 85, 85, 170);
        }

        public static Color randomModerateBlueColor() {
            return Random.randomColor(0, 85, 0, 85, 170, 255);
        }

        public static Color randomGrayColor(int min, int max) {
            int r = N.randInt(min, max);
            return new Color(r, r, r);
        }

        public static Color randomColor(int minR, int maxR, int minG, int maxG, int minB, int maxB) {
            return new Color(N.randInt(minR, maxR), N.randInt(minG, maxG), N.randInt(minB, maxB));
        }
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;


        public boolean isHorizontal() {
            return HORIZONTAL == this;
        }

        public boolean isVertical() {
            return VERTICAL == this;
        }

        public N.WH concatenate(N.Dimension d1, N.Dimension d2) {
            return this.isHorizontal() ? N.dimension(d1.w() + d2.w(), N.max(d1.h(), d2.h())) : N.dimension(N.max(d1.w(), d2.w()), d1.h() + d2.h());
        }

        public void drawImage(Graphics2D g, BufferedImage source1, BufferedImage source2) {
            g.drawImage(source1, 0, 0, source1.getWidth(), source1.getHeight(), null);
            int x2 = 0;
            int y2 = 0;
            if (this.isHorizontal()) {
                x2 = source1.getWidth();
            } else {
                y2 = source1.getHeight();
            }
            g.drawImage(source2, x2, y2, source2.getWidth(), source2.getHeight(), null);
        }
    }
}

