/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.Collection;
import java.util.Iterator;
import org.osgl.util.C;
import org.osgl.util.DelegatingIterator;
import org.osgl.util.SequenceBase;

class IterableSeq<T>
extends SequenceBase<T> {
    private Iterable<? extends T> data;

    IterableSeq(Iterable<? extends T> iterable) {
        this.data = iterable;
    }

    @Override
    public int size() throws UnsupportedOperationException {
        if (this.data instanceof Collection) {
            return ((Collection)this.data).size();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        return DelegatingIterator.of(this.data.iterator(), this.is(C.Feature.READONLY));
    }

    public static <T> C.Sequence<T> of(Iterable<? extends T> iterable) {
        if (iterable instanceof C.Sequence) {
            return (C.Sequence)iterable;
        }
        return new IterableSeq<T>(iterable);
    }
}

