/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.FastStr;
import org.osgl.util.S;

public final class Keyword
implements Comparable<Keyword> {
    public static final Keyword NULL = new Keyword();
    public static final char SEP_SPACE = ' ';
    public static final char SEP_UNDERSCORE = '_';
    public static final char SEP_DASH = '-';
    public static final char SEP_COMMA = ',';
    public static final char SEP_COLON = ':';
    public static final char SEP_DOT = '.';
    public static final char SEP_SEMI_COLON = ';';
    public static final char SEP_SLASH = '\\';
    public static final char SEP_FORWARD_SLASH = '/';
    private static final char[] SEPS = new char[]{' ', '_', '-', ',', ':', '.', ';', '/', '\\'};
    private C.List<FastStr> list = C.newList();

    private Keyword() {
    }

    public Keyword(CharSequence chars) {
        this.init(chars);
    }

    public boolean matches(CharSequence charSequence) {
        return this.matches(Keyword.of(charSequence));
    }

    public boolean matches(Keyword keyword) {
        return $.eq(this, keyword);
    }

    public String acronym() {
        S.Buffer buf = S.buffer();
        for (FastStr fs : this.list) {
            buf.a(Character.toUpperCase(fs.charAt(0)));
        }
        return buf.toString();
    }

    public String camelCase() {
        return Style.CAMEL_CASE.toString(this);
    }

    public String upperCamelCase() {
        return this.camelCase();
    }

    public String pascalCase() {
        return this.camelCase();
    }

    public String javaVariable() {
        return Style.JAVA_VARIABLE.toString(this);
    }

    public String lowerCamelCase() {
        return this.javaVariable();
    }

    public String constantName() {
        return Style.CONSTANT_NAME.toString(this);
    }

    public String underscore() {
        return Style.UNDERSCORE.toString(this);
    }

    public String snakeCase() {
        return this.underscore();
    }

    public String dashed() {
        return Style.DASHED.toString(this);
    }

    public String hyphenated() {
        return this.dashed();
    }

    public String kebabCase() {
        return this.dashed();
    }

    public String dotted() {
        return Style.DOTTED.toString(this);
    }

    public String httpHeader() {
        return Style.HTTP_HEADER.toString(this);
    }

    public String startCase() {
        return Style.START_CASE.toString(this);
    }

    public String readable() {
        return Style.READABLE.toString(this);
    }

    public List<String> tokens() {
        ArrayList<String> list = new ArrayList<String>();
        for (FastStr fs : this.list) {
            list.add(fs.toString());
        }
        return list;
    }

    public int hashCode() {
        return $.hc(this.list);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Keyword) {
            return ((Keyword)obj).list.equals(this.list);
        }
        return false;
    }

    public String toString() {
        return this.underscore();
    }

    public String toString(Style style) {
        return style.toString(this);
    }

    public boolean contains(Keyword keyword) {
        return this.toString().contains(keyword.toString());
    }

    public boolean contains(String string) {
        return this.toString().contains(string.toLowerCase()) || this.contains(Keyword.of(string));
    }

    public boolean startsWith(Keyword keyword) {
        return this.toString().startsWith(keyword.toString());
    }

    public boolean startsWith(String string) {
        return this.toString().startsWith(string) || this.startsWith(Keyword.of(string));
    }

    public boolean endsWith(Keyword keyword) {
        return this.toString().endsWith(keyword.toString());
    }

    public boolean endsWith(String string) {
        return this.toString().endsWith(string.toLowerCase()) || this.endsWith(Keyword.of(string));
    }

    @Override
    public int compareTo(Keyword o) {
        return this.camelCase().compareTo(o.camelCase());
    }

    public static Keyword of(CharSequence chars) {
        return null == chars ? NULL : new Keyword(chars);
    }

    public static boolean eq(CharSequence a, CharSequence b) {
        return Keyword.of(a).equals(Keyword.of(b));
    }

    public static boolean neq(CharSequence a, CharSequence b) {
        return !Keyword.eq(a, b);
    }

    public static boolean equals(CharSequence a, CharSequence b) {
        return Keyword.eq(a, b);
    }

    public static boolean notEquals(CharSequence a, CharSequence b) {
        return !Keyword.eq(a, b);
    }

    private void init(CharSequence chars) {
        FastStr fs = FastStr.of(chars);
        int sz = fs.length();
        int last = Keyword.nextNonSeparator(fs, 0);
        while (true) {
            FastStr sub;
            int pos;
            if ((pos = Keyword.locateNextStop(fs, last)) < 0 || pos == sz) {
                sub = (FastStr)fs.substr(last);
                if (sub.isEmpty()) break;
                this.list.add(sub.toLowerCase());
                break;
            }
            sub = fs.subSequence(last, pos);
            if (!sub.isEmpty()) {
                this.list.add(sub.toLowerCase());
            }
            last = Keyword.nextNonSeparator(fs, pos);
        }
    }

    private static int locateNextStop(FastStr str, int start) {
        char ch;
        int pos;
        boolean isUpper;
        int sz = str.length();
        if (start >= sz - 1) {
            return -1;
        }
        char c0 = str.charAt(start);
        boolean isDigit = Character.isDigit(c0);
        boolean isLetter = !isDigit && Character.isLetter(c0);
        boolean isLower = isLetter && Character.isLowerCase(c0);
        boolean bl = isUpper = isLetter && !isLower;
        if (isUpper) {
            char ch2;
            boolean curIsLetter;
            int pos2;
            boolean c2IsDigit;
            char c1 = str.charAt(start + 1);
            boolean c2IsSeparator = Keyword.isSeparator(c1);
            if (c2IsSeparator) {
                return start + 1;
            }
            boolean bl2 = c2IsDigit = !c2IsSeparator && Character.isDigit(c1);
            if (c2IsDigit) {
                return start + 1;
            }
            boolean c2IsLetter = Character.isLetter(c1);
            if (!c2IsLetter) {
                return start + 1;
            }
            boolean c2IsLower = Character.isLowerCase(c1);
            if (c2IsLower) {
                return Keyword.locateNextStop(str, start + 1);
            }
            for (pos2 = start + 2; pos2 < sz && (curIsLetter = Character.isLetter(ch2 = str.charAt(pos2))); ++pos2) {
                boolean curIsLower = Character.isLowerCase(ch2);
                if (!curIsLower) continue;
                --pos2;
                break;
            }
            return pos2;
        }
        for (pos = start + 1; pos < sz && !Keyword.isSeparator(ch = str.charAt(pos)) && !(isDigit ? !Character.isDigit(ch) : Character.isDigit(ch) || isLower && !Character.isLowerCase(ch)); ++pos) {
        }
        return pos;
    }

    private static int nextNonSeparator(FastStr str, int start) {
        char ch;
        int pos;
        int sz = str.length();
        for (pos = start; pos < sz && Keyword.isSeparator(ch = str.charAt(pos)); ++pos) {
        }
        return pos;
    }

    private static boolean isSeparator(char ch) {
        return Arrays.binarySearch(SEPS, ch) >= 0;
    }

    static {
        Arrays.sort(SEPS);
    }

    public static enum F {

        public static Lang.Transformer<String, Keyword> FROM_STRING = new Lang.Transformer<String, Keyword>(){

            @Override
            public Keyword transform(String s) {
                return Keyword.of(s);
            }
        };
    }

    public static enum Style {
        CAMEL_CASE{

            @Override
            protected CharSequence processToken(FastStr token, int seq) {
                return token.capFirst();
            }
        }
        ,
        UPPER_CAMEL_CASE{

            @Override
            protected CharSequence processToken(FastStr token, int seq) {
                return CAMEL_CASE.processToken(token, seq);
            }
        }
        ,
        PASCAL_CASE{

            @Override
            protected CharSequence processToken(FastStr token, int seq) {
                return CAMEL_CASE.processToken(token, seq);
            }
        }
        ,
        JAVA_VARIABLE{

            @Override
            protected CharSequence processToken(FastStr token, int seq) {
                return seq > 0 ? token.capFirst() : token;
            }
        }
        ,
        LOWER_CAMEL_CASE{

            @Override
            protected CharSequence processToken(FastStr token, int seq) {
                return JAVA_VARIABLE.processToken(token, seq);
            }
        }
        ,
        UNDERSCORE('_'),
        SNAKE_CASE('_'),
        CONSTANT_NAME('_'){

            @Override
            protected CharSequence processToken(FastStr token, int seq) {
                return token.toUpperCase();
            }
        }
        ,
        DASHED('-'),
        KEBAB('-'),
        HYPHENATED('-'),
        DOTTED('.'),
        HTTP_HEADER('-'){

            @Override
            protected CharSequence processToken(FastStr token, int seq) {
                return token.capFirst();
            }
        }
        ,
        READABLE(' '){

            @Override
            protected CharSequence processToken(FastStr token, int seq) {
                if (seq == 0) {
                    return token.capFirst();
                }
                return token;
            }
        }
        ,
        START_CASE(' '){

            @Override
            protected CharSequence processToken(FastStr token, int seq) {
                return token.capFirst();
            }
        };

        private String separator;

        private Style() {
            this.separator = null;
        }

        private Style(char sep) {
            this.separator = String.valueOf(sep);
        }

        public String toString(Keyword keyword) {
            S.Buffer sb = S.buffer();
            int sz = keyword.list.size();
            for (int i = 0; i < sz; ++i) {
                FastStr fs = (FastStr)keyword.list.get(i);
                sb.append(this.processToken(fs, i));
                if (i >= sz - 1 || null == this.separator) continue;
                sb.append(this.separator);
            }
            return sb.toString();
        }

        public Lang.Transformer<String, String> asTransformer() {
            final Style me = this;
            return new Lang.Transformer<String, String>(){

                @Override
                public String transform(String s) {
                    return me.toString(Keyword.of(s));
                }
            };
        }

        protected CharSequence processToken(FastStr token, int seq) {
            return token;
        }
    }
}

