/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class LFUCache<K, V> {
    private final Map<K, Node> store;
    private final LinkedHashSet<K>[] accessCountList;
    private int minFreq;
    private final int capacity;
    private final int evictNum;

    public LFUCache(int cap, double evictFactor) {
        if (cap <= 0 || evictFactor <= 0.0 || evictFactor >= 1.0) {
            throw new IllegalArgumentException("Eviction factor or Capacity is illegal.");
        }
        this.capacity = cap;
        this.minFreq = 0;
        this.evictNum = Math.min(cap, (int)Math.ceil((double)cap * evictFactor));
        this.store = new HashMap<K, Node>();
        this.accessCountList = new LinkedHashSet[cap];
        for (int i = 0; i < cap; ++i) {
            this.accessCountList[i] = new LinkedHashSet();
        }
    }

    private synchronized void touch(K key) {
        if (this.store.containsKey(key)) {
            Node node = this.store.get(key);
            int id = Math.min(node.count, this.capacity - 1);
            this.accessCountList[id].remove(key);
            int newCount = node.touch();
            if (newCount < this.capacity) {
                this.store.put(key, node);
                this.accessCountList[newCount].add(key);
                if (id == this.minFreq && this.accessCountList[this.minFreq].isEmpty()) {
                    ++this.minFreq;
                }
            } else {
                this.accessCountList[id].add(key);
            }
        }
    }

    private synchronized void evict() {
        for (int i = 0; i < this.evictNum && this.minFreq < this.capacity; ++i) {
            Object key = this.accessCountList[this.minFreq].iterator().next();
            this.accessCountList[this.minFreq].remove(key);
            this.store.remove(key);
            while (this.minFreq < this.capacity && this.accessCountList[this.minFreq].isEmpty()) {
                ++this.minFreq;
            }
        }
    }

    public synchronized V get(K key) {
        if (!this.store.containsKey(key)) {
            return null;
        }
        this.touch(key);
        return (V)this.store.get(key).v;
    }

    public synchronized void set(K key, V value) {
        Node node = this.store.get(key);
        if (null != node) {
            node.v = value;
            this.touch(key);
            return;
        }
        if (this.store.size() >= this.capacity) {
            this.evict();
        }
        this.store.put(key, new Node(value));
        this.accessCountList[0].add(key);
        this.minFreq = 0;
    }

    public synchronized Map<K, V> mget(List<K> keys) {
        LinkedHashMap<K, V> ret = new LinkedHashMap<K, V>();
        for (K key : keys) {
            V val = this.get(key);
            if (null == val) continue;
            ret.put(key, val);
        }
        return ret;
    }

    public synchronized void mset(Map<K, V> data) {
        for (Map.Entry<K, V> entry : data.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    public synchronized Integer incr(K key, Integer delta) {
        if (!this.store.containsKey(key)) {
            this.set(key, delta);
            return delta;
        }
        Node node = this.store.get(key);
        Integer I = (Integer)node.v;
        if (null == I) {
            I = 0;
        }
        I = I + delta;
        node.v = I;
        this.touch(key);
        return I;
    }

    public synchronized Integer decr(K key, Integer delta) {
        return this.incr(key, -delta.intValue());
    }

    public void print() {
        System.out.println("=========================");
        System.out.println("What is in cache?");
        for (int f2 = this.minFreq; f2 < this.capacity; ++f2) {
            for (Object key : this.accessCountList[f2]) {
                System.out.print("(" + key + ", " + this.store.get(key).count + " : " + this.store.get(key).v + "), ");
            }
        }
        System.out.println("\n=========================");
    }

    private class Node {
        private V v;
        private int count;

        Node(V v) {
            this.v = v;
            this.count = 0;
        }

        int touch() {
            return ++this.count;
        }
    }
}

