/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;

public final class MimeType {
    private static Map<String, MimeType> indexByName = new HashMap<String, MimeType>();
    private static Map<String, MimeType> indexByContentType = new HashMap<String, MimeType>();
    private static Map<String, Trait> traitMap = new HashMap<String, Trait>();
    private String name;
    private String type;
    private EnumSet<Trait> traits = EnumSet.noneOf(Trait.class);

    private MimeType() {
    }

    private MimeType(String name, String type, List<Trait> traitList) {
        this.name = name.intern();
        this.type = type.intern();
        this.traits.addAll(traitList);
    }

    public String toString() {
        return this.type;
    }

    @Deprecated
    public String fileExtension() {
        return this.name;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public boolean isSameTypeWith(MimeType mimeType) {
        return this.type == mimeType.type;
    }

    public boolean isSameTypeWithAny(MimeType ... types) {
        for (MimeType type : types) {
            if (!this.isSameTypeWith(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isAlias(MimeType mimeType) {
        return this.type == mimeType.type;
    }

    public MimeType createAlias(String name) {
        MimeType mimeType = indexByName.get(name);
        E.illegalArgumentIf(null != mimeType, "name already reigistered");
        mimeType = this.newInstance(name);
        indexByName.put(name, mimeType);
        return mimeType;
    }

    @Deprecated
    public boolean test(Trait trait) {
        return this.traits.contains((Object)trait);
    }

    public boolean hasTrait(Trait trait) {
        return this.traits.contains((Object)trait);
    }

    public boolean test(String s) {
        if (this.name.equalsIgnoreCase(s)) {
            return true;
        }
        if (this.type.equalsIgnoreCase(s)) {
            return true;
        }
        Trait trait = traitMap.get(s);
        return null != trait;
    }

    public boolean matches(String s) {
        if (this.name.equalsIgnoreCase(s)) {
            return true;
        }
        if (this.type.equalsIgnoreCase(s)) {
            return true;
        }
        Trait trait = traitMap.get(s);
        return null != trait;
    }

    private MimeType newInstance(String fileExtension) {
        MimeType newInstance = new MimeType();
        newInstance.name = fileExtension.intern();
        newInstance.type = this.type;
        newInstance.traits = this.traits;
        return newInstance;
    }

    @Deprecated
    public static MimeType findByFileExtension(String fileExtension) {
        return indexByName.get(fileExtension.trim().toLowerCase());
    }

    public static MimeType findByName(String name) {
        return indexByName.get(name.trim().toLowerCase());
    }

    public static MimeType findByContentType(String contentType) {
        return indexByContentType.get(contentType.trim().toLowerCase());
    }

    public static List<MimeType> filterByTrait(Trait trait) {
        ArrayList<MimeType> mimeTypes = new ArrayList<MimeType>();
        for (MimeType mimeType : MimeType.allMimeTypes()) {
            if (!mimeType.test(trait)) continue;
            mimeTypes.add(mimeType);
        }
        return mimeTypes;
    }

    public static Collection<MimeType> allMimeTypes() {
        return indexByName.values();
    }

    @Deprecated
    public static String typeOfSuffix(String fileExtension) {
        MimeType mimeType = indexByName.get(fileExtension);
        return null == mimeType ? fileExtension : mimeType.type;
    }

    public static String typeOfName(String name) {
        MimeType mimeType = indexByName.get(name);
        return null == mimeType ? name : mimeType.type;
    }

    public static void registerMimeType(String name, String contentType, Trait ... traits) {
        MimeType mimeType = new MimeType(name, contentType, C.listOf(traits));
        indexByName.put(name, mimeType);
        if (!indexByContentType.containsKey(contentType)) {
            indexByContentType.put(contentType, mimeType);
        }
    }

    private static void init() {
        for (Trait trait : Trait.values()) {
            traitMap.put(trait.name(), trait);
        }
        List<String> lines = IO.read(MimeType.class.getResource("/org/osgl/mime-types2.properties")).toLines();
        MimeType.load(lines);
    }

    private static void load(List<String> lines) {
        ArrayList<String> lowPriorityLines = new ArrayList<String>();
        for (String line : lines) {
            boolean parsed = MimeType.parse(line, true);
            if (parsed) continue;
            lowPriorityLines.add(line);
        }
        for (String line : lowPriorityLines) {
            MimeType.parse(line, false);
        }
    }

    private static boolean parse(String line, boolean first) {
        if (line.startsWith("#")) {
            return true;
        }
        boolean hasDecoration = line.contains("+");
        if (hasDecoration && first) {
            return false;
        }
        S.T2 pair = S.binarySplit(line, '=');
        String fileExtension = (String)pair.left();
        if (fileExtension.contains(".")) {
            MimeType mimeType = indexByName.get(fileExtension = S.cut(fileExtension).beforeFirst("."));
            E.illegalStateIf(null == mimeType, "error parsing line: " + line);
            indexByContentType.put((String)pair.right(), mimeType);
            return true;
        }
        C.List traits = C.newList();
        String type = (String)pair.right();
        if (type.contains("|")) {
            pair = S.binarySplit(type, '|');
            type = (String)pair.left();
            traits.addAll(S.fastSplit((String)pair.right(), ","));
        }
        pair = S.binarySplit(type, '/');
        String prefix = (String)pair.left();
        String suffix = (String)pair.right();
        Trait trait = traitMap.get(prefix);
        if (null != trait) {
            traits.add(trait.name());
        }
        if (hasDecoration) {
            String realType;
            String originalType;
            MimeType mimeType;
            pair = S.binarySplit(suffix, '+');
            String decorator = (String)pair.left();
            trait = traitMap.get(decorator);
            if (null != trait) {
                traits.add(trait.name());
            }
            if (null != (mimeType = indexByContentType.get(originalType = S.concat(prefix, "/", realType = (String)pair.right())))) {
                for (Trait element : mimeType.traits) {
                    traits.add(element.name());
                }
            } else {
                trait = traitMap.get(realType);
                if (null != trait) {
                    traits.add(trait.name());
                }
            }
        } else {
            trait = traitMap.get(suffix);
            if (null != trait) {
                traits.add(trait.name());
            }
        }
        MimeType mimeType = indexByContentType.get(type);
        if (null == mimeType) {
            mimeType = new MimeType(fileExtension, type, (List<Trait>)((Object)traits.map(new Lang.Transformer<String, Trait>(){

                @Override
                public Trait transform(String s) {
                    return Trait.valueOf(s);
                }
            })));
            if (mimeType.test(Trait.xls) || mimeType.test(Trait.xlsx)) {
                mimeType.traits.add(Trait.excel);
            } else if (mimeType.test(Trait.ppt) || mimeType.test(Trait.pptx)) {
                mimeType.traits.add(Trait.powerpoint);
            } else if (mimeType.test(Trait.doc) || mimeType.test(Trait.docx)) {
                mimeType.traits.add(Trait.word);
            } else if (mimeType.test(Trait.xml)) {
                mimeType.traits.add(Trait.text);
            }
            indexByContentType.put(type, mimeType);
        } else if (S.neq(fileExtension, mimeType.name)) {
            mimeType = mimeType.newInstance(fileExtension);
        }
        indexByName.put(fileExtension, mimeType);
        return true;
    }

    static {
        MimeType.init();
    }

    public static enum Trait {
        archive,
        audio,
        css,
        csv,
        doc,
        docx,
        excel,
        image,
        javascript,
        json,
        pdf,
        powerpoint,
        ppt,
        pptx,
        problem,
        text,
        video,
        word,
        xls,
        xlsx,
        xml,
        yaml;


        public boolean test(MimeType mimeType) {
            return mimeType.test(this);
        }
    }
}

