/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.Keyword;
import org.osgl.util.S;

public class N {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final int[] POW_OF_TEN_INT = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    public static final long[] POW_OF_TEN_LONG = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private static Random random = ThreadLocalRandom.current();
    private static Map<Class<? extends Number>, Type> _m = new HashMap<Class<? extends Number>, Type>();
    public static final double E = Math.E;
    public static final double PI = Math.PI;
    public static final List<Class<? extends Number>> NUMBER_CLASSES;

    N() {
    }

    public static Pair Pair(Integer a, Integer b) {
        return new Pair(a, b);
    }

    public static XY xy(int x, int y) {
        return new XY(x, y);
    }

    public static WH dimension(int width, int height) {
        return new WH(width, height);
    }

    public static WH wh(int w, int h) {
        return new WH(w, h);
    }

    private static Type _type(Class<? extends Number> c) {
        Type t = _m.get(c);
        if (null == t) {
            t = Type.DOUBLE;
        }
        return t;
    }

    private static Type _type(Number n) {
        if (n instanceof Num) {
            return ((Num)n)._t;
        }
        return N._type(n.getClass());
    }

    public static _IntRequire require(int n) {
        return new _IntRequire(n);
    }

    public static int requirePositive(int n) {
        return N.requirePositive(n, "positive int required", new Object[0]);
    }

    public static int requirePositive(int n, String errorTemplate, Object ... errorArgs) {
        org.osgl.util.E.illegalArgumentIfNot(n > 0, errorTemplate, errorArgs);
        return n;
    }

    public static int requireNonNegative(int n) {
        return N.requireNonNegative(n, "non negative int required", new Object[0]);
    }

    public static int requireNonNegative(int n, String errorTemplate, Object ... errorArgs) {
        org.osgl.util.E.illegalArgumentIfNot(n >= 0, errorTemplate, errorArgs);
        return n;
    }

    public static int requireNegative(int n) {
        return N.requireNegative(n, "negative int required", new Object[0]);
    }

    public static int requireNegative(int n, String errorTemplate, Object ... errorArgs) {
        org.osgl.util.E.illegalArgumentIfNot(n < 0, errorTemplate, errorArgs);
        return n;
    }

    public static float requirePositive(float n) {
        org.osgl.util.E.illegalArgumentIf(n <= 0.0f, "positive float required");
        return n;
    }

    public static float requirePositive(float n, String errorTemplate, Object ... errorArgs) {
        org.osgl.util.E.illegalArgumentIf(n <= 0.0f, "positive float required");
        return n;
    }

    public static boolean isAlpha(float f2) {
        return 0.0f <= f2 && f2 <= 1.0f;
    }

    public static float requireAlpha(float n) {
        return N.requireAlpha(n, "f [%s] should be between 0 and 1 inclusive", Float.valueOf(n));
    }

    public static float requireAlpha(float n, String errorTemplate, Object ... errorArgs) {
        org.osgl.util.E.illegalArgumentIfNot(N.isAlpha(n), errorTemplate, errorArgs);
        return n;
    }

    public static float requireNotNaN(float f2) {
        org.osgl.util.E.illegalArgumentIfNot(!Float.isNaN(f2), "f [%s] shall not be NaN", Float.valueOf(f2));
        return f2;
    }

    public static float requireNonNegative(float n) {
        org.osgl.util.E.illegalArgumentIfNot(n >= 0.0f, "non negative float required");
        return n;
    }

    public static float requireNegative(float n) {
        org.osgl.util.E.illegalArgumentIfNot(n < 0.0f, "negative float required");
        return n;
    }

    public static boolean isAlpha(double n) {
        return 0.0 <= n && n <= 1.0;
    }

    public static double requireAlpha(double n) {
        org.osgl.util.E.illegalArgumentIfNot(N.isAlpha(n), "d [%s] should be between 0 and 1 inclusive", n);
        return n;
    }

    public static double requirePositive(double n) {
        org.osgl.util.E.illegalArgumentIfNot(0.0 < n, "positive double required");
        return n;
    }

    public static double requireNotNaN(double d) {
        org.osgl.util.E.illegalArgumentIfNot(!Double.isNaN(d), "d [%s] shall not be NaN", d);
        return d;
    }

    public static double requireNonNegative(double n) {
        org.osgl.util.E.illegalArgumentIfNot(0.0 <= n, "non negative double required");
        return n;
    }

    public static double requireNegative(double n) {
        org.osgl.util.E.illegalArgumentIfNot(0.0 > n, "negative double required");
        return n;
    }

    public static double exp(double a) {
        return StrictMath.exp(a);
    }

    public static double log(double a) {
        return StrictMath.log(a);
    }

    public static double log10(double a) {
        return StrictMath.log10(a);
    }

    public static double sqrt(double a) {
        return StrictMath.sqrt(a);
    }

    public static double cbrt(double a) {
        return StrictMath.cbrt(a);
    }

    public static double ceil(double a) {
        return StrictMath.ceil(a);
    }

    public static double floor(double a) {
        return StrictMath.floor(a);
    }

    public static double pow(double a, double b) {
        return StrictMath.pow(a, b);
    }

    public static int powOfTen(int e) {
        org.osgl.util.E.illegalArgumentIf(e < 0 || e > 9);
        return POW_OF_TEN_INT[e];
    }

    public static long powOfTenLong(int e) {
        org.osgl.util.E.illegalArgumentIf(e < 0 || e > 18);
        return POW_OF_TEN_LONG[e];
    }

    public static int round(float a) {
        return Math.round(a);
    }

    public static float round(float value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.floatValue();
    }

    public static long round(double a) {
        return Math.round(a);
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static final boolean isPerfectSquare(long n) {
        if (n < 0L) {
            return false;
        }
        switch ((int)(n & 0x3FL)) {
            case 0: 
            case 1: 
            case 4: 
            case 9: 
            case 16: 
            case 17: 
            case 25: 
            case 33: 
            case 36: 
            case 41: 
            case 49: 
            case 57: {
                long sqrt;
                if (n < 410881L) {
                    float x2 = (float)n * 0.5f;
                    float y = n;
                    int i = Float.floatToRawIntBits(y);
                    i = 1597463007 - (i >> 1);
                    y = Float.intBitsToFloat(i);
                    y *= 1.5f - x2 * y * y;
                    sqrt = (long)(1.0f / y);
                } else {
                    sqrt = (long)Math.sqrt(n);
                }
                return sqrt * sqrt == n;
            }
        }
        return false;
    }

    public static boolean isInt(String s) {
        return N.isInt(s, 10);
    }

    public static boolean isInt(String s, int radix) {
        if (S.isBlank(s)) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!(i == 0 && s.charAt(i) == '-' ? s.length() == 1 : Character.digit(s.charAt(i), radix) < 0)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String s) {
        if (S.isBlank(s)) {
            return false;
        }
        if (N.isInt(s)) {
            return true;
        }
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isNegative(BigDecimal number) {
        return -1 == number.signum();
    }

    public static boolean isNegative(BigInteger number) {
        return -1 == number.signum();
    }

    public static boolean isPositive(BigDecimal number) {
        return 1 == number.signum();
    }

    public static boolean isPositive(BigInteger number) {
        return 1 == number.signum();
    }

    public static int randInt() {
        return ThreadLocalRandom.current().nextInt();
    }

    public static int secureRandInt() {
        return new SecureRandom().nextInt();
    }

    public static int randIntWithSymbol() {
        return N.randSymbol() * N.randInt();
    }

    public static int secureRandIntWithSymbol() {
        SecureRandom r = new SecureRandom();
        return N.randSymbol(r) * r.nextInt();
    }

    public static int randInt(int max) {
        return ThreadLocalRandom.current().nextInt(max);
    }

    public static int randInt(int min, int max) {
        return ThreadLocalRandom.current().nextInt(max - min) + min;
    }

    public static int secureRandInt(int max) {
        return new SecureRandom().nextInt(max);
    }

    public static int secureRandInt(int min, int max) {
        return new SecureRandom().nextInt(max - min) + min;
    }

    public static int randIntWithSymbol(int max) {
        return N.randSymbol() * N.randInt(max);
    }

    public static int secureRandIntWithSymbol(int max) {
        SecureRandom r = new SecureRandom();
        return N.randSymbol(r) * r.nextInt(max);
    }

    public static float randFloat() {
        return ThreadLocalRandom.current().nextFloat();
    }

    public static float secureRandFloat() {
        return new SecureRandom().nextFloat();
    }

    public static float randFloatWithSymbol() {
        return (float)N.randSymbol() * N.randFloat();
    }

    public static float secureRandFloatWithSymbol() {
        SecureRandom r = new SecureRandom();
        return (float)N.randSymbol(r) * r.nextFloat();
    }

    public static long randLong() {
        return ThreadLocalRandom.current().nextLong();
    }

    public static long randLong(long max) {
        return ThreadLocalRandom.current().nextLong(max);
    }

    public static long secureRandLong() {
        return new SecureRandom().nextLong();
    }

    public static long randLongWithSymbol() {
        return (long)N.randSymbol() * N.randLong();
    }

    public static long secureRandLongWithSymbol() {
        SecureRandom r = new SecureRandom();
        return (long)N.randSymbol(r) * r.nextLong();
    }

    public static double randDouble() {
        return ThreadLocalRandom.current().nextDouble();
    }

    public static double secureRandDouble() {
        return new SecureRandom().nextDouble();
    }

    public static double randDoubleWithSymbol() {
        return (double)N.randSymbol() * N.randDouble();
    }

    public static double secureRandDoubleWithSymbol() {
        SecureRandom r = new SecureRandom();
        return (double)N.randSymbol(r) * r.nextDouble();
    }

    public static int abs(int a) {
        return a < 0 ? -a : a;
    }

    public static long abs(long a) {
        return a < 0L ? -a : a;
    }

    public static float abs(float a) {
        return a <= 0.0f ? 0.0f - a : a;
    }

    public static double abs(double a) {
        return a <= 0.0 ? 0.0 - a : a;
    }

    public static int max(int a, int b) {
        return a >= b ? a : b;
    }

    public static long max(long a, long b) {
        return a >= b ? a : b;
    }

    public static float max(float a, float b) {
        return Math.max(a, b);
    }

    public static double max(double a, double b) {
        return Math.max(a, b);
    }

    public static int min(int a, int b) {
        return Math.min(a, b);
    }

    public static long min(long a, long b) {
        return Math.min(a, b);
    }

    public static float min(float a, float b) {
        return Math.min(a, b);
    }

    public static double min(double a, double b) {
        return Math.min(a, b);
    }

    public static int sign(Number number) {
        org.osgl.util.E.NPE(number);
        int n = number.intValue();
        if (n == 0) {
            return 0;
        }
        if (n > 0) {
            return 1;
        }
        return -1;
    }

    public static final boolean eq(Number a, Number b) {
        if (null == a) {
            return null == b;
        }
        if (null == b) {
            return false;
        }
        return Math.abs(a.doubleValue() - b.doubleValue()) <= Double.MIN_NORMAL;
    }

    public static final boolean neq(Number a, Number b) {
        return !N.eq(a, b);
    }

    public static final boolean lt(Number a, Number b) {
        return a.doubleValue() < b.doubleValue();
    }

    public static final boolean gt(Number a, Number b) {
        return a.doubleValue() > b.doubleValue();
    }

    public static final Num num(Number number) {
        return new Num(number);
    }

    public static final Num num(String s) {
        if (S.empty(s)) {
            return new Num(0);
        }
        if (s.contains(".")) {
            return new Num(Double.parseDouble(s));
        }
        if (s.length() > 0) {
            return new Num(Long.parseLong(s));
        }
        return new Num(Integer.parseInt(s));
    }

    private static int randSymbol() {
        return N.randSymbol(ThreadLocalRandom.current());
    }

    private static int randSymbol(Random r) {
        return r.nextInt(2) == 0 ? -1 : 1;
    }

    static {
        _m.put(Byte.class, Type.BYTE);
        _m.put(Short.class, Type.SHORT);
        _m.put(Integer.class, Type.INT);
        _m.put(Long.class, Type.LONG);
        _m.put(Float.class, Type.FLOAT);
        _m.put(Double.class, Type.DOUBLE);
        NUMBER_CLASSES = (List)$.cast(C.list(Byte.class, Short.class, Integer.class, Float.class, Long.class, Double.class, AtomicInteger.class, AtomicLong.class, BigInteger.class, BigDecimal.class, Num.class));
    }

    public static final class F {
        public static final Lang.F1<Number, Number> NEGATIVE = new Lang.F1<Number, Number>(){

            @Override
            public Number apply(Number number) throws NotAppliedException, Lang.Break {
                return N.num(number).mul(-1);
            }
        };
        public static final Lang.F1 DBL = F.multiplyBy(2);
        public static final Lang.F1 HALF = F.div(2);
        public static Lang.F2<Number, Number, Number> MULTIPLY = new Lang.F2<Number, Number, Number>(){

            @Override
            public Number apply(Number n1, Number n2) throws NotAppliedException, Lang.Break {
                return N.num(n1).mul(n2);
            }
        };
        public static Lang.F2<Number, Number, Number> DIVIDE = new Lang.F2<Number, Number, Number>(){

            @Override
            public Number apply(Number n1, Number n2) throws NotAppliedException, Lang.Break {
                return N.num(n1).div(n2);
            }
        };
        public static final IntRangeStep INT_RANGE_STEP = new IntRangeStep();
        public static final ByteRangeStep BYTE_RANGE_STEP = new ByteRangeStep();
        public static final ShortRangeStep SHORT_RANGE_STEP = new ShortRangeStep();
        public static final LongRangeStep LONG_RANGE_STEP = new LongRangeStep();
        public static final Lang.F2 COUNTER = new Lang.F2<Integer, Object, Integer>(){

            @Override
            public Integer apply(Integer integer, Object o) throws NotAppliedException, Lang.Break {
                return integer + 1;
            }
        };
        public static Lang.Predicate<Integer> IS_EVEN = new Lang.Predicate<Integer>(){

            @Override
            public boolean test(Integer integer) {
                return integer % 2 == 0;
            }
        };
        public static Lang.Predicate<Integer> IS_ODD = Lang.F.negate(IS_EVEN);

        public static Lang.Predicate<Integer> gt(final int n) {
            return new Lang.Predicate<Integer>(){

                @Override
                public boolean test(Integer integer) {
                    return integer > n;
                }
            };
        }

        public static Lang.Predicate<Integer> greaterThan(int n) {
            return F.gt(n);
        }

        public static Lang.Predicate<Integer> gte(int n) {
            return F.gt(n - 1);
        }

        public static Lang.Predicate<Integer> greaterThanOrEqualsTo(int n) {
            return F.gte(n);
        }

        public static Lang.Predicate<Integer> lt(int n) {
            return Lang.F.negate(F.gte(n));
        }

        public static Lang.Predicate<Integer> lessThan(int n) {
            return F.lt(n);
        }

        public static Lang.Predicate<Integer> lte(int n) {
            return Lang.F.negate(F.gt(n));
        }

        public static Lang.Predicate<Integer> lessThanOrEqualsTo(int n) {
            return F.lte(n);
        }

        public static <T extends Number> Lang.F1<T, Number> dbl() {
            return DBL;
        }

        public static <T extends Number> Lang.F1<T, Number> dbl(Class<T> clz) {
            return F.mul(2, clz);
        }

        public static <T extends Number> Lang.F1<T, Number> half() {
            return HALF;
        }

        public static <T extends Number> Lang.F1<T, Number> half(Class<T> clz) {
            return F.div(2, clz);
        }

        public static <T extends Number> Lang.F1<T, Number> add(final Number n) {
            return new Lang.F1<T, Number>(){

                @Override
                public Number apply(T t) {
                    return N.num(t).add(n).get();
                }
            };
        }

        public static <T extends Number> Lang.F1<T, Number> add(final Number n, final Class<T> clz) {
            return new Lang.F1<T, Number>(){

                @Override
                public Number apply(T t) {
                    return N.num(t).add(n).as(clz);
                }
            };
        }

        public static <T extends Number> Lang.F2<T, T, Number> addTwo() {
            return new Lang.F2<T, T, Number>(){

                @Override
                public Number apply(T t1, T t2) throws NotAppliedException, Lang.Break {
                    return N.num(t1).add((Number)t2);
                }
            };
        }

        public static <T extends Number> Lang.F2<T, T, T> addTwo(final Class<T> c) {
            return new Lang.F2<T, T, T>(){

                @Override
                public T apply(T t1, T t2) throws NotAppliedException, Lang.Break {
                    return N.num(t1).add((Number)t2).as(c);
                }
            };
        }

        public static <T extends Number, X> Lang.F2<T, X, Number> adder(final Lang.Function<X, T> func) {
            return new Lang.F2<T, X, Number>(){

                @Override
                public Number apply(T t, X x) throws NotAppliedException, Lang.Break {
                    return N.num(t).add((Number)func.apply(x));
                }
            };
        }

        public static <T extends Number, X> Lang.F2<T, X, T> adder(final Lang.Function<X, T> func, final Class<T> clz) {
            return new Lang.F2<T, X, T>(){

                @Override
                public T apply(T t, X x) throws NotAppliedException, Lang.Break {
                    return N.num(t).add((Number)func.apply(x)).as(clz);
                }
            };
        }

        public static <P1 extends Number, P2 extends Number, R extends Number> Lang.F2<P1, P2, R> multiply(final Class<R> type) {
            return new Lang.F2<P1, P2, R>(){

                @Override
                public R apply(P1 n1, P2 n2) throws NotAppliedException, Lang.Break {
                    return N.num(n1).mul((Number)n2).as(type);
                }
            };
        }

        public static <T extends Number> Lang.F1<T, Number> multiplyBy(final Number n) {
            return new Lang.F1<T, Number>(){

                @Override
                public Number apply(T t) {
                    return N.num(t).mul(n).get();
                }
            };
        }

        public static <T extends Number> Lang.F1<T, Number> multiplyBy(final Number n, final Class<T> clz) {
            return new Lang.F1<T, Number>(){

                @Override
                public Number apply(T t) {
                    return N.num(t).mul(n).as(clz);
                }
            };
        }

        @Deprecated
        public static <T extends Number> Lang.F1<T, Number> mul(Number n) {
            return F.multiplyBy(n);
        }

        @Deprecated
        public static <T extends Number> Lang.F1<T, Number> mul(final Number n, final Class<T> clz) {
            return new Lang.F1<T, Number>(){

                @Override
                public Number apply(T t) {
                    return N.num(t).mul(n).as(clz);
                }
            };
        }

        public static <P1 extends Number, P2 extends Number, R extends Number> Lang.F2<P1, P2, R> divide(final Class<R> type) {
            return new Lang.F2<P1, P2, R>(){

                @Override
                public R apply(P1 n1, P2 n2) throws NotAppliedException, Lang.Break {
                    return N.num(n1).div((Number)n2).as(type);
                }
            };
        }

        public static <T extends Number> Lang.F1<T, Number> divideBy(final Number n) {
            return new Lang.F1<T, Number>(){

                @Override
                public Number apply(T t) {
                    return N.num(t).div(n).get();
                }
            };
        }

        public static <T extends Number> Lang.F1<T, Number> divideBy(final Number n, final Class<T> type) {
            return new Lang.F1<T, Number>(){

                @Override
                public Number apply(T t) {
                    return N.num(t).div(n).as(type);
                }
            };
        }

        @Deprecated
        public static <T extends Number> Lang.F1<T, Number> div(Number n) {
            return F.divideBy(n);
        }

        @Deprecated
        public static <T extends Number> Lang.F1<T, Number> div(Number n, Class<T> clz) {
            return F.divideBy(n, clz);
        }

        public static <T extends Number> Lang.F1<T, Number> sqr() {
            return new Lang.F1<T, Number>(){

                @Override
                public Number apply(T t) throws NotAppliedException, Lang.Break {
                    Num nm = N.num(t);
                    return nm.mul(nm).get();
                }
            };
        }

        public static <T extends Number> Lang.F1<T, Number> sqr(final Class<T> clz) {
            return new Lang.F1<T, Number>(){

                @Override
                public Number apply(T t) throws NotAppliedException, Lang.Break {
                    Num nm = N.num(t);
                    return nm.mul(nm).as(clz);
                }
            };
        }

        public static <T extends Number> Lang.F1<T, Double> sqrt() {
            return new Lang.F1<T, Double>(){

                @Override
                public Double apply(T t) throws NotAppliedException, Lang.Break {
                    Num nm = N.num(t);
                    return nm.sqrt();
                }
            };
        }

        public static <T extends Number> Lang.F1<T, Number> cubic() {
            return new Lang.F1<T, Number>(){

                @Override
                public Number apply(T t) throws NotAppliedException, Lang.Break {
                    Num nm = N.num(t);
                    return nm.mul(nm).mul(nm).get();
                }
            };
        }

        public static <T extends Number> Lang.F1<T, Number> cubic(final Class<T> clz) {
            return new Lang.F1<T, Number>(){

                @Override
                public Number apply(T t) throws NotAppliedException, Lang.Break {
                    Num nm = N.num(t);
                    return nm.mul(nm).mul(nm).as(clz);
                }
            };
        }

        public static <T extends Number> Lang.F1<T, Double> cbrt() {
            return new Lang.F1<T, Double>(){

                @Override
                public Double apply(T t) throws NotAppliedException, Lang.Break {
                    return N.num(t).cbrt();
                }
            };
        }

        public static <T extends Number> Lang.F1<T, Integer> sign() {
            return new Lang.F1<T, Integer>(){

                @Override
                public Integer apply(T t) throws NotAppliedException, Lang.Break {
                    return N.sign(t);
                }
            };
        }

        public static <T extends Number> Lang.F2<T, T, T> aggregate(final Class<T> clz) {
            return new Lang.F2<T, T, T>(){

                @Override
                public T apply(T e, T v) {
                    return N.num(e).add((Number)v).as(clz);
                }
            };
        }

        public static <T extends Number> Lang.F2<T, T, T> subtract(final Class<T> clz) {
            return new Lang.F2<T, T, T>(){

                @Override
                public T apply(T minuend, T subtraend) throws NotAppliedException, Lang.Break {
                    return N.num(minuend).sub((Number)subtraend).as(clz);
                }
            };
        }

        public static final IntRangeStep intRangeStep(int times) {
            return new IntRangeStep(times);
        }

        public static ByteRangeStep byteRangeStep(int times) {
            return new ByteRangeStep(times);
        }

        public static ByteRangeStep shortRangeStep(int times) {
            return new ByteRangeStep(times);
        }

        public static LongRangeStep longRangeStep(int times) {
            return new LongRangeStep(times);
        }

        public static <T> Lang.F2<Integer, T, Integer> counter() {
            return (Lang.F2)$.cast(COUNTER);
        }
    }

    public static class _FloatRequire {
        private float f;

        private _FloatRequire(float f2) {
            this.f = f2;
        }
    }

    public static class _IntRequire {
        private int n;

        private _IntRequire(int n) {
            this.n = n;
        }

        public int positive() {
            return N.requirePositive(this.n);
        }

        public int positive(String err, Object ... errArgs) {
            return N.requirePositive(this.n, err, errArgs);
        }

        public int negative() {
            return N.requireNegative(this.n);
        }

        public int negative(String err, Object ... errArgs) {
            return N.requireNegative(this.n, err, errArgs);
        }

        public int nonNegative() {
            return N.requireNonNegative(this.n);
        }

        public int nonNegative(String err, Object ... args) {
            return N.requireNonNegative(this.n, err, args);
        }

        public int equalTo(int x) {
            return this.equalTo(x, "n[%s] should be equal to %s", this.n, x);
        }

        public int equalTo(int x, String err, Object ... errArgs) {
            org.osgl.util.E.illegalStateIfNot(this.n == x, err, errArgs);
            return this.n;
        }

        public int eq(int x) {
            return this.equalTo(x);
        }

        public int eq(int x, String err, Object ... errArgs) {
            return this.equalTo(x, err, errArgs);
        }

        public int notEqualTo(int x) {
            return this.notEqualTo(x, "n[%s] should not be equal to %s", this.n, x);
        }

        public int notEqualTo(int x, String err, Object ... errArgs) {
            org.osgl.util.E.illegalArgumentIfNot(this.n != x, err, errArgs);
            return this.n;
        }

        public int neq(int x) {
            return this.notEqualTo(x);
        }

        public int neq(int x, String err, Object ... errArgs) {
            return this.notEqualTo(x, err, errArgs);
        }

        public int greaterThan(int x) {
            return this.greaterThan(x, "n[%s] should be greater than %s", this.n, x);
        }

        public int greaterThan(int x, String err, Object ... errArgs) {
            org.osgl.util.E.illegalArgumentIfNot(this.n > x, err, errArgs);
            return this.n;
        }

        public int gt(int x) {
            return this.greaterThan(x);
        }

        public int gt(int x, String err, Object ... errArgs) {
            return this.greaterThan(x, err, errArgs);
        }

        public int greaterThanOrEqualTo(int x) {
            return this.greaterThanOrEqualTo(x, "n[%s] should be greater than or equal to %s", this.n, x);
        }

        public int greaterThanOrEqualTo(int x, String err, Object ... errArgs) {
            org.osgl.util.E.illegalArgumentIfNot(this.n >= x, err, errArgs);
            return this.n;
        }

        public int gte(int x) {
            return this.greaterThan(x);
        }

        public int gte(int x, String err, Object ... errArgs) {
            return this.greaterThanOrEqualTo(x, err, errArgs);
        }

        public int lessThan(int x) {
            return this.lessThan(x, "n[%s] should be less than %s", this.n, x);
        }

        public int lessThan(int x, String err, Object ... errArgs) {
            org.osgl.util.E.illegalArgumentIfNot(this.n > x, err, errArgs);
            return this.n;
        }

        public int lt(int x) {
            return this.lessThan(x);
        }

        public int lt(int x, String err, Object ... errArgs) {
            return this.lessThan(x, err, errArgs);
        }

        public int lessThanOrEqualTo(int x) {
            return this.lessThanOrEqualTo(x, "n[%s] should be less than or equal to %s", this.n, x);
        }

        public int lessThanOrEqualTo(int x, String err, Object ... errArgs) {
            org.osgl.util.E.illegalArgumentIfNot(this.n <= x, err, errArgs);
            return this.n;
        }

        public int lte(int x) {
            return this.lessThan(x);
        }

        public int lte(int x, String err, Object ... errArgs) {
            return this.lessThanOrEqualTo(x, err, errArgs);
        }
    }

    public static class XY
    extends Coordinate2D {
        public XY(Integer x, Integer y) {
            super(x, y);
        }
    }

    public static class Coordinate2D
    extends Pair {
        public Coordinate2D(Integer x, Integer y) {
            super(x, y);
        }

        public int x() {
            return (Integer)this._1;
        }

        public int y() {
            return (Integer)this._2;
        }
    }

    public static class Dimension
    extends Pair {
        public Dimension(Integer width, Integer height) {
            super(width, height);
        }

        public int width() {
            return (Integer)this.left();
        }

        public int height() {
            return (Integer)this.right();
        }

        public int w() {
            return this.width();
        }

        public int h() {
            return this.height();
        }
    }

    public static class WH
    extends Dimension {
        public WH(Integer width, Integer height) {
            super(width, height);
        }
    }

    public static class Pair
    extends Lang.T2<Integer, Integer> {
        public Pair(Integer _1, Integer _2) {
            super(_1, _2);
        }
    }

    public static class ByteRangeStep
    extends RangeStep<Byte> {
        public ByteRangeStep() {
        }

        public ByteRangeStep(int times) {
            super(times);
        }

        @Override
        public Byte apply(Byte from, Integer steps) throws NotAppliedException, Lang.Break {
            int limit;
            int n = limit = (steps = Integer.valueOf(this.step(steps))) < 0 ? -128 : 127;
            if (limit - from < steps) {
                throw new NoSuchElementException();
            }
            return (byte)(from + this.step(steps));
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ByteRangeStep) {
                ByteRangeStep that = (ByteRangeStep)obj;
                return that.times == this.times;
            }
            return false;
        }

        public ByteRangeStep times(int n) {
            if (n < 1) {
                throw new IllegalArgumentException("n must be positive integer");
            }
            return new ByteRangeStep(this.times * n);
        }
    }

    public static class ShortRangeStep
    extends RangeStep<Short> {
        public ShortRangeStep() {
        }

        public ShortRangeStep(int times) {
            super(times);
        }

        @Override
        public Short apply(Short from, Integer steps) throws NotAppliedException, Lang.Break {
            int limit;
            int n = limit = (steps = Integer.valueOf(this.step(steps))) < 0 ? Short.MIN_VALUE : Short.MAX_VALUE;
            if (limit - from < steps) {
                throw new NoSuchElementException();
            }
            return (short)(from + this.step(steps));
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ShortRangeStep) {
                ShortRangeStep that = (ShortRangeStep)obj;
                return that.times == this.times;
            }
            return false;
        }

        public ShortRangeStep times(int n) {
            if (n < 1) {
                throw new IllegalArgumentException("n must be positive integer");
            }
            return new ShortRangeStep(this.times * n);
        }
    }

    public static class LongRangeStep
    extends RangeStep<Long> {
        public LongRangeStep() {
        }

        public LongRangeStep(int times) {
            super(times);
        }

        @Override
        public Long apply(Long from, Integer steps) throws NotAppliedException, Lang.Break {
            return from + (long)this.step(steps);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof LongRangeStep) {
                LongRangeStep that = (LongRangeStep)obj;
                return that.times == this.times;
            }
            return false;
        }

        public LongRangeStep times(int n) {
            if (n < 1) {
                throw new IllegalArgumentException("n must be positive integer");
            }
            return new LongRangeStep(this.times * n);
        }
    }

    public static class IntRangeStep
    extends RangeStep<Integer> {
        public IntRangeStep() {
        }

        public IntRangeStep(int times) {
            super(times);
        }

        @Override
        public Integer apply(Integer from, Integer steps) throws NotAppliedException, Lang.Break {
            return from + this.step(steps);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof IntRangeStep) {
                IntRangeStep that = (IntRangeStep)obj;
                return that.times == this.times;
            }
            return false;
        }

        public IntRangeStep times(int n) {
            if (n < 1) {
                throw new IllegalArgumentException("n must be positive integer");
            }
            return new IntRangeStep(this.times * n);
        }
    }

    public static class RangeStep<T extends Number>
    extends Lang.F2<T, Integer, T>
    implements Serializable {
        protected int times = 1;

        public RangeStep() {
        }

        public RangeStep(int times) {
            org.osgl.util.E.invalidArgIf(times < 1, "times must be positive integer", new Object[0]);
            this.times = times;
        }

        protected final int step(int i) {
            return i * this.times;
        }

        @Override
        public T apply(T t, Integer steps) throws NotAppliedException, Lang.Break {
            return (T)N.num(t).add(steps * this.times).get();
        }

        public RangeStep<T> times(int n) {
            if (n < 1) {
                throw new IllegalArgumentException("n must be positive integer");
            }
            return new RangeStep<T>(this.times * n);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof RangeStep) {
                RangeStep that = (RangeStep)obj;
                return that.times == this.times && that.getClass().equals(this.getClass());
            }
            return false;
        }
    }

    public static class Num<T extends Number>
    extends Number {
        private Number _n;
        private Type _t;

        public Num(Number n) {
            if (n instanceof Num) {
                this._n = ((Num)n)._n;
                this._t = ((Num)n)._t;
            } else {
                this._n = n;
                this._t = (Type)((Object)_m.get(n.getClass()));
                if (null == this._t) {
                    this._t = Type.DOUBLE;
                }
            }
        }

        public T get() {
            return (T)this._n;
        }

        public <T extends Number> T as(Class<T> cls) {
            return (T)N._type(cls).valueOf(this._n);
        }

        public String toString() {
            return String.valueOf(this._n);
        }

        @Override
        public int intValue() {
            return this._n.intValue();
        }

        @Override
        public long longValue() {
            return this._n.longValue();
        }

        @Override
        public float floatValue() {
            return this._n.floatValue();
        }

        @Override
        public double doubleValue() {
            return this._n.doubleValue();
        }

        public Num<?> add(Number n) {
            return Num.valueOf(Op.ADD.apply(this._n, n));
        }

        public Num<?> sub(Number n) {
            return Num.valueOf(Op.SUB.apply(this._n, n));
        }

        public Num<?> mul(Number n) {
            return Num.valueOf(Op.MUL.apply(this._n, n));
        }

        public Num<?> div(Number n) {
            return Num.valueOf(Op.DIV.apply(this._n, n));
        }

        public double exp() {
            return N.exp(this.doubleValue());
        }

        public double log() {
            return N.log(this.doubleValue());
        }

        public double log10() {
            return N.log10(this.doubleValue());
        }

        public double sqrt() {
            return N.sqrt(this.doubleValue());
        }

        public double cbrt() {
            return N.cbrt(this.doubleValue());
        }

        public double ceil() {
            return N.ceil(this.doubleValue());
        }

        public double floor() {
            return N.floor(this.doubleValue());
        }

        public double pow(double b) {
            return N.pow(this.doubleValue(), b);
        }

        public int sign() {
            return N.sign(this._n);
        }

        public boolean eq(Number number) {
            return N.eq(this, number);
        }

        public boolean lt(Number number) {
            return N.lt(this, number);
        }

        public boolean gt(Number number) {
            return N.gt(this, number);
        }

        public static Num valueOf(Number n) {
            if (n instanceof Num) {
                return (Num)n;
            }
            return new Num(n);
        }
    }

    public static enum Op implements Lang.Func2<Number, Number, Number>
    {
        ADD{

            @Override
            public Number apply(Number a, Number b) {
                return Op.t(a, b).add(a, b);
            }
        }
        ,
        SUB{

            @Override
            public Number apply(Number a, Number b) {
                return Op.t(a, b).sub(a, b);
            }
        }
        ,
        MUL{

            @Override
            public Number apply(Number a, Number b) {
                return Op.t(a, b).mul(a, b);
            }
        }
        ,
        DIV{

            @Override
            public Number apply(Number a, Number b) {
                return Op.t(Op.t(a, b), Type.DOUBLE).div(a, b);
            }
        };


        private static Type t(Number a, Number b) {
            Type tb;
            Type ta = N._type(a);
            return ta.gt(tb = N._type(b)) ? ta : tb;
        }

        private static Type t(Type a, Type b) {
            return a.gt(b) ? a : b;
        }

        @Override
        public Number apply(Number o, Number o2) {
            return this.apply(o, o2);
        }

        public Lang.F0<Number> curry(Number a, Number b) {
            return this.curry(a, b);
        }
    }

    public static enum Comparator implements Lang.Func2<Number, Number, Boolean>
    {
        GT(new String[]{"greaterThan", "\u5927\u4e8e"}){

            @Override
            public Boolean apply(Number number, Number number2) throws NotAppliedException, Lang.Break {
                return number.doubleValue() > number2.doubleValue();
            }
        }
        ,
        GTE(new String[]{"greaterThanOrEqualTo", "atLeast", "noLessThan", "\u5927\u4e8e\u7b49\u4e8e", "\u5927\u4e8e\u6216\u7b49\u4e8e"}){

            @Override
            public Boolean apply(Number number, Number number2) throws NotAppliedException, Lang.Break {
                return number.doubleValue() > number2.doubleValue() || number.equals(number2);
            }
        }
        ,
        LT(new String[]{"lessThan", "\u5c0f\u4e8e"}){

            @Override
            public Boolean apply(Number number, Number number2) throws NotAppliedException, Lang.Break {
                return number.doubleValue() < number2.doubleValue();
            }
        }
        ,
        LTE(new String[]{"lessThanOrEqualTo", "atMost", "noGreaterThan", "\u5c0f\u4e8e\u7b49\u4e8e", "\u5c0f\u4e8e\u6216\u7b49\u4e8e"}){

            @Override
            public Boolean apply(Number number, Number number2) throws NotAppliedException, Lang.Break {
                return number.doubleValue() < number2.doubleValue() || number.equals(number2);
            }
        }
        ,
        EQ(new String[]{"equalTo", "equalsTo", "\u7b49\u4e8e"}){

            @Override
            public Boolean apply(Number number, Number number2) throws NotAppliedException, Lang.Break {
                return number.equals(number2);
            }
        }
        ,
        NE(new String[]{"neq", "notEqualTo", "notEqualsTo", "\u4e0d\u7b49\u4e8e"}){

            @Override
            public Boolean apply(Number number, Number number2) throws NotAppliedException, Lang.Break {
                return !number.equals(number2);
            }
        };

        private static Map<Keyword, Comparator> lookup;
        private Set<String> aliases = new HashSet<String>();

        private Comparator(String ... aliases) {
            this.aliases.addAll(C.listOf(aliases));
        }

        public boolean compare(Number n1, Number n2) {
            return (Boolean)this.apply(n1, n2);
        }

        public static Comparator of(String s) {
            return lookup.get(Keyword.of(s));
        }

        static {
            lookup = new HashMap<Keyword, Comparator>();
            for (Comparator comp : Comparator.values()) {
                lookup.put(Keyword.of(comp.name()), comp);
                for (String alias : comp.aliases) {
                    lookup.put(Keyword.of(alias), comp);
                }
            }
        }
    }

    public static enum Type {
        BYTE(1){

            @Override
            Number add(Number a, Number b) {
                return a.byteValue() + b.byteValue();
            }

            @Override
            Number sub(Number a, Number b) {
                return a.byteValue() - b.byteValue();
            }

            @Override
            Number mul(Number a, Number b) {
                return a.byteValue() * b.byteValue();
            }

            @Override
            Number div(Number a, Number b) {
                return a.byteValue() / b.byteValue();
            }

            @Override
            Number valueOf(Number n) {
                return n.byteValue();
            }
        }
        ,
        SHORT(5){

            @Override
            Number add(Number a, Number b) {
                return a.shortValue() + b.shortValue();
            }

            @Override
            Number sub(Number a, Number b) {
                return a.shortValue() - b.shortValue();
            }

            @Override
            Number mul(Number a, Number b) {
                return a.shortValue() * b.shortValue();
            }

            @Override
            Number div(Number a, Number b) {
                return a.shortValue() / b.shortValue();
            }

            @Override
            Number valueOf(Number n) {
                return n.shortValue();
            }
        }
        ,
        INT(10){

            @Override
            Number add(Number a, Number b) {
                return a.intValue() + b.intValue();
            }

            @Override
            Number sub(Number a, Number b) {
                return a.intValue() - b.intValue();
            }

            @Override
            Number mul(Number a, Number b) {
                return a.intValue() * b.intValue();
            }

            @Override
            Number div(Number a, Number b) {
                return a.intValue() / b.intValue();
            }

            @Override
            Number valueOf(Number n) {
                return n.intValue();
            }
        }
        ,
        LONG(15){

            @Override
            Number add(Number a, Number b) {
                return a.longValue() + b.longValue();
            }

            @Override
            Number sub(Number a, Number b) {
                return a.longValue() - b.longValue();
            }

            @Override
            Number mul(Number a, Number b) {
                return a.longValue() * b.longValue();
            }

            @Override
            Number div(Number a, Number b) {
                return a.longValue() / b.longValue();
            }

            @Override
            Number valueOf(Number n) {
                return n.longValue();
            }
        }
        ,
        FLOAT(20){

            @Override
            Number add(Number a, Number b) {
                return Float.valueOf(a.floatValue() + b.floatValue());
            }

            @Override
            Number sub(Number a, Number b) {
                return Float.valueOf(a.floatValue() - b.floatValue());
            }

            @Override
            Number mul(Number a, Number b) {
                return Float.valueOf(a.floatValue() * b.floatValue());
            }

            @Override
            Number div(Number a, Number b) {
                if ((double)b.floatValue() == 0.0) {
                    throw new ArithmeticException("/ by zero");
                }
                return Float.valueOf(a.floatValue() / b.floatValue());
            }

            @Override
            Number valueOf(Number n) {
                return Float.valueOf(n.floatValue());
            }
        }
        ,
        DOUBLE(25){

            @Override
            Number add(Number a, Number b) {
                return a.doubleValue() + b.doubleValue();
            }

            @Override
            Number sub(Number a, Number b) {
                return a.doubleValue() - b.doubleValue();
            }

            @Override
            Number mul(Number a, Number b) {
                return a.doubleValue() * b.doubleValue();
            }

            @Override
            Number div(Number a, Number b) {
                if (0.0 == b.doubleValue()) {
                    throw new ArithmeticException("/ by zero");
                }
                return a.doubleValue() / b.doubleValue();
            }

            @Override
            Number valueOf(Number n) {
                return n.doubleValue();
            }
        };

        private int _w;

        private Type(int weight) {
            this._w = weight;
        }

        abstract Number add(Number var1, Number var2);

        abstract Number sub(Number var1, Number var2);

        abstract Number mul(Number var1, Number var2);

        abstract Number div(Number var1, Number var2);

        abstract Number valueOf(Number var1);

        public boolean lt(Type type) {
            return this._w < type._w;
        }

        public boolean gt(Type type) {
            return this._w > type._w;
        }

        public boolean eq(Type type) {
            return type == this;
        }
    }
}

